/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.common;

import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.common.ClassAwareObjectStore;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.NamedEntryPoint;
import org.drools.core.common.ObjectTypeConfigurationRegistry;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.reteoo.ObjectTypeConf;
import org.drools.core.reteoo.ReteooFactHandleFactory;
import org.drools.core.rule.EntryPointId;
import org.drools.core.spi.Activation;
import org.drools.core.spi.PropagationContext;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.runtime.rule.RuleUnit;

public class DynamicEntryPoint
extends NamedEntryPoint {
    private final Map<RuleUnit, ObjectTypeConfigurationRegistry> boundUnits = new WeakHashMap<RuleUnit, ObjectTypeConfigurationRegistry>();

    public DynamicEntryPoint(EntryPointId entryPoint, StatefulKnowledgeSessionImpl wm) {
        this(entryPoint, wm, new ReentrantLock());
    }

    private DynamicEntryPoint(EntryPointId entryPoint, StatefulKnowledgeSessionImpl wm, ReentrantLock lock) {
        super(entryPoint, wm, new ReteooFactHandleFactory(), lock, new ClassAwareObjectStore(RuleBaseConfiguration.AssertBehaviour.IDENTITY, (Lock)lock));
    }

    public void bindRuleBase(InternalKnowledgeBase kBase) {
        this.kBase = kBase;
        this.pctxFactory = kBase.getConfiguration().getComponentFactory().getPropagationContextFactory();
        this.entryPointNode = this.kBase.getRete().getEntryPointNode(this.entryPoint);
        this.typeConfReg = new ObjectTypeConfigurationRegistry(this.kBase);
        this.boundUnits.clear();
        this.propagateAll();
    }

    private boolean isBoundToRuleBase() {
        return this.kBase != null;
    }

    private void propagateAll() {
        Iterator<InternalFactHandle> i = this.objectStore.iterateFactHandles();
        while (i.hasNext()) {
            this.propagateInsert(i.next());
        }
    }

    private void propagateInsert(InternalFactHandle handle) {
        ObjectTypeConf typeConf = this.typeConfReg.getObjectTypeConf(this.entryPointNode.getEntryPoint(), handle.getObject());
        PropagationContext pctx = this.pctxFactory.createPropagationContext(this.wm.getNextPropagationIdCounter(), PropagationContext.Type.INSERTION, null, null, handle, this.entryPoint);
        this.entryPointNode.assertObject(handle, pctx, typeConf, this.wm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FactHandle insert(Object object, boolean dynamic, RuleImpl rule, Activation activation) {
        if (this.isBoundToRuleBase()) {
            return super.insert(object, dynamic, rule, activation);
        }
        if (object == null) {
            return null;
        }
        try {
            this.wm.startOperation();
            InternalFactHandle handle = null;
            try {
                this.lock.lock();
                handle = this.objectStore.getHandleForObject(object);
                if (handle != null) {
                    InternalFactHandle internalFactHandle = handle;
                    return internalFactHandle;
                }
                handle = this.createHandle(object);
                this.objectStore.addHandle(handle, object);
            }
            finally {
                this.lock.unlock();
            }
            InternalFactHandle internalFactHandle = handle;
            return internalFactHandle;
        }
        finally {
            this.wm.endOperation();
        }
    }

    private InternalFactHandle createHandle(Object object) {
        return this.handleFactory.newFactHandle(object, null, this.wm, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(FactHandle factHandle, RuleImpl rule, Activation activation, FactHandle.State fhState) {
        if (this.isBoundToRuleBase()) {
            super.delete(factHandle, rule, activation, fhState);
        }
        try {
            this.lock.lock();
            this.wm.startOperation();
            InternalFactHandle handle = (InternalFactHandle)factHandle;
            if (handle.getId() == -1) {
                return;
            }
            if (handle.isDisconnected()) {
                handle = this.objectStore.reconnect(handle);
            }
            if (handle.getEntryPoint() != this) {
                throw new IllegalArgumentException("Invalid Entry Point. You updated the FactHandle on entry point '" + handle.getEntryPoint().getEntryPointId() + "' instead of '" + this.getEntryPointId() + "'");
            }
            this.objectStore.removeHandle(handle);
        }
        finally {
            this.wm.endOperation();
            this.lock.unlock();
        }
    }
}

