/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.ruleunit;

import java.util.HashMap;
import java.util.Map;
import org.drools.core.common.ConcurrentNodeMemories;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.Memory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.NodeMemories;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.ruleunit.RuleUnitUtil;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.runtime.rule.RuleUnit;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class RuleUnitsNodeMemories
implements NodeMemories {
    private final InternalKnowledgeBase kBase;
    private NodeMemories unitMemories;
    private final Map<RuleUnit.Identity, RuleUnitMemory> unitMemoriesMap = new HashMap<RuleUnit.Identity, RuleUnitMemory>();

    public RuleUnitsNodeMemories(InternalKnowledgeBase kBase) {
        this.kBase = kBase;
    }

    public void bindRuleUnit(StatefulKnowledgeSessionImpl session, RuleUnit ruleUnit) {
        RuleUnit.Identity ruId = ruleUnit.getUnitIdentity();
        RuleUnitMemory memory = this.unitMemoriesMap.get(ruId);
        if (memory == null) {
            this.unitMemoriesMap.put(ruId, this.createMemory(this.kBase, session, ruleUnit));
        } else {
            this.unitMemories = memory.memories;
        }
    }

    private RuleUnitMemory createMemory(InternalKnowledgeBase kBase, StatefulKnowledgeSessionImpl session, RuleUnit ruleUnit) {
        RuleUnitMemory memory = new RuleUnitMemory(kBase, ruleUnit);
        this.unitMemories = memory.memories;
        session.initInitialFact(kBase, null);
        memory.handle = session.getEntryPoint("$$units$$").insert(ruleUnit);
        return memory;
    }

    public void unbindRuleUnit() {
        this.unitMemories = null;
    }

    @Override
    public <T extends Memory> T getNodeMemory(MemoryFactory<T> node, InternalWorkingMemory wm) {
        return this.unitMemories.getNodeMemory(node, wm);
    }

    @Override
    public void clearNodeMemory(MemoryFactory node) {
        this.unitMemories.clearNodeMemory(node);
    }

    @Override
    public void clear() {
        this.unitMemories.clear();
    }

    @Override
    public Memory peekNodeMemory(int memoryId) {
        return this.unitMemories.peekNodeMemory(memoryId);
    }

    @Override
    public int length() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void resetAllMemories(StatefulKnowledgeSession session) {
        this.unitMemories.resetAllMemories(session);
    }

    private static class RuleUnitMemory {
        NodeMemories memories;
        FactHandle handle;

        RuleUnitMemory(InternalKnowledgeBase kBase, RuleUnit ruleUnit) {
            this.memories = new ConcurrentNodeMemories(kBase, RuleUnitUtil.getUnitName(ruleUnit));
        }
    }
}

