/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.integration.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.mvel2.UnresolveablePropertyException;
import org.mvel2.integration.VariableResolver;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.integration.impl.BaseVariableResolverFactory;
import org.mvel2.integration.impl.MapVariableResolver;

public class MapVariableResolverFactory
extends BaseVariableResolverFactory {
    protected Map<String, Object> variables;

    public MapVariableResolverFactory() {
        this.variables = new HashMap<String, Object>();
    }

    public MapVariableResolverFactory(Map variables) {
        this.variables = variables;
    }

    public MapVariableResolverFactory(Map<String, Object> variables, VariableResolverFactory nextFactory) {
        this.variables = variables;
        this.nextFactory = nextFactory;
    }

    public MapVariableResolverFactory(Map<String, Object> variables, boolean cachingSafe) {
        this.variables = variables;
    }

    @Override
    public VariableResolver createVariable(String name, Object value) {
        try {
            VariableResolver vr = this.getVariableResolver(name);
            vr.setValue(value);
            return vr;
        }
        catch (UnresolveablePropertyException e) {
            MapVariableResolver vr = new MapVariableResolver(this.variables, name);
            this.addResolver(name, vr).setValue(value);
            return vr;
        }
    }

    @Override
    public VariableResolver createVariable(String name, Object value, Class<?> type) {
        VariableResolver vr;
        try {
            vr = this.getVariableResolver(name);
        }
        catch (UnresolveablePropertyException e) {
            vr = null;
        }
        if (vr != null && vr.getType() != null) {
            throw new RuntimeException("variable already defined within scope: " + vr.getType() + " " + name);
        }
        vr = new MapVariableResolver(this.variables, name, type);
        this.addResolver(name, vr).setValue(value);
        return vr;
    }

    @Override
    public VariableResolver getVariableResolver(String name) {
        VariableResolver vr = (VariableResolver)this.variableResolvers.get(name);
        if (vr != null) {
            return vr;
        }
        if (this.variables.containsKey(name)) {
            vr = new MapVariableResolver(this.variables, name);
            this.variableResolvers.put(name, vr);
            return vr;
        }
        if (this.nextFactory != null) {
            return this.nextFactory.getVariableResolver(name);
        }
        throw new UnresolveablePropertyException("unable to resolve variable '" + name + "'");
    }

    @Override
    public boolean isResolveable(String name) {
        return this.variableResolvers.containsKey(name) || this.variables != null && this.variables.containsKey(name) || this.nextFactory != null && this.nextFactory.isResolveable(name);
    }

    protected VariableResolver addResolver(String name, VariableResolver vr) {
        this.variableResolvers.put(name, vr);
        return vr;
    }

    @Override
    public boolean isTarget(String name) {
        return this.variableResolvers.containsKey(name);
    }

    @Override
    public Set<String> getKnownVariables() {
        if (this.nextFactory == null) {
            if (this.variables != null) {
                return new HashSet<String>(this.variables.keySet());
            }
            return new HashSet<String>(0);
        }
        if (this.variables != null) {
            return new HashSet<String>(this.variables.keySet());
        }
        return new HashSet<String>(0);
    }

    public void clear() {
        this.variableResolvers.clear();
        this.variables.clear();
    }
}

