/*
 * Decompiled with CFR 0.152.
 */
package org.kie.eclipse.preferences;

import java.net.URL;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.kie.eclipse.preferences.AbstractRuntimesBlock;
import org.kie.eclipse.runtime.IRuntime;
import org.kie.eclipse.runtime.IRuntimeManager;
import org.kie.eclipse.runtime.IRuntimeManagerListener;

public abstract class AbstractRuntimesPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
IRuntimeManagerListener {
    private IRuntimeManager runtimeManager;
    private AbstractRuntimesBlock runtimesBlock;

    public AbstractRuntimesPreferencePage() {
        super("Installed Runtimes");
    }

    public AbstractRuntimesPreferencePage(String title) {
        super(title);
    }

    public void init(IWorkbench workbench) {
    }

    public void dispose() {
        this.runtimeManager.removeListener(this);
    }

    public void createControl(Composite parent) {
        this.runtimeManager = this.getRuntimeManager();
        super.createControl(parent);
        this.getDefaultsButton().setVisible(false);
        this.runtimeManager.addListener(this);
    }

    protected Control createContents(Composite ancestor) {
        this.initializeDialogUnits((Control)ancestor);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        ancestor.setLayout((Layout)layout);
        Label l = new Label(ancestor, 64);
        l.setFont(ancestor.getFont());
        l.setText("Add, remove or edit Runtime definitions. By default, the checked Runtime is added to the build path of newly created projects.");
        GridData gd = new GridData(768);
        gd.horizontalSpan = 1;
        gd.widthHint = 300;
        l.setLayoutData((Object)gd);
        final String downloadHelpURL = this.getDownloadHelpURL();
        Label helpLabel = null;
        if (downloadHelpURL != null) {
            helpLabel = new Label(ancestor, 64);
            helpLabel.setFont(ancestor.getFont());
            gd = new GridData(768);
            gd.horizontalSpan = 1;
            gd.verticalIndent = 12;
            helpLabel.setLayoutData((Object)gd);
            Link link = new Link(ancestor, 0);
            gd = new GridData(768);
            gd.horizontalSpan = 1;
            gd.verticalIndent = 0;
            link.setLayoutData((Object)gd);
            link.setText("<A>Click here to learn how to download and install a Runtime</A>");
            link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    try {
                        URL url = new URL(downloadHelpURL);
                        PlatformUI.getWorkbench().getBrowserSupport().createBrowser("Download JBoss Runtime").openURL(url);
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            });
        }
        l = new Label(ancestor, 0);
        gd = new GridData(768);
        gd.heightHint = 1;
        l.setLayoutData((Object)gd);
        this.runtimesBlock = this.createRuntimesBlock();
        this.runtimesBlock.createControl(ancestor);
        IRuntime[] runtimes = this.runtimeManager.getConfiguredRuntimes();
        this.runtimesBlock.setRuntimes(runtimes);
        if (this.runtimesBlock.getDefaultRuntime() == null) {
            this.setErrorMessage("Select a default Runtime");
        }
        Control control = this.runtimesBlock.getControl();
        GridData data = new GridData(1808);
        data.horizontalSpan = 1;
        data.widthHint = 450;
        control.setLayoutData((Object)data);
        this.runtimesBlock.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IRuntime runtime = AbstractRuntimesPreferencePage.this.runtimesBlock.getDefaultRuntime();
                if (runtime == null) {
                    if (AbstractRuntimesPreferencePage.this.runtimesBlock.getRuntimes().length == 0) {
                        AbstractRuntimesPreferencePage.this.setErrorMessage("Create a default Runtime");
                    } else {
                        AbstractRuntimesPreferencePage.this.setErrorMessage("Select a default Runtime");
                    }
                } else {
                    AbstractRuntimesPreferencePage.this.setErrorMessage(null);
                }
            }
        });
        if (this.runtimesBlock.getRuntimes().length == 0) {
            helpLabel.setText("Don't have any installed Runtimes yet?");
        } else {
            helpLabel.setText("Need to find the latest Runtime?");
        }
        this.applyDialogFont(ancestor);
        return ancestor;
    }

    public boolean performOk() {
        if (this.runtimeManager.getDefaultRuntime() != null) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Warning", (String)"You need to restart Eclipse to update the Runtime of existing projects.");
        }
        this.runtimeManager.setRuntimes(this.runtimesBlock.getRuntimes());
        return super.performOk();
    }

    @Override
    public void runtimeAdded(IRuntime rt) {
        this.runtimesBlock.setRuntimes(this.runtimeManager.getConfiguredRuntimes());
    }

    @Override
    public void runtimeRemoved(IRuntime rt) {
        this.runtimesBlock.setRuntimes(this.runtimeManager.getConfiguredRuntimes());
    }

    @Override
    public void runtimesChanged(IRuntime[] newList) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                AbstractRuntimesPreferencePage.this.runtimesBlock.setRuntimes(AbstractRuntimesPreferencePage.this.runtimeManager.getConfiguredRuntimes());
            }
        });
    }

    protected String getDownloadHelpURL() {
        return null;
    }

    protected abstract IRuntimeManager getRuntimeManager();

    protected abstract AbstractRuntimesBlock createRuntimesBlock();
}

