/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.common.editor.core.command;

import org.drools.eclipse.flow.common.editor.core.ElementConnection;
import org.drools.eclipse.flow.common.editor.core.ElementWrapper;
import org.eclipse.gef.commands.Command;

public class ElementConnectionCreateCommand
extends Command {
    private ElementConnection connection;
    private ElementWrapper source;
    private ElementWrapper target;

    public boolean canExecute() {
        if (this.source.equals(this.target)) {
            return false;
        }
        for (ElementConnection conn : this.source.getOutgoingConnections()) {
            if (!conn.getTarget().equals(this.target)) continue;
            return false;
        }
        return this.source.acceptsOutgoingConnection(this.connection, this.target) && this.target != null && this.target.acceptsIncomingConnection(this.connection, this.source);
    }

    public void execute() {
        this.connection.connect(this.source, this.target);
    }

    public ElementWrapper getSource() {
        return this.source;
    }

    public ElementWrapper getTarget() {
        return this.target;
    }

    public void redo() {
        this.connection.connect(this.source, this.target);
    }

    public void setSource(ElementWrapper source) {
        this.source = source;
    }

    public void setConnection(ElementConnection connection) {
        this.connection = connection;
    }

    public void setTarget(ElementWrapper target) {
        this.target = target;
    }

    public void undo() {
        this.connection.disconnect();
    }
}

