/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.reteoo;

import org.drools.core.base.ClassFieldReader;
import org.drools.core.reteoo.AlphaNode;
import org.drools.core.rule.constraint.MvelConstraint;
import org.drools.core.spi.AlphaNodeFieldConstraint;
import org.drools.core.spi.Constraint;
import org.drools.core.spi.FieldValue;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.eclipse.reteoo.BaseVertex;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.swt.graphics.Color;

public class AlphaNodeVertex
extends BaseVertex {
    private final AlphaNode node;
    private final String NODE_NAME = "AlphaNode";

    public AlphaNodeVertex(AlphaNode node) {
        this.node = node;
    }

    @Override
    public String getHtml() {
        AlphaNodeFieldConstraint constraint = this.node.getConstraint();
        if (constraint instanceof MvelConstraint) {
            MvelConstraint mvelConstraint = (MvelConstraint)constraint;
            return "AlphaNode<BR/>expression : " + mvelConstraint.toString();
        }
        return "AlphaNode<BR/>";
    }

    @Override
    public String toString() {
        return this.node.toString();
    }

    @Override
    public Color getFillColor() {
        return ColorConstants.blue;
    }

    public String getFieldName() {
        MvelConstraint mvelConstraint;
        InternalReadAccessor accessor;
        AlphaNodeFieldConstraint constraint = this.node.getConstraint();
        if (constraint instanceof MvelConstraint && (accessor = (mvelConstraint = (MvelConstraint)constraint).getFieldExtractor()) instanceof ClassFieldReader) {
            return ((ClassFieldReader)accessor).getFieldName();
        }
        return null;
    }

    public String getEvaluator() {
        AlphaNodeFieldConstraint constraint = this.node.getConstraint();
        if (constraint instanceof MvelConstraint) {
            MvelConstraint mvelConstraint = (MvelConstraint)constraint;
            return mvelConstraint.toString();
        }
        return null;
    }

    public String getValue() {
        AlphaNodeFieldConstraint constraint = this.node.getConstraint();
        if (constraint instanceof MvelConstraint) {
            MvelConstraint mvelConstraint = (MvelConstraint)constraint;
            FieldValue field = mvelConstraint.getField();
            return field != null ? field.toString() : null;
        }
        return null;
    }

    public Constraint getConstraint() {
        return this.node.getConstraint();
    }
}

