/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.compiler.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.jbpm.compiler.xml.ProcessDataEventListener;
import org.jbpm.compiler.xml.ProcessDataEventListenerProvider;
import org.jbpm.workflow.core.Node;
import org.kie.api.definition.process.Process;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessBuildData {
    private static final Logger logger = LoggerFactory.getLogger(ProcessBuildData.class);
    private static List<ProcessDataEventListenerProvider> providers = ProcessBuildData.collectProviders();
    private List<Process> processes = new ArrayList<Process>();
    private Map<Long, Node> nodes = new HashMap<Long, Node>();
    private Map<String, Object> metaData = new HashMap<String, Object>();
    private List<ProcessDataEventListener> listeners = new ArrayList<ProcessDataEventListener>();

    public ProcessBuildData() {
        if (providers != null) {
            for (ProcessDataEventListenerProvider provider : providers) {
                this.listeners.add(provider.newInstance());
            }
        }
    }

    public List<Process> getProcesses() {
        for (Process process : this.processes) {
            this.onComplete(process);
        }
        return this.processes;
    }

    public void addProcess(Process process) {
        this.onProcess(process);
        this.processes.add(process);
    }

    public void setProcesses(List<Process> process) {
        this.processes = process;
    }

    public Map<Long, Node> getNodes() {
        return this.nodes;
    }

    public boolean addNode(Node node) {
        this.onNode(node);
        return this.nodes.put(node.getId(), node) != null;
    }

    public Node getNode(Long id) {
        return this.nodes.get(id);
    }

    public Object getMetaData(String name) {
        return this.metaData.get(name);
    }

    public void setMetaData(String name, Object data) {
        this.onMetaData(name, data);
        this.metaData.put(name, data);
    }

    protected void onNode(Node node) {
        for (ProcessDataEventListener listener : this.listeners) {
            listener.onNodeAdded(node);
        }
    }

    protected void onProcess(Process process) {
        for (ProcessDataEventListener listener : this.listeners) {
            listener.onProcessAdded(process);
        }
    }

    protected void onMetaData(String name, Object data) {
        for (ProcessDataEventListener listener : this.listeners) {
            listener.onMetaDataAdded(name, data);
        }
    }

    protected void onComplete(Process process) {
        for (ProcessDataEventListener listener : this.listeners) {
            listener.onComplete(process);
        }
    }

    public void onBuildComplete(Process process) {
        for (ProcessDataEventListener listener : this.listeners) {
            listener.onBuildComplete(process);
        }
    }

    private static List<ProcessDataEventListenerProvider> collectProviders() {
        ServiceLoader<ProcessDataEventListenerProvider> availableProviders = ServiceLoader.load(ProcessDataEventListenerProvider.class);
        ArrayList<ProcessDataEventListenerProvider> collected = new ArrayList<ProcessDataEventListenerProvider>();
        try {
            for (ProcessDataEventListenerProvider provider : availableProviders) {
                collected.add(provider);
            }
        }
        catch (Throwable e) {
            logger.debug("Unable to collect process data event listeners due to {}", (Object)e.getMessage());
        }
        return collected;
    }
}

