/*
 * Decompiled with CFR 0.152.
 */
package org.drools.jsr94.rules.admin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.rules.ObjectFilter;
import javax.rules.admin.RuleExecutionSet;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.SessionConfiguration;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.drools.core.spi.FactHandleFactory;
import org.drools.jsr94.rules.Jsr94FactHandleFactory;
import org.drools.jsr94.rules.admin.RuleImpl;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.definition.KiePackage;
import org.kie.api.definition.rule.Rule;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.StatelessKieSession;

public class RuleExecutionSetImpl
implements RuleExecutionSet {
    private static final long serialVersionUID = 510L;
    private String description;
    private String defaultObjectFilterClassName;
    private Map properties;
    private InternalKnowledgeBase kBase;
    private InternalKnowledgePackage pkg;
    private ObjectFilter objectFilter;

    RuleExecutionSetImpl(InternalKnowledgePackage pkg, Map properties) {
        this.properties = null == properties ? new HashMap() : properties;
        this.pkg = pkg;
        this.description = pkg.getName();
        RuleBaseConfiguration config = (RuleBaseConfiguration)this.properties.get("javax.rules.admin.RuleExecutionSet.ruleBaseConfiguration");
        if (config == null) {
            config = new RuleBaseConfiguration();
        }
        config.getComponentFactory().setHandleFactoryProvider((FactHandleFactory)new Jsr94FactHandleFactory());
        this.kBase = KnowledgeBaseFactory.newKnowledgeBase((KieBaseConfiguration)config);
        this.kBase.addPackage((KiePackage)pkg);
        this.kBase = this.kBase;
    }

    public synchronized ObjectFilter getObjectFilter() {
        if (this.objectFilter != null) {
            return this.objectFilter;
        }
        if (this.defaultObjectFilterClassName != null) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl == null) {
                cl = RuleExecutionSetImpl.class.getClassLoader();
            }
            try {
                Class<?> filterClass = cl.loadClass(this.defaultObjectFilterClassName);
                this.objectFilter = (ObjectFilter)filterClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e.toString());
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e.toString());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e.toString());
            }
        }
        return this.objectFilter;
    }

    public KieSession newStatefulSession(SessionConfiguration conf) {
        return this.kBase.newKieSession((KieSessionConfiguration)conf, null);
    }

    public StatelessKieSession newStatelessSession() {
        return this.kBase.newStatelessKieSession();
    }

    public String getName() {
        return this.pkg.getName();
    }

    public String getDescription() {
        return this.description;
    }

    public Object getProperty(Object key) {
        return this.properties.get(key);
    }

    public void setProperty(Object key, Object value) {
        this.properties.put(key, value);
    }

    public void setDefaultObjectFilter(String objectFilterClassname) {
        this.defaultObjectFilterClassName = objectFilterClassname;
    }

    public String getDefaultObjectFilter() {
        return this.defaultObjectFilterClassName;
    }

    public List getRules() {
        ArrayList<RuleImpl> jsr94Rules = new ArrayList<RuleImpl>();
        for (Rule rule : this.pkg.getRules()) {
            jsr94Rules.add(new RuleImpl((org.drools.core.definitions.rule.impl.RuleImpl)rule));
        }
        return jsr94Rules;
    }
}

