/*
 * Decompiled with CFR 0.152.
 */
package org.kie.eclipse.navigator.view.utils;

import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.drools.eclipse.util.DroolsRuntimeManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.core.EclipseGitProgressTransformer;
import org.eclipse.egit.core.op.ConnectProviderOperation;
import org.eclipse.egit.core.project.RepositoryFinder;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.window.Window;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.TransportConfigCallback;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.WindowCacheConfig;
import org.eclipse.jgit.transport.JschConfigSessionFactory;
import org.eclipse.jgit.transport.OpenSshConfig;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.TransportGitSsh;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.util.FS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.kie.eclipse.navigator.view.actions.repository.KieCredentialsProvider;
import org.kie.eclipse.navigator.view.content.ProjectNode;
import org.kie.eclipse.navigator.view.content.RepositoryNode;
import org.kie.eclipse.runtime.IRuntime;
import org.kie.eclipse.runtime.IRuntimeManager;
import org.kie.eclipse.server.IKieRepositoryHandler;
import org.kie.eclipse.server.IKieServerHandler;
import org.kie.eclipse.server.IKieServiceDelegate;
import org.kie.eclipse.server.KieRepositoryHandler;
import org.kie.eclipse.utils.FileUtils;
import org.kie.eclipse.utils.GitUtils;
import org.kie.eclipse.utils.PreferencesUtils;

public class ActionUtils {
    public static IRuntimeManager runtimeManager = DroolsRuntimeManager.getDefault();

    private ActionUtils() {
    }

    public static Shell getShell() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    public static void importRepository(final Window.IExceptionHandler exceptionHandler, RepositoryNode container) {
        IKieRepositoryHandler handler = (IKieRepositoryHandler)container.getHandler();
        IKieServerHandler server = (IKieServerHandler)handler.getRoot();
        IKieServiceDelegate delegate = container.getHandler().getDelegate();
        try {
            WindowCacheConfig config = new WindowCacheConfig();
            config.setPackedGitMMAP(false);
            config.install();
            String host = delegate.getServer().getHost();
            int port = delegate.getGitPort();
            String username = delegate.getUsername();
            String password = delegate.getPassword();
            URIish uri = PreferencesUtils.getRepoURI((String)host, (int)port, (String)username, (String)handler.getName());
            uri = PreferencesUtils.getRepoURI((String)host, (int)port, (String)username, (String)handler.getName());
            final String localPath = PreferencesUtils.getRepoPath((IKieRepositoryHandler)handler);
            File localDir = new File(localPath);
            if (localDir.exists()) {
                boolean okToOverwrite = MessageDialog.openQuestion((Shell)ActionUtils.getShell(), (String)"Directory Exists", (String)("The local directory '" + localPath + "' already exists.\n" + "Do you want to overwrite it?"));
                if (!okToOverwrite) {
                    return;
                }
                if (!FileUtils.deleteFolder((File)localDir)) {
                    MessageDialog.openInformation((Shell)ActionUtils.getShell(), (String)"Delete Failed", (String)"Cannot delete the directory because it may be open in your workspace, or may be in use by some other process.\n\nPlease try exiting Eclipse and removing the directory manually");
                    return;
                }
            }
            final String remotePath = uri.toString();
            final KieCredentialsProvider credentialsProvider = new KieCredentialsProvider(server, username, password);
            Job job = new Job("Import Repository"){

                protected IStatus run(IProgressMonitor monitor) {
                    Git git = null;
                    try {
                        try {
                            EclipseGitProgressTransformer gitMonitor = new EclipseGitProgressTransformer(monitor);
                            CloneCommand cloneCmd = (CloneCommand)((CloneCommand)((CloneCommand)Git.cloneRepository().setURI(remotePath).setDirectory(new File(localPath)).setProgressMonitor((ProgressMonitor)gitMonitor).setCloneAllBranches(true).setTimeout(60)).setCredentialsProvider(credentialsProvider)).setTransportConfigCallback(new TransportConfigCallback(){

                                public void configure(Transport transport) {
                                    TransportGitSsh gt = (TransportGitSsh)transport;
                                    gt.setSshSessionFactory((SshSessionFactory)new JschConfigSessionFactory(){

                                        protected Session createSession(OpenSshConfig.Host hc, String user, String host, int port, FS fs) throws JSchException {
                                            Session session = super.createSession(hc, user, host, port, fs);
                                            session.setConfig("PreferredAuthentications", "password");
                                            return session;
                                        }

                                        protected void configure(OpenSshConfig.Host hc, Session session) {
                                            session.setConfig("PreferredAuthentications", "password");
                                        }
                                    });
                                }
                            });
                            git = cloneCmd.call();
                            GitUtils.getRepositoryUtil().addConfiguredRepository(git.getRepository().getDirectory());
                        }
                        catch (Exception e) {
                            exceptionHandler.handleException((Throwable)e);
                            if (git != null) {
                                git.getRepository().close();
                                git = null;
                            }
                        }
                    }
                    finally {
                        if (git != null) {
                            git.getRepository().close();
                            git = null;
                        }
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setUser(true);
            job.schedule();
            job.join();
        }
        catch (Exception e) {
            exceptionHandler.handleException((Throwable)e);
        }
    }

    public static void pullRepository(final Window.IExceptionHandler exceptionHandler, RepositoryNode container) {
        final IKieRepositoryHandler handler = (IKieRepositoryHandler)container.getHandler();
        IKieServerHandler server = (IKieServerHandler)handler.getRoot();
        IKieServiceDelegate delegate = container.getHandler().getDelegate();
        try {
            WindowCacheConfig config = new WindowCacheConfig();
            config.setPackedGitMMAP(false);
            config.install();
            String username = delegate.getUsername();
            String password = delegate.getPassword();
            final KieCredentialsProvider credentialsProvider = new KieCredentialsProvider(server, username, password);
            Job job = new Job("Import Repository"){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        try {
                            EclipseGitProgressTransformer gitMonitor = new EclipseGitProgressTransformer(monitor);
                            PullCommand pullCmd = new Git(handler.getRepository()).pull();
                            ((PullCommand)((PullCommand)pullCmd.setProgressMonitor((ProgressMonitor)gitMonitor).setTimeout(60)).setCredentialsProvider(credentialsProvider)).setTransportConfigCallback(new TransportConfigCallback(){

                                public void configure(Transport transport) {
                                    TransportGitSsh gt = (TransportGitSsh)transport;
                                    gt.setSshSessionFactory((SshSessionFactory)new JschConfigSessionFactory(){

                                        protected Session createSession(OpenSshConfig.Host hc, String user, String host, int port, FS fs) throws JSchException {
                                            Session session = super.createSession(hc, user, host, port, fs);
                                            session.setConfig("PreferredAuthentications", "password");
                                            return session;
                                        }

                                        protected void configure(OpenSshConfig.Host hc, Session session) {
                                            session.setConfig("PreferredAuthentications", "password");
                                        }
                                    });
                                }
                            });
                            pullCmd.call();
                        }
                        catch (Exception e) {
                            exceptionHandler.handleException((Throwable)e);
                            monitor.worked(1);
                        }
                    }
                    finally {
                        monitor.worked(1);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setUser(true);
            job.schedule();
            job.join();
        }
        catch (Exception e) {
            exceptionHandler.handleException((Throwable)e);
        }
    }

    public static IJavaProject importProject(final ProjectNode projectNode, final Window.IExceptionHandler exceptionHandler) {
        final String projectName = projectNode.getName();
        final AtomicReference ar = new AtomicReference();
        IWorkspaceRunnable wsr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                try {
                    IJavaProject javaProject = ActionUtils.createOrOpenProject(projectNode, projectName, monitor);
                    if (javaProject != null) {
                        ar.set(javaProject);
                        IProject project = javaProject.getProject();
                        HashMap<IProject, File> projectsToConnect = new HashMap<IProject, File>();
                        RepositoryFinder finder = new RepositoryFinder(project);
                        finder.setFindInChildren(false);
                        List mappings = finder.find((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        if (!mappings.isEmpty()) {
                            RepositoryMapping mapping = (RepositoryMapping)mappings.iterator().next();
                            projectsToConnect.put(project, mapping.getGitDirAbsolutePath().toFile());
                            ConnectProviderOperation connect = new ConnectProviderOperation(projectsToConnect);
                            connect.execute(monitor);
                            FileUtils.createGitIgnore((IJavaProject)javaProject, (IProgressMonitor)monitor);
                            FileUtils.addMavenLibraries((IJavaProject)javaProject, (IProgressMonitor)monitor);
                        }
                    }
                }
                catch (Exception e1) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            exceptionHandler.handleException((Throwable)e1);
                        }
                    });
                }
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(wsr, null);
        }
        catch (Exception e) {
            exceptionHandler.handleException((Throwable)e);
        }
        return (IJavaProject)ar.get();
    }

    public static IJavaProject createOrOpenProject(ProjectNode projectNode, final String projectName, IProgressMonitor monitor) throws CoreException, IllegalArgumentException {
        final AtomicReference ar = new AtomicReference();
        final IWorkspace workspace = ResourcesPlugin.getWorkspace();
        final IProject project = workspace.getRoot().getProject(projectName);
        RepositoryNode repoNode = (RepositoryNode)projectNode.getParent();
        Repository repository = ((KieRepositoryHandler)repoNode.getHandler()).getRepository();
        final IPath location = new Path(repository.getWorkTree().toString()).append(projectName);
        if (project.exists()) {
            IPath oldLocation;
            if (!project.isOpen() && (oldLocation = project.getFile(".project").getLocation()) != null && oldLocation.equals((Object)location)) {
                project.open(monitor);
                project.refreshLocal(2, monitor);
                return null;
            }
            throw new IllegalArgumentException("The Project " + projectName + " already exists");
        }
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException {
                try {
                    IProjectDescription pd = workspace.newProjectDescription(projectName);
                    pd.setLocation(location);
                    FileUtils.addJavaNature((IProjectDescription)pd);
                    FileUtils.addMavenNature((IProjectDescription)pd);
                    project.create(pd, (IProgressMonitor)new SubProgressMonitor(monitor, 30));
                    project.open(128, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                    IRuntime runtime = runtimeManager.getEffectiveRuntime(null, true);
                    runtimeManager.setRuntime(runtime, project, monitor);
                    IJavaProject javaProject = JavaCore.create((IProject)project);
                    FileUtils.createOutputLocation((IJavaProject)javaProject, (String)"bin", (IProgressMonitor)monitor);
                    FileUtils.addJRELibraries((IJavaProject)javaProject, (IProgressMonitor)monitor);
                    FileUtils.addJavaBuilder((IJavaProject)javaProject, (IProgressMonitor)monitor);
                    FileUtils.addMavenBuilder((IJavaProject)javaProject, (IProgressMonitor)monitor);
                    runtimeManager.addBuilder(javaProject, monitor);
                    FileUtils.addFolderToClasspath((IJavaProject)javaProject, (String)"src/main/java", (boolean)true, (IProgressMonitor)monitor);
                    FileUtils.addFolderToClasspath((IJavaProject)javaProject, (String)"src/main/resources", (boolean)true, (IProgressMonitor)monitor);
                    FileUtils.addFolderToClasspath((IJavaProject)javaProject, (String)"src/main/rules", (boolean)true, (IProgressMonitor)monitor);
                    ar.set(javaProject);
                    project.refreshLocal(2, monitor);
                }
                catch (Exception e) {
                    ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Problem creating new project", (String)e.getMessage(), null);
                }
            }
        };
        try {
            op.run(monitor);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return (IJavaProject)ar.get();
    }

    public static void createProjectArtifacts(final IJavaProject javaProject, final String groupId, final String artifactId, final String version, IProgressMonitor monitor) throws CoreException, IllegalArgumentException {
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException {
                try {
                    FileUtils.createFolder((IJavaProject)javaProject, (String)"src/main/resources/META-INF", (IProgressMonitor)monitor);
                    FileUtils.createFolder((IJavaProject)javaProject, (String)"src/main/resources/META-INF/maven", (IProgressMonitor)monitor);
                    FileUtils.createMavenArtifacts((IJavaProject)javaProject, (String)groupId, (String)artifactId, (String)version, (IProgressMonitor)monitor);
                    FileUtils.createKJarArtifacts((IJavaProject)javaProject, (IProgressMonitor)monitor);
                    javaProject.getProject().build(6, monitor);
                    IProject project = javaProject.getProject();
                    project.refreshLocal(2, monitor);
                    project.build(6, monitor);
                }
                catch (Exception e) {
                    ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Problem creating project artifacts", (String)e.getMessage(), null);
                }
            }
        };
        try {
            op.run(monitor);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

