/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.dom;

import org.eclipse.webdav.Policy;
import org.eclipse.webdav.dom.ElementEditor;
import org.eclipse.webdav.dom.MalformedElementException;
import org.w3c.dom.Element;

public class Label
extends ElementEditor {
    protected static final String[] childNames = new String[]{"add", "set", "remove"};

    public Label(Element root) throws MalformedElementException {
        super(root, "label");
    }

    public String getLabelName() throws MalformedElementException {
        Element child = Label.getFirstChild(this.root, childNames);
        Label.ensureNotNull(Policy.bind("ensure.missingElmt"), child);
        String labelName = Label.getChildText(child, "label-name", true);
        Label.ensureNotNull(Policy.bind("ensure.missingLabel"), labelName);
        return labelName;
    }

    public boolean isAdd() {
        Element child = Label.getFirstChild(this.root, childNames);
        return Label.getNSLocalName(child).equals("add");
    }

    public boolean isRemove() {
        Element child = Label.getFirstChild(this.root, childNames);
        return Label.getNSLocalName(child).equals("remove");
    }

    public boolean isSet() {
        Element child = Label.getFirstChild(this.root, childNames);
        return Label.getNSLocalName(child).equals("set");
    }
}

