/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.internal.kernel;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.webdav.internal.kernel.ConditionTerm;
import org.eclipse.webdav.internal.kernel.Policy;
import org.eclipse.webdav.internal.kernel.WebDAVException;

public class Condition {
    private String uri = null;
    private Vector conditionTerms = new Vector();

    public Condition() {
    }

    public Condition(String uri) {
        this.uri = uri;
    }

    public void addConditionTerm(ConditionTerm term) throws WebDAVException {
        this.conditionTerms.addElement(term);
    }

    public boolean contains(ConditionTerm term) {
        boolean match = false;
        Enumeration terms = this.getConditionTerms();
        while (!match && terms.hasMoreElements()) {
            ConditionTerm t = (ConditionTerm)terms.nextElement();
            match = term.matches(t);
        }
        return match;
    }

    public static Condition create(StreamTokenizer tokenizer) throws WebDAVException {
        Condition condition;
        block8: {
            condition = new Condition();
            try {
                int token = tokenizer.ttype;
                if (token == 60) {
                    token = tokenizer.nextToken();
                    if (token != -3) {
                        throw new WebDAVException(400, Policy.bind("error.parseMissingResource"));
                    }
                    condition.setResourceURI(tokenizer.sval);
                    token = tokenizer.nextToken();
                    if (token == 62) {
                        token = tokenizer.nextToken();
                    } else {
                        throw new WebDAVException(400, Policy.bind("error.parseMissing", String.valueOf(token), ">"));
                    }
                }
                if (token == 40) {
                    while (token == 40) {
                        condition.addConditionTerm(ConditionTerm.create(tokenizer));
                        token = tokenizer.ttype;
                    }
                    break block8;
                }
                throw new WebDAVException(400, Policy.bind("error.parseMissingStart", String.valueOf(token)));
            }
            catch (IOException iOException) {}
        }
        return condition;
    }

    public static Condition create(String ifHeader) throws WebDAVException {
        StreamTokenizer tokenizer = new StreamTokenizer(new StringReader(ifHeader));
        tokenizer.wordChars(33, 47);
        tokenizer.wordChars(58, 64);
        tokenizer.ordinaryChar(40);
        tokenizer.ordinaryChar(41);
        tokenizer.ordinaryChar(60);
        tokenizer.ordinaryChar(62);
        tokenizer.ordinaryChar(91);
        tokenizer.ordinaryChar(93);
        tokenizer.quoteChar(34);
        Condition condition = null;
        try {
            int token = tokenizer.nextToken();
            condition = Condition.create(tokenizer);
            token = tokenizer.ttype;
            if (token != -1) {
                throw new WebDAVException(400, Policy.bind("error.parseMissing", String.valueOf(token), "EOF"));
            }
        }
        catch (IOException iOException) {}
        return condition;
    }

    public Enumeration getConditionTerms() {
        return this.conditionTerms.elements();
    }

    public String getResourceURI() {
        return this.uri;
    }

    public boolean matches(Condition condition) {
        return false;
    }

    public void setResourceURI(String value) {
        this.uri = value;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.getResourceURI() != null) {
            buffer.append('<');
            buffer.append(this.getResourceURI());
            buffer.append("> ");
        }
        Enumeration terms = this.getConditionTerms();
        while (terms.hasMoreElements()) {
            ConditionTerm term = (ConditionTerm)terms.nextElement();
            buffer.append(term.toString());
            if (!terms.hasMoreElements()) continue;
            buffer.append(' ');
        }
        return buffer.toString();
    }
}

