/*
 * Decompiled with CFR 0.152.
 */
package org.kie.internal.xstream;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.time.DateTimeException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;

public class LocalDateTimeXStreamConverter
implements Converter {
    private final DateTimeFormatter formatter = new DateTimeFormatterBuilder().appendPattern("uuuu-MM-dd'T'HH:mm:ss").appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).toFormatter();

    public void marshal(Object localDateTimeObject, HierarchicalStreamWriter writer, MarshallingContext context) {
        LocalDateTime localDateTime = (LocalDateTime)localDateTimeObject;
        writer.setValue(this.formatter.format(localDateTime));
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        String localDateTimeString = reader.getValue();
        try {
            return LocalDateTime.from(this.formatter.parse(localDateTimeString));
        }
        catch (DateTimeException e) {
            throw new IllegalStateException("Failed to convert string (" + localDateTimeString + ") to type (" + LocalDateTime.class.getName() + ").");
        }
    }

    public boolean canConvert(Class type) {
        return LocalDateTime.class.isAssignableFrom(type);
    }
}

