/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.ast;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.event.DMNRuntimeEventManager;
import org.kie.dmn.core.api.DMNExpressionEvaluator;
import org.kie.dmn.core.api.EvaluatorResult;
import org.kie.dmn.core.ast.EvaluatorResultImpl;
import org.kie.dmn.core.impl.DMNResultImpl;
import org.kie.dmn.core.util.Msg;
import org.kie.dmn.core.util.MsgUtil;
import org.kie.dmn.model.v1_1.DMNElement;
import org.kie.dmn.model.v1_1.DMNModelInstrumentedBase;
import org.kie.dmn.model.v1_1.Relation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMNRelationEvaluator
implements DMNExpressionEvaluator {
    private static final Logger logger = LoggerFactory.getLogger(DMNRelationEvaluator.class);
    private final String name;
    private final DMNElement node;
    private final Relation relationDef;
    private final List<String> columns = new ArrayList<String>();
    private final List<List<DMNExpressionEvaluator>> rows = new ArrayList<List<DMNExpressionEvaluator>>();

    public DMNRelationEvaluator(String name, DMNElement node, Relation relationDef) {
        this.name = name;
        this.node = node;
        this.relationDef = relationDef;
    }

    public void addColumn(String name) {
        this.columns.add(name);
    }

    public void addRow(List<DMNExpressionEvaluator> vals) {
        this.rows.add(vals);
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public List<List<DMNExpressionEvaluator>> getRows() {
        return this.rows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EvaluatorResult evaluate(DMNRuntimeEventManager eventManager, DMNResult dmnr) {
        DMNResultImpl result = (DMNResultImpl)dmnr;
        ArrayList results = new ArrayList();
        DMNContext previousContext = result.getContext();
        DMNContext dmnContext = previousContext.clone();
        result.setContext(dmnContext);
        try {
            for (int rowIndex = 0; rowIndex < this.rows.size(); ++rowIndex) {
                List<DMNExpressionEvaluator> row = this.rows.get(rowIndex);
                HashMap<String, Object> element = new HashMap<String, Object>();
                for (int i = 0; i < this.columns.size(); ++i) {
                    try {
                        EvaluatorResult er = row.get(i).evaluate(eventManager, result);
                        if (er.getResultType() != EvaluatorResult.ResultType.SUCCESS) {
                            MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)this.node, result, null, null, Msg.ERR_EVAL_ROW_ELEMENT_ON_POSITION_ON_ROW_OF_RELATION, i + 1, rowIndex + 1, this.name);
                            EvaluatorResultImpl evaluatorResultImpl = new EvaluatorResultImpl(results, EvaluatorResult.ResultType.FAILURE);
                            return evaluatorResultImpl;
                        }
                        element.put(this.columns.get(i), er.getResult());
                        continue;
                    }
                    catch (Exception e) {
                        MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)this.node, result, e, null, Msg.ERR_EVAL_ROW_ELEMENT_ON_POSITION_ON_ROW_OF_RELATION, i + 1, rowIndex + 1, this.name);
                        EvaluatorResultImpl evaluatorResultImpl = new EvaluatorResultImpl(results, EvaluatorResult.ResultType.FAILURE);
                        return evaluatorResultImpl;
                    }
                }
                results.add(element);
            }
        }
        finally {
            result.setContext(previousContext);
        }
        return new EvaluatorResultImpl(results, EvaluatorResult.ResultType.SUCCESS);
    }
}

