/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.ast;

import java.util.LinkedHashMap;
import java.util.Map;
import org.kie.dmn.api.core.DMNType;
import org.kie.dmn.api.core.ast.DMNNode;
import org.kie.dmn.api.core.ast.DecisionServiceNode;
import org.kie.dmn.core.api.DMNExpressionEvaluator;
import org.kie.dmn.core.ast.DMNBaseNode;
import org.kie.dmn.model.v1_1.DecisionService;
import org.kie.dmn.model.v1_1.NamedElement;

public class DecisionServiceNodeImpl
extends DMNBaseNode
implements DecisionServiceNode {
    private DecisionService ds;
    private DMNExpressionEvaluator evaluator;
    private DMNType resultType;
    private Map<String, DMNNode> inputs = new LinkedHashMap<String, DMNNode>();

    public DecisionServiceNodeImpl(DecisionService ds, DMNType resultType) {
        super((NamedElement)ds);
        this.ds = ds;
        this.resultType = resultType;
    }

    public DecisionService getDecisionService() {
        return this.ds;
    }

    public DMNExpressionEvaluator getEvaluator() {
        return this.evaluator;
    }

    public void setEvaluator(DMNExpressionEvaluator evaluator) {
        this.evaluator = evaluator;
    }

    public DMNType getResultType() {
        return this.resultType;
    }

    public void setResultType(DMNType resultType) {
        this.resultType = resultType;
    }

    @Override
    public DMNType getType() {
        return this.getResultType();
    }

    @Override
    public Map<String, DMNNode> getDependencies() {
        throw new UnsupportedOperationException("A Decision Service has no dependency");
    }

    @Override
    public void setDependencies(Map<String, DMNNode> dependencies) {
        throw new UnsupportedOperationException("A Decision Service has no dependency");
    }

    @Override
    public void addDependency(String name, DMNNode dependency) {
        throw new UnsupportedOperationException("A Decision Service has no dependency");
    }

    public Map<String, DMNNode> getInputParameters() {
        return this.inputs;
    }

    public void addInputParameter(String name, DMNNode node) {
        this.inputs.put(name, node);
    }
}

