/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.compiler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNType;
import org.kie.dmn.api.core.ast.BusinessKnowledgeModelNode;
import org.kie.dmn.api.core.ast.DMNNode;
import org.kie.dmn.api.core.ast.DecisionNode;
import org.kie.dmn.core.api.DMNExpressionEvaluator;
import org.kie.dmn.core.api.EvaluatorResult;
import org.kie.dmn.core.ast.DMNBaseNode;
import org.kie.dmn.core.ast.DMNContextEvaluator;
import org.kie.dmn.core.ast.DMNDTExpressionEvaluator;
import org.kie.dmn.core.ast.DMNFunctionDefinitionEvaluator;
import org.kie.dmn.core.ast.DMNInvocationEvaluator;
import org.kie.dmn.core.ast.DMNListEvaluator;
import org.kie.dmn.core.ast.DMNLiteralExpressionEvaluator;
import org.kie.dmn.core.ast.DMNRelationEvaluator;
import org.kie.dmn.core.ast.EvaluatorResultImpl;
import org.kie.dmn.core.compiler.DMNCompilerContext;
import org.kie.dmn.core.compiler.DMNCompilerHelper;
import org.kie.dmn.core.compiler.DMNCompilerImpl;
import org.kie.dmn.core.compiler.DMNFEELHelper;
import org.kie.dmn.core.compiler.DMNTypeRegistry;
import org.kie.dmn.core.impl.BaseDMNTypeImpl;
import org.kie.dmn.core.impl.DMNModelImpl;
import org.kie.dmn.core.util.Msg;
import org.kie.dmn.core.util.MsgUtil;
import org.kie.dmn.feel.FEEL;
import org.kie.dmn.feel.lang.CompiledExpression;
import org.kie.dmn.feel.runtime.FEELFunction;
import org.kie.dmn.feel.runtime.UnaryTest;
import org.kie.dmn.feel.runtime.decisiontables.DTDecisionRule;
import org.kie.dmn.feel.runtime.decisiontables.DTInputClause;
import org.kie.dmn.feel.runtime.decisiontables.DTOutputClause;
import org.kie.dmn.feel.runtime.decisiontables.DecisionTableImpl;
import org.kie.dmn.feel.runtime.decisiontables.HitPolicy;
import org.kie.dmn.feel.runtime.functions.BaseFEELFunction;
import org.kie.dmn.feel.runtime.functions.DTInvokerFunction;
import org.kie.dmn.model.v1_1.Binding;
import org.kie.dmn.model.v1_1.BusinessKnowledgeModel;
import org.kie.dmn.model.v1_1.Context;
import org.kie.dmn.model.v1_1.ContextEntry;
import org.kie.dmn.model.v1_1.DMNElement;
import org.kie.dmn.model.v1_1.DMNModelInstrumentedBase;
import org.kie.dmn.model.v1_1.Decision;
import org.kie.dmn.model.v1_1.DecisionRule;
import org.kie.dmn.model.v1_1.DecisionTable;
import org.kie.dmn.model.v1_1.Expression;
import org.kie.dmn.model.v1_1.FunctionDefinition;
import org.kie.dmn.model.v1_1.InformationItem;
import org.kie.dmn.model.v1_1.InputClause;
import org.kie.dmn.model.v1_1.Invocation;
import org.kie.dmn.model.v1_1.LiteralExpression;
import org.kie.dmn.model.v1_1.NamedElement;
import org.kie.dmn.model.v1_1.OutputClause;
import org.kie.dmn.model.v1_1.Relation;
import org.kie.dmn.model.v1_1.UnaryTests;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMNEvaluatorCompiler {
    private static final Logger logger = LoggerFactory.getLogger(DMNEvaluatorCompiler.class);
    private final DMNFEELHelper feel;
    private DMNCompilerImpl compiler;

    public DMNEvaluatorCompiler(DMNCompilerImpl compiler, DMNFEELHelper feel) {
        this.compiler = compiler;
        this.feel = feel;
    }

    public DMNExpressionEvaluator compileExpression(DMNCompilerContext ctx, DMNModelImpl model, DMNBaseNode node, String exprName, Expression expression) {
        if (expression == null) {
            if (node instanceof DecisionNode) {
                MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)node.getSource(), model, null, null, Msg.MISSING_EXPRESSION_FOR_DECISION, node.getIdentifierString());
            } else if (node instanceof BusinessKnowledgeModelNode) {
                MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)node.getSource(), model, null, null, Msg.MISSING_EXPRESSION_FOR_BKM, node.getIdentifierString());
            } else {
                MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)node.getSource(), model, null, null, Msg.MISSING_EXPRESSION_FOR_NODE, node.getIdentifierString());
            }
        } else {
            if (expression instanceof LiteralExpression) {
                return this.compileLiteralExpression(ctx, model, node, exprName, (LiteralExpression)expression);
            }
            if (expression instanceof DecisionTable) {
                return this.compileDecisionTable(ctx, model, node, exprName, (DecisionTable)expression);
            }
            if (expression instanceof FunctionDefinition) {
                return this.compileFunctionDefinition(ctx, model, node, exprName, (FunctionDefinition)expression);
            }
            if (expression instanceof Context) {
                return this.compileContext(ctx, model, node, exprName, (Context)expression);
            }
            if (expression instanceof org.kie.dmn.model.v1_1.List) {
                return this.compileList(ctx, model, node, exprName, (org.kie.dmn.model.v1_1.List)expression);
            }
            if (expression instanceof Relation) {
                return this.compileRelation(ctx, model, node, exprName, (Relation)expression);
            }
            if (expression instanceof Invocation) {
                return this.compileInvocation(ctx, model, node, (Invocation)expression);
            }
            MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)node.getSource(), model, null, null, Msg.EXPR_TYPE_NOT_SUPPORTED_IN_NODE, expression.getClass().getSimpleName(), node.getIdentifierString());
        }
        return null;
    }

    private DMNExpressionEvaluator compileInvocation(DMNCompilerContext ctx, DMNModelImpl model, DMNBaseNode node, Invocation expression) {
        Invocation invocation = expression;
        String functionName = ((LiteralExpression)invocation.getExpression()).getText();
        DMNInvocationEvaluator invEval = new DMNInvocationEvaluator(node.getName(), (DMNElement)node.getSource(), functionName, invocation, null, this.feel.newFEELInstance());
        for (Binding binding : invocation.getBinding()) {
            if (binding.getParameter() == null) {
                MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)binding, model, null, null, Msg.MISSING_PARAMETER_FOR_INVOCATION, node.getIdentifierString());
                return null;
            }
            if (binding.getExpression() == null) {
                MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)binding, model, null, null, Msg.MISSING_PARAMETER_FOR_INVOCATION, node.getIdentifierString());
                return null;
            }
            invEval.addParameter(binding.getParameter().getName(), this.compiler.resolveTypeRef(model, (NamedElement)binding.getParameter(), (DMNModelInstrumentedBase)binding.getParameter(), binding.getParameter().getTypeRef()), this.compileExpression(ctx, model, node, binding.getParameter().getName(), binding.getExpression()));
        }
        return invEval;
    }

    private DMNExpressionEvaluator compileRelation(DMNCompilerContext ctx, DMNModelImpl model, DMNBaseNode node, String relationName, Relation expression) {
        Relation relationDef = expression;
        DMNRelationEvaluator relationEval = new DMNRelationEvaluator(node.getName(), (DMNElement)node.getSource(), relationDef);
        for (InformationItem col : relationDef.getColumn()) {
            DMNCompilerHelper.checkVariableName(model, (NamedElement)col, col.getName());
            relationEval.addColumn(col.getName());
        }
        for (org.kie.dmn.model.v1_1.List row : relationDef.getRow()) {
            ArrayList<DMNExpressionEvaluator> values = new ArrayList<DMNExpressionEvaluator>();
            for (Expression expr : row.getExpression()) {
                LiteralExpression literalExpression;
                if (expr instanceof LiteralExpression && ((literalExpression = (LiteralExpression)expr).getText() == null || literalExpression.getText().isEmpty())) {
                    LiteralExpression nullProxy = new LiteralExpression();
                    nullProxy.setText("null");
                    nullProxy.setImportedValues(literalExpression.getImportedValues());
                    nullProxy.setExpressionLanguage(literalExpression.getExpressionLanguage());
                    nullProxy.setTypeRef(literalExpression.getTypeRef());
                    nullProxy.setId(literalExpression.getId());
                    nullProxy.setLabel(literalExpression.getLabel());
                    nullProxy.setDescription(literalExpression.getDescription());
                    nullProxy.setExtensionElements(literalExpression.getExtensionElements());
                    nullProxy.setParent(literalExpression.getParent());
                    nullProxy.getNsContext().putAll(literalExpression.getNsContext());
                    nullProxy.setAdditionalAttributes(literalExpression.getAdditionalAttributes());
                    nullProxy.setLocation(literalExpression.getLocation());
                    expr = nullProxy;
                }
                values.add(this.compileExpression(ctx, model, node, relationName, expr));
            }
            relationEval.addRow(values);
        }
        return relationEval;
    }

    private DMNExpressionEvaluator compileList(DMNCompilerContext ctx, DMNModelImpl model, DMNBaseNode node, String listName, org.kie.dmn.model.v1_1.List expression) {
        org.kie.dmn.model.v1_1.List listDef = expression;
        DMNListEvaluator listEval = new DMNListEvaluator(node.getName(), (DMNElement)node.getSource(), listDef);
        for (Expression expr : listDef.getExpression()) {
            listEval.addElement(this.compileExpression(ctx, model, node, listName, expr));
        }
        return listEval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DMNExpressionEvaluator compileContext(DMNCompilerContext ctx, DMNModelImpl model, DMNBaseNode node, String contextName, Context expression) {
        Context ctxDef = expression;
        DMNContextEvaluator ctxEval = new DMNContextEvaluator(node.getName(), ctxDef);
        ctx.enterFrame();
        try {
            for (ContextEntry ce : ctxDef.getContextEntry()) {
                if (ce.getVariable() != null) {
                    String entryName = ce.getVariable().getName();
                    DMNCompilerHelper.checkVariableName(model, node.getSource(), entryName);
                    DMNType entryType = this.compiler.resolveTypeRef(model, (NamedElement)ce.getVariable(), (DMNModelInstrumentedBase)ce.getVariable(), ce.getVariable().getTypeRef());
                    ctx.setVariable(entryName, entryType);
                    DMNExpressionEvaluator evaluator = this.compileExpression(ctx, model, node, entryName, ce.getExpression());
                    ctxEval.addEntry(entryName, entryType, evaluator, ce);
                    continue;
                }
                DMNType type = null;
                if (ctxDef.getParent() instanceof ContextEntry && ((ContextEntry)ctxDef.getParent()).getVariable() != null) {
                    ContextEntry parentEntry = (ContextEntry)ctxDef.getParent();
                    type = this.compiler.resolveTypeRef(model, (NamedElement)parentEntry.getVariable(), (DMNModelInstrumentedBase)parentEntry.getVariable(), parentEntry.getVariable().getTypeRef());
                } else if (node instanceof BusinessKnowledgeModelNode) {
                    type = ((BusinessKnowledgeModelNode)node).getResultType();
                } else if (node instanceof DecisionNode) {
                    type = ((DecisionNode)node).getResultType();
                }
                ctxEval.addEntry("__RESULT__", type, this.compileExpression(ctx, model, node, contextName, ce.getExpression()), ce);
            }
        }
        finally {
            ctx.exitFrame();
        }
        return ctxEval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DMNExpressionEvaluator compileFunctionDefinition(DMNCompilerContext ctx, DMNModelImpl model, DMNBaseNode node, String functionName, FunctionDefinition expression) {
        FunctionDefinition.Kind kind;
        FunctionDefinition funcDef = expression;
        String kindStr = (String)funcDef.getAdditionalAttributes().get(FunctionDefinition.KIND_QNAME);
        FunctionDefinition.Kind kind2 = kind = kindStr != null ? FunctionDefinition.Kind.determineFromString((String)kindStr) : FunctionDefinition.Kind.FEEL;
        if (kind == null) {
            MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)funcDef, model, null, null, Msg.FUNC_DEF_INVALID_KIND, kindStr, node.getIdentifierString());
            return new DMNFunctionDefinitionEvaluator(node.getName(), funcDef);
        }
        if (kind.equals((Object)FunctionDefinition.Kind.FEEL)) {
            ctx.enterFrame();
            try {
                DMNFunctionDefinitionEvaluator fexpr;
                DMNFunctionDefinitionEvaluator func = new DMNFunctionDefinitionEvaluator(node.getName(), funcDef);
                for (InformationItem p2 : funcDef.getFormalParameter()) {
                    DMNCompilerHelper.checkVariableName(model, (NamedElement)p2, p2.getName());
                    DMNType dmnType = this.compiler.resolveTypeRef(model, (NamedElement)p2, (DMNModelInstrumentedBase)p2, p2.getTypeRef());
                    func.addParameter(p2.getName(), dmnType);
                    ctx.setVariable(p2.getName(), dmnType);
                }
                DMNExpressionEvaluator eval = this.compileExpression(ctx, model, node, functionName, funcDef.getExpression());
                if (eval instanceof DMNLiteralExpressionEvaluator && ((DMNLiteralExpressionEvaluator)eval).isFunctionDefinition()) {
                    fexpr = ((DMNLiteralExpressionEvaluator)eval).getExpression();
                    FEELFunction feelFunction = this.feel.evaluateFunctionDef(ctx, (CompiledExpression)fexpr, model, (DMNElement)funcDef, (Msg.Message)Msg.FUNC_DEF_COMPILATION_ERR, functionName, node.getIdentifierString());
                    DMNInvocationEvaluator invoker = new DMNInvocationEvaluator(node.getName(), (DMNElement)node.getSource(), functionName, new Invocation(), (fctx, fname) -> feelFunction, null);
                    for (InformationItem p3 : funcDef.getFormalParameter()) {
                        invoker.addParameter(p3.getName(), func.getParameterType(p3.getName()), (em, dr) -> new EvaluatorResultImpl(dr.getContext().get(p3.getName()), EvaluatorResult.ResultType.SUCCESS));
                    }
                    eval = invoker;
                }
                func.setEvaluator(eval);
                fexpr = func;
                return fexpr;
            }
            finally {
                ctx.exitFrame();
            }
        }
        if (kind.equals((Object)FunctionDefinition.Kind.JAVA)) {
            if (funcDef.getExpression() instanceof Context) {
                Context context = (Context)funcDef.getExpression();
                String clazz = null;
                String method = null;
                for (ContextEntry ce : context.getContextEntry()) {
                    if (ce.getVariable() == null || ce.getVariable().getName() == null || ce.getExpression() == null || !(ce.getExpression() instanceof LiteralExpression)) continue;
                    if (ce.getVariable().getName().equals("class")) {
                        clazz = this.stripQuotes(((LiteralExpression)ce.getExpression()).getText().trim());
                        continue;
                    }
                    if (!ce.getVariable().getName().equals("method signature")) continue;
                    method = this.stripQuotes(((LiteralExpression)ce.getExpression()).getText().trim());
                }
                if (clazz != null && method != null) {
                    String params = funcDef.getFormalParameter().stream().map(p -> p.getName()).collect(Collectors.joining(","));
                    String expr = String.format("function(%s) external { java: { class: \"%s\", method signature: \"%s\" }}", params, clazz, method);
                    try {
                        FEELFunction feelFunction = this.feel.evaluateFunctionDef(ctx, expr, model, (DMNElement)funcDef, (Msg.Message)Msg.FUNC_DEF_COMPILATION_ERR, functionName, node.getIdentifierString());
                        if (feelFunction != null) {
                            ((BaseFEELFunction)feelFunction).setName(functionName);
                        }
                        DMNInvocationEvaluator invoker = new DMNInvocationEvaluator(node.getName(), (DMNElement)node.getSource(), functionName, new Invocation(), (fctx, fname) -> feelFunction, null);
                        DMNFunctionDefinitionEvaluator func = new DMNFunctionDefinitionEvaluator(node.getName(), funcDef);
                        for (InformationItem p4 : funcDef.getFormalParameter()) {
                            DMNCompilerHelper.checkVariableName(model, (NamedElement)p4, p4.getName());
                            DMNType dmnType = this.compiler.resolveTypeRef(model, (NamedElement)p4, (DMNModelInstrumentedBase)p4, p4.getTypeRef());
                            func.addParameter(p4.getName(), dmnType);
                            invoker.addParameter(p4.getName(), dmnType, (em, dr) -> new EvaluatorResultImpl(dr.getContext().get(p4.getName()), EvaluatorResult.ResultType.SUCCESS));
                        }
                        func.setEvaluator(invoker);
                        return func;
                    }
                    catch (Throwable e) {
                        MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)expression, model, e, null, Msg.FUNC_DEF_COMPILATION_ERR, functionName, node.getIdentifierString(), "Exception raised: " + e.getClass().getSimpleName());
                    }
                } else {
                    MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)expression, model, null, null, Msg.FUNC_DEF_MISSING_ENTRY, functionName, node.getIdentifierString());
                }
            } else {
                MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)funcDef, model, null, null, Msg.FUNC_DEF_BODY_NOT_CONTEXT, node.getIdentifierString());
            }
        } else if (kind.equals((Object)FunctionDefinition.Kind.PMML)) {
            MsgUtil.reportMessage(logger, DMNMessage.Severity.WARN, (DMNModelInstrumentedBase)funcDef, model, null, null, Msg.FUNC_DEF_PMML_NOT_SUPPORTED, node.getIdentifierString());
        } else {
            MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)funcDef, model, null, null, Msg.FUNC_DEF_INVALID_KIND, kindStr, node.getIdentifierString());
        }
        return new DMNFunctionDefinitionEvaluator(node.getName(), funcDef);
    }

    private String stripQuotes(String trim) {
        return trim.startsWith("\"") && trim.endsWith("\"") && trim.length() >= 2 ? trim.substring(1, trim.length() - 1) : trim;
    }

    private String resolveNamespaceForTypeRef(QName typeRef, DMNElement fromElement) {
        if (typeRef.getNamespaceURI() == null || typeRef.getNamespaceURI().isEmpty()) {
            String namespaceURI = fromElement.getNamespaceURI(typeRef.getPrefix());
            return namespaceURI;
        }
        return typeRef.getNamespaceURI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DMNExpressionEvaluator compileDecisionTable(DMNCompilerContext ctx, DMNModelImpl model, DMNBaseNode node, String dtName, DecisionTable dt) {
        ArrayList<DTInputClause> inputs = new ArrayList<DTInputClause>();
        ArrayList<DMNType> inputTypes = new ArrayList<DMNType>();
        int index = 0;
        for (InputClause ic : dt.getInput()) {
            ++index;
            String inputExpressionText = ic.getInputExpression().getText();
            String inputValuesText = Optional.ofNullable(ic.getInputValues()).map(UnaryTests::getText).orElse(null);
            List<UnaryTest> inputValues = null;
            DMNType inputType = DMNTypeRegistry.UNKNOWN;
            if (inputValuesText != null) {
                inputValues = this.textToUnaryTestList(ctx, inputValuesText, model, (DMNElement)ic, Msg.ERR_COMPILING_FEEL_EXPR_ON_DT_INPUT_CLAUSE_IDX, inputValuesText, node.getIdentifierString(), index);
            } else if (ic.getInputExpression().getTypeRef() != null) {
                QName inputExpressionTypeRef = ic.getInputExpression().getTypeRef();
                BaseDMNTypeImpl baseDMNTypeImpl = (BaseDMNTypeImpl)model.getTypeRegistry().resolveType(this.resolveNamespaceForTypeRef(inputExpressionTypeRef, (DMNElement)ic.getInputExpression()), inputExpressionTypeRef.getLocalPart());
                inputType = baseDMNTypeImpl;
                inputValues = baseDMNTypeImpl.getAllowedValuesFEEL();
            }
            CompiledExpression compiledInput = this.feel.compileFeelExpression(ctx, inputExpressionText, model, (DMNElement)dt, Msg.ERR_COMPILING_FEEL_EXPR_ON_DT_INPUT_CLAUSE_IDX, inputExpressionText, dtName, index);
            inputs.add(new DTInputClause(inputExpressionText, inputValuesText, inputValues, compiledInput));
            inputTypes.add(inputType);
        }
        ArrayList<DTOutputClause> outputs = new ArrayList<DTOutputClause>();
        index = 0;
        boolean hasOutputValues = false;
        for (Object oc : dt.getOutput()) {
            QName inferredTypeRef;
            String outputName = oc.getName();
            if (outputName != null) {
                DMNCompilerHelper.checkVariableName(model, node.getSource(), outputName);
            }
            String id = oc.getId();
            String outputValuesText = Optional.ofNullable(oc.getOutputValues()).map(UnaryTests::getText).orElse(null);
            String string = oc.getDefaultOutputEntry() != null ? oc.getDefaultOutputEntry().getText() : null;
            BaseDMNTypeImpl typeRef = (BaseDMNTypeImpl)DMNTypeRegistry.UNKNOWN;
            List<UnaryTest> outputValues = null;
            if (oc.getTypeRef() != null) {
                QName outputExpressionTypeRef = oc.getTypeRef();
                typeRef = (BaseDMNTypeImpl)model.getTypeRegistry().resolveType(this.resolveNamespaceForTypeRef(outputExpressionTypeRef, (DMNElement)oc), outputExpressionTypeRef.getLocalPart());
                if (typeRef == null) {
                    typeRef = (BaseDMNTypeImpl)DMNTypeRegistry.UNKNOWN;
                }
            } else if (dt.getOutput().size() == 1 && (dt.getParent() instanceof Decision || dt.getParent() instanceof BusinessKnowledgeModel || dt.getParent() instanceof ContextEntry) && (inferredTypeRef = this.recurseUpToInferTypeRef(model, (OutputClause)oc, (DMNElement)dt)) != null) {
                typeRef = (BaseDMNTypeImpl)model.getTypeRegistry().resolveType(this.resolveNamespaceForTypeRef(inferredTypeRef, (DMNElement)oc), inferredTypeRef.getLocalPart());
            }
            if (outputValuesText != null) {
                outputValues = this.textToUnaryTestList(ctx, outputValuesText, model, (DMNElement)oc, Msg.ERR_COMPILING_FEEL_EXPR_ON_DT_OUTPUT_CLAUSE_IDX, outputValuesText, node.getIdentifierString(), ++index);
            } else if (typeRef != DMNTypeRegistry.UNKNOWN) {
                outputValues = typeRef.getAllowedValuesFEEL();
            }
            if (outputValues != null && !outputValues.isEmpty()) {
                hasOutputValues = true;
            }
            outputs.add(new DTOutputClause(outputName, id, outputValues, string, typeRef.getFeelType(), typeRef.isCollection()));
        }
        if (dt.getHitPolicy().equals((Object)org.kie.dmn.model.v1_1.HitPolicy.PRIORITY) && !hasOutputValues) {
            MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, dt.getParent(), model, null, null, Msg.MISSING_OUTPUT_VALUES, dt.getParent());
        }
        ArrayList<DTDecisionRule> rules = new ArrayList<DTDecisionRule>();
        index = 0;
        for (DecisionRule dr : dt.getRule()) {
            DTDecisionRule rule = new DTDecisionRule(index);
            for (int i = 0; i < dr.getInputEntry().size(); ++i) {
                List<Object> tests;
                UnaryTests unaryTests = (UnaryTests)dr.getInputEntry().get(i);
                if (unaryTests == null || unaryTests.getText() == null || unaryTests.getText().isEmpty()) {
                    tests = Collections.emptyList();
                    MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)unaryTests, model, null, null, Msg.DTABLE_EMPTY_ENTRY, dt.getRule().indexOf(dr) + 1, dr.getInputEntry().indexOf(unaryTests) + 1, dt.getParentDRDElement().getIdentifierString());
                } else {
                    ctx.enterFrame();
                    try {
                        ctx.setVariable("?", (DMNType)inputTypes.get(i));
                        tests = this.textToUnaryTestList(ctx, unaryTests.getText(), model, (DMNElement)dr, Msg.ERR_COMPILING_FEEL_EXPR_ON_DT_RULE_IDX, unaryTests.getText(), node.getIdentifierString(), index + 1);
                    }
                    finally {
                        ctx.exitFrame();
                    }
                }
                rule.getInputEntry().add((c, x) -> tests.stream().anyMatch(t -> {
                    Boolean result = (Boolean)t.apply(c, x);
                    return result != null && result != false;
                }));
            }
            for (LiteralExpression literalExpression : dr.getOutputEntry()) {
                String expressionText = literalExpression.getText();
                CompiledExpression compiledExpression = this.feel.compileFeelExpression(ctx, expressionText, model, (DMNElement)dr, Msg.ERR_COMPILING_FEEL_EXPR_ON_DT_RULE_IDX, expressionText, dtName, index + 1);
                rule.getOutputEntry().add(compiledExpression);
            }
            rules.add(rule);
            ++index;
        }
        String policy = dt.getHitPolicy().value() + (dt.getAggregation() != null ? " " + dt.getAggregation().value() : "");
        HitPolicy hp = HitPolicy.fromString((String)policy);
        ArrayList<Object> parameterNames = new ArrayList<Object>();
        if (node instanceof BusinessKnowledgeModelNode) {
            parameterNames.addAll(((BusinessKnowledgeModelNode)node).getBusinessKnowledModel().getEncapsulatedLogic().getFormalParameter().stream().map(f -> f.getName()).collect(Collectors.toList()));
        } else {
            for (Map.Entry entry : node.getDependencies().entrySet()) {
                if (((DMNNode)entry.getValue()).getModelNamespace().equals(node.getModelNamespace())) {
                    parameterNames.add(entry.getKey());
                    continue;
                }
                Optional<String> importAlias = model.getImportAliasFor(((DMNNode)entry.getValue()).getModelNamespace(), ((DMNNode)entry.getValue()).getModelName());
                if (!importAlias.isPresent()) {
                    MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, dt.getParent(), model, null, null, Msg.IMPORT_NOT_FOUND_FOR_NODE_MISSING_ALIAS, new QName(((DMNNode)entry.getValue()).getModelNamespace(), ((DMNNode)entry.getValue()).getModelName()), node);
                    return null;
                }
                parameterNames.add(importAlias.get() + "." + (String)entry.getKey());
            }
        }
        FEEL feelInstance = this.feel.newFEELInstance();
        DecisionTableImpl decisionTableImpl = new DecisionTableImpl(dtName, parameterNames, inputs, outputs, rules, hp, feelInstance);
        DTInvokerFunction dtf = new DTInvokerFunction(decisionTableImpl);
        DMNDTExpressionEvaluator dtee = new DMNDTExpressionEvaluator(node, feelInstance, dtf);
        return dtee;
    }

    private QName recurseUpToInferTypeRef(DMNModelImpl model, OutputClause originalElement, DMNElement recursionIdx) {
        if (recursionIdx.getParent() instanceof Decision) {
            InformationItem parentVariable = ((Decision)recursionIdx.getParent()).getVariable();
            if (parentVariable != null) {
                return this.variableTypeRefOrErrIfNull(model, parentVariable);
            }
            return null;
        }
        if (recursionIdx.getParent() instanceof BusinessKnowledgeModel) {
            InformationItem parentVariable = ((BusinessKnowledgeModel)recursionIdx.getParent()).getVariable();
            if (parentVariable != null) {
                return this.variableTypeRefOrErrIfNull(model, parentVariable);
            }
            return null;
        }
        if (recursionIdx.getParent() instanceof ContextEntry) {
            ContextEntry parentCtxEntry = (ContextEntry)recursionIdx.getParent();
            if (parentCtxEntry.getVariable() != null) {
                return this.variableTypeRefOrErrIfNull(model, parentCtxEntry.getVariable());
            }
            Context parentCtx = (Context)parentCtxEntry.getParent();
            if (((ContextEntry)parentCtx.getContextEntry().get(parentCtx.getContextEntry().size() - 1)).equals(parentCtxEntry)) {
                return this.recurseUpToInferTypeRef(model, originalElement, (DMNElement)parentCtx);
            }
            MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)parentCtxEntry, model, null, null, Msg.MISSING_VARIABLE_ON_CONTEXT, parentCtxEntry);
            return null;
        }
        MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)originalElement, model, null, null, Msg.UNKNOWN_OUTPUT_TYPE_FOR_DT_ON_NODE, originalElement.getParentDRDElement().getIdentifierString());
        return null;
    }

    private QName variableTypeRefOrErrIfNull(DMNModelImpl model, InformationItem variable) {
        if (variable.getTypeRef() != null) {
            return variable.getTypeRef();
        }
        MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)variable, model, null, null, Msg.MISSING_TYPEREF_FOR_VARIABLE, variable.getName(), variable.getParentDRDElement().getIdentifierString());
        return null;
    }

    private DMNExpressionEvaluator compileLiteralExpression(DMNCompilerContext ctx, DMNModelImpl model, DMNBaseNode node, String exprName, LiteralExpression expression) {
        DMNLiteralExpressionEvaluator evaluator = null;
        if (expression.getExpressionLanguage() == null || expression.getExpressionLanguage().equals("http://www.omg.org/spec/FEEL/20140401")) {
            String exprText = expression.getText();
            if (exprText != null) {
                try {
                    CompiledExpression compiledExpression = this.feel.compileFeelExpression(ctx, exprText, model, (DMNElement)expression, Msg.ERR_COMPILING_FEEL_EXPR_FOR_NAME_ON_NODE, exprText, exprName, node.getIdentifierString());
                    evaluator = new DMNLiteralExpressionEvaluator(compiledExpression);
                }
                catch (Throwable e) {
                    MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)expression, model, e, null, Msg.ERR_COMPILING_FEEL_EXPR_FOR_NAME_ON_NODE, exprText, exprName, node.getIdentifierString(), "Exception raised: " + e.getClass().getSimpleName());
                }
            } else {
                MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)expression, model, null, null, Msg.MISSING_EXPRESSION_FOR_NAME, exprName, node.getIdentifierString());
            }
        }
        return evaluator;
    }

    private List<UnaryTest> textToUnaryTestList(DMNCompilerContext ctx, String text, DMNModelImpl model, DMNElement element, Msg.Message errorMsg, Object ... msgParams) {
        if (text == null || text.isEmpty()) {
            return Collections.emptyList();
        }
        return this.feel.evaluateUnaryTests(ctx, text, model, element, errorMsg, msgParams);
    }
}

