/*
 * Decompiled with CFR 0.152.
 */
package org.drools.repository.events;

import org.drools.repository.AssetItem;
import org.drools.repository.PackageItem;
import org.drools.repository.RepositoryTestCase;
import org.drools.repository.RulesRepository;
import org.drools.repository.events.CheckinEvent;
import org.drools.repository.events.LoadEvent;
import org.drools.repository.events.MockLoadEvent;
import org.drools.repository.events.MockSaveEvent;
import org.drools.repository.events.SaveEvent;
import org.drools.repository.events.StorageEventManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class StorageEventManagerTest
extends RepositoryTestCase {
    @After
    public void tearDownLocal() throws Exception {
        StorageEventManager.le = null;
        StorageEventManager.se = null;
    }

    @Test
    public void testLoadEvent() {
        System.setProperty("guvnor.loadEventListener", "org.drools.repository.events.MockLoadEvent");
        LoadEvent le = StorageEventManager.loadEvent();
        Assert.assertNotNull((Object)le);
        Assert.assertTrue((boolean)(le instanceof MockLoadEvent));
        System.setProperty("guvnor.loadEventListener", "");
        Assert.assertNull((Object)StorageEventManager.loadEvent());
        StorageEventManager.le = le;
        Assert.assertNotNull((Object)StorageEventManager.getLoadEvent());
        Assert.assertTrue((boolean)StorageEventManager.hasLoadEvent());
        StorageEventManager.le = null;
        Assert.assertFalse((boolean)StorageEventManager.hasLoadEvent());
    }

    @Test
    public void testSaveEvent() {
        System.setProperty("guvnor.saveEventListener", "org.drools.repository.events.MockSaveEvent");
        SaveEvent le = StorageEventManager.saveEvent();
        Assert.assertNotNull((Object)le);
        Assert.assertTrue((boolean)(le instanceof MockSaveEvent));
        System.setProperty("guvnor.saveEventListener", "");
        Assert.assertNull((Object)StorageEventManager.saveEvent());
        StorageEventManager.se = le;
        Assert.assertNotNull((Object)StorageEventManager.getSaveEvent());
        Assert.assertTrue((boolean)StorageEventManager.hasSaveEvent());
        StorageEventManager.se = null;
        Assert.assertFalse((boolean)StorageEventManager.hasSaveEvent());
    }

    @Test
    public void testAssetContentCallbacks() {
        StorageEventManager.le = null;
        StorageEventManager.se = null;
        RulesRepository repo = this.getRepo();
        PackageItem pkg = repo.loadDefaultPackage();
        AssetItem asset = pkg.addAsset("testAssetContentCallbacks", "");
        Assert.assertEquals((long)0L, (long)asset.getContentLength());
        asset.updateContent("boo");
        asset.checkin("");
        asset.updateContent("whee");
        StorageEventManager.le = new MockLoadEvent();
        StorageEventManager.se = new MockSaveEvent();
        asset.checkin("");
        Assert.assertTrue((boolean)((MockSaveEvent)StorageEventManager.se).checkinCalled);
        asset.getContent();
        Assert.assertTrue((boolean)((MockLoadEvent)StorageEventManager.le).loadCalled);
    }

    @Test
    public void testCheckinListener() throws Exception {
        StorageEventManager.le = null;
        StorageEventManager.se = null;
        final AssetItem[] x = new AssetItem[1];
        CheckinEvent e = new CheckinEvent(){

            public void afterCheckin(AssetItem item) {
                x[0] = item;
            }
        };
        StorageEventManager.registerCheckinEvent((CheckinEvent)e);
        RulesRepository repo = this.getRepo();
        PackageItem pkg = repo.loadDefaultPackage();
        AssetItem asset = pkg.addAsset("testCheckinListener", "");
        Assert.assertEquals((long)0L, (long)asset.getContentLength());
        asset.updateContent("boo");
        asset.checkin("");
        Assert.assertSame((Object)asset, (Object)x[0]);
    }
}

