/*
 * Decompiled with CFR 0.152.
 */
package org.drools.repository.remoteapi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.drools.repository.AssetItem;
import org.drools.repository.PackageItem;
import org.drools.repository.RepositorySessionUtil;
import org.drools.repository.RepositoryTestCase;
import org.drools.repository.RulesRepository;
import org.drools.repository.RulesRepositoryException;
import org.drools.repository.RulesRepositoryTest;
import org.drools.repository.remoteapi.Response;
import org.drools.repository.remoteapi.RestAPI;
import org.junit.Assert;
import org.junit.Test;

public class RestAPITest
extends RepositoryTestCase {
    @Test
    public void testGetWithSpaces() throws Exception {
        RulesRepository repo = RepositorySessionUtil.getRepository();
        PackageItem pkg = repo.createPackage("testRestGetSpaces", "", "package");
        AssetItem ass = pkg.addAsset("some space", "");
        ass.updateFormat("drl");
        ass.checkin("hey");
        RestAPI api = new RestAPI(repo);
        String url = "packages/testRestGetSpaces";
        Response res = api.get(url);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        res.writeData((OutputStream)out);
        Assert.assertTrue((new String(out.toByteArray()).indexOf("\\ ") > -1 ? 1 : 0) != 0);
        url = "packages/testRestGetSpaces/some space.drl";
        res = api.get(url);
        Assert.assertNotNull((Object)res.lastModified);
    }

    @Test
    public void testGetBasics() throws Exception {
        RulesRepository repo = RepositorySessionUtil.getRepository();
        PackageItem pkg = repo.createPackage("testRestGetBasics", "", "package");
        pkg.updateStringProperty("This is some header", "drools:header");
        repo.save();
        AssetItem asset1 = pkg.addAsset("asset1", "");
        asset1.updateContent("this is content");
        asset1.updateFormat("drl");
        asset1.checkin("");
        AssetItem asset2 = pkg.addAsset("asset2", "");
        asset2.updateContent("this is content");
        asset2.updateFormat("xml");
        asset2.checkin("");
        AssetItem asset3 = pkg.addAsset("asset3", "");
        ByteArrayInputStream in = new ByteArrayInputStream("abc".getBytes());
        asset3.updateBinaryContentAttachment((InputStream)in);
        asset3.updateFormat("xls");
        asset3.checkin("");
        Assert.assertTrue((boolean)asset3.isBinary());
        Assert.assertFalse((boolean)asset1.isBinary());
        RestAPI api = new RestAPI(repo);
        String url = "packages/testRestGetBasics/.package";
        Response res = api.get(url);
        Assert.assertNotNull((Object)res.lastModified);
        Assert.assertEquals((Object)pkg.getLastModified(), (Object)res.lastModified);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        res.writeData((OutputStream)out);
        String dotPackage = new String(out.toByteArray());
        Assert.assertEquals((Object)pkg.getStringProperty("drools:header"), (Object)dotPackage);
        res = api.get("packages/testRestGetBasics");
        Assert.assertTrue((boolean)(res instanceof Response.Text));
        Assert.assertNotNull((Object)res.lastModified);
        out = new ByteArrayOutputStream();
        res.writeData((OutputStream)out);
        String listing = new String(out.toByteArray());
        Assert.assertNotNull((Object)listing);
        Properties p = new Properties();
        p.load(new ByteArrayInputStream(out.toByteArray()));
        Assert.assertEquals((long)3L, (long)p.size());
        Assert.assertTrue((boolean)p.containsKey("asset1.drl"));
        Assert.assertTrue((boolean)p.containsKey("asset2.xml"));
        Assert.assertTrue((boolean)p.containsKey("asset3.xls"));
        Assert.assertNotNull((Object)p.getProperty("asset1.drl"));
        String prop = p.getProperty("asset1.drl");
        System.err.println(prop);
        String[] dt = prop.split(",");
        SimpleDateFormat sdf = RestAPI.getISODateFormat();
        Date d = sdf.parse(dt[0]);
        Assert.assertNotNull((Object)d);
        Assert.assertEquals((Object)sdf.format(asset1.getLastModified().getTime()), (Object)dt[0]);
        Assert.assertEquals((long)asset1.getVersionNumber(), (long)Long.parseLong(dt[1]));
        res = api.get("packages/testRestGetBasics/asset1.drl");
        Assert.assertTrue((boolean)(res instanceof Response.Text));
        out = new ByteArrayOutputStream();
        Assert.assertNotNull((Object)res.lastModified);
        Assert.assertTrue((boolean)res.lastModified.getTime().after(sdf.parse("2000-04-14T18:36:37")));
        res.writeData((OutputStream)out);
        String s = new String(out.toByteArray());
        Assert.assertEquals((Object)asset1.getContent(), (Object)s);
        res = api.get("packages/testRestGetBasics/asset3.xls");
        Assert.assertTrue((boolean)(res instanceof Response.Binary));
        out = new ByteArrayOutputStream();
        Assert.assertNotNull((Object)res.lastModified);
        Assert.assertTrue((boolean)res.lastModified.getTime().after(sdf.parse("2000-04-14T18:36:37")));
        res.writeData((OutputStream)out);
        byte[] data = out.toByteArray();
        Assert.assertNotNull((Object)data);
        Assert.assertEquals((Object)"abc", (Object)new String(data));
    }

    @Test
    public void testGetMisc() throws Exception {
        RulesRepository repo = RepositorySessionUtil.getRepository();
        RestAPI api = new RestAPI(repo);
        api.get("");
        api.get("/");
        api.get("packages");
        api.get("snapshots");
        api.get("snapshots/defaultPackage");
    }

    @Test
    public void testGetVersionHistory() throws Exception {
        RulesRepository repo = RepositorySessionUtil.getRepository();
        PackageItem pkg = repo.createPackage("testRestGetVersionHistory", "", "package");
        repo.save();
        AssetItem asset1 = pkg.addAsset("asset1", "");
        asset1.updateContent("this is content");
        asset1.updateFormat("drl");
        asset1.checkin("This is something");
        Assert.assertEquals((long)1L, (long)asset1.getVersionNumber());
        RestAPI api = new RestAPI(repo);
        Response res = api.get("packages/testRestGetVersionHistory/asset1.drl?version=all");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        res.writeData((OutputStream)out);
        String d = new String(out.toByteArray());
        Assert.assertTrue((d.indexOf(",alan_parsons,This is something") > 0 ? 1 : 0) != 0);
        asset1.updateContent("new content");
        asset1.checkin("This is another");
        res = api.get("packages/testRestGetVersionHistory/asset1.drl?version=all");
        out = new ByteArrayOutputStream();
        res.writeData((OutputStream)out);
        d = new String(out.toByteArray());
        System.err.println(d);
        Assert.assertTrue((d.indexOf(",alan_parsons,This is something") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((d.indexOf(",alan_parsons,This is another") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((d.indexOf("1=") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((d.indexOf("2=") > -1 ? 1 : 0) != 0);
        Assert.assertEquals((long)-1L, (long)d.indexOf("0="));
        res = api.get("packages/testRestGetVersionHistory/asset1.drl?version=1");
        out = new ByteArrayOutputStream();
        res.writeData((OutputStream)out);
        d = new String(out.toByteArray());
        Assert.assertEquals((Object)"this is content", (Object)d);
        res = api.get("packages");
        res = api.get("packages?version=all");
        res = api.get("snapshots");
        res = api.get("snapshots?version=all");
    }

    @Test
    public void testVersionHistoryAndArchived() throws Exception {
        RulesRepository repo = RepositorySessionUtil.getRepository();
        PackageItem pkg = repo.createPackage("testVersionHistoryAndArchived", "", "package");
        repo.save();
        AssetItem asset1 = pkg.addAsset("asset1", "");
        asset1.updateContent("this is content");
        asset1.updateFormat("drl");
        asset1.checkin("This is something");
        AssetItem asset2 = pkg.addAsset("asset2", "");
        asset2.updateContent("this is content");
        asset2.updateFormat("drl");
        asset2.checkin("This is another");
        Assert.assertEquals((long)1L, (long)asset1.getVersionNumber());
        RestAPI api = new RestAPI(repo);
        Response.Text res = (Response.Text)api.get("packages/testVersionHistoryAndArchived");
        System.err.println(res.data);
        Assert.assertTrue((res.data.indexOf("asset2.drl") > -1 ? 1 : 0) != 0);
        asset2.archiveItem(true);
        asset2.checkin("");
        res = (Response.Text)api.get("packages/testVersionHistoryAndArchived");
        Assert.assertEquals((long)-1L, (long)res.data.indexOf("asset2.drl"));
        Response resp = api.get("packages/testVersionHistoryAndArchived/asset1.drl?version=all");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        res.writeData((OutputStream)out);
        String d = new String(out.toByteArray());
        Assert.assertNotNull((Object)d);
        resp = api.get("packages/testVersionHistoryAndArchived/asset2.drl?version=all");
        out = new ByteArrayOutputStream();
        resp.writeData((OutputStream)out);
        d = new String(out.toByteArray());
        Assert.assertEquals((Object)"", (Object)d);
    }

    @Test
    public void testPost() throws Exception {
        RulesRepository repo = RepositorySessionUtil.getRepository();
        PackageItem pkg = repo.createPackage("testRestPost", "", "package");
        pkg.updateStringProperty("This is some header", "drools:header");
        repo.save();
        RestAPI api = new RestAPI(repo);
        ByteArrayInputStream in = new ByteArrayInputStream("abc".getBytes());
        api.post("/packages/testRestPost/asset1.drl", (InputStream)in, "a comment");
        AssetItem a = pkg.loadAsset("asset1");
        Assert.assertFalse((boolean)a.isBinary());
        Assert.assertEquals((Object)"drl", (Object)a.getFormat());
        Assert.assertEquals((Object)"abc", (Object)a.getContent());
        Assert.assertEquals((Object)"a comment", (Object)a.getCheckinComment());
        in = new ByteArrayInputStream("qed".getBytes());
        api.post("/packages/testRestPost/asset2.xls", (InputStream)in, "a comment");
        a = pkg.loadAsset("asset2");
        Assert.assertTrue((boolean)a.isBinary());
        String s = new String(a.getBinaryContentAsBytes());
        Assert.assertEquals((Object)"qed", (Object)s);
        Assert.assertEquals((Object)"a comment", (Object)a.getCheckinComment());
        Assert.assertEquals((Object)"xls", (Object)a.getFormat());
        List assets = RulesRepositoryTest.iteratorToList(repo.loadPackage("testRestPost").listAssetsByFormat(new String[]{"drl", "xls"}));
        Assert.assertEquals((long)2L, (long)assets.size());
    }

    @Test
    public void testPostNewPackage() throws Exception {
        RulesRepository repo = RepositorySessionUtil.getRepository();
        RestAPI api = new RestAPI(repo);
        api.post("/packages/testPostNewPackage/.package", (InputStream)new ByteArrayInputStream("qaz".getBytes()), "This is a new package");
        PackageItem pkg = repo.loadPackage("testPostNewPackage");
        Assert.assertEquals((Object)"qaz", (Object)pkg.getStringProperty("drools:header"));
        Assert.assertEquals((Object)"This is a new package", (Object)pkg.getCheckinComment());
    }

    @Test
    public void testPut() throws Exception {
        RulesRepository repo = RepositorySessionUtil.getRepository();
        PackageItem pkg = repo.createPackage("testRestPut", "", "package");
        pkg.updateStringProperty("This is some header", "drools:header");
        repo.save();
        AssetItem asset1 = pkg.addAsset("asset1", "");
        asset1.updateContent("this is content");
        asset1.updateFormat("drl");
        asset1.checkin("");
        Calendar cd = asset1.getLastModified();
        AssetItem asset2 = pkg.addAsset("asset2", "");
        ByteArrayInputStream in = new ByteArrayInputStream("abc".getBytes());
        asset2.updateBinaryContentAttachment((InputStream)in);
        asset2.updateFormat("xls");
        asset2.checkin("");
        RestAPI api = new RestAPI(repo);
        Thread.sleep(42L);
        api.put("packages/testRestPut/asset1.drl", Calendar.getInstance(), (InputStream)new ByteArrayInputStream("qaz".getBytes()), "a new comment");
        AssetItem asset1_ = pkg.loadAsset("asset1");
        Assert.assertEquals((Object)"qaz", (Object)asset1_.getContent());
        Assert.assertEquals((Object)"a new comment", (Object)asset1_.getCheckinComment());
        Assert.assertTrue((boolean)asset1_.getLastModified().after(cd));
        api.put("packages/testRestPut/asset2.xls", Calendar.getInstance(), (InputStream)new ByteArrayInputStream("def".getBytes()), "a new comment");
        AssetItem asset2_ = pkg.loadAsset("asset2");
        Assert.assertEquals((Object)"def", (Object)new String(asset2_.getBinaryContentAsBytes()));
        Assert.assertEquals((Object)"a new comment", (Object)asset2_.getCheckinComment());
        Assert.assertTrue((boolean)asset2_.getLastModified().after(cd));
        api.put("packages/testRestPut/.package", Calendar.getInstance(), (InputStream)new ByteArrayInputStream("whee".getBytes()), "hey");
        pkg = repo.loadPackage("testRestPut");
        Assert.assertEquals((Object)"whee", (Object)pkg.getStringProperty("drools:header"));
        try {
            api.put("packages/testRestPut/asset1.drl", cd, (InputStream)new ByteArrayInputStream("qaz".getBytes()), "a new comment");
            Assert.fail((String)"should not be able to do this as it is stale timestamp.");
        }
        catch (Exception e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
        try {
            api.put("packages/testRestPut/.package", cd, (InputStream)new ByteArrayInputStream("whee".getBytes()), "hey");
            Assert.fail((String)"should not be able to do this as it is stale timestamp.");
        }
        catch (Exception e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
    }

    @Test
    public void testDelete() throws Exception {
        RulesRepository repo = RepositorySessionUtil.getRepository();
        PackageItem pkg = repo.createPackage("testRestDelete", "", "package");
        pkg.updateStringProperty("This is some header", "drools:header");
        repo.save();
        AssetItem asset1 = pkg.addAsset("asset1", "");
        asset1.updateContent("this is content");
        asset1.updateFormat("drl");
        asset1.checkin("");
        RestAPI api = new RestAPI(repo);
        api.delete("packages/testRestDelete/asset1.drl");
        List l = RulesRepositoryTest.iteratorToList(pkg.listAssetsByFormat(new String[]{"drl"}));
        Assert.assertEquals((long)0L, (long)l.size());
        l = RulesRepositoryTest.iteratorToList(pkg.listArchivedAssets());
        Assert.assertEquals((long)1L, (long)l.size());
        api.post("packages/testRestDelete/asset1.drl", (InputStream)new ByteArrayInputStream("123".getBytes()), "new comment");
        AssetItem ass = pkg.loadAsset("asset1");
        Assert.assertEquals((Object)"123", (Object)ass.getContent());
        Assert.assertEquals((Object)"new comment", (Object)ass.getCheckinComment());
        Assert.assertFalse((boolean)ass.isArchived());
        l = RulesRepositoryTest.iteratorToList(pkg.listAssetsByFormat(new String[]{"drl"}));
        Assert.assertEquals((long)1L, (long)l.size());
        try {
            api.post("packages/testRestDelete/asset1.drl", (InputStream)new ByteArrayInputStream("123".getBytes()), "new comment");
            Assert.fail((String)"this should be rejected as its not archived.");
        }
        catch (RulesRepositoryException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
    }

    @Test
    public void testSplit() throws Exception {
        RestAPI a = new RestAPI(null);
        String[] x = a.split("packages/foo/bar");
        Assert.assertEquals((long)3L, (long)x.length);
        Assert.assertEquals((Object)"packages", (Object)x[0]);
        Assert.assertEquals((Object)"foo", (Object)x[1]);
        Assert.assertEquals((Object)"bar", (Object)x[2]);
        x = a.split("/packages/foo/bar");
        Assert.assertEquals((long)3L, (long)x.length);
        Assert.assertEquals((Object)"packages", (Object)x[0]);
        Assert.assertEquals((Object)"foo", (Object)x[1]);
        Assert.assertEquals((Object)"bar", (Object)x[2]);
        String p = URLEncoder.encode("some package", "UTF-8");
        String asset = URLEncoder.encode("some asset", "UTF-8");
        x = a.split("packages/" + p + "/" + asset);
        Assert.assertEquals((Object)"packages", (Object)x[0]);
        Assert.assertEquals((Object)"some package", (Object)x[1]);
        Assert.assertEquals((Object)"some asset", (Object)x[2]);
        x = a.split("http://localhost:8080/guvnor-webapp/org.dooby.doo.X.html/api/packages/foo/bar.drl");
        Assert.assertEquals((long)3L, (long)x.length);
        Assert.assertEquals((Object)"packages", (Object)x[0]);
        Assert.assertEquals((Object)"foo", (Object)x[1]);
        Assert.assertEquals((Object)"bar.drl", (Object)x[2]);
    }
}

