/*
 * Decompiled with CFR 0.152.
 */
package org.drools.repository.remoteapi;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Properties;
import org.drools.repository.AssetHistoryIterator;
import org.drools.repository.AssetItem;
import org.drools.repository.ModuleItem;
import org.drools.repository.RulesRepository;
import org.drools.repository.RulesRepositoryException;
import org.drools.repository.remoteapi.Response;
import org.drools.repository.utils.IOUtils;

public class RestAPI {
    private final RulesRepository repo;
    private static Properties TEXT_ASSET_TYPES = RestAPI.loadAssetTypes();

    public RestAPI(RulesRepository repo) {
        this.repo = repo;
    }

    private static Properties loadAssetTypes() {
        InputStream in = null;
        try {
            in = RestAPI.class.getResourceAsStream("text_assets.properties");
            Properties p = new Properties();
            p.load(in);
            Properties properties = p;
            return properties;
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to load asset text types properties.", e);
        }
        finally {
            IOUtils.closeQuietly(in);
        }
    }

    public Response get(String path) throws UnsupportedEncodingException {
        String[] bits = this.split(path);
        if (bits.length == 1) {
            return new Response.Text("");
        }
        if (bits[0].equals("packages")) {
            String pkgName = bits[1];
            if (bits.length == 2) {
                return this.listPackage(pkgName);
            }
            String resourceFile = bits[2];
            return this.loadContent(pkgName, resourceFile);
        }
        return new Response.Text("");
    }

    String[] split(String path) throws UnsupportedEncodingException {
        if (path.indexOf("api") > -1) {
            path = path.split("api")[1];
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        String[] bits = path.split("/");
        for (int i = 0; i < bits.length; ++i) {
            bits[i] = URLDecoder.decode(bits[i], "UTF-8");
        }
        return bits;
    }

    private Response loadContent(String pkgName, String resourceFile) throws UnsupportedEncodingException {
        ModuleItem pkg = this.repo.loadModule(pkgName);
        if (resourceFile.equals(".package")) {
            Response.Text r = new Response.Text();
            r.lastModified = pkg.getLastModified();
            r.data = pkg.getStringProperty("drools:header");
            return r;
        }
        if (resourceFile.indexOf("?version=") > -1) {
            String[] v = resourceFile.split("\\?version\\=");
            String version = v[1];
            String assetName = AssetItem.getAssetNameFromFileName(v[0])[0];
            AssetItem asset = pkg.loadAsset(assetName);
            if (asset.isArchived()) {
                Response.Text r = new Response.Text();
                r.data = "";
                return r;
            }
            if (version.equals("all")) {
                AssetHistoryIterator it = asset.getHistory();
                StringBuilder buf = new StringBuilder();
                while (it.hasNext()) {
                    AssetItem h = it.next();
                    if (h.getVersionNumber() == 0L) continue;
                    String checkinComment = h.getCheckinComment();
                    String lastMofiedBy = h.getLastContributor();
                    if (lastMofiedBy == null || lastMofiedBy.equals("")) {
                        lastMofiedBy = asset.getCreator();
                    }
                    SimpleDateFormat sdf = RestAPI.getISODateFormat();
                    Calendar lastModDate = h.getLastModified();
                    if (lastModDate == null) {
                        lastModDate = asset.getCreatedDate();
                    }
                    String lastModifiedOn = sdf.format(lastModDate.getTime());
                    buf.append(h.getVersionNumber());
                    buf.append("=");
                    buf.append(lastModifiedOn + "," + lastMofiedBy + "," + checkinComment);
                    if (!it.hasNext()) continue;
                    buf.append('\n');
                }
                Response.Text r = new Response.Text();
                r.lastModified = asset.getLastModified();
                r.data = buf.toString();
                return r;
            }
            long versionNumber = Long.parseLong(version);
            AssetHistoryIterator it = asset.getHistory();
            while (it.hasNext()) {
                AssetItem h = it.next();
                if (h.getVersionNumber() != versionNumber) continue;
                return this.buildAssetContentResponse(pkg, h);
            }
            Response.Text r = new Response.Text();
            r.lastModified = asset.getLastModified();
            r.data = "Unknown version number : " + versionNumber;
            return r;
        }
        String assetName = AssetItem.getAssetNameFromFileName(resourceFile)[0];
        AssetItem asset = pkg.loadAsset(assetName);
        return this.buildAssetContentResponse(pkg, asset);
    }

    private Response buildAssetContentResponse(ModuleItem pkg, AssetItem asset) {
        if (asset.isBinary()) {
            Response.Binary r = new Response.Binary();
            r.lastModified = asset.getLastModified();
            r.stream = asset.getBinaryContentAttachment();
            return r;
        }
        Response.Text r = new Response.Text();
        r.lastModified = pkg.getLastModified();
        r.data = asset.getContent();
        return r;
    }

    private Response listPackage(String pkgName) throws UnsupportedEncodingException {
        ModuleItem pkg = this.repo.loadModule(URLDecoder.decode(pkgName, "UTF-8"));
        StringBuilder sb = new StringBuilder();
        Iterator<AssetItem> it = pkg.getAssets();
        SimpleDateFormat sdf = RestAPI.getISODateFormat();
        while (it.hasNext()) {
            AssetItem a = it.next();
            if (a.isArchived()) continue;
            Calendar lastMod = a.getLastModified();
            if (lastMod == null) {
                lastMod = a.getCreatedDate();
            }
            sb.append(a.getName().replaceAll("\\s", "\\\\ ") + "." + a.getFormat() + "=" + sdf.format(lastMod.getTime()) + "," + a.getVersionNumber());
            sb.append('\n');
        }
        Response.Text r = new Response.Text();
        r.lastModified = pkg.getLastModified();
        r.data = sb.toString();
        return r;
    }

    private String escapeSpacesForProps(String s) {
        return s.replaceAll("\\s", "\\ ");
    }

    public static SimpleDateFormat getISODateFormat() {
        return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    }

    public void post(String path, InputStream in, String comment) throws RulesRepositoryException, IOException {
        String[] bits = this.split(path);
        if (bits[0].equals("packages")) {
            String fileName = bits[2];
            String[] a = fileName.split("\\.");
            if (a[1].equals("package")) {
                ModuleItem pkg = this.repo.createModule(bits[1], "<added remotely>");
                pkg.updateCheckinComment(comment);
                pkg.updateStringProperty(this.readContent(in), "drools:header");
                this.repo.save();
            } else {
                AssetItem asset;
                ModuleItem pkg = this.repo.loadModule(bits[1]);
                if (pkg.containsAsset(a[0])) {
                    asset = pkg.loadAsset(a[0]);
                    if (!asset.isArchived()) {
                        throw new RulesRepositoryException("The file " + path + " already exists, and was not archived.");
                    }
                    asset.archiveItem(false);
                    if (asset.isBinary()) {
                        asset.updateBinaryContentAttachment(in);
                    } else {
                        asset.updateContent(this.readContent(in));
                    }
                } else {
                    asset = pkg.addAsset(a[0], "<added remotely>");
                    asset.updateFormat(a[1]);
                    if (TEXT_ASSET_TYPES.containsKey(a[1])) {
                        asset.updateContent(this.readContent(in));
                    } else {
                        asset.updateBinaryContentAttachment(in);
                    }
                }
                asset.checkin(comment);
            }
        } else {
            throw new IllegalArgumentException("Unknown rest path for post.");
        }
    }

    private String readContent(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        int len = 0;
        while ((len = in.read(buf)) >= 0) {
            out.write(buf, 0, len);
        }
        return new String(out.toByteArray());
    }

    public void put(String path, Calendar lastModified, InputStream in, String comment) throws IOException {
        String[] bits = this.split(path);
        if (bits[0].equals("packages")) {
            String fileName = bits[2];
            String[] a = fileName.split("\\.");
            ModuleItem pkg = this.repo.loadModule(bits[1]);
            if (a[1].equals("package")) {
                if (lastModified != null && pkg.getLastModified().after(lastModified)) {
                    throw new RulesRepositoryException("The package was modified by: " + pkg.getLastContributor() + ", unable to write changes.");
                }
                pkg.updateStringProperty(this.readContent(in), "drools:header");
                pkg.checkin(comment);
                this.repo.save();
            } else {
                AssetItem as = pkg.loadAsset(a[0]);
                if (lastModified != null && as.getLastModified().after(lastModified)) {
                    throw new RulesRepositoryException("The asset was modified by: " + as.getLastContributor() + ", unable to write changes.");
                }
                if (as.isBinary()) {
                    as.updateBinaryContentAttachment(in);
                } else {
                    as.updateContent(this.readContent(in));
                }
                as.checkin(comment);
            }
        } else {
            throw new IllegalArgumentException("Unknown rest path for put");
        }
    }

    public void delete(String path) throws UnsupportedEncodingException {
        String[] bits = this.split(path);
        if (!bits[0].equals("packages")) {
            throw new IllegalArgumentException("Unknown rest path for delete");
        }
        String fileName = bits[2].split("\\.")[0];
        AssetItem asset = this.repo.loadModule(bits[1]).loadAsset(fileName);
        asset.archiveItem(true);
        asset.checkin("<removed remotely>");
    }
}

