/*
 * Decompiled with CFR 0.152.
 */
package org.drools.repository;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import org.drools.repository.CategoryItem;
import org.drools.repository.RulesRepository;
import org.drools.repository.RulesRepositoryException;
import org.drools.repository.VersionableItem;

public abstract class CategorisableItem
extends VersionableItem {
    public CategorisableItem(RulesRepository rulesRepository, Node node) {
        super(rulesRepository, node);
    }

    public void addCategory(String tag) throws RulesRepositoryException {
        try {
            this.checkIsUpdateable();
            CategoryItem tagItem = this.rulesRepository.loadCategory(tag);
            String tagItemUUID = this.node.getSession().getValueFactory().createValue(tagItem.getNode()).getString();
            try {
                Property tagReferenceProperty = this.node.getProperty("drools:categoryReference");
                Value[] oldTagValues = tagReferenceProperty.getValues();
                for (int j = 0; j < oldTagValues.length; ++j) {
                    if (!oldTagValues[j].getString().equals(tagItemUUID)) continue;
                    log.info("tag '" + tag + "' already existed for asset node: " + this.node.getName());
                    return;
                }
                Value[] newTagValues = new Value[oldTagValues.length + 1];
                for (int i = 0; i < oldTagValues.length; ++i) {
                    newTagValues[i] = oldTagValues[i];
                }
                newTagValues[oldTagValues.length] = this.node.getSession().getValueFactory().createValue(tagItem.getNode());
                this.updateCategories(newTagValues);
            }
            catch (PathNotFoundException e) {
                Value[] newTagValues = new Value[]{this.node.getSession().getValueFactory().createValue(tagItem.getNode())};
                this.updateCategories(newTagValues);
            }
        }
        catch (Exception e) {
            log.error("Caught exception", (Throwable)e);
            throw new RulesRepositoryException(e);
        }
    }

    private void updateCategories(Value[] newTagValues) throws UnsupportedRepositoryOperationException, LockException, RepositoryException, ValueFormatException, VersionException, ConstraintViolationException {
        this.checkout();
        this.node.setProperty("drools:categoryReference", newTagValues);
    }

    public void updateCategoryList(String[] categories) {
        this.checkIsUpdateable();
        try {
            Value[] newCats = new Value[categories.length];
            for (int i = 0; i < categories.length; ++i) {
                CategoryItem item = this.rulesRepository.loadCategory(categories[i]);
                newCats[i] = this.node.getSession().getValueFactory().createValue(item.getNode());
            }
            this.updateCategories(newCats);
        }
        catch (RepositoryException e) {
            throw new RulesRepositoryException(e);
        }
    }

    public List<CategoryItem> getCategories() throws RulesRepositoryException {
        final ArrayList<CategoryItem> cats = new ArrayList<CategoryItem>();
        this.doList(new Accum(){

            @Override
            public void add(CategoryItem c) {
                cats.add(c);
            }
        });
        return cats;
    }

    private void doList(Accum ac) {
        block6: {
            try {
                Node assetNode = this.getVersionContentNode();
                try {
                    Property tagReferenceProperty = assetNode.getProperty("drools:categoryReference");
                    if (tagReferenceProperty.isMultiple()) {
                        Value[] tagValues = tagReferenceProperty.getValues();
                        for (int i = 0; i < tagValues.length; ++i) {
                            this.addTag(ac, tagValues[i].getString());
                        }
                        break block6;
                    }
                    Value tagValue = tagReferenceProperty.getValue();
                    this.addTag(ac, tagValue.getString());
                }
                catch (PathNotFoundException pathNotFoundException) {}
            }
            catch (RepositoryException e) {
                log.error("Error loading cateories", (Throwable)e);
                throw new RulesRepositoryException(e);
            }
        }
    }

    private void addTag(Accum ac, String tag) throws RepositoryException {
        try {
            Node tagNode = this.node.getSession().getNodeByIdentifier(tag);
            CategoryItem tagItem = new CategoryItem(this.rulesRepository, tagNode);
            ac.add(tagItem);
        }
        catch (ItemNotFoundException e) {
            log.debug("Was unable to load a category by UUID - must have been removed.");
        }
    }

    public String getCategorySummary() {
        final StringBuilder sum = new StringBuilder();
        this.doList(new Accum(){
            int count = 0;

            @Override
            public void add(CategoryItem c) {
                ++this.count;
                if (this.count == 4) {
                    sum.append("...");
                } else if (this.count < 4) {
                    sum.append(c.getName());
                    sum.append(' ');
                }
            }
        });
        return sum.toString();
    }

    public void removeCategory(String tag) throws RulesRepositoryException {
        CategorisableItem.removeCategory(this.node, tag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void removeCategory(Node targetNode, String tag) throws RulesRepositoryException {
        try {
            Value[] newTagValues;
            block16: {
                block19: {
                    block17: {
                        if (targetNode.getPrimaryNodeType().getName().equals("nt:version")) {
                            String message = "Error. Tags can only be removed from the head version of an asset node";
                            log.error(message);
                            throw new RulesRepositoryException(message);
                        }
                        int i = 0;
                        int j = 0;
                        newTagValues = null;
                        try {
                            Node tagNode;
                            Property tagReferenceProperty = targetNode.getProperty("drools:categoryReference");
                            Value[] oldTagValues = tagReferenceProperty.getValues();
                            boolean wasThere = false;
                            for (i = 0; i < oldTagValues.length; ++i) {
                                tagNode = targetNode.getSession().getNodeByIdentifier(oldTagValues[i].getString());
                                if (!tagNode.getName().equals(tag)) continue;
                                wasThere = true;
                            }
                            if (wasThere) {
                                newTagValues = new Value[oldTagValues.length + 1];
                                for (i = 0; i < oldTagValues.length; ++i) {
                                    tagNode = targetNode.getSession().getNodeByIdentifier(oldTagValues[i].getString());
                                    if (tagNode.getName().equals(tag)) continue;
                                    newTagValues[j] = oldTagValues[i];
                                    ++j;
                                }
                                break block16;
                            }
                            if (newTagValues == null) break block17;
                        }
                        catch (PathNotFoundException e) {
                            if (newTagValues != null) {
                                CategorisableItem.checkout(targetNode);
                                targetNode.setProperty("drools:categoryReference", newTagValues);
                            } else {
                                log.error("reached expected path of execution when removing tag '" + tag + "' from asset node: " + targetNode.getName());
                            }
                            return;
                            catch (Throwable throwable) {
                                if (newTagValues != null) {
                                    CategorisableItem.checkout(targetNode);
                                    targetNode.setProperty("drools:categoryReference", newTagValues);
                                } else {
                                    log.error("reached expected path of execution when removing tag '" + tag + "' from asset node: " + targetNode.getName());
                                }
                                throw throwable;
                            }
                        }
                        CategorisableItem.checkout(targetNode);
                        targetNode.setProperty("drools:categoryReference", newTagValues);
                        break block19;
                    }
                    log.error("reached expected path of execution when removing tag '" + tag + "' from asset node: " + targetNode.getName());
                }
                return;
            }
            if (newTagValues != null) {
                CategorisableItem.checkout(targetNode);
                targetNode.setProperty("drools:categoryReference", newTagValues);
            } else {
                log.error("reached expected path of execution when removing tag '" + tag + "' from asset node: " + targetNode.getName());
            }
        }
        catch (Exception e) {
            log.error("Caught exception", (Throwable)e);
            throw new RulesRepositoryException(e);
        }
    }

    static interface Accum {
        public void add(CategoryItem var1);
    }
}

