/*
 * Decompiled with CFR 0.152.
 */
package org.drools.repository.security;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.drools.repository.RulesRepository;
import org.drools.repository.RulesRepositoryException;

public class PermissionManager {
    private RulesRepository repository;

    public PermissionManager(RulesRepository repo) {
        this.repository = repo;
    }

    public void updateUserPermissions(String userName, Map<String, List<String>> perms) {
        if (!this.isValideUserName(userName)) {
            return;
        }
        try {
            Node permsNode = this.getUserPermissionNode(userName);
            permsNode.remove();
            permsNode = this.getUserPermissionNode(userName).addNode("jcr:content", "nt:unstructured");
            for (Map.Entry<String, List<String>> en : perms.entrySet()) {
                String perm = en.getKey();
                List<String> targets = en.getValue();
                if (targets == null) {
                    targets = new ArrayList<String>();
                }
                permsNode.setProperty(perm, targets.toArray(new String[targets.size()]));
            }
            this.repository.save();
        }
        catch (RepositoryException e) {
            throw new RulesRepositoryException(e);
        }
    }

    public void createUser(String userName) {
        if (!this.isValideUserName(userName)) {
            throw new RulesRepositoryException("Invalide user name");
        }
        if (this.containsUser(userName)) {
            throw new RulesRepositoryException("User name [" + userName + "] already exists");
        }
        try {
            Node permsNode = this.getUserPermissionNode(userName);
            permsNode.remove();
            permsNode = this.getUserPermissionNode(userName).addNode("jcr:content", "nt:unstructured");
            this.repository.save();
        }
        catch (RepositoryException e) {
            throw new RulesRepositoryException(e);
        }
    }

    private boolean containsUser(String userName) {
        try {
            Node userRoot = PermissionManager.getUsersRootNode(PermissionManager.getRootNode(this.repository));
            if (userRoot.hasNode(userName)) {
                return true;
            }
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return false;
    }

    private Node getUserPermissionNode(String userName) throws RepositoryException {
        Node permsNode = PermissionManager.getNode(PermissionManager.getUserInfoNode(userName, this.repository), "permissions", "nt:file");
        return permsNode;
    }

    public static Node getUserInfoNode(String userName, RulesRepository repo) throws RepositoryException {
        Node root = PermissionManager.getRootNode(repo);
        return PermissionManager.getNode(PermissionManager.getUsersRootNode(root), userName, "nt:folder");
    }

    public static Node getRootNode(RulesRepository repo) throws RepositoryException {
        Session session = repo.getSession();
        Node rootNode = session.getRootNode();
        return rootNode.getNode("drools:repository");
    }

    public static Node getUsersRootNode(Node root) throws RepositoryException {
        return PermissionManager.getNode(root, "user_info", "nt:folder");
    }

    public Map<String, List<String>> retrieveUserPermissions(String userName) {
        try {
            HashMap<String, List<String>> result = new HashMap<String, List<String>>(10);
            if (!this.isValideUserName(userName)) {
                return result;
            }
            if (!this.getUserPermissionNode(userName).hasNode("jcr:content")) {
                return result;
            }
            Node permsNode = this.getUserPermissionNode(userName).getNode("jcr:content");
            PropertyIterator it = permsNode.getProperties();
            while (it.hasNext()) {
                ArrayList<String> perms;
                Property p = (Property)it.next();
                String name = p.getName();
                if (name.startsWith("jcr")) continue;
                if (p.getDefinition().isMultiple()) {
                    Value[] vs = p.getValues();
                    perms = new ArrayList<String>();
                    for (int i = 0; i < vs.length; ++i) {
                        perms.add(vs[i].getString());
                    }
                    result.put(name, perms);
                    continue;
                }
                Value v = p.getValue();
                perms = new ArrayList(1);
                perms.add(v.getString());
                result.put(name, perms);
            }
            return result;
        }
        catch (RepositoryException e) {
            throw new RulesRepositoryException(e);
        }
    }

    public static Node getNode(Node node, String name, String nodeType) throws RepositoryException {
        Node permsNode = !node.hasNode(name) ? node.addNode(name, nodeType) : node.getNode(name);
        return permsNode;
    }

    public Map<String, List<String>> listUsers() {
        try {
            HashMap<String, List<String>> listing = new HashMap<String, List<String>>();
            Node root = PermissionManager.getRootNode(this.repository);
            Node usersNode = PermissionManager.getUsersRootNode(root);
            NodeIterator users = usersNode.getNodes();
            while (users.hasNext()) {
                Node userNode = (Node)users.next();
                listing.put(userNode.getName(), this.listOfPermTypes(userNode));
            }
            return listing;
        }
        catch (RepositoryException e) {
            throw new RulesRepositoryException(e);
        }
    }

    private List<String> listOfPermTypes(Node userNode) throws RepositoryException {
        ArrayList<String> permTypes = new ArrayList<String>();
        Node permsNode = PermissionManager.getNode(userNode, "permissions", "nt:file");
        Node content = PermissionManager.getNode(permsNode, "jcr:content", "nt:unstructured");
        PropertyIterator perms = content.getProperties();
        while (perms.hasNext()) {
            Property p = (Property)perms.next();
            String name = p.getName();
            if (name.startsWith("jcr")) continue;
            permTypes.add(name);
        }
        return permTypes;
    }

    void deleteAllUsers() throws RepositoryException {
        Node root = PermissionManager.getRootNode(this.repository);
        PermissionManager.getUsersRootNode(root).remove();
    }

    public void removeUserPermissions(String userName) {
        if (!this.isValideUserName(userName)) {
            return;
        }
        try {
            Node permsNode = this.getUserPermissionNode(userName);
            permsNode.getParent().remove();
        }
        catch (RepositoryException e) {
            throw new RulesRepositoryException(e);
        }
    }

    private boolean isValideUserName(String userName) {
        return !"".equals(userName.trim()) && userName.trim().length() != 0;
    }
}

