/*
 * Decompiled with CFR 0.152.
 */
package org.drools.repository;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.PreDestroy;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import org.drools.repository.AssetItem;
import org.drools.repository.AssetItemIterator;
import org.drools.repository.AssetItemPageResult;
import org.drools.repository.CategoryItem;
import org.drools.repository.ModuleHistoryIterator;
import org.drools.repository.ModuleItem;
import org.drools.repository.ModuleIterator;
import org.drools.repository.RepositoryFilter;
import org.drools.repository.RulesRepositoryAdministrator;
import org.drools.repository.RulesRepositoryException;
import org.drools.repository.StateItem;
import org.drools.repository.VersionableItem;
import org.drools.repository.events.StorageEventManager;
import org.drools.repository.migration.MigrateDroolsPackage;
import org.drools.repository.utils.NodeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RulesRepository {
    public static final String DEFAULT_PACKAGE = "defaultPackage";
    public static final String DEFAULT_WORKSPACE = "defaultWorkspace";
    public static final String DROOLS_URI = "http://www.jboss.org/drools-repository/1.0";
    private static final Logger log = LoggerFactory.getLogger(RulesRepository.class);
    public static final String MODULE_AREA = "drools:package_area";
    public static final String GLOBAL_AREA = "globalArea";
    public static final String MODULE_SNAPSHOT_AREA = "drools:packagesnapshot_area";
    public static final String TAG_AREA = "drools:tag_area";
    public static final String STATE_AREA = "drools:state_area";
    public static final String CONFIGURATION_AREA = "drools:configuration_area";
    public static final String PERSPECTIVES_CONFIGURATION_AREA = "drools:perspectives_configuration_area";
    public static final String SCHEMA_AREA = "drools:schema_area";
    public static final String METADATA_TYPE_AREA = "drools:metadata_type_area";
    public static final String WORKSPACE_AREA = "drools:workspace_area";
    public static final String DO_NOT_INSTALL_SAMPLE_NODE = "drools:do_not_install_sample";
    public static final String RULES_REPOSITORY_NAME = "drools:repository";
    private final Session session;
    boolean initialized = false;

    public RulesRepository() {
        this.session = null;
    }

    public RulesRepository(Session session) {
        this.session = session;
        this.checkForDataMigration(this);
    }

    private synchronized void checkForDataMigration(RulesRepository self) {
        if (this.initialized) {
            return;
        }
        if (self.session.getUserID().equals("anonymous")) {
            return;
        }
        try {
            MigrateDroolsPackage migration = new MigrateDroolsPackage();
            if (migration.needsMigration(self)) {
                migration.migrate(self);
            }
        }
        catch (RepositoryException e) {
            throw new RulesRepositoryException(e);
        }
        this.initialized = true;
    }

    protected static Node addNodeIfNew(Node parent, String nodeName, String type) throws RulesRepositoryException {
        Node node;
        try {
            node = parent.getNode(nodeName);
        }
        catch (PathNotFoundException e) {
            try {
                log.debug("Adding new node of type: {} named: {} to parent node named {}", new Object[]{type, nodeName, parent.getName()});
                node = parent.addNode(nodeName, type);
            }
            catch (Exception e1) {
                log.error("Caught Exception", (Throwable)e);
                throw new RulesRepositoryException(e1);
            }
        }
        catch (Exception e) {
            log.error("Caught Exception", (Throwable)e);
            throw new RulesRepositoryException(e);
        }
        return node;
    }

    @PreDestroy
    public void logout() {
        this.session.logout();
    }

    public Node getAreaNode(String areaName) throws RulesRepositoryException {
        Node folderNode = null;
        int tries = 0;
        while (folderNode == null && tries < 2) {
            try {
                ++tries;
                System.out.println("=============== " + this.session);
                folderNode = this.session.getRootNode().getNode("drools:repository/" + areaName);
            }
            catch (PathNotFoundException e) {
                if (tries == 1) {
                    throw new RulesRepositoryException("Unable to get node [" + areaName + "]. Repository is not setup correctly.", e);
                }
                log.error("The repository appears to have become corrupted. Unable to correct repository corruption");
            }
            catch (Exception e) {
                log.error("Caught Exception", (Throwable)e);
                throw new RulesRepositoryException("Caught exception " + e.getClass().getName(), e);
            }
        }
        if (folderNode == null) {
            String message = "Could not get a reference to a node for drools:repository/" + areaName;
            log.error(message);
            throw new RulesRepositoryException(message);
        }
        return folderNode;
    }

    private Node getMetaDataTypeNode(String metadataType) throws RepositoryException {
        Node schemaNode = this.getAreaNode(SCHEMA_AREA);
        return RulesRepository.addNodeIfNew(RulesRepository.addNodeIfNew(schemaNode, METADATA_TYPE_AREA, "nt:folder"), metadataType, "nt:file");
    }

    private NodeIterator getMetaDataTypeNodes() throws RepositoryException {
        Node schemaNode = this.getAreaNode(SCHEMA_AREA);
        return RulesRepository.addNodeIfNew(schemaNode, METADATA_TYPE_AREA, "nt:folder").getNodes();
    }

    public String copyAsset(String uuidSource, String destinationModule, String destinationName) {
        try {
            AssetItem source = this.loadAssetByUUID(uuidSource);
            String sourcePath = source.getNode().getPath();
            String safeDestinationName = NodeUtils.makeJSR170ComplaintName(destinationName);
            String destPath = this.getAreaNode(MODULE_AREA).getPath() + "/" + destinationModule + "/" + "assets" + "/" + safeDestinationName;
            this.session.getWorkspace().copy(sourcePath, destPath);
            AssetItem dest = this.loadModule(destinationModule).loadAsset(safeDestinationName);
            dest.updateStringProperty(destinationModule, "drools:packageName");
            dest.node.setProperty("drools:versionNumber", 0L);
            dest.updateTitle(destinationName);
            dest.checkin("Copied from " + source.getModuleName() + "/" + source.getName());
            return dest.getUUID();
        }
        catch (RepositoryException e) {
            log.error("Unable to copy asset.", (Throwable)e);
            throw new RulesRepositoryException(e);
        }
    }

    public ModuleItem loadModule(String name) throws RulesRepositoryException {
        try {
            Node folderNode = this.getAreaNode(MODULE_AREA);
            Node moduleNode = folderNode.getNode(name);
            return new ModuleItem(this, moduleNode);
        }
        catch (RepositoryException e) {
            if (GLOBAL_AREA.equals(name)) {
                log.info("Creating Global area as it does not exist yet.");
                return this.createModule(GLOBAL_AREA, "the global area that holds sharable assets");
            }
            log.error("Unable to load a module. ", (Throwable)e);
            throw new RulesRepositoryException("Unable to load a module. ", e);
        }
    }

    public ModuleItem loadModule(String name, long versionNumber) throws RulesRepositoryException {
        try {
            Node folderNode = this.getAreaNode(MODULE_AREA);
            Node moduleNode = folderNode.getNode(name);
            ModuleItem item = new ModuleItem(this, moduleNode);
            ModuleHistoryIterator it = item.getHistory();
            while (it.hasNext()) {
                ModuleItem historical = it.next();
                if (historical.getVersionNumber() != versionNumber) continue;
                return historical;
            }
            throw new RulesRepositoryException("Unable to load a module with version: " + versionNumber);
        }
        catch (RepositoryException e) {
            if (GLOBAL_AREA.equals(name)) {
                log.info("Creating Global area as it does not exist yet.");
                return this.createModule(GLOBAL_AREA, "the global area that holds sharable assets");
            }
            log.error("Unable to load a module. ", (Throwable)e);
            throw new RulesRepositoryException("Unable to load a module. ", e);
        }
    }

    public StateItem loadState(String name) throws RulesRepositoryException {
        try {
            Node ruleStateNode = this.getAreaNode(STATE_AREA).getNode(name);
            return new StateItem(this, ruleStateNode);
        }
        catch (RepositoryException e) {
            log.error("Unable to load a status. ", (Throwable)e);
            throw new RulesRepositoryException("Unable to load a status. ", e);
        }
    }

    public boolean containsModule(String name) {
        Node folderNode = this.getAreaNode(MODULE_AREA);
        try {
            return folderNode.hasNode(name);
        }
        catch (RepositoryException e) {
            throw new RulesRepositoryException(e);
        }
    }

    public boolean isModuleArchived(String name) {
        Node folderNode = this.getAreaNode(MODULE_AREA);
        try {
            Node node = folderNode.getNode(name);
            return node.getProperty("drools:archive").getBoolean();
        }
        catch (RepositoryException e) {
            throw new RulesRepositoryException(e);
        }
    }

    public boolean containsSnapshot(String moduleName, String snapshotName) {
        try {
            Node areaNode = this.getAreaNode(MODULE_SNAPSHOT_AREA);
            if (!areaNode.hasNode(moduleName)) {
                return false;
            }
            Node n = areaNode.getNode(moduleName);
            return n.hasNode(snapshotName);
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RulesRepositoryException(e);
        }
    }

    public ModuleItem loadModuleSnapshot(String moduleName, String snapshotName) {
        try {
            Node n = this.getAreaNode(MODULE_SNAPSHOT_AREA).getNode(moduleName).getNode(snapshotName);
            return new ModuleItem(this, n);
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RulesRepositoryException(e);
        }
    }

    public void createModuleSnapshot(String moduleName, String snapshotName) {
        log.debug("Creating snapshot for [" + moduleName + "] called [" + snapshotName + "]");
        try {
            Node snaps = this.getAreaNode(MODULE_SNAPSHOT_AREA);
            String nodePath = NodeUtils.makeJSR170ComplaintName(moduleName);
            if (!snaps.hasNode(nodePath)) {
                snaps.addNode(nodePath, "nt:folder");
                this.save();
            }
            String newName = snaps.getNode(nodePath).getPath() + "/" + snapshotName;
            Node moduleNode = this.getAreaNode(MODULE_AREA).getNode(moduleName);
            long start = System.currentTimeMillis();
            this.session.getWorkspace().copy(moduleNode.getPath(), newName);
            log.debug("Time taken for snap: " + (System.currentTimeMillis() - start));
        }
        catch (RepositoryException e) {
            log.error("Unable to create snapshot", (Throwable)e);
            throw new RulesRepositoryException(e);
        }
    }

    public void removeModuleSnapshot(String moduleName, String snapshotName) {
        log.debug("Removing snapshot for [" + moduleName + "] called [" + snapshotName + "]");
        try {
            Node snaps = this.getAreaNode(MODULE_SNAPSHOT_AREA);
            if (!snaps.hasNode(moduleName)) {
                throw new RulesRepositoryException("The module " + moduleName + " does not have any snapshots.");
            }
            Node moduleSnaps = snaps.getNode(moduleName);
            if (moduleSnaps.hasNode(snapshotName)) {
                moduleSnaps.getNode(snapshotName).remove();
            }
            this.save();
        }
        catch (RepositoryException e) {
            log.error("Unable to remove snapshot", (Throwable)e);
            throw new RulesRepositoryException(e);
        }
    }

    public void copyModuleSnapshot(String moduleName, String snapshotName, String newName) {
        log.debug("Creating snapshot for [" + moduleName + "] called [" + snapshotName + "]");
        try {
            Node moduleSnaps = this.getAreaNode(MODULE_SNAPSHOT_AREA).getNode(moduleName);
            Node sourceNode = moduleSnaps.getNode(snapshotName);
            if (moduleSnaps.hasNode(newName)) {
                moduleSnaps.getNode(newName).remove();
                this.session.save();
            }
            String destinationPath = moduleSnaps.getPath() + "/" + newName;
            this.session.getWorkspace().copy(sourceNode.getPath(), destinationPath);
        }
        catch (RepositoryException e) {
            log.error("Unable to create snapshot", (Throwable)e);
            throw new RulesRepositoryException(e);
        }
    }

    public ModuleItem loadDefaultModule() throws RulesRepositoryException {
        Node folderNode = this.getAreaNode(MODULE_AREA);
        try {
            if (folderNode.hasNode(DEFAULT_PACKAGE)) {
                return this.loadModule(DEFAULT_PACKAGE);
            }
            return this.createModule(DEFAULT_PACKAGE, "");
        }
        catch (RepositoryException e) {
            throw new RulesRepositoryException(e);
        }
    }

    public ModuleItem loadGlobalArea() throws RulesRepositoryException {
        return this.loadModule(GLOBAL_AREA);
    }

    public ModuleItem loadModuleByUUID(String uuid) throws RulesRepositoryException {
        try {
            Node moduleNode = this.session.getNodeByIdentifier(uuid);
            return new ModuleItem(this, moduleNode);
        }
        catch (Exception e) {
            log.error("Unable to load a module by UUID. ", (Throwable)e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RulesRepositoryException("Unable to load a module. ", e);
        }
    }

    public VersionableItem loadItemByUUID(String uuid) throws RulesRepositoryException {
        try {
            Node moduleNode = this.session.getNodeByIdentifier(uuid);
            if (moduleNode.getPrimaryNodeType().getName().equals("drools:packageNodeType")) {
                return new ModuleItem(this, moduleNode);
            }
            if (moduleNode.getPrimaryNodeType().getName().equals("drools:assetNodeType")) {
                return new AssetItem(this, moduleNode);
            }
            throw new RulesRepositoryException("Unable to load a module. ");
        }
        catch (Exception e) {
            log.error("Unable to load a module by UUID. ", (Throwable)e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RulesRepositoryException("Unable to load a module. ", e);
        }
    }

    public void restoreHistoricalAsset(AssetItem versionToRestore, AssetItem headVersion, String comment) {
        headVersion.checkout();
        if (versionToRestore.isBinary()) {
            headVersion.updateBinaryContentAttachment(versionToRestore.getBinaryContentAttachment());
        } else {
            headVersion.updateContent(versionToRestore.getContent());
        }
        headVersion.checkin(comment);
    }

    public AssetItem loadAssetByUUID(String uuid) {
        try {
            Node moduleNode = this.session.getNodeByIdentifier(uuid);
            return new AssetItem(this, moduleNode);
        }
        catch (ItemNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new RulesRepositoryException("That item does not exist.");
        }
        catch (RepositoryException e) {
            log.error("Unable to load an asset by UUID.", (Throwable)e);
            throw new RulesRepositoryException(e);
        }
    }

    public ModuleItem createModule(String name, String description) throws RulesRepositoryException {
        return this.createModule(name, description, "package", null, "Initial");
    }

    public ModuleItem createModule(String name, String description, String format) throws RulesRepositoryException {
        return this.createModule(name, description, format, null, "Initial");
    }

    public ModuleItem createModule(String name, String description, String format, String[] workspace, String checkInComment) throws RulesRepositoryException {
        Node folderNode = this.getAreaNode(MODULE_AREA);
        try {
            String nodePath = NodeUtils.makeJSR170ComplaintName(name);
            Node moduleNode = folderNode.addNode(nodePath, "drools:packageNodeType");
            moduleNode.addNode("assets", "drools:versionableAssetFolder");
            moduleNode.setProperty("drools:title", name);
            moduleNode.setProperty("drools:description", description);
            moduleNode.setProperty("drools:format", format);
            moduleNode.setProperty("drools:creator", this.session.getUserID());
            moduleNode.setProperty("drools:workspace", workspace);
            moduleNode.setProperty("drools:lastModified", Calendar.getInstance());
            ModuleItem item = new ModuleItem(this, moduleNode);
            item.checkin(checkInComment);
            if (StorageEventManager.hasSaveEvent()) {
                StorageEventManager.getSaveEvent().onModuleCreate(item);
            }
            return item;
        }
        catch (ItemExistsException e) {
            throw new RulesRepositoryException("A module name must be unique.", e);
        }
        catch (RepositoryException e) {
            log.error("Error when creating a new module", (Throwable)e);
            throw new RulesRepositoryException(e);
        }
    }

    public ModuleItem createSubModule(String name, String description, String parentModule) throws RulesRepositoryException {
        try {
            ModuleItem parentModuleItem = this.loadModule(parentModule);
            ModuleItem subModuleItem = parentModuleItem.createSubModule(name);
            subModuleItem.checkin("Initial");
            if (StorageEventManager.hasSaveEvent()) {
                StorageEventManager.getSaveEvent().onModuleCreate(subModuleItem);
            }
            return subModuleItem;
        }
        catch (ItemExistsException e) {
            throw new RulesRepositoryException("A module name must be unique.", e);
        }
        catch (RepositoryException e) {
            log.error("Error when creating a new module", (Throwable)e);
            throw new RulesRepositoryException(e);
        }
    }

    public StateItem getState(String name) throws RulesRepositoryException {
        try {
            Node folderNode = this.getAreaNode(STATE_AREA);
            String nodePath = NodeUtils.makeJSR170ComplaintName(name);
            if (!folderNode.hasNode(nodePath)) {
                throw new RulesRepositoryException("The state called [" + name + "] does not exist.");
            }
            Node stateNode = folderNode.getNode(nodePath);
            return new StateItem(this, stateNode);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RulesRepositoryException(e);
        }
    }

    public StateItem createState(String name) {
        try {
            Node folderNode = this.getAreaNode(STATE_AREA);
            String nodePath = NodeUtils.makeJSR170ComplaintName(name);
            Node stateNode = RulesRepository.addNodeIfNew(folderNode, nodePath, "drools:stateNodeType");
            log.debug("Created the status [" + name + "] at [" + nodePath + "]");
            return new StateItem(this, stateNode);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RulesRepositoryException(e);
        }
    }

    public String[] listWorkspaces() throws RulesRepositoryException {
        ArrayList<String> result = new ArrayList<String>();
        try {
            Node schemaNode = RulesRepository.addNodeIfNew(this.session.getRootNode().getNode(RULES_REPOSITORY_NAME), SCHEMA_AREA, "nt:folder");
            NodeIterator workspaceNodes = RulesRepository.addNodeIfNew(schemaNode, WORKSPACE_AREA, "nt:folder").getNodes();
            while (workspaceNodes.hasNext()) {
                Node workspaceNode = workspaceNodes.nextNode();
                result.add(workspaceNode.getName());
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RulesRepositoryException(e);
        }
        return result.toArray(new String[result.size()]);
    }

    public Node createWorkspace(String workspace) {
        try {
            Node schemaNode = RulesRepository.addNodeIfNew(this.session.getRootNode().getNode(RULES_REPOSITORY_NAME), SCHEMA_AREA, "nt:folder");
            Node workspaceNode = RulesRepository.addNodeIfNew(schemaNode, WORKSPACE_AREA, "nt:folder");
            Node node = RulesRepository.addNodeIfNew(workspaceNode, workspace, "nt:file");
            node.addNode("jcr:content", "nt:unstructured");
            this.getSession().save();
            log.debug("Created workspace [" + workspace + "]");
            return node;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RulesRepositoryException(e);
        }
    }

    public void removeWorkspace(String workspace) {
        try {
            Node schemaNode = RulesRepository.addNodeIfNew(this.session.getRootNode().getNode(RULES_REPOSITORY_NAME), SCHEMA_AREA, "nt:folder");
            Node workspaceAreaNode = RulesRepository.addNodeIfNew(schemaNode, WORKSPACE_AREA, "nt:folder");
            Node workspaceNode = workspaceAreaNode.getNode(workspace);
            workspaceNode.remove();
            this.getSession().save();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RulesRepositoryException(e);
        }
    }

    public CategoryItem loadCategory(String tagName) throws RulesRepositoryException {
        if (tagName == null || "".equals(tagName)) {
            throw new RuntimeException("Empty category name not permitted.");
        }
        try {
            Node folderNode;
            Node tagNode = folderNode = this.getAreaNode(TAG_AREA);
            StringTokenizer tok = new StringTokenizer(tagName, "/");
            while (tok.hasMoreTokens()) {
                String currentTagName = tok.nextToken();
                folderNode = tagNode = folderNode.getNode(currentTagName);
            }
            return new CategoryItem(this, tagNode);
        }
        catch (RepositoryException e) {
            if (e instanceof PathNotFoundException) {
                throw new RulesRepositoryException("Unable to load the category : [" + tagName + "] does not exist.", e);
            }
            throw new RulesRepositoryException(e);
        }
    }

    public AssetItemPageResult findAssetsByCategory(String categoryTag, boolean seekArchivedAsset, int skip, int numRowsToReturn) throws RulesRepositoryException {
        return this.findAssetsByCategory(categoryTag, seekArchivedAsset, skip, numRowsToReturn, null);
    }

    public AssetItemPageResult findAssetsByCategory(String categoryTag, boolean seekArchivedAsset, int skip, int numRowsToReturn, RepositoryFilter filter) throws RulesRepositoryException {
        CategoryItem item = this.loadCategory(categoryTag);
        try {
            return this.loadLinkedAssets(seekArchivedAsset, skip, numRowsToReturn, item.getNode(), filter);
        }
        catch (RepositoryException e) {
            throw new RulesRepositoryException(e);
        }
    }

    public AssetItemPageResult findAssetsByState(String stateName, boolean seekArchivedAsset, int skip, int numRowsToReturn) throws RulesRepositoryException {
        return this.findAssetsByState(stateName, seekArchivedAsset, skip, numRowsToReturn, null);
    }

    public AssetItemPageResult findAssetsByState(String stateName, boolean seekArchivedAsset, int skip, int numRowsToReturn, RepositoryFilter filter) throws RulesRepositoryException {
        StateItem item = this.getState(stateName);
        try {
            return this.loadLinkedAssets(seekArchivedAsset, skip, numRowsToReturn, item.getNode(), filter);
        }
        catch (RepositoryException e) {
            throw new RulesRepositoryException(e);
        }
    }

    private AssetItemPageResult loadLinkedAssets(boolean seekArchivedAsset, int skip, int numRowsToReturn, Node n, RepositoryFilter filter) throws RepositoryException {
        int rows = 0;
        boolean hasNext = false;
        long currentPosition = 0L;
        ArrayList<AssetItem> results = new ArrayList<AssetItem>();
        PropertyIterator it = n.getReferences();
        while (it.hasNext() && (numRowsToReturn == -1 || rows < skip + numRowsToReturn + 1)) {
            int numRowsInPage;
            Property ruleLink = (Property)it.next();
            Node parentNode = ruleLink.getParent();
            if (!this.isNotSnapshot(parentNode) || !parentNode.getPrimaryNodeType().getName().equals("drools:assetNodeType") || !seekArchivedAsset && parentNode.getProperty("drools:archive").getBoolean()) continue;
            AssetItem ai = new AssetItem(this, parentNode);
            if (filter != null && !filter.accept(ai, "package.readonly") || (numRowsInPage = ++rows - skip) <= 0) continue;
            if (numRowsInPage <= numRowsToReturn || numRowsToReturn == -1) {
                results.add(ai);
                currentPosition = rows;
            }
            hasNext = numRowsInPage > numRowsToReturn && numRowsToReturn != -1;
        }
        return new AssetItemPageResult(results, currentPosition, hasNext);
    }

    public AssetItemPageResult findAssetsByCategory(String categoryTag, int skip, int numRowsToReturn) throws RulesRepositoryException {
        return this.findAssetsByCategory(categoryTag, false, skip, numRowsToReturn);
    }

    public void exportRepositoryToStream(OutputStream output) {
        try {
            this.session.refresh(false);
            this.session.exportSystemView("/drools:repository", output, false, false);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RulesRepositoryException(e);
        }
    }

    public byte[] exportModuleFromRepository(String moduleName) throws IOException, PathNotFoundException, RepositoryException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ZipOutputStream zout = new ZipOutputStream(bout);
        zout.putNextEntry(new ZipEntry("repository_export.xml"));
        zout.write(this.dumpModuleFromRepositoryXml(moduleName));
        zout.closeEntry();
        zout.finish();
        return bout.toByteArray();
    }

    public byte[] dumpModuleFromRepositoryXml(String moduleName) throws PathNotFoundException, IOException, RepositoryException {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        this.session.refresh(false);
        this.session.exportSystemView("/drools:repository/drools:package_area/" + moduleName, (OutputStream)byteOut, false, false);
        return byteOut.toByteArray();
    }

    public void importRepository(InputStream in) {
        new RulesRepositoryAdministrator(this.session).clearRulesRepository();
        try {
            this.session.getWorkspace().importXML("/", in, 0);
            this.session.save();
        }
        catch (RepositoryException e) {
            throw new RulesRepositoryException(e);
        }
        catch (IOException e) {
            throw new RulesRepositoryException(e);
        }
    }

    public void importRulesRepositoryFromStream(InputStream instream) {
        try {
            new RulesRepositoryAdministrator(this.session).clearRulesRepository();
            this.session.getWorkspace().importXML("/", instream, 3);
            this.session.save();
            MigrateDroolsPackage mig = new MigrateDroolsPackage();
            if (mig.needsMigration(this)) {
                mig.migrate(this);
            }
        }
        catch (ItemExistsException e) {
            String message = "Item already exists. At least two items with the path: " + e.getLocalizedMessage();
            log.error(message, (Throwable)e);
            throw new RulesRepositoryException(message);
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RulesRepositoryException("Repository error when importing from stream.", e);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RulesRepositoryException(e);
        }
    }

    public void importPackageToRepository(byte[] byteArray, boolean importAsNew) {
        try {
            if (importAsNew) {
                this.session.getWorkspace().importXML("/drools:repository/drools:package_area/", (InputStream)new ByteArrayInputStream(byteArray), 0);
            } else {
                this.session.getWorkspace().importXML("/drools:repository/drools:package_area/", (InputStream)new ByteArrayInputStream(byteArray), 2);
            }
            this.session.save();
            MigrateDroolsPackage mig = new MigrateDroolsPackage();
            if (mig.needsMigration(this)) {
                mig.migrate(this);
            }
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RulesRepositoryException(e);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RulesRepositoryException(e);
        }
    }

    boolean isNotSnapshot(Node parentNode) throws RepositoryException {
        return parentNode.getPath().indexOf(MODULE_SNAPSHOT_AREA) == -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModuleIterator listModules() {
        Node folderNode = this.getAreaNode(MODULE_AREA);
        try {
            Class<RulesRepository> clazz = RulesRepository.class;
            synchronized (RulesRepository.class) {
                if (!folderNode.hasNode(DEFAULT_PACKAGE)) {
                    this.createModule(DEFAULT_PACKAGE, "The default rule package");
                    folderNode = this.getAreaNode(MODULE_AREA);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return new ModuleIterator(this, folderNode.getNodes());
            }
        }
        catch (RepositoryException e) {
            throw new RulesRepositoryException(e);
        }
    }

    public Session getSession() {
        return this.session;
    }

    public void save() {
        try {
            this.session.save();
        }
        catch (InvalidItemStateException e) {
            String message = "Your operation was failed because it conflicts with a change made through another user. Please try again.";
            log.error("Caught Exception", (Throwable)e);
            throw new RulesRepositoryException(message, e);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RulesRepositoryException(e);
        }
    }

    public void moveRuleItemModule(String newModule, String uuid, String explanation) {
        try {
            AssetItem item = this.loadAssetByUUID(uuid);
            String sourcePath = item.node.getPath();
            String destPath = this.loadModule((String)newModule).node.getPath() + "/" + "assets" + "/" + item.getName();
            this.session.move(sourcePath, destPath);
            this.session.save();
            item.checkout();
            item.node.setProperty("drools:packageName", newModule);
            item.checkin(explanation);
        }
        catch (RepositoryException e) {
            throw new RulesRepositoryException(e);
        }
    }

    public String renameAsset(String uuid, String newAssetName) {
        try {
            AssetItem itemOriginal = this.loadAssetByUUID(uuid);
            log.info("Renaming asset: " + itemOriginal.getNode().getPath() + " to " + newAssetName);
            Node node = itemOriginal.getNode();
            String sourcePath = node.getPath();
            String destPath = node.getParent().getPath() + "/" + newAssetName;
            this.session.move(sourcePath, destPath);
            this.session.save();
            itemOriginal.updateTitle(newAssetName);
            itemOriginal.checkin("Renamed asset " + itemOriginal.getName());
            return itemOriginal.getUUID();
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RulesRepositoryException(e);
        }
    }

    public void renameCategory(String originalPath, String newName) {
        try {
            Node node = this.loadCategory(originalPath).getNode();
            String sourcePath = node.getPath();
            String destPath = node.getParent().getPath() + "/" + newName;
            this.session.move(sourcePath, destPath);
            this.save();
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RulesRepositoryException(e);
        }
    }

    public void renameState(String oldName, String newName) {
        try {
            StateItem state = this.loadState(oldName);
            Node node = state.getNode();
            String sourcePath = node.getPath();
            String destPath = node.getParent().getPath() + "/" + newName;
            this.session.move(sourcePath, destPath);
            this.save();
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RulesRepositoryException(e);
        }
    }

    public String renameModule(String uuid, String newModuleName) {
        try {
            ModuleItem itemOriginal = this.loadModuleByUUID(uuid);
            log.info("Renaming module: " + itemOriginal.getNode().getPath() + " to " + newModuleName);
            Node node = itemOriginal.getNode();
            String sourcePath = node.getPath();
            String destPath = node.getParent().getPath() + "/" + newModuleName;
            this.session.move(sourcePath, destPath);
            this.session.save();
            itemOriginal.updateTitle(newModuleName);
            itemOriginal.checkin("Renamed module " + itemOriginal.getName());
            ModuleItem newModuleItem = this.loadModule(newModuleName);
            Iterator<AssetItem> iter = newModuleItem.getAssets();
            while (iter.hasNext()) {
                AssetItem as = iter.next();
                as.updateStringProperty(newModuleName, "drools:packageName");
            }
            this.save();
            return itemOriginal.getUUID();
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RulesRepositoryException(e);
        }
    }

    public String[] listModuleSnapshots(String moduleName) {
        Node snaps = this.getAreaNode(MODULE_SNAPSHOT_AREA);
        try {
            if (!snaps.hasNode(moduleName)) {
                return new String[0];
            }
            ArrayList<String> result = new ArrayList<String>();
            NodeIterator it = snaps.getNode(moduleName).getNodes();
            while (it.hasNext()) {
                Node element = (Node)it.next();
                result.add(element.getName());
            }
            return result.toArray(new String[result.size()]);
        }
        catch (RepositoryException e) {
            throw new RulesRepositoryException(e);
        }
    }

    public AssetItemIterator findArchivedAssets() {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("SELECT ").append("drools:title").append(", ").append("drools:description").append(", ").append("drools:archive").append(" FROM ").append("drools:assetNodeType").append(" WHERE ").append(" jcr:path LIKE '/").append(RULES_REPOSITORY_NAME).append("/").append(MODULE_AREA).append("/%'").append(" AND ").append("drools:archive").append(" = 'true'");
            stringBuilder.append(" ORDER BY jcr:score DESC");
            Query q = this.session.getWorkspace().getQueryManager().createQuery(stringBuilder.toString(), "sql");
            QueryResult res = q.execute();
            return new AssetItemIterator(res.getNodes(), this);
        }
        catch (RepositoryException e) {
            throw new RulesRepositoryException(e);
        }
    }

    public AssetItemIterator findAssetsByName(String name, boolean seekArchived) {
        return this.findAssetsByName(name, seekArchived, true);
    }

    public AssetItemIterator findAssetsByName(String name, boolean seekArchived, boolean isCaseSensitive) {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT ");
            sb.append("drools:title");
            sb.append(", ");
            sb.append("drools:description");
            sb.append(", ");
            sb.append("drools:archive");
            sb.append(" ");
            sb.append("FROM ");
            sb.append("drools:assetNodeType");
            sb.append(" ");
            sb.append("WHERE ");
            if (isCaseSensitive) {
                sb.append("drools:title");
                sb.append(" ");
                sb.append("LIKE '");
                sb.append(name);
                sb.append("' ");
            } else {
                sb.append("LOWER(");
                sb.append("drools:title");
                sb.append(") ");
                sb.append("LIKE '");
                sb.append(name.toLowerCase());
                sb.append("' ");
            }
            sb.append("AND jcr:path LIKE '/");
            sb.append(RULES_REPOSITORY_NAME);
            sb.append("/");
            sb.append(MODULE_AREA);
            sb.append("/%'");
            if (!seekArchived) {
                sb.append(" AND ");
                sb.append("drools:archive");
                sb.append(" = 'false'");
            }
            sb.append(" ORDER BY jcr:score DESC");
            Query q = this.session.getWorkspace().getQueryManager().createQuery(sb.toString(), "sql");
            QueryResult res = q.execute();
            return new AssetItemIterator(res.getNodes(), this);
        }
        catch (RepositoryException e) {
            throw new RulesRepositoryException(e);
        }
    }

    public AssetItemIterator queryFullText(String qry, boolean seekArchived) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("/jcr:root/").append(RULES_REPOSITORY_NAME).append("/").append(MODULE_AREA).append("//element(*, ").append("drools:assetNodeType").append(")");
            if (seekArchived) {
                stringBuilder.append("[jcr:contains(., '" + qry + "')]");
            } else {
                stringBuilder.append("[jcr:contains(., '").append(qry).append("') and ").append("drools:archive").append(" = 'false']");
            }
            stringBuilder.append(" ORDER BY [jcr:score] DESC");
            Query q = this.session.getWorkspace().getQueryManager().createQuery(stringBuilder.toString(), "xpath");
            QueryResult res = q.execute();
            return new AssetItemIterator(res.getNodes(), this);
        }
        catch (RepositoryException e) {
            throw new RulesRepositoryException(e);
        }
    }

    public AssetItemIterator query(Map<String, String[]> params, boolean seekArchived, DateQuery[] dates) {
        try {
            StringBuilder sql = new StringBuilder("SELECT ").append("drools:title").append(", ").append("drools:description").append(", ").append("drools:archive").append(" FROM ").append("drools:assetNodeType");
            sql.append(" WHERE jcr:path LIKE '/").append(RULES_REPOSITORY_NAME).append("/").append(MODULE_AREA).append("/%'");
            for (Map.Entry<String, String[]> en : params.entrySet()) {
                String fld = en.getKey();
                String[] options = en.getValue();
                if (options == null || options.length <= 0) continue;
                if (options.length > 1) {
                    sql.append(" AND (");
                    for (int i = 0; i < options.length; ++i) {
                        sql.append(fld).append(" LIKE '").append(options[i].replace("*", "%")).append("'");
                        if (i >= options.length - 1) continue;
                        sql.append(" OR ");
                    }
                    sql.append(")");
                    continue;
                }
                sql.append(" AND ").append(fld).append(" LIKE '").append(options[0].replace("*", "%")).append("'");
            }
            if (!seekArchived) {
                sql.append(" AND ").append("drools:archive").append(" = 'false'");
            }
            if (dates != null) {
                for (DateQuery d : dates) {
                    if (d.after != null) {
                        sql.append(" AND ").append(d.field).append(" > TIMESTAMP '").append(d.after).append("'");
                    }
                    if (d.before == null) continue;
                    sql.append(" AND ").append(d.field).append(" < TIMESTAMP '").append(d.before).append("'");
                }
            }
            sql.append(" ORDER BY jcr:score DESC");
            Query q = this.session.getWorkspace().getQueryManager().createQuery(sql.toString(), "sql");
            QueryResult res = q.execute();
            return new AssetItemIterator(res.getNodes(), this);
        }
        catch (RepositoryException e) {
            throw new RulesRepositoryException(e);
        }
    }

    private Node getPerspectivesConfigurationArea() throws RepositoryException {
        Node areaNode;
        try {
            areaNode = this.getAreaNode(String.format("%s/%s", CONFIGURATION_AREA, PERSPECTIVES_CONFIGURATION_AREA));
        }
        catch (RulesRepositoryException e) {
            Node repositoryNode = this.session.getRootNode().getNode(RULES_REPOSITORY_NAME);
            Node configurationArea = RulesRepository.addNodeIfNew(repositoryNode, CONFIGURATION_AREA, "nt:folder");
            areaNode = RulesRepository.addNodeIfNew(configurationArea, PERSPECTIVES_CONFIGURATION_AREA, "nt:folder");
        }
        return areaNode;
    }

    public AssetItemIterator findAssetsByName(String name) {
        return this.findAssetsByName(name, false);
    }

    public StateItem[] listStates() {
        ArrayList<StateItem> states = new ArrayList<StateItem>();
        try {
            NodeIterator it = this.getAreaNode(STATE_AREA).getNodes();
            while (it.hasNext()) {
                states.add(new StateItem(this, it.nextNode()));
            }
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RulesRepositoryException(e);
        }
        return states.toArray(new StateItem[states.size()]);
    }

    public String copyModule(String sourceModuleName, String destModuleName) {
        ModuleItem source = this.loadModule(sourceModuleName);
        try {
            String destPath = source.getNode().getParent().getPath() + "/" + destModuleName;
            if (this.getAreaNode(MODULE_AREA).hasNode(destModuleName)) {
                throw new RulesRepositoryException("Destination already exists.");
            }
            this.session.getWorkspace().copy(source.getNode().getPath(), destPath);
            ModuleItem newModuleItem = this.loadModule(destModuleName);
            newModuleItem.updateTitle(destModuleName);
            Iterator<AssetItem> iter = newModuleItem.getAssets();
            while (iter.hasNext()) {
                AssetItem as = iter.next();
                as.updateStringProperty(destModuleName, "drools:packageName");
            }
            this.save();
            return newModuleItem.getUUID();
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RulesRepositoryException(e);
        }
    }

    public boolean isDoNotInstallSample() throws RepositoryException {
        return this.containsDoNotInstallSampleNode();
    }

    public void setDoNotInstallSample() throws RepositoryException {
        Node rootNode = this.session.getRootNode().getNode(RULES_REPOSITORY_NAME);
        if (!rootNode.hasNode(DO_NOT_INSTALL_SAMPLE_NODE)) {
            rootNode.addNode(DO_NOT_INSTALL_SAMPLE_NODE, "nt:folder");
            this.save();
        }
    }

    private boolean containsDoNotInstallSampleNode() throws RepositoryException {
        Node rootNode = this.session.getRootNode().getNode(RULES_REPOSITORY_NAME);
        try {
            return rootNode.hasNode(DO_NOT_INSTALL_SAMPLE_NODE);
        }
        catch (RepositoryException e) {
            throw new RulesRepositoryException(e);
        }
    }

    public static class DateQuery {
        private final String after;
        private final String before;
        private final String field;

        public DateQuery(String field, String after, String before) {
            this.field = field;
            this.after = after;
            this.before = before;
        }
    }
}

