/*
 * Decompiled with CFR 0.152.
 */
package org.drools.repository;

import java.util.Calendar;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.drools.repository.AssetItem;
import org.drools.repository.CategoryItem;
import org.drools.repository.RepositoryTestCase;
import org.drools.repository.RulesRepository;
import org.drools.repository.RulesRepositoryException;
import org.junit.Assert;
import org.junit.Test;

public class CategoryItemTest
extends RepositoryTestCase {
    @Test
    public void testTagItem() throws Exception {
        CategoryItem root = this.getRepo().loadCategory("/");
        root.addCategory("TestTag", "nothing to see");
        CategoryItem tagItem1 = this.getRepo().loadCategory("TestTag");
        Assert.assertNotNull((Object)tagItem1);
        Assert.assertEquals((Object)"TestTag", (Object)tagItem1.getName());
        CategoryItem tagItem2 = this.getRepo().loadCategory("TestTag");
        Assert.assertNotNull((Object)tagItem2);
        Assert.assertEquals((Object)"TestTag", (Object)tagItem2.getName());
        Assert.assertEquals((Object)tagItem1, (Object)tagItem2);
        List originalCats = this.getRepo().loadCategory("/").getChildTags();
        Assert.assertTrue((originalCats.size() > 0 ? 1 : 0) != 0);
        CategoryItem rootCat = (CategoryItem)originalCats.get(0);
        Assert.assertNotNull((Object)rootCat.getName());
        Assert.assertNotNull((Object)rootCat.getFullPath());
        root.addCategory("FootestTagItem", "nothing");
        List cats = root.getChildTags();
        Assert.assertEquals((long)(originalCats.size() + 1), (long)cats.size());
        boolean found = false;
        for (CategoryItem element : cats) {
            if (!element.getName().equals("FootestTagItem")) continue;
            found = true;
            break;
        }
        Assert.assertTrue((boolean)found);
    }

    @Test
    public void testCreateCateories() throws Exception {
        RulesRepository repo = this.getRepo();
        CategoryItem root = repo.loadCategory("/");
        CategoryItem item = root.addCategory("testCreateCategories", "this is a top level one");
        Assert.assertEquals((Object)"testCreateCategories", (Object)item.getName());
        Assert.assertEquals((Object)"testCreateCategories", (Object)item.getFullPath());
        item = repo.loadCategory("testCreateCategories");
        Assert.assertEquals((Object)"testCreateCategories", (Object)item.getName());
        item.remove();
        repo.save();
        try {
            repo.loadCategory("testCreateCategories");
            Assert.fail((String)"this should not exist");
        }
        catch (RulesRepositoryException e) {
            Assert.assertNotNull((Object)e.getCause());
        }
    }

    @Test
    public void testGetChildTags() {
        CategoryItem root = this.getRepo().loadCategory("/");
        root.addCategory("TestTag", "nothing to see");
        CategoryItem tagItem1 = this.getRepo().loadCategory("TestTag");
        Assert.assertNotNull((Object)tagItem1);
        Assert.assertEquals((Object)"TestTag", (Object)tagItem1.getName());
        List childTags = tagItem1.getChildTags();
        Assert.assertNotNull((Object)childTags);
        Assert.assertEquals((long)0L, (long)childTags.size());
        tagItem1.addCategory("TestChildTag1", "description");
        childTags = tagItem1.getChildTags();
        Assert.assertNotNull((Object)childTags);
        Assert.assertEquals((long)1L, (long)childTags.size());
        Assert.assertEquals((Object)"TestChildTag1", (Object)((CategoryItem)childTags.get(0)).getName());
        tagItem1.addCategory("AnotherChild", "ignore me");
        childTags = tagItem1.getChildTags();
        Assert.assertNotNull((Object)childTags);
        Assert.assertEquals((long)2L, (long)childTags.size());
    }

    @Test
    public void testGetChildTag() {
        CategoryItem root = this.getRepo().loadCategory("/");
        CategoryItem tagItem1 = root.addCategory("testGetChildTag", "yeah");
        Assert.assertNotNull((Object)tagItem1);
        Assert.assertEquals((Object)"testGetChildTag", (Object)tagItem1.getName());
        List childTags = tagItem1.getChildTags();
        Assert.assertNotNull((Object)childTags);
        Assert.assertEquals((long)0L, (long)childTags.size());
        CategoryItem childTagItem1 = tagItem1.addCategory("TestChildTag1", "woo");
        Assert.assertNotNull((Object)childTagItem1);
        Assert.assertEquals((Object)"TestChildTag1", (Object)childTagItem1.getName());
        CategoryItem childTagItem2 = this.getRepo().loadCategory("testGetChildTag/TestChildTag1");
        Assert.assertNotNull((Object)childTagItem2);
        Assert.assertEquals((Object)"TestChildTag1", (Object)childTagItem2.getName());
        Assert.assertEquals((Object)childTagItem1, (Object)childTagItem2);
    }

    @Test
    public void testGetFullPath() {
        CategoryItem root = this.getRepo().loadCategory("/");
        CategoryItem tagItem1 = root.addCategory("testGetFullPath", "foo");
        Assert.assertNotNull((Object)tagItem1);
        Assert.assertEquals((Object)"testGetFullPath", (Object)tagItem1.getFullPath());
        CategoryItem childTagItem1 = tagItem1.addCategory("TestChildTag1", "foo");
        Assert.assertNotNull((Object)childTagItem1);
        Assert.assertEquals((Object)"testGetFullPath/TestChildTag1", (Object)childTagItem1.getFullPath());
        CategoryItem childTagItem2 = childTagItem1.addCategory("TestChildTag2", "wee");
        Assert.assertNotNull((Object)childTagItem2);
        Assert.assertEquals((Object)"testGetFullPath/TestChildTag1/TestChildTag2", (Object)childTagItem2.getFullPath());
    }

    @Test
    public void testRemoveCategoryUneeded() {
        RulesRepository repo = this.getRepo();
        repo.loadCategory("/").addCategory("testRemoveCat", "a");
        AssetItem as = repo.loadDefaultModule().addAsset("testRemoveCategory", "a", "testRemoveCat", "drl");
        as.checkin("a");
        as.updateCategoryList(new String[0]);
        as.checkin("a");
        as = repo.loadDefaultModule().loadAsset("testRemoveCategory");
        Assert.assertEquals((long)0L, (long)as.getCategories().size());
        repo.loadCategory("testRemoveCat").remove();
        repo.save();
    }

    @Test
    public void testRemoveCategoryLinkedWithArchived() {
        RulesRepository repo = this.getRepo();
        repo.loadCategory("/").addCategory("testRemoveCategoryWithArchivedCat", "a");
        AssetItem as = repo.loadDefaultModule().addAsset("testRemoveCategoryWithArchivedAsset", "a", "testRemoveCategoryWithArchivedCat", "drl");
        as.checkin("a");
        as.archiveItem(true);
        repo.loadCategory("testRemoveCategoryWithArchivedCat").remove();
        repo.save();
        as.remove();
    }

    @Test
    public void simpleRemoveCategoryLinkedWithArchived() {
        try {
            RulesRepository repo = this.getRepo();
            Session session = repo.getSession();
            Node rn = session.getRootNode();
            Node asset = rn.addNode("asset", "drools:assetNodeType");
            asset.setProperty("drools:packageName", "one");
            asset.setProperty("drools:title", "title");
            asset.setProperty("drools:format", "format");
            asset.setProperty("drools:description", "description");
            Calendar lastModified = Calendar.getInstance();
            asset.setProperty("drools:lastModified", lastModified);
            Node category = rn.addNode("category", "drools:categoryNodeType");
            Value[] newTagValues = new Value[]{asset.getSession().getValueFactory().createValue(category)};
            asset.setProperty("drools:categoryReference", newTagValues);
            session.save();
            PropertyIterator pi = category.getReferences();
            while (pi.hasNext()) {
                Property property = pi.nextProperty();
                String name = property.getName();
                System.out.println("Name=" + name);
                Assert.assertEquals((Object)"drools:categoryReference", (Object)name);
            }
            Value[] updatedTagValues = new Value[]{null};
            asset.setProperty("drools:categoryReference", updatedTagValues);
            category.remove();
            session.save();
        }
        catch (RepositoryException e) {
            e.printStackTrace();
            Assert.fail();
        }
    }
}

