/*
 * Decompiled with CFR 0.152.
 */
package org.drools.repository.utils;

import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.drools.repository.AssetItem;
import org.drools.repository.utils.Validator;

@Singleton
public class AssetValidator {
    private Validator defaultValidator;
    @Inject
    @Any
    private Instance<Validator> validators;

    public boolean validate(AssetItem assetItem) {
        if (this.validators != null) {
            for (Validator validator : this.validators) {
                if (validator.getFormat().equals("default")) {
                    this.defaultValidator = validator;
                }
                if (!assetItem.getFormat().equals(validator.getFormat())) continue;
                return validator.validate(assetItem);
            }
            if (this.defaultValidator != null) {
                return this.defaultValidator.validate(assetItem);
            }
        }
        return true;
    }
}

