/*
 * Copyright 2012 JBoss Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.drools.guvnor.server.contenthandler.drools;

import com.google.gwt.user.client.rpc.SerializationException;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.ServiceConfig;
import org.drools.guvnor.client.rpc.Asset;
import org.drools.guvnor.server.contenthandler.ContentHandler;
import org.drools.repository.AssetItem;

public class ServiceConfigContentHandler extends ContentHandler {

    @Override
    public void retrieveAssetContent(final Asset asset, final AssetItem item) throws SerializationException {
        final ServiceConfig model = ServiceConfigPersistence.getInstance().unmarshal(item.getContent());

        asset.setContent(model);
    }

    @Override
    public void storeAssetContent(final Asset asset, final AssetItem repoAsset) throws SerializationException {
        ServiceConfig data = (ServiceConfig) asset.getContent();
        repoAsset.updateContent(ServiceConfigPersistence.getInstance().marshal(data));
    }
}
