/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.asseteditor.drools.serviceconfig;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.AssetReference;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.ProtocolOption;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.ServiceKBaseConfig;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.ServiceKSessionConfig;
import org.drools.guvnor.client.rpc.MavenArtifact;
import org.drools.guvnor.client.util.Preconditions;
import org.drools.ide.common.client.modeldriven.brl.PortableObject;

public class ServiceConfig
implements PortableObject {
    private static final long serialVersionUID = -5738821650999392917L;
    private final String version = "1.0";
    private Integer pollingFrequency;
    private Set<MavenArtifact> excludedArtifacts;
    private Map<String, ServiceKBaseConfig> kbases;

    public ServiceConfig() {
        this.pollingFrequency = null;
        this.excludedArtifacts = new HashSet();
        this.kbases = new HashMap();
    }

    public ServiceConfig(ServiceConfig source) {
        Preconditions.checkNotNull((String)"source", (Object)source);
        this.pollingFrequency = source.pollingFrequency;
        if (source.excludedArtifacts == null) {
            this.excludedArtifacts = new HashSet();
        } else {
            this.excludedArtifacts = new HashSet(source.excludedArtifacts.size());
            for (MavenArtifact mavenArtifact : source.excludedArtifacts) {
                this.excludedArtifacts.add(new MavenArtifact(mavenArtifact));
            }
        }
        if (source.kbases == null) {
            this.kbases = new HashMap();
        } else {
            this.kbases = new HashMap(source.kbases.size());
            for (Map.Entry entry : source.kbases.entrySet()) {
                this.kbases.put(((String)entry.getKey()).toLowerCase(), new ServiceKBaseConfig((ServiceKBaseConfig)entry.getValue()));
            }
        }
    }

    public ServiceConfig(String pollingFrequency, Collection<MavenArtifact> excludedArtifacts, Collection<ServiceKBaseConfig> kbases) {
        if (pollingFrequency != null) {
            Preconditions.checkCondition((String)"pollingFrequency must be numeric", (boolean)this.isNumeric(pollingFrequency));
            this.pollingFrequency = Integer.valueOf(pollingFrequency);
        }
        if (excludedArtifacts == null) {
            this.excludedArtifacts = new HashSet();
        } else {
            this.excludedArtifacts = new HashSet(excludedArtifacts.size());
            for (MavenArtifact excludedArtifact : excludedArtifacts) {
                this.excludedArtifacts.add(new MavenArtifact(excludedArtifact));
            }
        }
        if (kbases == null) {
            this.kbases = new HashMap();
        } else {
            this.kbases = new HashMap(kbases.size());
            for (ServiceKBaseConfig activeKBase : kbases) {
                this.kbases.put(activeKBase.getName().toLowerCase(), new ServiceKBaseConfig(activeKBase));
            }
        }
    }

    public Collection<AssetReference> getModels() {
        HashSet<AssetReference> result = new HashSet<AssetReference>();
        for (ServiceKBaseConfig kbase : this.kbases.values()) {
            result.addAll(kbase.getModels());
        }
        return result;
    }

    public boolean hasProtocolReference(ProtocolOption protocol) {
        Preconditions.checkNotNull((String)"protocol", (Object)protocol);
        for (ServiceKBaseConfig kbase : this.kbases.values()) {
            for (ServiceKSessionConfig ksession : kbase.getKsessions()) {
                if (!ksession.getProtocol().equals((Object)protocol)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isNumeric(String value) {
        try {
            Integer.valueOf(value);
            return true;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    public Integer getPollingFrequency() {
        return this.pollingFrequency;
    }

    public void setPollingFrequency(int pollingFrequency) {
        this.pollingFrequency = pollingFrequency;
    }

    public ServiceKBaseConfig getKbase(String kbaseName) {
        if (kbaseName == null || kbaseName.trim().length() == 0) {
            return null;
        }
        return (ServiceKBaseConfig)this.kbases.get(kbaseName.toLowerCase());
    }

    public Collection<ServiceKBaseConfig> getKbases() {
        return this.kbases.values();
    }

    public void addKBase(ServiceKBaseConfig kbase) {
        if (kbase == null) {
            return;
        }
        if (this.kbases.containsKey(kbase.getName().toLowerCase())) {
            throw new IllegalArgumentException("KBase already exists.");
        }
        this.kbases.put(kbase.getName().toLowerCase(), kbase);
    }

    public void removeKBase(String kbase) {
        if (kbase == null || kbase.trim().length() == 0) {
            return;
        }
        this.kbases.remove(kbase.toLowerCase());
    }

    public Collection<MavenArtifact> getExcludedArtifacts() {
        return this.excludedArtifacts;
    }

    public void setExcludedArtifacts(Collection<MavenArtifact> excludedItems) {
        if (excludedItems == null) {
            return;
        }
        this.excludedArtifacts = new HashSet<MavenArtifact>(excludedItems);
    }

    public void addExcludedArtifacts(Collection<MavenArtifact> excludedItems) {
        if (excludedItems == null || excludedItems.size() == 0) {
            return;
        }
        this.excludedArtifacts.addAll(excludedItems);
    }

    public void addExcludedArtifact(MavenArtifact artifact) {
        if (artifact == null) {
            return;
        }
        this.excludedArtifacts.add(artifact);
    }

    public void removeExcludedArtifacts(Collection<MavenArtifact> excludedItems) {
        if (excludedItems == null || excludedItems.size() == 0) {
            return;
        }
        this.excludedArtifacts.removeAll(excludedItems);
    }

    public void removeExcludedArtifact(MavenArtifact artifact) {
        if (artifact == null) {
            return;
        }
        this.excludedArtifacts.remove(artifact);
    }

    public String getNextKBaseName() {
        String name;
        int i = 0;
        while (this.kbases.containsKey(name = "kbase" + ++i)) {
        }
        return name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceConfig that = (ServiceConfig)o;
        if (!((Object)this.excludedArtifacts).equals(that.excludedArtifacts)) {
            return false;
        }
        if (!((Object)this.kbases).equals(that.kbases)) {
            return false;
        }
        return !(this.pollingFrequency != null ? !this.pollingFrequency.equals(that.pollingFrequency) : that.pollingFrequency != null);
    }

    public int hashCode() {
        int result = this.pollingFrequency != null ? this.pollingFrequency.hashCode() : 0;
        result = 31 * result + ((Object)this.excludedArtifacts).hashCode();
        result = 31 * result + ((Object)this.kbases).hashCode();
        return result;
    }
}

