/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.decisiontable;

import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.RadioButton;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashSet;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.HumanReadable;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.BindingTextBox;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.CEPOperatorsDropdown;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.CEPWindowOperatorsDropdown;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.ImageButton;
import org.drools.guvnor.client.common.InfoPopup;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.decisiontable.ConditionColumnCommand;
import org.drools.guvnor.client.decisiontable.ConditionPopup;
import org.drools.guvnor.client.decisiontable.DTCellValueWidgetFactory;
import org.drools.guvnor.client.decisiontable.Validator;
import org.drools.guvnor.client.decisiontable.widget.DTCellValueUtilities;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.resources.DroolsGuvnorImages;
import org.drools.ide.common.client.modeldriven.FieldAccessorsAndMutators;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.brl.HasCEPWindow;
import org.drools.ide.common.client.modeldriven.brl.HasParameterizedOperator;
import org.drools.ide.common.client.modeldriven.dt52.BRLRuleModel;
import org.drools.ide.common.client.modeldriven.dt52.BaseColumn;
import org.drools.ide.common.client.modeldriven.dt52.CompositeColumn;
import org.drools.ide.common.client.modeldriven.dt52.ConditionCol52;
import org.drools.ide.common.client.modeldriven.dt52.DTCellValue52;
import org.drools.ide.common.client.modeldriven.dt52.DTColumnConfig52;
import org.drools.ide.common.client.modeldriven.dt52.DTDataTypes52;
import org.drools.ide.common.client.modeldriven.dt52.GuidedDecisionTable52;
import org.drools.ide.common.client.modeldriven.dt52.LimitedEntryCol;
import org.drools.ide.common.client.modeldriven.dt52.LimitedEntryConditionCol52;
import org.drools.ide.common.client.modeldriven.dt52.Pattern52;

public class ConditionPopup
extends FormStylePopup {
    private SmallLabel patternLabel = new SmallLabel();
    private TextBox fieldLabel = this.getFieldLabel();
    private TextBox binding = new BindingTextBox();
    private Label operatorLabel = new Label();
    private SimplePanel limitedEntryValueWidgetContainer = new SimplePanel();
    private int limitedEntryValueAttributeIndex = 0;
    private TextBox valueListWidget = null;
    private SimplePanel defaultValueWidgetContainer = new SimplePanel();
    private int defaultValueWidgetContainerIndex = 0;
    private ImageButton editField;
    private ImageButton editOp;
    private RadioButton literal = new RadioButton("constraintValueType", Constants.INSTANCE.LiteralValue());
    private RadioButton formula = new RadioButton("constraintValueType", Constants.INSTANCE.Formula());
    private RadioButton predicate = new RadioButton("constraintValueType", Constants.INSTANCE.Predicate());
    private CEPWindowOperatorsDropdown cwo;
    private TextBox entryPointName;
    private int cepWindowRowIndex;
    private final GuidedDecisionTable52 model;
    private final SuggestionCompletionEngine sce;
    private final DTCellValueWidgetFactory factory;
    private final Validator validator;
    private final BRLRuleModel rm;
    private final DTCellValueUtilities utilities;
    private Pattern52 editingPattern;
    private ConditionCol52 editingCol;
    private final boolean isReadOnly;
    private InfoPopup fieldLabelInterpolationInfo = this.getPredicateHint();

    public ConditionPopup(SuggestionCompletionEngine sce, GuidedDecisionTable52 model, ConditionColumnCommand refreshGrid, ConditionCol52 col, boolean isNew, boolean isReadOnly) {
        this.rm = new BRLRuleModel(model);
        this.editingPattern = model.getPattern(col);
        this.editingCol = this.cloneConditionColumn(col);
        this.model = model;
        this.sce = sce;
        this.isReadOnly = isReadOnly;
        this.validator = new Validator(model.getConditions());
        this.utilities = new DTCellValueUtilities(model, sce);
        this.factory = DTCellValueWidgetFactory.getInstance((GuidedDecisionTable52)model, (SuggestionCompletionEngine)sce, (boolean)isReadOnly, (boolean)this.allowEmptyValues());
        this.setTitle(Constants.INSTANCE.ConditionColumnConfiguration());
        this.setModal(false);
        HorizontalPanel pattern = new HorizontalPanel();
        pattern.add((Widget)this.patternLabel);
        this.doPatternLabel();
        ImageButton changePattern = new ImageButton(DroolsGuvnorImages.INSTANCE.edit(), DroolsGuvnorImages.INSTANCE.editDisabled(), Constants.INSTANCE.ChooseAnExistingPatternThatThisColumnAddsTo(), (ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        changePattern.setEnabled(!isReadOnly);
        pattern.add((Widget)changePattern);
        this.addAttribute(Constants.INSTANCE.Pattern(), (IsWidget)pattern);
        switch (22.$SwitchMap$org$drools$ide$common$client$modeldriven$dt52$GuidedDecisionTable52$TableFormat[model.getTableFormat().ordinal()]) {
            case 1: {
                HorizontalPanel valueTypes = new HorizontalPanel();
                valueTypes.add((Widget)this.literal);
                valueTypes.add((Widget)this.formula);
                valueTypes.add((Widget)this.predicate);
                this.addAttribute(Constants.INSTANCE.CalculationType(), (IsWidget)valueTypes);
                switch (this.editingCol.getConstraintValueType()) {
                    case 1: {
                        this.literal.setValue(Boolean.valueOf(true));
                        this.binding.setEnabled(!isReadOnly);
                        break;
                    }
                    case 3: {
                        this.formula.setValue(Boolean.valueOf(true));
                        this.binding.setEnabled(false);
                        break;
                    }
                    case 5: {
                        this.predicate.setValue(Boolean.valueOf(true));
                        this.binding.setEnabled(false);
                    }
                }
                if (!isReadOnly) {
                    this.literal.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
                }
                if (!isReadOnly) {
                    this.formula.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
                }
                if (!isReadOnly) {
                    this.predicate.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
                }
                this.doCalculationType();
                break;
            }
            case 2: {
                this.binding.setEnabled(!isReadOnly);
            }
        }
        HorizontalPanel field = new HorizontalPanel();
        this.fieldLabel.setEnabled(!isReadOnly);
        field.add((Widget)this.fieldLabel);
        field.add((Widget)this.fieldLabelInterpolationInfo);
        this.editField = new ImageButton(DroolsGuvnorImages.INSTANCE.edit(), DroolsGuvnorImages.INSTANCE.editDisabled(), Constants.INSTANCE.EditTheFieldThatThisColumnOperatesOn(), (ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.editField.setEnabled(!isReadOnly);
        field.add((Widget)this.editField);
        this.addAttribute(Constants.INSTANCE.Field(), (IsWidget)field);
        this.doFieldLabel();
        HorizontalPanel operator = new HorizontalPanel();
        operator.add((Widget)this.operatorLabel);
        this.editOp = new ImageButton(DroolsGuvnorImages.INSTANCE.edit(), DroolsGuvnorImages.INSTANCE.editDisabled(), Constants.INSTANCE.EditTheOperatorThatIsUsedToCompareDataWithThisField(), (ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.editOp.setEnabled(!isReadOnly);
        operator.add((Widget)this.editOp);
        this.addAttribute(Constants.INSTANCE.Operator(), (IsWidget)operator);
        this.doOperatorLabel();
        this.doImageButtons();
        this.cepWindowRowIndex = this.addAttribute(Constants.INSTANCE.DTLabelOverCEPWindow(), (IsWidget)this.createCEPWindowWidget((HasCEPWindow)this.editingPattern));
        this.displayCEPOperators();
        this.entryPointName = new TextBox();
        this.entryPointName.setText(this.editingPattern.getEntryPointName());
        this.entryPointName.setEnabled(!isReadOnly);
        if (!isReadOnly) {
            this.entryPointName.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        }
        this.addAttribute(Constants.INSTANCE.DTLabelFromEntryPoint(), (IsWidget)this.entryPointName);
        TextBox header = new TextBox();
        header.setText(col.getHeader());
        header.setEnabled(!isReadOnly);
        if (!isReadOnly) {
            header.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        }
        this.addAttribute(Constants.INSTANCE.ColumnHeaderDescription(), (IsWidget)header);
        if (model.getTableFormat() == GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY) {
            this.valueListWidget = new TextBox();
            this.valueListWidget.setText(this.editingCol.getValueList());
            this.valueListWidget.setEnabled(!isReadOnly);
            if (!isReadOnly) {
                this.valueListWidget.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
                this.valueListWidget.addBlurHandler((BlurHandler)new /* Unavailable Anonymous Inner Class!! */);
            }
            HorizontalPanel vl = new HorizontalPanel();
            vl.add((Widget)this.valueListWidget);
            vl.add((Widget)new InfoPopup(Constants.INSTANCE.ValueList(), Constants.INSTANCE.ValueListsExplanation()));
            this.addAttribute(Constants.INSTANCE.optionalValueList(), (IsWidget)vl);
        }
        this.doValueList();
        if (model.getTableFormat() == GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY) {
            this.defaultValueWidgetContainerIndex = this.addAttribute(Constants.INSTANCE.DefaultValue(), (IsWidget)this.defaultValueWidgetContainer);
            this.makeDefaultValueWidget();
        }
        if (model.getTableFormat() == GuidedDecisionTable52.TableFormat.LIMITED_ENTRY) {
            this.limitedEntryValueAttributeIndex = this.addAttribute(Constants.INSTANCE.LimitedEntryValue(), (IsWidget)this.limitedEntryValueWidgetContainer);
            this.makeLimitedValueWidget();
        }
        this.binding.setText(col.getBinding());
        if (!isReadOnly) {
            this.binding.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        }
        this.addAttribute(Constants.INSTANCE.Binding(), (IsWidget)this.binding);
        this.addAttribute(Constants.INSTANCE.HideThisColumn(), (IsWidget)DTCellValueWidgetFactory.getHideColumnIndicator((DTColumnConfig52)this.editingCol));
        Button apply = new Button(Constants.INSTANCE.ApplyChanges());
        apply.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.addAttribute("", (IsWidget)apply);
    }

    private boolean allowEmptyValues() {
        return this.model.getTableFormat() == GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY;
    }

    private ConditionCol52 cloneConditionColumn(ConditionCol52 col) {
        LimitedEntryConditionCol52 clone = null;
        if (col instanceof LimitedEntryConditionCol52) {
            clone = new LimitedEntryConditionCol52();
            DTCellValue52 dcv = this.cloneLimitedEntryValue(((LimitedEntryCol)col).getValue());
            ((LimitedEntryCol)clone).setValue(dcv);
        } else {
            clone = new ConditionCol52();
        }
        clone.setConstraintValueType(col.getConstraintValueType());
        clone.setFactField(col.getFactField());
        clone.setFieldType(col.getFieldType());
        clone.setHeader(col.getHeader());
        clone.setOperator(col.getOperator());
        clone.setValueList(col.getValueList());
        clone.setDefaultValue(new DTCellValue52(col.getDefaultValue()));
        clone.setHideColumn(col.isHideColumn());
        clone.setParameters(col.getParameters());
        clone.setWidth(col.getWidth());
        clone.setBinding(col.getBinding());
        return clone;
    }

    private DTCellValue52 cloneLimitedEntryValue(DTCellValue52 dcv) {
        if (dcv == null) {
            return null;
        }
        DTCellValue52 clone = new DTCellValue52(dcv);
        return clone;
    }

    private void makeLimitedValueWidget() {
        if (!(this.editingCol instanceof LimitedEntryConditionCol52)) {
            return;
        }
        LimitedEntryConditionCol52 lec = (LimitedEntryConditionCol52)this.editingCol;
        boolean doesOperatorNeedValue = this.validator.doesOperatorNeedValue(this.editingCol);
        if (!doesOperatorNeedValue) {
            this.setAttributeVisibility(this.limitedEntryValueAttributeIndex, false);
            lec.setValue(null);
            return;
        }
        this.setAttributeVisibility(this.limitedEntryValueAttributeIndex, true);
        if (lec.getValue() == null) {
            lec.setValue(this.factory.makeNewValue(this.editingPattern, this.editingCol));
        }
        this.limitedEntryValueWidgetContainer.setWidget(this.factory.getWidget(this.editingPattern, this.editingCol, lec.getValue()));
    }

    private void makeDefaultValueWidget() {
        if (this.nil(this.editingCol.getFactField())) {
            this.setAttributeVisibility(this.defaultValueWidgetContainerIndex, false);
            return;
        }
        if (!this.validator.doesOperatorNeedValue(this.editingCol)) {
            this.setAttributeVisibility(this.defaultValueWidgetContainerIndex, false);
            return;
        }
        this.setAttributeVisibility(this.defaultValueWidgetContainerIndex, true);
        if (this.editingCol.getDefaultValue() == null) {
            this.editingCol.setDefaultValue(this.factory.makeNewValue(this.editingPattern, this.editingCol));
        }
        DTCellValue52 defaultValue = this.editingCol.getDefaultValue();
        DTDataTypes52 dataType = this.utilities.getDataType(this.editingPattern, this.editingCol);
        this.utilities.assertDTCellValue(dataType, defaultValue);
        this.defaultValueWidgetContainer.setWidget(this.factory.getWidget(this.editingPattern, this.editingCol, defaultValue));
    }

    private void applyConsTypeChange(int newType) {
        this.editingCol.setConstraintValueType(newType);
        this.binding.setEnabled(newType == 1 && !this.isReadOnly);
        this.doFieldLabel();
        this.doValueList();
        this.doOperatorLabel();
        this.doImageButtons();
        this.makeDefaultValueWidget();
    }

    private void doImageButtons() {
        int constraintType = this.editingCol.getConstraintValueType();
        this.editField.setEnabled(constraintType != 5 && !this.isReadOnly);
        this.editOp.setEnabled(constraintType != 5 && !this.isReadOnly);
    }

    private boolean isBindingUnique(String binding) {
        return !this.rm.isVariableNameUsed(binding);
    }

    private void doFieldLabel() {
        if (this.editingCol.getConstraintValueType() == 5) {
            if (this.editingCol.getFactField() == null || this.editingCol.getFactField().equals("")) {
                this.fieldLabel.setText(Constants.INSTANCE.notNeededForPredicate());
            } else {
                this.fieldLabel.setText(this.editingCol.getFactField());
            }
            this.fieldLabelInterpolationInfo.setVisible(true);
        } else if (this.nil(this.editingPattern.getFactType())) {
            this.fieldLabel.setText(Constants.INSTANCE.pleaseSelectAPatternFirst());
            this.fieldLabelInterpolationInfo.setVisible(false);
        } else if (this.nil(this.editingCol.getFactField())) {
            this.fieldLabel.setText(Constants.INSTANCE.pleaseSelectAField());
            this.fieldLabelInterpolationInfo.setVisible(false);
        } else {
            this.fieldLabel.setText(this.editingCol.getFactField());
        }
    }

    private void doOperatorLabel() {
        if (this.editingCol.getConstraintValueType() == 5) {
            this.operatorLabel.setText(Constants.INSTANCE.notNeededForPredicate());
        } else if (this.nil(this.editingPattern.getFactType())) {
            this.operatorLabel.setText(Constants.INSTANCE.pleaseSelectAPatternFirst());
        } else if (this.nil(this.editingCol.getFactField())) {
            this.operatorLabel.setText(Constants.INSTANCE.pleaseChooseAFieldFirst());
        } else if (this.nil(this.editingCol.getOperator())) {
            this.operatorLabel.setText(Constants.INSTANCE.pleaseSelectAField());
        } else {
            this.operatorLabel.setText(HumanReadable.getOperatorDisplayName((String)this.editingCol.getOperator()));
        }
    }

    private void doPatternLabel() {
        if (this.editingPattern.getFactType() != null) {
            StringBuilder patternLabel = new StringBuilder();
            String factType = this.editingPattern.getFactType();
            String boundName = this.editingPattern.getBoundName();
            if (factType != null && factType.length() > 0) {
                if (this.editingPattern.isNegated()) {
                    patternLabel.append(Constants.INSTANCE.negatedPattern()).append(" ").append(factType);
                } else {
                    patternLabel.append(factType).append(" [").append(boundName).append("]");
                }
            }
            this.patternLabel.setText(patternLabel.toString());
        }
        this.doFieldLabel();
        this.doOperatorLabel();
    }

    private TextBox getFieldLabel() {
        TextBox box = new TextBox();
        box.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        return box;
    }

    private InfoPopup getPredicateHint() {
        return new InfoPopup(Constants.INSTANCE.Predicates(), Constants.INSTANCE.PredicatesInfo());
    }

    private void doValueList() {
        boolean enableValueList;
        if (this.model.getTableFormat() == GuidedDecisionTable52.TableFormat.LIMITED_ENTRY) {
            return;
        }
        String factType = this.editingPattern.getFactType();
        String factField = this.editingCol.getFactField();
        boolean bl = enableValueList = factType != null && !"".equals(factType) && factField != null && !"".equals(factField);
        if (enableValueList) {
            enableValueList = this.validator.doesOperatorAcceptValueList(this.editingCol);
        }
        if (enableValueList) {
            enableValueList = !this.sce.hasEnums(factType, factField);
        }
        this.valueListWidget.setEnabled(enableValueList);
        if (!enableValueList) {
            this.valueListWidget.setText("");
        }
    }

    private void doCalculationType() {
        String factField;
        if (this.model.getTableFormat() == GuidedDecisionTable52.TableFormat.LIMITED_ENTRY) {
            return;
        }
        String factType = this.editingPattern.getFactType();
        boolean hasEnums = this.sce.hasEnums(factType, factField = this.editingCol.getFactField());
        this.literal.setEnabled(hasEnums || !this.isReadOnly);
        this.formula.setEnabled(!hasEnums && !this.isReadOnly);
        this.predicate.setEnabled(!hasEnums && !this.isReadOnly);
        if (hasEnums) {
            this.editingCol.setConstraintValueType(1);
        }
    }

    private ListBox loadPatterns() {
        HashSet<String> vars = new HashSet<String>();
        ListBox patterns = new ListBox();
        for (Pattern52 p : this.model.getPatterns()) {
            if (vars.contains(p.getBoundName())) continue;
            patterns.addItem((p.isNegated() ? Constants.INSTANCE.negatedPattern() + " " : "") + p.getFactType() + " [" + p.getBoundName() + "]", p.getFactType() + " " + p.getBoundName() + " " + p.isNegated());
            vars.add(p.getBoundName());
        }
        return patterns;
    }

    private boolean nil(String s) {
        return s == null || s.equals("");
    }

    private void showOperatorChange() {
        FormStylePopup pop = new FormStylePopup();
        pop.setTitle(Constants.INSTANCE.SetTheOperator());
        pop.setModal(false);
        String factType = this.editingPattern.getFactType();
        String factField = this.editingCol.getFactField();
        String[] ops = this.sce.getOperatorCompletions(factType, factField);
        ArrayList<String> filteredOps = new ArrayList<String>();
        for (String op : ops) {
            filteredOps.add(op);
        }
        if (1 != this.editingCol.getConstraintValueType()) {
            filteredOps.remove("in");
            filteredOps.remove("not in");
        }
        if (this.sce.hasEnums(factType, factField)) {
            filteredOps.remove("in");
            filteredOps.remove("not in");
        }
        String[] displayOps = new String[filteredOps.size()];
        filteredOps.toArray(displayOps);
        CEPOperatorsDropdown box = new CEPOperatorsDropdown(displayOps, (HasParameterizedOperator)this.editingCol);
        box.addItem(Constants.INSTANCE.noOperator(), "");
        pop.addAttribute(Constants.INSTANCE.Operator(), (IsWidget)box);
        Button b = new Button(Constants.INSTANCE.OK());
        pop.addAttribute("", (IsWidget)b);
        b.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        pop.show();
    }

    private boolean unique(String header) {
        for (CompositeColumn cc : this.model.getConditions()) {
            for (int iChild = 0; iChild < cc.getChildColumns().size(); ++iChild) {
                if (!((BaseColumn)cc.getChildColumns().get(iChild)).getHeader().equals(header)) continue;
                return false;
            }
        }
        return true;
    }

    protected void showChangePattern(ClickEvent w) {
        ListBox pats = this.loadPatterns();
        if (pats.getItemCount() == 0) {
            this.showNewPatternDialog();
            return;
        }
        FormStylePopup pop = new FormStylePopup();
        Button ok = new Button(Constants.INSTANCE.OK());
        HorizontalPanel hp = new HorizontalPanel();
        hp.add((Widget)pats);
        hp.add((Widget)ok);
        pop.addAttribute(Constants.INSTANCE.ChooseExistingPatternToAddColumnTo(), (IsWidget)hp);
        pop.addAttribute("", (IsWidget)new HTML(Constants.INSTANCE.ORwithEmphasis()));
        Button createPattern = new Button(Constants.INSTANCE.CreateNewFactPattern());
        createPattern.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        pop.addAttribute("", (IsWidget)createPattern);
        ok.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        pop.show();
    }

    protected void showFieldChange() {
        FormStylePopup pop = new FormStylePopup();
        pop.setModal(false);
        String[] fields = this.sce.getFieldCompletions(FieldAccessorsAndMutators.ACCESSOR, this.editingPattern.getFactType());
        ListBox box = new ListBox();
        switch (this.editingCol.getConstraintValueType()) {
            case 1: {
                int i;
                for (i = 0; i < fields.length; ++i) {
                    box.addItem(fields[i]);
                }
                break;
            }
            case 3: {
                int i;
                for (i = 0; i < fields.length; ++i) {
                    if (this.sce.hasEnums(this.editingPattern.getFactType(), fields[i])) continue;
                    box.addItem(fields[i]);
                }
                break;
            }
        }
        pop.addAttribute(Constants.INSTANCE.Field(), (IsWidget)box);
        Button b = new Button(Constants.INSTANCE.OK());
        pop.addAttribute("", (IsWidget)b);
        b.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        pop.show();
    }

    protected void showNewPatternDialog() {
        FormStylePopup pop = new FormStylePopup();
        pop.setTitle(Constants.INSTANCE.CreateANewFactPattern());
        ListBox types = new ListBox();
        for (int i = 0; i < this.sce.getFactTypes().length; ++i) {
            types.addItem(this.sce.getFactTypes()[i]);
        }
        pop.addAttribute(Constants.INSTANCE.FactType(), (IsWidget)types);
        BindingTextBox binding = new BindingTextBox();
        binding.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        pop.addAttribute(Constants.INSTANCE.Binding(), (IsWidget)binding);
        CheckBox chkNegated = new CheckBox();
        chkNegated.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        pop.addAttribute(Constants.INSTANCE.negatePattern(), (IsWidget)chkNegated);
        Button ok = new Button(Constants.INSTANCE.OK());
        ok.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        pop.addAttribute("", (IsWidget)ok);
        pop.show();
    }

    private Widget createCEPWindowWidget(HasCEPWindow c) {
        HorizontalPanel hp = new HorizontalPanel();
        Label lbl = new Label(Constants.INSTANCE.OverCEPWindow());
        lbl.setStyleName("paddedLabel");
        hp.add((Widget)lbl);
        this.cwo = new CEPWindowOperatorsDropdown(c, this.isReadOnly);
        if (!this.isReadOnly) {
            this.cwo.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        }
        hp.add((Widget)this.cwo);
        return hp;
    }

    private void displayCEPOperators() {
        boolean isVisible = this.sce.isFactTypeAnEvent(this.editingPattern.getFactType());
        this.setAttributeVisibility(this.cepWindowRowIndex, isVisible);
    }

    static /* synthetic */ ConditionCol52 access$000(ConditionPopup x0) {
        return x0.editingCol;
    }

    static /* synthetic */ void access$100(ConditionPopup x0, int x1) {
        x0.applyConsTypeChange(x1);
    }

    static /* synthetic */ void access$200(ConditionPopup x0) {
        x0.showOperatorChange();
    }

    static /* synthetic */ TextBox access$300(ConditionPopup x0) {
        return x0.entryPointName;
    }

    static /* synthetic */ Pattern52 access$400(ConditionPopup x0) {
        return x0.editingPattern;
    }

    static /* synthetic */ TextBox access$500(ConditionPopup x0) {
        return x0.valueListWidget;
    }

    static /* synthetic */ void access$600(ConditionPopup x0) {
        x0.makeDefaultValueWidget();
    }

    static /* synthetic */ DTCellValueUtilities access$700(ConditionPopup x0) {
        return x0.utilities;
    }

    static /* synthetic */ TextBox access$800(ConditionPopup x0) {
        return x0.binding;
    }

    static /* synthetic */ boolean access$900(ConditionPopup x0, String x1) {
        return x0.isBindingUnique(x1);
    }

    static /* synthetic */ boolean access$1000(ConditionPopup x0, String x1) {
        return x0.unique(x1);
    }

    static /* synthetic */ void access$1100(ConditionPopup x0) {
        x0.makeLimitedValueWidget();
    }

    static /* synthetic */ void access$1200(ConditionPopup x0) {
        x0.doOperatorLabel();
    }

    static /* synthetic */ void access$1300(ConditionPopup x0) {
        x0.doValueList();
    }

    static /* synthetic */ Pattern52 access$402(ConditionPopup x0, Pattern52 x1) {
        x0.editingPattern = x1;
        return x0.editingPattern;
    }

    static /* synthetic */ GuidedDecisionTable52 access$1400(ConditionPopup x0) {
        return x0.model;
    }

    static /* synthetic */ CEPWindowOperatorsDropdown access$1500(ConditionPopup x0) {
        return x0.cwo;
    }

    static /* synthetic */ void access$1600(ConditionPopup x0) {
        x0.displayCEPOperators();
    }

    static /* synthetic */ void access$1700(ConditionPopup x0) {
        x0.doPatternLabel();
    }

    static /* synthetic */ void access$1800(ConditionPopup x0) {
        x0.doCalculationType();
    }

    static /* synthetic */ SuggestionCompletionEngine access$1900(ConditionPopup x0) {
        return x0.sce;
    }

    static /* synthetic */ void access$2000(ConditionPopup x0) {
        x0.doFieldLabel();
    }
}

