/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.decisiontable.analysis;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.drools.guvnor.client.decisiontable.analysis.RowDetector;
import org.drools.guvnor.client.decisiontable.analysis.action.ActionDetector;
import org.drools.guvnor.client.decisiontable.analysis.action.ActionDetectorKey;
import org.drools.guvnor.client.decisiontable.analysis.action.InsertFactActionDetectorKey;
import org.drools.guvnor.client.decisiontable.analysis.action.SetFieldColActionDetectorKey;
import org.drools.guvnor.client.decisiontable.analysis.action.UnrecognizedActionDetectorKey;
import org.drools.guvnor.client.decisiontable.analysis.condition.BooleanConditionDetector;
import org.drools.guvnor.client.decisiontable.analysis.condition.ConditionDetector;
import org.drools.guvnor.client.decisiontable.analysis.condition.DateConditionDetector;
import org.drools.guvnor.client.decisiontable.analysis.condition.EnumConditionDetector;
import org.drools.guvnor.client.decisiontable.analysis.condition.NumericBigDecimalConditionDetector;
import org.drools.guvnor.client.decisiontable.analysis.condition.NumericBigIntegerConditionDetector;
import org.drools.guvnor.client.decisiontable.analysis.condition.NumericByteConditionDetector;
import org.drools.guvnor.client.decisiontable.analysis.condition.NumericConditionDetector;
import org.drools.guvnor.client.decisiontable.analysis.condition.NumericDoubleConditionDetector;
import org.drools.guvnor.client.decisiontable.analysis.condition.NumericFloatConditionDetector;
import org.drools.guvnor.client.decisiontable.analysis.condition.NumericIntegerConditionDetector;
import org.drools.guvnor.client.decisiontable.analysis.condition.NumericLongConditionDetector;
import org.drools.guvnor.client.decisiontable.analysis.condition.NumericShortConditionDetector;
import org.drools.guvnor.client.decisiontable.analysis.condition.StringConditionDetector;
import org.drools.guvnor.client.decisiontable.analysis.condition.UnrecognizedConditionDetector;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.dt52.ActionCol52;
import org.drools.ide.common.client.modeldriven.dt52.ActionInsertFactCol52;
import org.drools.ide.common.client.modeldriven.dt52.ActionSetFieldCol52;
import org.drools.ide.common.client.modeldriven.dt52.Analysis;
import org.drools.ide.common.client.modeldriven.dt52.BRLActionColumn;
import org.drools.ide.common.client.modeldriven.dt52.BaseColumn;
import org.drools.ide.common.client.modeldriven.dt52.ConditionCol52;
import org.drools.ide.common.client.modeldriven.dt52.DTCellValue52;
import org.drools.ide.common.client.modeldriven.dt52.GuidedDecisionTable52;
import org.drools.ide.common.client.modeldriven.dt52.LimitedEntryCol;
import org.drools.ide.common.client.modeldriven.dt52.Pattern52;

public class DecisionTableAnalyzer {
    private SuggestionCompletionEngine sce;

    public DecisionTableAnalyzer(SuggestionCompletionEngine sce) {
        this.sce = sce;
    }

    public List<Analysis> analyze(GuidedDecisionTable52 model) {
        List data = model.getData();
        ArrayList<Analysis> analysisData = new ArrayList<Analysis>(data.size());
        ArrayList<RowDetector> rowDetectorList = new ArrayList<RowDetector>(data.size());
        for (List row : data) {
            Integer rowNumber = (Integer)((DTCellValue52)row.get(0)).getNumericValue() - 1;
            RowDetector rowDetector = new RowDetector((long)rowNumber.intValue());
            for (Pattern52 pattern : model.getPatterns()) {
                for (ConditionCol52 conditionCol : pattern.getChildColumns()) {
                    boolean cellIsNotBlank;
                    DTCellValue52 realCellValue;
                    int columnIndex = model.getExpandedColumns().indexOf(conditionCol);
                    DTCellValue52 visibleCellValue = (DTCellValue52)row.get(columnIndex);
                    if (conditionCol instanceof LimitedEntryCol) {
                        realCellValue = ((LimitedEntryCol)conditionCol).getValue();
                        cellIsNotBlank = visibleCellValue.getBooleanValue();
                    } else {
                        realCellValue = visibleCellValue;
                        cellIsNotBlank = visibleCellValue.hasValue();
                    }
                    if (!cellIsNotBlank) continue;
                    ConditionDetector conditionDetector = this.buildConditionDetector(model, pattern, conditionCol, realCellValue);
                    rowDetector.putOrMergeConditionDetector(conditionDetector);
                }
            }
            for (ActionCol52 actionCol : model.getActionCols()) {
                boolean cellIsNotBlank;
                DTCellValue52 realCellValue;
                if (actionCol instanceof BRLActionColumn) continue;
                int columnIndex = model.getExpandedColumns().indexOf(actionCol);
                DTCellValue52 visibleCellValue = (DTCellValue52)row.get(columnIndex);
                if (actionCol instanceof LimitedEntryCol) {
                    realCellValue = ((LimitedEntryCol)actionCol).getValue();
                    cellIsNotBlank = visibleCellValue.getBooleanValue();
                } else {
                    realCellValue = visibleCellValue;
                    cellIsNotBlank = visibleCellValue.hasValue();
                }
                if (!cellIsNotBlank) continue;
                ActionDetector actionDetector = this.buildActionDetector(model, actionCol, realCellValue);
                rowDetector.putOrMergeActionDetector(actionDetector);
            }
            rowDetectorList.add(rowDetector);
        }
        for (RowDetector rowDetector : rowDetectorList) {
            analysisData.add(rowDetector.buildAnalysis(rowDetectorList));
        }
        return analysisData;
    }

    private ConditionDetector buildConditionDetector(GuidedDecisionTable52 model, Pattern52 pattern, ConditionCol52 conditionCol, DTCellValue52 realCellValue) {
        String factField = conditionCol.getFactField();
        String operator = conditionCol.getOperator();
        String type = model.getType((BaseColumn)conditionCol, this.sce);
        String[] allValueList = model.getValueList((BaseColumn)conditionCol);
        Object newDetector = allValueList.length != 0 ? new EnumConditionDetector(pattern, factField, Arrays.asList(allValueList), realCellValue.getStringValue(), operator) : (type == null ? new UnrecognizedConditionDetector(pattern, factField, operator) : (type.equals("String") ? new StringConditionDetector(pattern, factField, realCellValue.getStringValue(), operator) : (type.equals("Numeric") ? new NumericConditionDetector(pattern, factField, (BigDecimal)realCellValue.getNumericValue(), operator) : (type.equals("BigDecimal") ? new NumericBigDecimalConditionDetector(pattern, factField, (BigDecimal)realCellValue.getNumericValue(), operator) : (type.equals("BigInteger") ? new NumericBigIntegerConditionDetector(pattern, factField, (BigInteger)realCellValue.getNumericValue(), operator) : (type.equals("Byte") ? new NumericByteConditionDetector(pattern, factField, (Byte)realCellValue.getNumericValue(), operator) : (type.equals("Double") ? new NumericDoubleConditionDetector(pattern, factField, (Double)realCellValue.getNumericValue(), operator) : (type.equals("Float") ? new NumericFloatConditionDetector(pattern, factField, (Float)realCellValue.getNumericValue(), operator) : (type.equals("Integer") ? new NumericIntegerConditionDetector(pattern, factField, (Integer)realCellValue.getNumericValue(), operator) : (type.equals("Long") ? new NumericLongConditionDetector(pattern, factField, (Long)realCellValue.getNumericValue(), operator) : (type.equals("Short") ? new NumericShortConditionDetector(pattern, factField, (Short)realCellValue.getNumericValue(), operator) : (type.equals("Boolean") ? new BooleanConditionDetector(pattern, factField, realCellValue.getBooleanValue(), operator) : (type.equals("Date") ? new DateConditionDetector(pattern, factField, realCellValue.getDateValue(), operator) : new UnrecognizedConditionDetector(pattern, factField, operator))))))))))))));
        return newDetector;
    }

    private ActionDetector buildActionDetector(GuidedDecisionTable52 model, ActionCol52 actionCol, DTCellValue52 realCellValue) {
        Object key = actionCol instanceof ActionSetFieldCol52 ? new SetFieldColActionDetectorKey((ActionSetFieldCol52)actionCol) : (actionCol instanceof ActionInsertFactCol52 ? new InsertFactActionDetectorKey((ActionInsertFactCol52)actionCol) : new UnrecognizedActionDetectorKey(actionCol));
        return new ActionDetector((ActionDetectorKey)key, realCellValue);
    }
}

