/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.decisiontable.widget;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.ui.Composite;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.drools.guvnor.client.decisiontable.analysis.DecisionTableAnalyzer;
import org.drools.guvnor.client.decisiontable.widget.AbstractDecisionTableWidget;
import org.drools.guvnor.client.decisiontable.widget.AbstractDecoratedDecisionTableGridWidget;
import org.drools.guvnor.client.decisiontable.widget.BoundFactsChangedEvent;
import org.drools.guvnor.client.decisiontable.widget.DTCellValueUtilities;
import org.drools.guvnor.client.decisiontable.widget.DecisionTableCellFactory;
import org.drools.guvnor.client.decisiontable.widget.DecisionTableCellValueFactory;
import org.drools.guvnor.client.decisiontable.widget.DecisionTableControlsWidget;
import org.drools.guvnor.client.decisiontable.widget.DecisionTableDropDownManager;
import org.drools.guvnor.client.decisiontable.widget.DecisionTableResourcesProvider;
import org.drools.guvnor.client.decisiontable.widget.events.InsertDecisionTableColumnEvent;
import org.drools.guvnor.client.util.DateConverter;
import org.drools.guvnor.client.util.GWTDateConverter;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.CellValue;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.DecoratedGridCellValueAdaptor;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.data.Coordinate;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.events.AppendRowEvent;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.events.CellStateChangedEvent;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.events.CopyRowsEvent;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.events.DeleteColumnEvent;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.events.DeleteRowEvent;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.events.InsertColumnEvent;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.events.InsertRowEvent;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.events.MoveColumnsEvent;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.events.PasteRowsEvent;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.events.SelectedCellChangeEvent;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.events.SetColumnVisibilityEvent;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.events.ToggleMergingEvent;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.events.UpdateColumnDataEvent;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.events.UpdateColumnDefinitionEvent;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.events.UpdateModelEvent;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.dt52.ActionCol52;
import org.drools.ide.common.client.modeldriven.dt52.ActionInsertFactCol52;
import org.drools.ide.common.client.modeldriven.dt52.ActionRetractFactCol52;
import org.drools.ide.common.client.modeldriven.dt52.ActionSetFieldCol52;
import org.drools.ide.common.client.modeldriven.dt52.ActionWorkItemCol52;
import org.drools.ide.common.client.modeldriven.dt52.ActionWorkItemSetFieldCol52;
import org.drools.ide.common.client.modeldriven.dt52.Analysis;
import org.drools.ide.common.client.modeldriven.dt52.AnalysisCol52;
import org.drools.ide.common.client.modeldriven.dt52.AttributeCol52;
import org.drools.ide.common.client.modeldriven.dt52.BRLActionColumn;
import org.drools.ide.common.client.modeldriven.dt52.BRLActionVariableColumn;
import org.drools.ide.common.client.modeldriven.dt52.BRLConditionColumn;
import org.drools.ide.common.client.modeldriven.dt52.BRLConditionVariableColumn;
import org.drools.ide.common.client.modeldriven.dt52.BRLRuleModel;
import org.drools.ide.common.client.modeldriven.dt52.BaseColumn;
import org.drools.ide.common.client.modeldriven.dt52.CompositeColumn;
import org.drools.ide.common.client.modeldriven.dt52.ConditionCol52;
import org.drools.ide.common.client.modeldriven.dt52.DTCellValue52;
import org.drools.ide.common.client.modeldriven.dt52.DTColumnConfig52;
import org.drools.ide.common.client.modeldriven.dt52.DescriptionCol52;
import org.drools.ide.common.client.modeldriven.dt52.GuidedDecisionTable52;
import org.drools.ide.common.client.modeldriven.dt52.LimitedEntryBRLActionColumn;
import org.drools.ide.common.client.modeldriven.dt52.LimitedEntryBRLConditionColumn;
import org.drools.ide.common.client.modeldriven.dt52.LimitedEntryCol;
import org.drools.ide.common.client.modeldriven.dt52.MetadataCol52;
import org.drools.ide.common.client.modeldriven.dt52.Pattern52;
import org.drools.ide.common.client.modeldriven.dt52.RowNumberCol52;

public abstract class AbstractDecisionTableWidget
extends Composite
implements SelectedCellChangeEvent.Handler,
InsertRowEvent.Handler,
DeleteRowEvent.Handler,
AppendRowEvent.Handler,
CopyRowsEvent.Handler,
PasteRowsEvent.Handler,
DeleteColumnEvent.Handler,
InsertColumnEvent.Handler<BaseColumn, DTCellValue52>,
MoveColumnsEvent.Handler,
UpdateModelEvent.Handler {
    protected final GuidedDecisionTable52 model;
    protected AbstractDecoratedDecisionTableGridWidget widget;
    protected final SuggestionCompletionEngine sce;
    protected final DecisionTableCellFactory cellFactory;
    protected final DecisionTableCellValueFactory cellValueFactory;
    protected final DecisionTableDropDownManager dropDownManager;
    protected final DecisionTableControlsWidget dtableCtrls;
    protected final EventBus eventBus;
    protected final boolean isReadOnly;
    private final BRLRuleModel rm;
    private List<List<DTCellValue52>> copiedRows = new ArrayList();
    protected static final DecisionTableResourcesProvider resources = new DecisionTableResourcesProvider();

    public AbstractDecisionTableWidget(GuidedDecisionTable52 model, SuggestionCompletionEngine sce, DecisionTableControlsWidget dtableCtrls, boolean isReadOnly, EventBus eventBus) {
        if (model == null) {
            throw new IllegalArgumentException("model cannot be null");
        }
        if (sce == null) {
            throw new IllegalArgumentException("sce cannot be null");
        }
        if (dtableCtrls == null) {
            throw new IllegalArgumentException("dtableControls cannot be null");
        }
        if (eventBus == null) {
            throw new IllegalArgumentException("eventBus cannot be null");
        }
        this.model = model;
        this.sce = sce;
        this.dtableCtrls = dtableCtrls;
        this.dtableCtrls.setDecisionTableWidget(this);
        this.rm = new BRLRuleModel(model);
        this.eventBus = eventBus;
        this.isReadOnly = isReadOnly;
        for (CompositeColumn cc : model.getConditions()) {
            if (!(cc instanceof Pattern52)) continue;
            Pattern52 p = (Pattern52)cc;
            Iterator i$ = p.getChildColumns().iterator();
            while (i$.hasNext()) {
                ConditionCol52 col;
                ConditionCol52 c = col = (ConditionCol52)i$.next();
                c.setFieldType(sce.getFieldType(p.getFactType(), c.getFactField()));
            }
        }
        this.dropDownManager = new DecisionTableDropDownManager(model, sce);
        this.cellFactory = new DecisionTableCellFactory(model, sce, this.dropDownManager, isReadOnly, eventBus);
        this.cellValueFactory = new DecisionTableCellValueFactory(model, sce);
        DTCellValueUtilities.injectDateConvertor((DateConverter)GWTDateConverter.getInstance());
        eventBus.addHandler(InsertRowEvent.TYPE, (EventHandler)this);
        eventBus.addHandler(DeleteRowEvent.TYPE, (EventHandler)this);
        eventBus.addHandler(AppendRowEvent.TYPE, (EventHandler)this);
        eventBus.addHandler(CopyRowsEvent.TYPE, (EventHandler)this);
        eventBus.addHandler(PasteRowsEvent.TYPE, (EventHandler)this);
        eventBus.addHandler(SelectedCellChangeEvent.TYPE, (EventHandler)this);
        eventBus.addHandler(DeleteColumnEvent.TYPE, (EventHandler)this);
        eventBus.addHandler(InsertDecisionTableColumnEvent.TYPE, (EventHandler)this);
        eventBus.addHandler(MoveColumnsEvent.TYPE, (EventHandler)this);
        eventBus.addHandler(UpdateModelEvent.TYPE, (EventHandler)this);
    }

    public void addColumn(ActionCol52 modelColumn) {
        if (modelColumn == null) {
            throw new IllegalArgumentException("modelColumn cannot be null.");
        }
        this.model.getActionCols().add(modelColumn);
        this.addColumn(modelColumn, this.cellValueFactory.makeColumnData((BaseColumn)modelColumn), true);
    }

    public void addColumn(BRLActionColumn modelColumn) {
        if (modelColumn == null) {
            throw new IllegalArgumentException("modelColumn cannot be null.");
        }
        this.model.getActionCols().add(modelColumn);
        this.addBRLActionVariableColumns(modelColumn.getChildColumns(), true);
    }

    public void addColumn(LimitedEntryBRLActionColumn modelColumn) {
        if (modelColumn == null) {
            throw new IllegalArgumentException("modelColumn cannot be null.");
        }
        this.model.getActionCols().add(modelColumn);
        this.addColumn((ActionCol52)modelColumn, this.cellValueFactory.makeColumnData((BaseColumn)modelColumn), true);
    }

    public void addColumn(BRLConditionColumn modelColumn) {
        if (modelColumn == null) {
            throw new IllegalArgumentException("modelColumn cannot be null.");
        }
        this.model.getConditions().add(modelColumn);
        this.addBRLConditionVariableColumns(modelColumn.getChildColumns(), true);
    }

    public void addColumn(LimitedEntryBRLConditionColumn modelColumn) {
        if (modelColumn == null) {
            throw new IllegalArgumentException("modelColumn cannot be null.");
        }
        this.model.getConditions().add(modelColumn);
        this.addColumn((ConditionCol52)modelColumn, this.cellValueFactory.makeColumnData((BaseColumn)modelColumn), true);
    }

    public void addColumn(AttributeCol52 modelColumn) {
        if (modelColumn == null) {
            throw new IllegalArgumentException("modelColumn cannot be null.");
        }
        this.model.getAttributeCols().add(modelColumn);
        this.addColumn(modelColumn, this.cellValueFactory.makeColumnData((BaseColumn)modelColumn), true);
    }

    public void addColumn(MetadataCol52 modelColumn) {
        if (modelColumn == null) {
            throw new IllegalArgumentException("modelColumn cannot be null.");
        }
        this.model.getMetadataCols().add(modelColumn);
        this.addColumn(modelColumn, this.cellValueFactory.makeColumnData((BaseColumn)modelColumn), true);
    }

    public void addColumn(Pattern52 pattern, ConditionCol52 modelColumn) {
        if (pattern == null) {
            throw new IllegalArgumentException("pattern cannot be null.");
        }
        if (modelColumn == null) {
            throw new IllegalArgumentException("modelColumn cannot be null.");
        }
        if (!this.model.getConditions().contains(pattern)) {
            this.model.getConditions().add(pattern);
            BoundFactsChangedEvent pce = new BoundFactsChangedEvent(this.rm.getLHSBoundFacts());
            this.eventBus.fireEvent((GwtEvent)pce);
        }
        pattern.getChildColumns().add(modelColumn);
        this.addColumn(modelColumn, this.cellValueFactory.makeColumnData((BaseColumn)modelColumn), true);
    }

    public void deleteColumn(ActionCol52 modelColumn) {
        if (modelColumn == null) {
            throw new IllegalArgumentException("modelColumn cannot be null.");
        }
        int index = this.model.getExpandedColumns().indexOf(modelColumn);
        this.model.getActionCols().remove(modelColumn);
        this.deleteColumn(index, true);
    }

    public void deleteColumn(BRLActionColumn modelColumn) {
        if (modelColumn == null) {
            throw new IllegalArgumentException("modelColumn cannot be null.");
        }
        BRLActionVariableColumn firstColumn = (BRLActionVariableColumn)modelColumn.getChildColumns().get(0);
        int firstColumnIndex = this.model.getExpandedColumns().indexOf(firstColumn);
        int numberOfColumns = modelColumn.getChildColumns().size();
        this.deleteColumns(firstColumnIndex, numberOfColumns, true);
        this.model.getActionCols().remove(modelColumn);
    }

    public void deleteColumn(LimitedEntryBRLActionColumn modelColumn) {
        if (modelColumn == null) {
            throw new IllegalArgumentException("modelColumn cannot be null.");
        }
        int index = this.model.getExpandedColumns().indexOf(modelColumn);
        this.model.getActionCols().remove(modelColumn);
        this.deleteColumn(index, true);
    }

    public void deleteColumn(BRLConditionColumn modelColumn) {
        if (modelColumn == null) {
            throw new IllegalArgumentException("modelColumn cannot be null.");
        }
        BRLConditionVariableColumn firstColumn = (BRLConditionVariableColumn)modelColumn.getChildColumns().get(0);
        int firstColumnIndex = this.model.getExpandedColumns().indexOf(firstColumn);
        int numberOfColumns = modelColumn.getChildColumns().size();
        this.deleteColumns(firstColumnIndex, numberOfColumns, true);
        this.model.getConditions().remove(modelColumn);
    }

    public void deleteColumn(LimitedEntryBRLConditionColumn modelColumn) {
        if (modelColumn == null) {
            throw new IllegalArgumentException("modelColumn cannot be null.");
        }
        int index = this.model.getExpandedColumns().indexOf(modelColumn);
        this.model.getConditions().remove(modelColumn);
        this.deleteColumn(index, true);
    }

    public void deleteColumn(AttributeCol52 modelColumn) {
        if (modelColumn == null) {
            throw new IllegalArgumentException("modelColumn cannot be null.");
        }
        int index = this.model.getExpandedColumns().indexOf(modelColumn);
        this.model.getAttributeCols().remove(modelColumn);
        this.deleteColumn(index, true);
    }

    public void deleteColumn(MetadataCol52 modelColumn) {
        if (modelColumn == null) {
            throw new IllegalArgumentException("modelColumn cannot be null.");
        }
        int index = this.model.getExpandedColumns().indexOf(modelColumn);
        this.model.getMetadataCols().remove(modelColumn);
        this.deleteColumn(index, true);
    }

    public void deleteColumn(ConditionCol52 modelColumn) {
        if (modelColumn == null) {
            throw new IllegalArgumentException("modelColumn cannot be null.");
        }
        int index = this.model.getExpandedColumns().indexOf(modelColumn);
        Pattern52 pattern = this.model.getPattern(modelColumn);
        pattern.getChildColumns().remove(modelColumn);
        if (pattern.getChildColumns().size() == 0) {
            this.model.getConditions().remove(pattern);
            BoundFactsChangedEvent pce = new BoundFactsChangedEvent(this.rm.getLHSBoundFacts());
            this.eventBus.fireEvent((GwtEvent)pce);
        }
        this.deleteColumn(index, true);
    }

    private void deleteColumn(int index, boolean redraw) {
        DeleteColumnEvent dce = new DeleteColumnEvent(index, redraw);
        this.eventBus.fireEvent((GwtEvent)dce);
    }

    private void deleteColumns(int firstColumnIndex, int numberOfColumns, boolean redraw) {
        DeleteColumnEvent dce = new DeleteColumnEvent(firstColumnIndex, numberOfColumns, redraw);
        this.eventBus.fireEvent((GwtEvent)dce);
    }

    public void appendRow() {
        AppendRowEvent are = new AppendRowEvent();
        this.eventBus.fireEvent((GwtEvent)are);
    }

    public SuggestionCompletionEngine getSCE() {
        return this.sce;
    }

    public void makeOtherwiseCell() {
        HashSet<CellStateChangedEvent.CellStateOperation> operations = new HashSet<CellStateChangedEvent.CellStateOperation>();
        operations.add(new CellStateChangedEvent.CellStateOperation(CellValue.CellState.OTHERWISE, CellStateChangedEvent.Operation.ADD));
        CellStateChangedEvent csce = new CellStateChangedEvent(operations);
        this.eventBus.fireEvent((GwtEvent)csce);
    }

    public void setColumnVisibility(DTColumnConfig52 modelColumn, boolean isVisible) {
        if (modelColumn == null) {
            throw new IllegalArgumentException("modelColumn cannot be null");
        }
        int index = this.model.getExpandedColumns().indexOf(modelColumn);
        SetColumnVisibilityEvent scve = new SetColumnVisibilityEvent(index, isVisible);
        this.eventBus.fireEvent((GwtEvent)scve);
    }

    public void setPixelSize(int width, int height) {
        if (width < 0) {
            throw new IllegalArgumentException("width cannot be less than zero");
        }
        if (height < 0) {
            throw new IllegalArgumentException("height cannot be less than zero");
        }
        super.setPixelSize(width, height);
        this.widget.setPixelSize(width, height);
    }

    public void updateColumn(ActionInsertFactCol52 origColumn, ActionInsertFactCol52 editColumn) {
        if (origColumn == null) {
            throw new IllegalArgumentException("origColumn cannot be null");
        }
        if (editColumn == null) {
            throw new IllegalArgumentException("editColumn cannot be null");
        }
        boolean bUpdateColumnData = false;
        boolean bUpdateColumnDefinition = false;
        int iCol = this.model.getExpandedColumns().indexOf(origColumn);
        if (origColumn.isHideColumn() != editColumn.isHideColumn()) {
            this.setColumnVisibility((DTColumnConfig52)origColumn, !editColumn.isHideColumn());
        }
        if (!this.isEqualOrNull((Object)origColumn.getBoundName(), (Object)editColumn.getBoundName())) {
            if (!this.isEqualOrNull((Object)origColumn.getFactType(), (Object)editColumn.getFactType()) || !this.isEqualOrNull((Object)origColumn.getFactField(), (Object)editColumn.getFactField())) {
                bUpdateColumnData = true;
                bUpdateColumnDefinition = true;
            }
        } else if (!this.isEqualOrNull((Object)origColumn.getFactType(), (Object)editColumn.getFactType()) || !this.isEqualOrNull((Object)origColumn.getFactField(), (Object)editColumn.getFactField())) {
            bUpdateColumnData = true;
            bUpdateColumnDefinition = true;
        }
        if (!this.isEqualOrNull((Object)origColumn.getValueList(), (Object)editColumn.getValueList())) {
            bUpdateColumnDefinition = true;
            bUpdateColumnData = this.updateCellsForOptionValueList((DTColumnConfig52)editColumn, (DTColumnConfig52)origColumn);
        }
        if (!origColumn.getHeader().equals(editColumn.getHeader())) {
            bUpdateColumnDefinition = true;
        }
        if (origColumn instanceof LimitedEntryCol && editColumn instanceof LimitedEntryCol) {
            LimitedEntryCol lecOrig = (LimitedEntryCol)origColumn;
            LimitedEntryCol lecEditing = (LimitedEntryCol)editColumn;
            if (!lecOrig.getValue().equals((Object)lecEditing.getValue())) {
                bUpdateColumnDefinition = true;
            }
        }
        this.populateModelColumn(origColumn, editColumn);
        if (bUpdateColumnData) {
            ToggleMergingEvent tme = new ToggleMergingEvent(false);
            this.eventBus.fireEvent((GwtEvent)tme);
        }
        if (bUpdateColumnDefinition) {
            DecoratedGridCellValueAdaptor cell = this.cellFactory.getCell((BaseColumn)origColumn);
            UpdateColumnDefinitionEvent updateColumnDefinition = new UpdateColumnDefinitionEvent(cell, iCol);
            this.eventBus.fireEvent((GwtEvent)updateColumnDefinition);
        }
        if (bUpdateColumnData) {
            UpdateColumnDataEvent updateColumnData = new UpdateColumnDataEvent(iCol, this.getColumnData((BaseColumn)origColumn));
            this.eventBus.fireEvent((GwtEvent)updateColumnData);
        }
    }

    public void updateColumn(ActionSetFieldCol52 origColumn, ActionSetFieldCol52 editColumn) {
        if (origColumn == null) {
            throw new IllegalArgumentException("origColumn cannot be null");
        }
        if (editColumn == null) {
            throw new IllegalArgumentException("editColumn cannot be null");
        }
        boolean bUpdateColumnData = false;
        boolean bUpdateColumnDefinition = false;
        int iCol = this.model.getExpandedColumns().indexOf(origColumn);
        if (origColumn.isHideColumn() != editColumn.isHideColumn()) {
            this.setColumnVisibility((DTColumnConfig52)origColumn, !editColumn.isHideColumn());
        }
        if (!this.isEqualOrNull((Object)origColumn.getBoundName(), (Object)editColumn.getBoundName())) {
            if (!this.isEqualOrNull((Object)origColumn.getFactField(), (Object)editColumn.getFactField())) {
                bUpdateColumnData = true;
                bUpdateColumnDefinition = true;
            }
        } else if (!this.isEqualOrNull((Object)origColumn.getFactField(), (Object)editColumn.getFactField())) {
            bUpdateColumnData = true;
            bUpdateColumnDefinition = true;
        }
        if (!this.isEqualOrNull((Object)origColumn.getValueList(), (Object)editColumn.getValueList())) {
            bUpdateColumnDefinition = true;
            bUpdateColumnData = this.updateCellsForOptionValueList((DTColumnConfig52)editColumn, (DTColumnConfig52)origColumn);
        }
        if (!origColumn.getHeader().equals(editColumn.getHeader())) {
            bUpdateColumnDefinition = true;
        }
        if (origColumn.getFactField() != null && !origColumn.getFactField().equals(editColumn.getFactField())) {
            bUpdateColumnDefinition = true;
        }
        if (origColumn instanceof LimitedEntryCol && editColumn instanceof LimitedEntryCol) {
            LimitedEntryCol lecOrig = (LimitedEntryCol)origColumn;
            LimitedEntryCol lecEditing = (LimitedEntryCol)editColumn;
            if (!lecOrig.getValue().equals((Object)lecEditing.getValue())) {
                bUpdateColumnDefinition = true;
            }
        }
        this.populateModelColumn(origColumn, editColumn);
        if (bUpdateColumnData) {
            ToggleMergingEvent tme = new ToggleMergingEvent(false);
            this.eventBus.fireEvent((GwtEvent)tme);
        }
        if (bUpdateColumnDefinition) {
            DecoratedGridCellValueAdaptor cell = this.cellFactory.getCell((BaseColumn)origColumn);
            UpdateColumnDefinitionEvent updateColumnDefinition = new UpdateColumnDefinitionEvent(cell, iCol);
            this.eventBus.fireEvent((GwtEvent)updateColumnDefinition);
        }
        if (bUpdateColumnData) {
            UpdateColumnDataEvent updateColumnData = new UpdateColumnDataEvent(iCol, this.getColumnData((BaseColumn)origColumn));
            this.eventBus.fireEvent((GwtEvent)updateColumnData);
        }
    }

    public void updateColumn(ActionWorkItemSetFieldCol52 origColumn, ActionWorkItemSetFieldCol52 editColumn) {
        if (origColumn == null) {
            throw new IllegalArgumentException("origColumn cannot be null");
        }
        if (editColumn == null) {
            throw new IllegalArgumentException("editColumn cannot be null");
        }
        boolean bUpdateColumnDefinition = false;
        int iCol = this.model.getExpandedColumns().indexOf(origColumn);
        if (origColumn.isHideColumn() != editColumn.isHideColumn()) {
            this.setColumnVisibility((DTColumnConfig52)origColumn, !editColumn.isHideColumn());
        }
        if (!this.isEqualOrNull((Object)origColumn.getBoundName(), (Object)editColumn.getBoundName())) {
            if (!this.isEqualOrNull((Object)origColumn.getFactField(), (Object)editColumn.getFactField())) {
                bUpdateColumnDefinition = true;
            }
        } else if (!this.isEqualOrNull((Object)origColumn.getFactField(), (Object)editColumn.getFactField())) {
            bUpdateColumnDefinition = true;
        }
        if (!origColumn.getHeader().equals(editColumn.getHeader())) {
            bUpdateColumnDefinition = true;
        }
        this.populateModelColumn(origColumn, editColumn);
        if (bUpdateColumnDefinition) {
            DecoratedGridCellValueAdaptor cell = this.cellFactory.getCell((BaseColumn)origColumn);
            UpdateColumnDefinitionEvent updateColumnDefinition = new UpdateColumnDefinitionEvent(cell, iCol);
            this.eventBus.fireEvent((GwtEvent)updateColumnDefinition);
        }
    }

    public void updateColumn(ActionRetractFactCol52 origColumn, ActionRetractFactCol52 editColumn) {
        if (origColumn == null) {
            throw new IllegalArgumentException("origColumn cannot be null");
        }
        if (editColumn == null) {
            throw new IllegalArgumentException("editColumn cannot be null");
        }
        boolean bUpdateColumnDefinition = false;
        int iCol = this.model.getExpandedColumns().indexOf(origColumn);
        if (origColumn.isHideColumn() != editColumn.isHideColumn()) {
            this.setColumnVisibility((DTColumnConfig52)origColumn, !editColumn.isHideColumn());
        }
        if (!origColumn.getHeader().equals(editColumn.getHeader())) {
            bUpdateColumnDefinition = true;
        }
        if (origColumn instanceof LimitedEntryCol && editColumn instanceof LimitedEntryCol) {
            LimitedEntryCol lecOrig = (LimitedEntryCol)origColumn;
            LimitedEntryCol lecEditing = (LimitedEntryCol)editColumn;
            if (!lecOrig.getValue().equals((Object)lecEditing.getValue())) {
                bUpdateColumnDefinition = true;
            }
        }
        this.populateModelColumn(origColumn, editColumn);
        if (bUpdateColumnDefinition) {
            DecoratedGridCellValueAdaptor cell = this.cellFactory.getCell((BaseColumn)origColumn);
            UpdateColumnDefinitionEvent updateColumnDefinition = new UpdateColumnDefinitionEvent(cell, iCol);
            this.eventBus.fireEvent((GwtEvent)updateColumnDefinition);
        }
    }

    public void updateColumn(ActionWorkItemCol52 origColumn, ActionWorkItemCol52 editColumn) {
        if (origColumn == null) {
            throw new IllegalArgumentException("origColumn cannot be null");
        }
        if (editColumn == null) {
            throw new IllegalArgumentException("editColumn cannot be null");
        }
        boolean bUpdateColumnDefinition = false;
        int iCol = this.model.getExpandedColumns().indexOf(origColumn);
        if (origColumn.isHideColumn() != editColumn.isHideColumn()) {
            this.setColumnVisibility((DTColumnConfig52)origColumn, !editColumn.isHideColumn());
        }
        if (!origColumn.getHeader().equals(editColumn.getHeader())) {
            bUpdateColumnDefinition = true;
        }
        this.populateModelColumn(origColumn, editColumn);
        if (bUpdateColumnDefinition) {
            DecoratedGridCellValueAdaptor cell = this.cellFactory.getCell((BaseColumn)origColumn);
            UpdateColumnDefinitionEvent updateColumnDefinition = new UpdateColumnDefinitionEvent(cell, iCol);
            this.eventBus.fireEvent((GwtEvent)updateColumnDefinition);
        }
    }

    public void updateColumn(BRLActionColumn origColumn, BRLActionColumn editColumn) {
        List columnData;
        if (origColumn == null) {
            throw new IllegalArgumentException("origColumn cannot be null");
        }
        if (editColumn == null) {
            throw new IllegalArgumentException("editColumn cannot be null");
        }
        HashMap origColumnVariables = new HashMap();
        for (BRLActionVariableColumn variable : origColumn.getChildColumns()) {
            int iCol = this.model.getExpandedColumns().indexOf(variable);
            columnData = new ArrayList();
            String key = this.getUpdateBRLActionColumnKey(variable);
            for (List row : this.model.getData()) {
                columnData.add(row.get(iCol));
            }
            origColumnVariables.put(key, columnData);
        }
        for (BRLActionVariableColumn variable : editColumn.getChildColumns()) {
            String key = this.getUpdateBRLActionColumnKey(variable);
            columnData = (List)origColumnVariables.get(key);
            if (columnData == null) {
                columnData = this.cellValueFactory.makeColumnData((BaseColumn)variable);
            }
            origColumn.getChildColumns().add(variable);
            this.addColumn((ActionCol52)variable, columnData, true);
        }
        for (int iCol = 0; iCol < origColumn.getChildColumns().size(); ++iCol) {
            BRLActionVariableColumn columnToDelete = (BRLActionVariableColumn)origColumn.getChildColumns().get(iCol);
            if (editColumn.getChildColumns().contains(columnToDelete)) continue;
            int index = this.model.getExpandedColumns().indexOf(origColumn.getChildColumns().get(0));
            DeleteColumnEvent dce = new DeleteColumnEvent(index, true);
            this.eventBus.fireEvent((GwtEvent)dce);
        }
        this.populateModelColumn(origColumn, editColumn);
    }

    private String getUpdateBRLActionColumnKey(BRLActionVariableColumn variable) {
        StringBuilder key = new StringBuilder(variable.getVarName()).append(":").append(variable.getFieldType()).append(":").append(variable.getFactField()).append(":").append(variable.getFactType());
        return key.toString();
    }

    public void updateColumn(BRLConditionColumn origColumn, BRLConditionColumn editColumn) {
        List columnData;
        if (origColumn == null) {
            throw new IllegalArgumentException("origColumn cannot be null");
        }
        if (editColumn == null) {
            throw new IllegalArgumentException("editColumn cannot be null");
        }
        HashMap origColumnVariables = new HashMap();
        for (BRLConditionVariableColumn variable : origColumn.getChildColumns()) {
            int iCol = this.model.getExpandedColumns().indexOf(variable);
            columnData = new ArrayList();
            String key = this.getUpdateBRLConditionColumnKey(variable);
            for (List row : this.model.getData()) {
                columnData.add(row.get(iCol));
            }
            origColumnVariables.put(key, columnData);
        }
        for (BRLConditionVariableColumn variable : editColumn.getChildColumns()) {
            String key = this.getUpdateBRLConditionColumnKey(variable);
            columnData = (List)origColumnVariables.get(key);
            if (columnData == null) {
                columnData = this.cellValueFactory.makeColumnData((BaseColumn)variable);
            }
            origColumn.getChildColumns().add(variable);
            this.addColumn((ConditionCol52)variable, columnData, true);
        }
        for (int iCol = 0; iCol < origColumn.getChildColumns().size(); ++iCol) {
            BRLConditionVariableColumn columnToDelete = (BRLConditionVariableColumn)origColumn.getChildColumns().get(iCol);
            if (editColumn.getChildColumns().contains(columnToDelete)) continue;
            int index = this.model.getExpandedColumns().indexOf(origColumn.getChildColumns().get(0));
            DeleteColumnEvent dce = new DeleteColumnEvent(index, true);
            this.eventBus.fireEvent((GwtEvent)dce);
        }
        this.populateModelColumn(origColumn, editColumn);
        BoundFactsChangedEvent pce = new BoundFactsChangedEvent(this.rm.getLHSBoundFacts());
        this.eventBus.fireEvent((GwtEvent)pce);
    }

    private String getUpdateBRLConditionColumnKey(BRLConditionVariableColumn variable) {
        StringBuilder key = new StringBuilder(variable.getVarName()).append(":").append(variable.getFieldType()).append(":").append(variable.getFactField()).append(":").append(variable.getFactType());
        return key.toString();
    }

    public void updateColumn(LimitedEntryBRLConditionColumn origColumn, LimitedEntryBRLConditionColumn editColumn) {
        if (origColumn == null) {
            throw new IllegalArgumentException("origColumn cannot be null");
        }
        if (editColumn == null) {
            throw new IllegalArgumentException("editColumn cannot be null");
        }
        boolean bUpdateColumnDefinition = false;
        int iCol = this.model.getExpandedColumns().indexOf(origColumn);
        if (origColumn.isHideColumn() != editColumn.isHideColumn()) {
            this.setColumnVisibility((DTColumnConfig52)origColumn, !editColumn.isHideColumn());
        }
        if (!origColumn.getHeader().equals(editColumn.getHeader())) {
            bUpdateColumnDefinition = true;
        }
        this.populateModelColumn(origColumn, editColumn);
        if (bUpdateColumnDefinition) {
            DecoratedGridCellValueAdaptor cell = this.cellFactory.getCell((BaseColumn)origColumn);
            UpdateColumnDefinitionEvent updateColumnDefinition = new UpdateColumnDefinitionEvent(cell, iCol);
            this.eventBus.fireEvent((GwtEvent)updateColumnDefinition);
        }
    }

    public void updateColumn(LimitedEntryBRLActionColumn origColumn, LimitedEntryBRLActionColumn editColumn) {
        if (origColumn == null) {
            throw new IllegalArgumentException("origColumn cannot be null");
        }
        if (editColumn == null) {
            throw new IllegalArgumentException("editColumn cannot be null");
        }
        boolean bUpdateColumnDefinition = false;
        int iCol = this.model.getExpandedColumns().indexOf(origColumn);
        if (origColumn.isHideColumn() != editColumn.isHideColumn()) {
            this.setColumnVisibility((DTColumnConfig52)origColumn, !editColumn.isHideColumn());
        }
        if (!origColumn.getHeader().equals(editColumn.getHeader())) {
            bUpdateColumnDefinition = true;
        }
        this.populateModelColumn(origColumn, editColumn);
        if (bUpdateColumnDefinition) {
            DecoratedGridCellValueAdaptor cell = this.cellFactory.getCell((BaseColumn)origColumn);
            UpdateColumnDefinitionEvent updateColumnDefinition = new UpdateColumnDefinitionEvent(cell, iCol);
            this.eventBus.fireEvent((GwtEvent)updateColumnDefinition);
        }
    }

    public void updateColumn(Pattern52 origPattern, ConditionCol52 origColumn, Pattern52 editPattern, ConditionCol52 editColumn) {
        if (origPattern == null) {
            throw new IllegalArgumentException("origPattern cannot be null");
        }
        if (origColumn == null) {
            throw new IllegalArgumentException("origColumn cannot be null");
        }
        if (editPattern == null) {
            throw new IllegalArgumentException("editPattern cannot be null");
        }
        if (editColumn == null) {
            throw new IllegalArgumentException("editColumn cannot be null");
        }
        if (!this.model.getConditions().contains(editPattern)) {
            this.model.getConditions().add(editPattern);
            BoundFactsChangedEvent pce = new BoundFactsChangedEvent(this.rm.getLHSBoundFacts());
            this.eventBus.fireEvent((GwtEvent)pce);
        }
        boolean bUpdateColumnData = false;
        boolean bUpdateColumnDefinition = false;
        if (!this.isEqualOrNull((Object)origPattern.getBoundName(), (Object)editPattern.getBoundName())) {
            editPattern.getChildColumns().add(editColumn);
            List columnData = this.cellValueFactory.makeColumnData((BaseColumn)editColumn);
            int origColumnIndex = this.model.getExpandedColumns().indexOf(origColumn);
            if (this.isEqualOrNull((Object)origPattern.getFactType(), (Object)editPattern.getFactType()) && this.isEqualOrNull((Object)origColumn.getFactField(), (Object)editColumn.getFactField()) && origColumn.getConstraintValueType() == editColumn.getConstraintValueType()) {
                columnData.clear();
                for (int iRow = 0; iRow < this.model.getData().size(); ++iRow) {
                    List row = (List)this.model.getData().get(iRow);
                    columnData.add(row.get(origColumnIndex));
                }
            }
            this.addColumn(editColumn, columnData, true);
            origPattern.getChildColumns().remove(origColumn);
            if (origPattern.getChildColumns().size() == 0) {
                this.model.getConditions().remove(origPattern);
                BRLRuleModel rm = new BRLRuleModel(this.model);
                BoundFactsChangedEvent pce = new BoundFactsChangedEvent(rm.getLHSBoundFacts());
                this.eventBus.fireEvent((GwtEvent)pce);
            }
            this.deleteColumn(origColumnIndex, true);
        } else {
            if (origColumn.isHideColumn() != editColumn.isHideColumn()) {
                this.setColumnVisibility((DTColumnConfig52)origColumn, !editColumn.isHideColumn());
            }
            if (!this.isEqualOrNull((Object)origColumn.getOperator(), (Object)editColumn.getOperator())) {
                bUpdateColumnDefinition = true;
                if (!this.canAcceptOtherwiseValues((BaseColumn)editColumn)) {
                    this.removeOtherwiseStates((DTColumnConfig52)origColumn);
                    bUpdateColumnData = true;
                }
            }
            if (!(this.isEqualOrNull((Object)origPattern.getFactType(), (Object)editPattern.getFactType()) && this.isEqualOrNull((Object)origColumn.getFactField(), (Object)editColumn.getFactField()) && this.isEqualOrNull((Object)origColumn.getFieldType(), (Object)editColumn.getFieldType()) && this.isEqualOrNull((Object)origColumn.getOperator(), (Object)editColumn.getOperator()) && origColumn.getConstraintValueType() == editColumn.getConstraintValueType())) {
                bUpdateColumnData = true;
                bUpdateColumnDefinition = true;
            }
            if (!this.isEqualOrNull((Object)origColumn.getValueList(), (Object)editColumn.getValueList())) {
                bUpdateColumnDefinition = true;
                bUpdateColumnData = this.updateCellsForOptionValueList((DTColumnConfig52)editColumn, (DTColumnConfig52)origColumn);
            }
            if (!origColumn.getHeader().equals(editColumn.getHeader())) {
                bUpdateColumnDefinition = true;
            }
            if (!origColumn.isBound() && editColumn.isBound()) {
                bUpdateColumnDefinition = true;
            } else if (origColumn.isBound() && !editColumn.isBound()) {
                bUpdateColumnDefinition = true;
            } else if (origColumn.isBound() && editColumn.isBound() && !origColumn.getBinding().equals(editColumn.getBinding())) {
                bUpdateColumnDefinition = true;
            }
            if (origColumn instanceof LimitedEntryCol && editColumn instanceof LimitedEntryCol) {
                LimitedEntryCol lecOrig = (LimitedEntryCol)origColumn;
                LimitedEntryCol lecEditing = (LimitedEntryCol)editColumn;
                if (!this.isEqualOrNull((Object)lecOrig.getValue(), (Object)lecEditing.getValue())) {
                    bUpdateColumnDefinition = true;
                }
            }
            this.populateModelColumn(origColumn, editColumn);
        }
        if (bUpdateColumnData) {
            ToggleMergingEvent tme = new ToggleMergingEvent(false);
            this.eventBus.fireEvent((GwtEvent)tme);
        }
        if (bUpdateColumnDefinition) {
            int iCol = this.model.getExpandedColumns().indexOf(origColumn);
            DecoratedGridCellValueAdaptor cell = this.cellFactory.getCell((BaseColumn)origColumn);
            UpdateColumnDefinitionEvent updateColumnDefinition = new UpdateColumnDefinitionEvent(cell, iCol);
            this.eventBus.fireEvent((GwtEvent)updateColumnDefinition);
        }
        if (bUpdateColumnData) {
            int iCol = this.model.getExpandedColumns().indexOf(origColumn);
            UpdateColumnDataEvent updateColumnData = new UpdateColumnDataEvent(iCol, this.getColumnData((BaseColumn)origColumn));
            this.eventBus.fireEvent((GwtEvent)updateColumnData);
        }
    }

    public void updateSystemControlledColumnValues() {
        for (BaseColumn column : this.model.getExpandedColumns()) {
            AttributeCol52 attrCol;
            if (column instanceof RowNumberCol52) {
                this.updateRowNumberColumnValues(column);
                continue;
            }
            if (!(column instanceof AttributeCol52) || !(attrCol = (AttributeCol52)column).getAttribute().equals("salience")) continue;
            this.updateSalienceColumnValues(attrCol);
        }
    }

    private void addColumn(MetadataCol52 modelColumn, List<DTCellValue52> columnData, boolean bRedraw) {
        int index = this.model.getExpandedColumns().indexOf(modelColumn);
        InsertDecisionTableColumnEvent dce = new InsertDecisionTableColumnEvent((BaseColumn)modelColumn, columnData, index, bRedraw);
        this.eventBus.fireEvent((GwtEvent)dce);
    }

    private void addColumn(AttributeCol52 modelColumn, List<DTCellValue52> columnData, boolean bRedraw) {
        int index = this.model.getExpandedColumns().indexOf(modelColumn);
        InsertDecisionTableColumnEvent dce = new InsertDecisionTableColumnEvent((BaseColumn)modelColumn, columnData, index, bRedraw);
        this.eventBus.fireEvent((GwtEvent)dce);
    }

    private void addColumn(ConditionCol52 modelColumn, List<DTCellValue52> columnData, boolean bRedraw) {
        int index = this.findConditionColumnIndex(modelColumn);
        InsertDecisionTableColumnEvent dce = new InsertDecisionTableColumnEvent((BaseColumn)modelColumn, columnData, index, bRedraw);
        this.eventBus.fireEvent((GwtEvent)dce);
    }

    private void addColumn(ActionCol52 modelColumn, List<DTCellValue52> columnData, boolean bRedraw) {
        int index = this.model.getExpandedColumns().indexOf(modelColumn);
        InsertDecisionTableColumnEvent dce = new InsertDecisionTableColumnEvent((BaseColumn)modelColumn, columnData, index, bRedraw);
        this.eventBus.fireEvent((GwtEvent)dce);
    }

    private void addBRLActionVariableColumns(List<BRLActionVariableColumn> modelColumns, boolean bRedraw) {
        int index = this.model.getExpandedColumns().indexOf(modelColumns.get(0));
        ArrayList<BRLActionVariableColumn> columns = new ArrayList<BRLActionVariableColumn>();
        ArrayList<List> columnsData = new ArrayList<List>();
        columns.addAll(modelColumns);
        for (BaseColumn baseColumn : columns) {
            columnsData.add(this.cellValueFactory.makeColumnData(baseColumn));
        }
        InsertDecisionTableColumnEvent dce = new InsertDecisionTableColumnEvent(columns, columnsData, index, bRedraw);
        this.eventBus.fireEvent((GwtEvent)dce);
    }

    private void addBRLConditionVariableColumns(List<BRLConditionVariableColumn> modelColumns, boolean bRedraw) {
        int index = this.model.getExpandedColumns().indexOf(modelColumns.get(0));
        ArrayList<BRLConditionVariableColumn> columns = new ArrayList<BRLConditionVariableColumn>();
        ArrayList<List> columnsData = new ArrayList<List>();
        columns.addAll(modelColumns);
        for (BaseColumn baseColumn : columns) {
            columnsData.add(this.cellValueFactory.makeColumnData(baseColumn));
        }
        InsertDecisionTableColumnEvent dce = new InsertDecisionTableColumnEvent(columns, columnsData, index, bRedraw);
        this.eventBus.fireEvent((GwtEvent)dce);
    }

    private boolean canAcceptOtherwiseValues(BaseColumn column) {
        if (!(column instanceof ConditionCol52)) {
            return false;
        }
        ConditionCol52 cc = (ConditionCol52)column;
        if (cc.getConstraintValueType() != 1) {
            return false;
        }
        if (cc.getOperator() == null) {
            return false;
        }
        if (cc.getOperator().equals("==")) {
            return true;
        }
        return cc.getOperator().equals("!=");
    }

    private int findConditionColumnIndex(ConditionCol52 col) {
        int index = 0;
        boolean bMatched = false;
        List columns = this.model.getExpandedColumns();
        for (int iCol = 0; iCol < columns.size(); ++iCol) {
            BaseColumn column = (BaseColumn)columns.get(iCol);
            if (column instanceof RowNumberCol52) {
                index = iCol;
                continue;
            }
            if (column instanceof DescriptionCol52) {
                index = iCol;
                continue;
            }
            if (column instanceof MetadataCol52) {
                index = iCol;
                continue;
            }
            if (column instanceof AttributeCol52) {
                index = iCol;
                continue;
            }
            if (!(column instanceof ConditionCol52)) continue;
            if (this.isEquivalentConditionColumn((ConditionCol52)column, col)) {
                index = iCol;
                bMatched = true;
                continue;
            }
            if (bMatched) continue;
            index = iCol;
        }
        return index;
    }

    private List<CellValue<? extends Comparable<?>>> getColumnData(BaseColumn column) {
        int iColIndex = this.model.getExpandedColumns().indexOf(column);
        ArrayList columnData = new ArrayList();
        for (List row : this.model.getData()) {
            DTCellValue52 dcv = (DTCellValue52)row.get(iColIndex);
            columnData.add(this.cellValueFactory.convertModelCellValue(column, dcv));
        }
        return columnData;
    }

    private List<CellValue<? extends Comparable<?>>> getAnalysisColumnData() {
        ArrayList columnData = new ArrayList();
        List analysisData = this.model.getAnalysisData();
        for (int i = 0; i < analysisData.size(); ++i) {
            Analysis analysis = (Analysis)analysisData.get(i);
            CellValue cell = new CellValue((Comparable)analysis);
            columnData.add(cell);
        }
        return columnData;
    }

    private boolean isEqualOrNull(Object s1, Object s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        return s1 != null && s2 != null && s1.equals(s2);
    }

    private boolean isEquivalentConditionColumn(ConditionCol52 c1, ConditionCol52 c2) {
        Pattern52 c1Pattern = this.model.getPattern(c1);
        Pattern52 c2Pattern = this.model.getPattern(c2);
        return this.isEqualOrNull((Object)c1Pattern.getFactType(), (Object)c2Pattern.getFactType()) && this.isEqualOrNull((Object)c1Pattern.getBoundName(), (Object)c2Pattern.getBoundName());
    }

    private void populateModelColumn(ActionInsertFactCol52 col, ActionInsertFactCol52 editingCol) {
        col.setBoundName(editingCol.getBoundName());
        col.setType(editingCol.getType());
        col.setFactField(editingCol.getFactField());
        col.setHeader(editingCol.getHeader());
        col.setValueList(editingCol.getValueList());
        col.setDefaultValue(editingCol.getDefaultValue());
        col.setHideColumn(editingCol.isHideColumn());
        col.setFactType(editingCol.getFactType());
        col.setInsertLogical(editingCol.isInsertLogical());
        if (col instanceof LimitedEntryCol && editingCol instanceof LimitedEntryCol) {
            ((LimitedEntryCol)col).setValue(((LimitedEntryCol)editingCol).getValue());
        }
    }

    private void populateModelColumn(ActionSetFieldCol52 col, ActionSetFieldCol52 editingCol) {
        col.setBoundName(editingCol.getBoundName());
        col.setType(editingCol.getType());
        col.setFactField(editingCol.getFactField());
        col.setHeader(editingCol.getHeader());
        col.setValueList(editingCol.getValueList());
        col.setDefaultValue(editingCol.getDefaultValue());
        col.setHideColumn(editingCol.isHideColumn());
        col.setUpdate(editingCol.isUpdate());
        if (col instanceof LimitedEntryCol && editingCol instanceof LimitedEntryCol) {
            ((LimitedEntryCol)col).setValue(((LimitedEntryCol)editingCol).getValue());
        }
    }

    private void populateModelColumn(ActionRetractFactCol52 col, ActionRetractFactCol52 editingCol) {
        col.setHeader(editingCol.getHeader());
        col.setDefaultValue(editingCol.getDefaultValue());
        col.setHideColumn(editingCol.isHideColumn());
        if (col instanceof LimitedEntryCol && editingCol instanceof LimitedEntryCol) {
            ((LimitedEntryCol)col).setValue(((LimitedEntryCol)editingCol).getValue());
        }
    }

    private void populateModelColumn(ActionWorkItemCol52 col, ActionWorkItemCol52 editingCol) {
        col.setHeader(editingCol.getHeader());
        col.setDefaultValue(editingCol.getDefaultValue());
        col.setHideColumn(editingCol.isHideColumn());
        col.setWorkItemDefinition(editingCol.getWorkItemDefinition());
    }

    private void populateModelColumn(ActionWorkItemSetFieldCol52 col, ActionWorkItemSetFieldCol52 editingCol) {
        col.setBoundName(editingCol.getBoundName());
        col.setType(editingCol.getType());
        col.setFactField(editingCol.getFactField());
        col.setHeader(editingCol.getHeader());
        col.setHideColumn(editingCol.isHideColumn());
        col.setUpdate(editingCol.isUpdate());
        col.setWorkItemName(editingCol.getWorkItemName());
        col.setWorkItemResultParameterName(editingCol.getWorkItemResultParameterName());
        col.setParameterClassName(editingCol.getParameterClassName());
    }

    private void populateModelColumn(BRLActionColumn col, BRLActionColumn editingCol) {
        col.setHeader(editingCol.getHeader());
        col.setDefaultValue(editingCol.getDefaultValue());
        col.setHideColumn(editingCol.isHideColumn());
        col.setDefinition(editingCol.getDefinition());
        col.setChildColumns(editingCol.getChildColumns());
    }

    private void populateModelColumn(LimitedEntryBRLActionColumn col, LimitedEntryBRLActionColumn editingCol) {
        col.setHeader(editingCol.getHeader());
        col.setDefaultValue(editingCol.getDefaultValue());
        col.setHideColumn(editingCol.isHideColumn());
        col.setDefinition(editingCol.getDefinition());
    }

    private void populateModelColumn(ConditionCol52 col, ConditionCol52 editingCol) {
        col.setConstraintValueType(editingCol.getConstraintValueType());
        col.setFactField(editingCol.getFactField());
        col.setFieldType(editingCol.getFieldType());
        col.setHeader(editingCol.getHeader());
        col.setOperator(editingCol.getOperator());
        col.setValueList(editingCol.getValueList());
        col.setDefaultValue(editingCol.getDefaultValue());
        col.setHideColumn(editingCol.isHideColumn());
        col.setParameters(editingCol.getParameters());
        col.setBinding(editingCol.getBinding());
        if (col instanceof LimitedEntryCol && editingCol instanceof LimitedEntryCol) {
            ((LimitedEntryCol)col).setValue(((LimitedEntryCol)editingCol).getValue());
        }
    }

    private void populateModelColumn(BRLConditionColumn col, BRLConditionColumn editingCol) {
        col.setHeader(editingCol.getHeader());
        col.setDefaultValue(editingCol.getDefaultValue());
        col.setHideColumn(editingCol.isHideColumn());
        col.setDefinition(editingCol.getDefinition());
        col.setChildColumns(editingCol.getChildColumns());
    }

    private void populateModelColumn(LimitedEntryBRLConditionColumn col, LimitedEntryBRLConditionColumn editingCol) {
        col.setHeader(editingCol.getHeader());
        col.setDefaultValue(editingCol.getDefaultValue());
        col.setHideColumn(editingCol.isHideColumn());
        col.setDefinition(editingCol.getDefinition());
    }

    private void removeOtherwiseStates(DTColumnConfig52 column) {
        int index = this.model.getExpandedColumns().indexOf(column);
        for (List row : this.model.getData()) {
            DTCellValue52 dcv = (DTCellValue52)row.get(index);
            dcv.setOtherwise(false);
        }
    }

    private boolean updateCellsForOptionValueList(DTColumnConfig52 editColumn, DTColumnConfig52 origColumn) {
        List<String> vals = Arrays.asList(this.model.getValueList((BaseColumn)editColumn));
        boolean clearExistingValues = vals.size() > 0;
        boolean bUpdateColumnData = false;
        int iCol = this.model.getExpandedColumns().indexOf(origColumn);
        for (List row : this.model.getData()) {
            if (!vals.contains(((DTCellValue52)row.get(iCol)).getStringValue())) {
                bUpdateColumnData = true;
            }
            if (!clearExistingValues) continue;
            ((DTCellValue52)row.get(iCol)).clearValues();
        }
        return bUpdateColumnData;
    }

    private void updateRowNumberColumnValues(BaseColumn column) {
        int rowNumber = 1;
        int iColIndex = this.model.getExpandedColumns().indexOf(column);
        for (List row : this.model.getData()) {
            ((DTCellValue52)row.get(iColIndex)).setNumericValue(Integer.valueOf(rowNumber));
            ++rowNumber;
        }
        UpdateColumnDataEvent uce = new UpdateColumnDataEvent(iColIndex, this.getColumnData(column));
        this.eventBus.fireEvent((GwtEvent)uce);
    }

    private void updateSalienceColumnValues(AttributeCol52 column) {
        int iColIndex = this.model.getExpandedColumns().indexOf(column);
        UpdateColumnDefinitionEvent updateColumnDefinition = new UpdateColumnDefinitionEvent(this.cellFactory.getCell((BaseColumn)column), column.isUseRowNumber(), !column.isUseRowNumber(), iColIndex);
        this.eventBus.fireEvent((GwtEvent)updateColumnDefinition);
        if (!column.isUseRowNumber()) {
            return;
        }
        if (!column.isReverseOrder()) {
            this.updateRowNumberColumnValues((BaseColumn)column);
        }
        int salience = column.isReverseOrder() ? this.model.getData().size() : 1;
        for (List row : this.model.getData()) {
            ((DTCellValue52)row.get(iColIndex)).setNumericValue(Integer.valueOf(salience));
            if (column.isReverseOrder()) {
                --salience;
                continue;
            }
            ++salience;
        }
        UpdateColumnDataEvent updateColumnData = new UpdateColumnDataEvent(iColIndex, this.getColumnData((BaseColumn)column));
        this.eventBus.fireEvent((GwtEvent)updateColumnData);
    }

    public void analyze() {
        this.model.getAnalysisData().clear();
        DecisionTableAnalyzer analyzer = new DecisionTableAnalyzer(this.sce);
        List analysisData = analyzer.analyze(this.model);
        this.model.getAnalysisData().addAll(analysisData);
        this.showAnalysis();
    }

    private void showAnalysis() {
        AnalysisCol52 analysisCol = this.model.getAnalysisCol();
        int analysisColumnIndex = this.model.getExpandedColumns().indexOf(analysisCol);
        UpdateColumnDataEvent updateColumnData = new UpdateColumnDataEvent(analysisColumnIndex, this.getAnalysisColumnData());
        this.eventBus.fireEvent((GwtEvent)updateColumnData);
        analysisCol.setHideColumn(false);
        this.setColumnVisibility((DTColumnConfig52)analysisCol, !analysisCol.isHideColumn());
    }

    public void movePattern(CompositeColumn<?> pattern, int patternTargetIndex) {
        if (patternTargetIndex < 0 || patternTargetIndex > this.model.getConditions().size() - 1) {
            throw new IndexOutOfBoundsException();
        }
        int patternSourceIndex = this.model.getConditions().indexOf(pattern);
        if (patternSourceIndex == patternTargetIndex) {
            return;
        }
        if (patternTargetIndex > patternSourceIndex) {
            CompositeColumn patternBeingMovedAfter = (CompositeColumn)this.model.getConditions().get(patternTargetIndex);
            int sourceColumnIndex = this.model.getExpandedColumns().indexOf(pattern.getChildColumns().get(0));
            int targetColumnIndex = this.model.getExpandedColumns().indexOf(patternBeingMovedAfter.getChildColumns().get(patternBeingMovedAfter.getChildColumns().size() - 1));
            int numberOfColumns = pattern.getChildColumns().size();
            this.model.getConditions().remove(pattern);
            this.model.getConditions().add(patternTargetIndex, pattern);
            MoveColumnsEvent mce = new MoveColumnsEvent(sourceColumnIndex, targetColumnIndex, numberOfColumns);
            this.eventBus.fireEvent((GwtEvent)mce);
        } else {
            CompositeColumn patternBeingMovedBefore = (CompositeColumn)this.model.getConditions().get(patternTargetIndex);
            int sourceColumnIndex = this.model.getExpandedColumns().indexOf(pattern.getChildColumns().get(0));
            int targetColumnIndex = this.model.getExpandedColumns().indexOf(patternBeingMovedBefore.getChildColumns().get(0));
            int numberOfColumns = pattern.getChildColumns().size();
            this.model.getConditions().remove(pattern);
            this.model.getConditions().add(patternTargetIndex, pattern);
            MoveColumnsEvent mce = new MoveColumnsEvent(sourceColumnIndex, targetColumnIndex, numberOfColumns);
            this.eventBus.fireEvent((GwtEvent)mce);
        }
    }

    public void moveCondition(Pattern52 pattern, ConditionCol52 condition, int conditionTargetIndex) {
        if (conditionTargetIndex < 0 || conditionTargetIndex > pattern.getChildColumns().size() - 1) {
            throw new IndexOutOfBoundsException();
        }
        int conditionSourceIndex = pattern.getChildColumns().indexOf(condition);
        if (conditionSourceIndex == conditionTargetIndex) {
            return;
        }
        ConditionCol52 conditionTarget = (ConditionCol52)pattern.getChildColumns().get(conditionTargetIndex);
        int conditionTargetColumnIndex = this.model.getExpandedColumns().indexOf(conditionTarget);
        int conditionSourceColumnIndex = this.model.getExpandedColumns().indexOf(condition);
        pattern.getChildColumns().remove(condition);
        pattern.getChildColumns().add(conditionTargetIndex, condition);
        MoveColumnsEvent mce = new MoveColumnsEvent(conditionSourceColumnIndex, conditionTargetColumnIndex, 1);
        this.eventBus.fireEvent((GwtEvent)mce);
    }

    public void moveAction(ActionCol52 action, int actionTargetIndex) {
        if (actionTargetIndex < 0 || actionTargetIndex > this.model.getActionCols().size() - 1) {
            throw new IndexOutOfBoundsException();
        }
        int actionSourceIndex = this.model.getActionCols().indexOf(action);
        if (actionSourceIndex == actionTargetIndex) {
            return;
        }
        if (actionTargetIndex > actionSourceIndex) {
            BRLActionVariableColumn variable;
            BRLActionColumn brlColumn;
            ActionCol52 actionBeingMovedAfter = (ActionCol52)this.model.getActionCols().get(actionTargetIndex);
            int sourceColumnIndex = -1;
            int targetColumnIndex = -1;
            int numberOfColumns = -1;
            if (action instanceof BRLActionColumn) {
                brlColumn = (BRLActionColumn)action;
                variable = (BRLActionVariableColumn)brlColumn.getChildColumns().get(0);
                sourceColumnIndex = this.model.getExpandedColumns().indexOf(variable);
                numberOfColumns = brlColumn.getChildColumns().size();
            } else {
                sourceColumnIndex = this.model.getExpandedColumns().indexOf(action);
                numberOfColumns = 1;
            }
            if (actionBeingMovedAfter instanceof BRLActionColumn) {
                brlColumn = (BRLActionColumn)actionBeingMovedAfter;
                variable = (BRLActionVariableColumn)brlColumn.getChildColumns().get(brlColumn.getChildColumns().size() - 1);
                targetColumnIndex = this.model.getExpandedColumns().indexOf(variable);
            } else {
                targetColumnIndex = this.model.getExpandedColumns().indexOf(actionBeingMovedAfter);
            }
            this.model.getActionCols().remove(action);
            this.model.getActionCols().add(actionTargetIndex, action);
            MoveColumnsEvent mce = new MoveColumnsEvent(sourceColumnIndex, targetColumnIndex, numberOfColumns);
            this.eventBus.fireEvent((GwtEvent)mce);
        } else {
            BRLActionVariableColumn variable;
            BRLActionColumn brlColumn;
            ActionCol52 actionBeingMovedBefore = (ActionCol52)this.model.getActionCols().get(actionTargetIndex);
            int sourceColumnIndex = -1;
            int targetColumnIndex = -1;
            int numberOfColumns = -1;
            if (action instanceof BRLActionColumn) {
                brlColumn = (BRLActionColumn)action;
                variable = (BRLActionVariableColumn)brlColumn.getChildColumns().get(0);
                sourceColumnIndex = this.model.getExpandedColumns().indexOf(variable);
                numberOfColumns = brlColumn.getChildColumns().size();
            } else {
                sourceColumnIndex = this.model.getExpandedColumns().indexOf(action);
                numberOfColumns = 1;
            }
            if (actionBeingMovedBefore instanceof BRLActionColumn) {
                brlColumn = (BRLActionColumn)actionBeingMovedBefore;
                variable = (BRLActionVariableColumn)brlColumn.getChildColumns().get(0);
                targetColumnIndex = this.model.getExpandedColumns().indexOf(variable);
            } else {
                targetColumnIndex = this.model.getExpandedColumns().indexOf(actionBeingMovedBefore);
            }
            this.model.getActionCols().remove(action);
            this.model.getActionCols().add(actionTargetIndex, action);
            MoveColumnsEvent mce = new MoveColumnsEvent(sourceColumnIndex, targetColumnIndex, numberOfColumns);
            this.eventBus.fireEvent((GwtEvent)mce);
        }
    }

    public void onDeleteRow(DeleteRowEvent event) {
        this.model.getData().remove(event.getIndex());
        this.model.getAnalysisData().remove(event.getIndex());
        Scheduler.get().scheduleFinally((Scheduler.ScheduledCommand)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void onInsertRow(InsertRowEvent event) {
        List data = this.cellValueFactory.makeRowData();
        this.model.getData().add(event.getIndex(), data);
        this.model.getAnalysisData().add(event.getIndex(), new Analysis());
        Scheduler.get().scheduleFinally((Scheduler.ScheduledCommand)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void onCopyRows(CopyRowsEvent event) {
        this.copiedRows.clear();
        for (Integer iRow : event.getRowIndexes()) {
            this.copiedRows.add(this.model.getData().get(iRow));
        }
    }

    public void onPasteRows(PasteRowsEvent event) {
        if (this.copiedRows == null || this.copiedRows.size() == 0) {
            return;
        }
        int iRow = event.getTargetRowIndex();
        for (List sourceRowData : this.copiedRows) {
            List rowData = this.cellValueFactory.makeRowData();
            block14: for (int iCol = 1; iCol < sourceRowData.size(); ++iCol) {
                DTCellValue52 sourceCell = (DTCellValue52)sourceRowData.get(iCol);
                DTCellValue52 targetCell = (DTCellValue52)rowData.get(iCol);
                switch (6.$SwitchMap$org$drools$ide$common$client$modeldriven$dt52$DTDataTypes52[sourceCell.getDataType().ordinal()]) {
                    case 1: {
                        targetCell.setBooleanValue(sourceCell.getBooleanValue());
                        continue block14;
                    }
                    case 2: {
                        targetCell.setDateValue(sourceCell.getDateValue());
                        continue block14;
                    }
                    case 3: {
                        targetCell.setNumericValue(sourceCell.getNumericValue());
                        continue block14;
                    }
                    case 4: {
                        targetCell.setNumericValue((BigDecimal)sourceCell.getNumericValue());
                        continue block14;
                    }
                    case 5: {
                        targetCell.setNumericValue((BigInteger)sourceCell.getNumericValue());
                        continue block14;
                    }
                    case 6: {
                        targetCell.setNumericValue((Byte)sourceCell.getNumericValue());
                        continue block14;
                    }
                    case 7: {
                        targetCell.setNumericValue((Double)sourceCell.getNumericValue());
                        continue block14;
                    }
                    case 8: {
                        targetCell.setNumericValue((Float)sourceCell.getNumericValue());
                        continue block14;
                    }
                    case 9: {
                        targetCell.setNumericValue((Integer)sourceCell.getNumericValue());
                        continue block14;
                    }
                    case 10: {
                        targetCell.setNumericValue((Long)sourceCell.getNumericValue());
                        continue block14;
                    }
                    case 11: {
                        targetCell.setNumericValue((Short)sourceCell.getNumericValue());
                        continue block14;
                    }
                    default: {
                        targetCell.setStringValue(sourceCell.getStringValue());
                    }
                }
            }
            this.model.getData().add(iRow, rowData);
            this.model.getAnalysisData().add(iRow, new Analysis());
            ++iRow;
        }
        Scheduler.get().scheduleFinally((Scheduler.ScheduledCommand)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void onAppendRow(AppendRowEvent event) {
        List data = this.cellValueFactory.makeRowData();
        this.model.getData().add(data);
        this.model.getAnalysisData().add(new Analysis());
        Scheduler.get().scheduleFinally((Scheduler.ScheduledCommand)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void onDeleteColumn(DeleteColumnEvent event) {
        int firstColumnIndex = event.getFirstColumnIndex();
        for (int iCol = 0; iCol < event.getNumberOfColumns(); ++iCol) {
            for (List row : this.model.getData()) {
                row.remove(firstColumnIndex);
            }
        }
    }

    public void onInsertColumn(InsertColumnEvent<BaseColumn, DTCellValue52> event) {
        int index = event.getIndex();
        List columnsData = event.getColumnsData();
        for (int iCol = 0; iCol < columnsData.size(); ++iCol) {
            List columnData = (List)columnsData.get(iCol);
            for (int iRow = 0; iRow < columnData.size(); ++iRow) {
                DTCellValue52 dcv = (DTCellValue52)columnData.get(iRow);
                List row = (List)this.model.getData().get(iRow);
                row.add(index, dcv);
            }
            ++index;
        }
    }

    public void onSelectedCellChange(SelectedCellChangeEvent event) {
        if (event.getCellSelectionDetail() == null) {
            this.dtableCtrls.setEnableOtherwiseButton(false);
        } else {
            Coordinate c = event.getCellSelectionDetail().getCoordinate();
            BaseColumn column = (BaseColumn)this.model.getExpandedColumns().get(c.getCol());
            this.dtableCtrls.setEnableOtherwiseButton(this.canAcceptOtherwiseValues(column) && !this.isReadOnly);
        }
    }

    public void onMoveColumns(MoveColumnsEvent event) {
        block5: {
            int numberOfColumns;
            int targetColumnIndex;
            int sourceColumnIndex;
            block4: {
                sourceColumnIndex = event.getSourceColumnIndex();
                targetColumnIndex = event.getTargetColumnIndex();
                numberOfColumns = event.getNumberOfColumns();
                if (targetColumnIndex <= sourceColumnIndex) break block4;
                for (int iCol = 0; iCol < numberOfColumns; ++iCol) {
                    for (int iRow = 0; iRow < this.model.getData().size(); ++iRow) {
                        List row = (List)this.model.getData().get(iRow);
                        row.add(targetColumnIndex, row.remove(sourceColumnIndex));
                    }
                }
                break block5;
            }
            if (targetColumnIndex >= sourceColumnIndex) break block5;
            for (int iCol = 0; iCol < numberOfColumns; ++iCol) {
                for (int iRow = 0; iRow < this.model.getData().size(); ++iRow) {
                    List row = (List)this.model.getData().get(iRow);
                    row.add(targetColumnIndex, row.remove(sourceColumnIndex));
                }
                ++sourceColumnIndex;
                ++targetColumnIndex;
            }
        }
    }

    public void onUpdateModel(UpdateModelEvent event) {
        Map updates = event.getUpdates();
        for (Map.Entry e : updates.entrySet()) {
            Coordinate originCoordinate = (Coordinate)e.getKey();
            int originRowIndex = originCoordinate.getRow();
            int originColumnIndex = originCoordinate.getCol();
            List data = (List)e.getValue();
            for (int iRow = 0; iRow < data.size(); ++iRow) {
                List rowData = (List)data.get(iRow);
                int targetRowIndex = originRowIndex + iRow;
                for (int iCol = 0; iCol < rowData.size(); ++iCol) {
                    int targetColumnIndex = originColumnIndex + iCol;
                    CellValue changedCell = (CellValue)rowData.get(iCol);
                    BaseColumn col = (BaseColumn)this.model.getExpandedColumns().get(targetColumnIndex);
                    DTCellValue52 dcv = this.cellValueFactory.convertToModelCell(col, changedCell);
                    ((List)this.model.getData().get(targetRowIndex)).set(targetColumnIndex, dcv);
                }
            }
        }
        Scheduler.get().scheduleFinally((Scheduler.ScheduledCommand)new /* Unavailable Anonymous Inner Class!! */);
    }
}

