/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.moduleeditor.drools;

import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.GenericCallback;
import org.drools.guvnor.client.common.ImageButton;
import org.drools.guvnor.client.common.InfoPopup;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.moduleeditor.drools.PackageHeaderWidget;
import org.drools.guvnor.client.resources.DroolsGuvnorImages;
import org.drools.guvnor.client.rpc.Module;
import org.drools.guvnor.client.rpc.RepositoryServiceFactory;
import org.drools.guvnor.shared.modules.ModuleHeader;
import org.drools.guvnor.shared.modules.ModuleHeaderHelper;

public class PackageHeaderWidget
extends Composite {
    private Module conf;
    private SimplePanel layout;
    private ListBox importList;
    private ListBox globalList;
    private boolean isHistoricalReadOnly = false;

    public PackageHeaderWidget(Module conf, boolean isHistoricalReadOnly) {
        this.conf = conf;
        this.isHistoricalReadOnly = isHistoricalReadOnly;
        this.layout = new SimplePanel();
        this.render();
        this.initWidget((Widget)this.layout);
    }

    private void render() {
        ModuleHeader mh = ModuleHeaderHelper.parseHeader((String)this.conf.getHeader());
        if (mh == null) {
            this.textEditorVersion();
        } else {
            this.basicEditorVersion(mh);
        }
    }

    private void basicEditorVersion(ModuleHeader mh) {
        ImageButton newItemButton;
        ImageButton trashButton;
        ImageButton newItemButton2;
        this.layout.clear();
        HorizontalPanel main = new HorizontalPanel();
        VerticalPanel imports = new VerticalPanel();
        imports.add((Widget)new Label(Constants.INSTANCE.ImportedTypes()));
        this.importList = new ListBox(true);
        this.doImports(mh);
        HorizontalPanel importCols = new HorizontalPanel();
        importCols.add((Widget)this.importList);
        VerticalPanel importActions = new VerticalPanel();
        if (this.isHistoricalReadOnly) {
            newItemButton2 = new ImageButton(DroolsGuvnorImages.INSTANCE.newItem(), DroolsGuvnorImages.INSTANCE.newItemDisabled());
            newItemButton2.setEnabled(false);
            importActions.add((Widget)newItemButton2);
            trashButton = new ImageButton(DroolsGuvnorImages.INSTANCE.trash(), DroolsGuvnorImages.INSTANCE.trashDisabled());
            trashButton.setEnabled(false);
            importActions.add((Widget)trashButton);
        } else {
            newItemButton2 = new /* Unavailable Anonymous Inner Class!! */;
            importActions.add((Widget)newItemButton2);
            trashButton = new /* Unavailable Anonymous Inner Class!! */;
            importActions.add((Widget)trashButton);
        }
        importCols.add((Widget)importActions);
        imports.add((Widget)importCols);
        VerticalPanel globals = new VerticalPanel();
        globals.add((Widget)new Label(Constants.INSTANCE.Globals()));
        this.globalList = new ListBox(true);
        this.doGlobals(mh);
        HorizontalPanel globalCols = new HorizontalPanel();
        globalCols.add((Widget)this.globalList);
        VerticalPanel globalActions = new VerticalPanel();
        if (this.isHistoricalReadOnly) {
            newItemButton = new ImageButton(DroolsGuvnorImages.INSTANCE.newItem(), DroolsGuvnorImages.INSTANCE.newItemDisabled());
            newItemButton.setEnabled(false);
            globalActions.add((Widget)newItemButton);
            ImageButton trashButton2 = new ImageButton(DroolsGuvnorImages.INSTANCE.trash(), DroolsGuvnorImages.INSTANCE.trashDisabled());
            trashButton2.setEnabled(false);
            globalActions.add((Widget)trashButton2);
        } else {
            newItemButton = new /* Unavailable Anonymous Inner Class!! */;
            globalActions.add((Widget)newItemButton);
            4 trashButton3 = new /* Unavailable Anonymous Inner Class!! */;
            globalActions.add((Widget)trashButton3);
        }
        globalCols.add((Widget)globalActions);
        globals.add((Widget)globalCols);
        main.add((Widget)imports);
        main.add((Widget)new HTML("&nbsp;"));
        main.add((Widget)globals);
        5 advanced = new /* Unavailable Anonymous Inner Class!! */;
        main.add((Widget)advanced);
        this.layout.add((Widget)main);
    }

    private void textEditorVersion() {
        this.layout.clear();
        VerticalPanel main = new VerticalPanel();
        TextArea area = new TextArea();
        if (this.isHistoricalReadOnly) {
            area.setEnabled(false);
        }
        area.setWidth("100%");
        area.setVisibleLines(8);
        area.setCharacterWidth(100);
        area.setText(this.conf.getHeader());
        area.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        main.add((Widget)area);
        Button basicMode = this.createBasicModeButton(area);
        main.add((Widget)basicMode);
        this.layout.add((Widget)main);
    }

    private Button createBasicModeButton(TextArea area) {
        7 basicMode = new /* Unavailable Anonymous Inner Class!! */;
        return basicMode;
    }

    private ClickHandler createClickHanderForBasicModeButton(TextArea area) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private void handleCasesForBasicModeButton() {
        ModuleHeader mh = ModuleHeaderHelper.parseHeader((String)this.conf.getHeader());
        if (mh == null) {
            Window.alert((String)Constants.INSTANCE.CanNotSwitchToBasicView());
        } else if (mh.hasDeclaredTypes()) {
            Window.alert((String)Constants.INSTANCE.CanNotSwitchToBasicViewDeclaredTypes());
        } else if (mh.hasFunctions()) {
            Window.alert((String)Constants.INSTANCE.CanNotSwitchToBasicViewFunctions());
        } else if (mh.hasRules()) {
            Window.alert((String)Constants.INSTANCE.CanNotSwitchToBasicViewRules());
        } else if (Window.confirm((String)Constants.INSTANCE.SwitchToGuidedModeForPackageEditing())) {
            this.basicEditorVersion(mh);
        }
    }

    private void showTypeQuestion(Widget w, ModuleHeader mh, boolean global, String headerMessage) {
        FormStylePopup pop = new FormStylePopup(DroolsGuvnorImages.INSTANCE.homeIcon(), Constants.INSTANCE.ChooseAFactType());
        pop.addRow((Widget)new HTML("<small><i>" + headerMessage + " </i></small>"));
        ListBox factList = new ListBox();
        factList.addItem(Constants.INSTANCE.loadingList());
        RepositoryServiceFactory.getPackageService().listTypesInPackage(this.conf.getUuid(), (AsyncCallback)this.createGenericCallbackForListTypesInPackage(global, factList));
        InfoPopup info = new InfoPopup(Constants.INSTANCE.TypesInThePackage(), Constants.INSTANCE.IfNoTypesTip());
        pop.addAttribute(Constants.INSTANCE.ChooseClassType(), (IsWidget)this.createHorizontalPanel(new Widget[]{factList, info}));
        TextBox globalName = new TextBox();
        if (global) {
            pop.addAttribute(Constants.INSTANCE.GlobalName(), (IsWidget)globalName);
        }
        TextBox className = new TextBox();
        InfoPopup infoClass = new InfoPopup(Constants.INSTANCE.EnteringATypeClassName(), Constants.INSTANCE.EnterTypeNameTip());
        pop.addAttribute(Constants.INSTANCE.advancedClassName(), (IsWidget)this.createHorizontalPanel(new Widget[]{className, infoClass}));
        9 ok = new /* Unavailable Anonymous Inner Class!! */;
        10 cancel = new /* Unavailable Anonymous Inner Class!! */;
        HorizontalPanel buttonPanel = new HorizontalPanel();
        buttonPanel.add((Widget)ok);
        buttonPanel.add((Widget)cancel);
        pop.addAttribute("", (IsWidget)buttonPanel);
        pop.show();
    }

    private HorizontalPanel createHorizontalPanel(Widget ... wigets) {
        HorizontalPanel horizontalPanel = new HorizontalPanel();
        for (Widget widget : wigets) {
            horizontalPanel.add(widget);
        }
        return horizontalPanel;
    }

    private GenericCallback<String[]> createGenericCallbackForListTypesInPackage(boolean global, ListBox factList) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private void updateHeader(ModuleHeader mh) {
        this.conf.setHeader(ModuleHeaderHelper.renderModuleHeader((ModuleHeader)mh));
    }

    private void doGlobals(ModuleHeader mh) {
        this.globalList.clear();
        for (ModuleHeader.Global g : mh.getGlobals()) {
            this.globalList.addItem(g.getType() + " [" + g.getName() + "]");
        }
    }

    private void doImports(ModuleHeader mh) {
        this.importList.clear();
        for (ModuleHeader.Import i : mh.getImports()) {
            this.importList.addItem(i.getType());
        }
    }

    static /* synthetic */ void access$000(PackageHeaderWidget x0, Widget x1, ModuleHeader x2, boolean x3, String x4) {
        x0.showTypeQuestion(x1, x2, x3, x4);
    }

    static /* synthetic */ ListBox access$100(PackageHeaderWidget x0) {
        return x0.importList;
    }

    static /* synthetic */ void access$200(PackageHeaderWidget x0, ModuleHeader x1) {
        x0.updateHeader(x1);
    }

    static /* synthetic */ ListBox access$300(PackageHeaderWidget x0) {
        return x0.globalList;
    }

    static /* synthetic */ void access$400(PackageHeaderWidget x0) {
        x0.textEditorVersion();
    }

    static /* synthetic */ Module access$500(PackageHeaderWidget x0) {
        return x0.conf;
    }

    static /* synthetic */ ClickHandler access$600(PackageHeaderWidget x0, TextArea x1) {
        return x0.createClickHanderForBasicModeButton(x1);
    }

    static /* synthetic */ void access$700(PackageHeaderWidget x0) {
        x0.handleCasesForBasicModeButton();
    }

    static /* synthetic */ void access$800(PackageHeaderWidget x0, ModuleHeader x1) {
        x0.doImports(x1);
    }

    static /* synthetic */ void access$900(PackageHeaderWidget x0, ModuleHeader x1) {
        x0.doGlobals(x1);
    }
}

