/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.widgets.drools.decoratedgrid;

import java.util.EnumSet;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.CellValue;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.data.Coordinate;

public class CellValue<T extends Comparable<T>>
implements Comparable<CellValue<T>> {
    private T value;
    private int rowSpan = 1;
    private Coordinate coordinate = new Coordinate();
    private Coordinate mapHtmlToData = new Coordinate();
    private Coordinate mapDataToHtml = new Coordinate();
    private EnumSet<CellState> state = EnumSet.noneOf(CellState.class);

    public CellValue(T value) {
        this.value = value;
    }

    public void addState(CellState state) {
        this.state.add(state);
    }

    @Override
    public int compareTo(CellValue<T> cv) {
        if (this.value == null) {
            if (cv.value == null) {
                return 0;
            }
            return 1;
        }
        if (cv.value == null) {
            return -1;
        }
        return this.value.compareTo(cv.value);
    }

    public GroupedCellValue convertToGroupedCell() {
        GroupedCellValue groupedCell = new GroupedCellValue(this, this.getValue());
        if (this.isOtherwise()) {
            groupedCell.addState(CellState.OTHERWISE);
        }
        return groupedCell;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CellValue)) {
            return false;
        }
        CellValue that = (CellValue)obj;
        return this.equalOrNull((Object)this.value, (Object)that.value) && this.rowSpan == that.rowSpan && this.equalOrNull((Object)this.coordinate, (Object)that.coordinate) && this.equalOrNull((Object)this.mapHtmlToData, (Object)that.mapHtmlToData) && this.equalOrNull((Object)this.mapDataToHtml, (Object)that.mapDataToHtml) && this.state.equals(that.state);
    }

    public Coordinate getCoordinate() {
        return this.coordinate;
    }

    public Coordinate getHtmlCoordinate() {
        return new Coordinate(this.mapDataToHtml);
    }

    public Coordinate getPhysicalCoordinate() {
        return new Coordinate(this.mapHtmlToData);
    }

    public int getRowSpan() {
        return this.rowSpan;
    }

    public T getValue() {
        return (T)this.value;
    }

    public int hashCode() {
        int hash = 1;
        hash = hash * 31 + (this.value == null ? 0 : this.value.hashCode());
        hash = hash * 31 + this.rowSpan;
        hash = hash * 31 + (this.coordinate == null ? 0 : this.coordinate.hashCode());
        hash = hash * 31 + (this.mapHtmlToData == null ? 0 : this.mapHtmlToData.hashCode());
        hash = hash * 31 + (this.mapDataToHtml == null ? 0 : this.mapDataToHtml.hashCode());
        hash = hash * 31 + this.state.hashCode();
        return hash;
    }

    public boolean isEmpty() {
        return this.value == null;
    }

    public boolean isGrouped() {
        return this.state.contains(CellState.GROUPED);
    }

    public boolean isOtherwise() {
        return this.state.contains(CellState.OTHERWISE);
    }

    public boolean isSelected() {
        return this.state.contains(CellState.SELECTED);
    }

    public void removeState(CellState state) {
        this.state.remove(state);
    }

    public void setCoordinate(Coordinate coordinate) {
        if (coordinate == null) {
            throw new IllegalArgumentException("Coordinate cannot be null.");
        }
        this.coordinate = coordinate;
    }

    public void setHtmlCoordinate(Coordinate c) {
        if (c == null) {
            throw new IllegalArgumentException("Coordinate cannot be null.");
        }
        this.mapDataToHtml = c;
    }

    public void setPhysicalCoordinate(Coordinate c) {
        if (c == null) {
            throw new IllegalArgumentException("Coordinate cannot be null.");
        }
        this.mapHtmlToData = c;
    }

    public void setRowSpan(int rowSpan) {
        if (rowSpan < 0) {
            throw new IllegalArgumentException("rowSpan cannot be less than zero.");
        }
        this.rowSpan = rowSpan;
    }

    public void setValue(Object value) {
        this.value = (Comparable)value;
    }

    private boolean equalOrNull(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 != null && o2 == null) {
            return false;
        }
        if (o1 == null && o2 != null) {
            return false;
        }
        return o1.equals(o2);
    }

    static /* synthetic */ boolean access$000(CellValue x0, Object x1, Object x2) {
        return x0.equalOrNull(x1, x2);
    }
}

