/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.widgets.drools.decoratedgrid.data;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.CellValue;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.data.Coordinate;

public class DynamicDataRow
implements Iterable<CellValue<? extends Comparable<?>>> {
    private static long _COUNTER = 0L;
    private long creationIndex = DynamicDataRow.getNextCreationIndex();
    private List<CellValue<? extends Comparable<?>>> rowData = new ArrayList();

    private static synchronized long getNextCreationIndex() {
        return _COUNTER++;
    }

    public CellValue<? extends Comparable<?>> get(int index) {
        return (CellValue)this.rowData.get(index);
    }

    @Override
    public Iterator<CellValue<? extends Comparable<?>>> iterator() {
        return this.rowData.iterator();
    }

    public CellValue<? extends Comparable<?>> set(int index, CellValue<? extends Comparable<?>> cell) {
        Coordinate c = this.get(index).getCoordinate();
        Coordinate hc = this.get(index).getHtmlCoordinate();
        Coordinate pc = this.get(index).getPhysicalCoordinate();
        cell.setCoordinate(c);
        cell.setHtmlCoordinate(hc);
        cell.setPhysicalCoordinate(pc);
        cell.setRowSpan(this.get(index).getRowSpan());
        return this.rowData.set(index, cell);
    }

    public int size() {
        return this.rowData.size();
    }

    public boolean add(CellValue<? extends Comparable<?>> cell) {
        return this.rowData.add(cell);
    }

    public void add(int index, CellValue<? extends Comparable<?>> cell) {
        this.rowData.add(index, cell);
    }

    void clear() {
        this.rowData.clear();
    }

    public CellValue<? extends Comparable<?>> remove(int index) {
        return (CellValue)this.rowData.remove(index);
    }

    long getCreationIndex() {
        return this.creationIndex;
    }

    public void move(int targetColumnIndex, int sourceColumnIndex) {
        this.rowData.add(targetColumnIndex, this.rowData.remove(sourceColumnIndex));
    }
}

