/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.widgets.drools.explorer;

import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.RadioButton;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Tree;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.moduleeditor.drools.PackageBuilderWidget;
import org.drools.guvnor.client.rpc.Module;
import org.drools.guvnor.client.rpc.ModuleServiceAsync;
import org.drools.guvnor.client.widgets.drools.explorer.AbstractPackageDefinitionExplorerWidget;
import org.drools.guvnor.client.widgets.drools.explorer.ExplorerRenderMode;
import org.drools.guvnor.client.widgets.drools.explorer.PackageReadyCommand;
import org.drools.guvnor.client.widgets.drools.explorer.PackageResourceExplorerWidget;

public class PackageResourceExplorerWidget
extends AbstractPackageDefinitionExplorerWidget {
    private boolean globalArea;
    private ModuleServiceAsync packageService;
    private String packageUUID;
    private static CreatePackageResourceWidgetBinder uiBinder = (CreatePackageResourceWidgetBinder)GWT.create(CreatePackageResourceWidgetBinder.class);
    @UiField
    protected TextBox txtName;
    @UiField
    protected TextBox txtDescription;
    @UiField
    protected Tree packageTree;
    @UiField
    protected Label labelName;
    @UiField
    protected Label labelDescr;

    public PackageResourceExplorerWidget(String packageUUID, String packageName, ClientFactory clientFactory, ExplorerRenderMode mode) {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.globalArea = packageName.equals("globalArea");
        this.packageService = clientFactory.getModuleService();
        this.packageUUID = packageUUID;
        this.initializePackageTree();
        if (mode.equals((Object)ExplorerRenderMode.HIDE_NAME_AND_DESCRIPTION)) {
            this.txtName.setVisible(false);
            this.txtDescription.setVisible(false);
            this.labelName.setVisible(false);
            this.labelDescr.setVisible(false);
        }
    }

    private void initializePackageTree() {
        if (this.globalArea) {
            this.packageService.loadGlobalModule((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
            this.packageService.listModules((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        } else {
            this.packageService.loadModule(this.packageUUID, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        this.packageTree.setStyleName("category-explorer-Tree");
    }

    private void populatePackageTree(Module packageConfigData, TreeItem rootItem) {
        TreeItem packageItem = new TreeItem(packageConfigData.getName());
        packageItem.addItem(this.createTreeItem("LATEST", packageConfigData.getName(), PackageBuilderWidget.getDownloadLink((Module)packageConfigData)));
        this.packageService.listSnapshots(packageConfigData.getName(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        if (rootItem == null) {
            this.packageTree.addItem(packageItem);
        } else {
            rootItem.addItem(packageItem);
        }
    }

    private TreeItem createTreeItem(String label, String moduleName, String link) {
        TreeItem treeItem = new TreeItem((Widget)new RadioButton("pkgResourceGroup", label));
        treeItem.setUserObject((Object)new TreeItemData(this, moduleName, label, link));
        return treeItem;
    }

    public void processSelectedPackage(PackageReadyCommand command) {
        try {
            TreeItem selectedPackageItem = this.packageTree.getSelectedItem();
            if (selectedPackageItem == null || selectedPackageItem.getChildCount() != 0) {
                throw new IllegalStateException(Constants.INSTANCE.NoPackageSeleced());
            }
            TreeItemData treeItem = (TreeItemData)selectedPackageItem.getUserObject();
            command.onSuccess(treeItem.moduleName, treeItem.label, treeItem.link, this.txtName.getText(), this.txtDescription.getText());
        }
        catch (Throwable t) {
            command.onFailure(t);
        }
    }

    static /* synthetic */ void access$000(PackageResourceExplorerWidget x0, Module x1, TreeItem x2) {
        x0.populatePackageTree(x1, x2);
    }

    static /* synthetic */ TreeItem access$100(PackageResourceExplorerWidget x0, String x1, String x2, String x3) {
        return x0.createTreeItem(x1, x2, x3);
    }
}

