/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.widgets.drools.toolbar;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.place.shared.Place;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.MenuItem;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.LoadingPopup;
import org.drools.guvnor.client.common.StatusChangePopup;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.explorer.ModuleEditorPlace;
import org.drools.guvnor.client.explorer.navigation.ClosePlaceEvent;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.moduleeditor.RefreshModuleListEvent;
import org.drools.guvnor.client.resources.DroolsGuvnorImages;
import org.drools.guvnor.client.rpc.Module;
import org.drools.guvnor.client.rpc.RepositoryServiceFactory;
import org.drools.guvnor.client.widgets.drools.toolbar.PackageActionToolbarButtonsConfigurationProvider;
import org.drools.guvnor.client.widgets.drools.toolbar.PackageEditorActionToolbar;
import org.drools.guvnor.client.widgets.toolbar.ActionToolbarButtonsConfigurationProvider;

public class PackageEditorActionToolbar
extends Composite {
    private static PackageEditorActionToolbarBinder uiBinder = (PackageEditorActionToolbarBinder)GWT.create(PackageEditorActionToolbarBinder.class);
    @UiField
    MenuItem saveChanges;
    @UiField
    MenuItem saveChangesAndClose;
    @UiField
    MenuItem archive;
    @UiField
    MenuItem delete;
    @UiField
    MenuItem copy;
    @UiField
    MenuItem rename;
    @UiField
    MenuItem promoteToGlobal;
    @UiField
    MenuItem selectWorkingSets;
    @UiField
    MenuItem validate;
    @UiField
    MenuItem verify;
    @UiField
    MenuItem viewSource;
    @UiField
    MenuItem changeStatus;
    @UiField
    Label status;
    @UiField
    MenuItem sourceMenu;
    private ActionToolbarButtonsConfigurationProvider actionToolbarButtonsConfigurationProvider = new PackageActionToolbarButtonsConfigurationProvider();
    private Module packageConfigData;
    private final EventBus eventBus;
    private final ClientFactory clientFactory;
    private Command refreshCommand;
    private boolean readOnly;

    public PackageEditorActionToolbar(Module data, ClientFactory clientFactory, EventBus eventBus, boolean readOnly, Command refreshCommand) {
        this.packageConfigData = data;
        this.eventBus = eventBus;
        this.clientFactory = clientFactory;
        this.readOnly = readOnly;
        this.refreshCommand = refreshCommand;
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.setState(this.packageConfigData.getState());
        this.applyToolBarConfiguration();
        this.status.setVisible(this.actionToolbarButtonsConfigurationProvider.showStateLabel());
        this.initActionToolBar();
    }

    public void setState(String newStatus) {
        this.status.setText(Constants.INSTANCE.statusIs(newStatus));
    }

    private void applyToolBarConfiguration() {
        this.saveChanges.setVisible(this.actionToolbarButtonsConfigurationProvider.showSaveButton());
        this.saveChangesAndClose.setVisible(this.actionToolbarButtonsConfigurationProvider.showSaveAndCloseButton());
        this.validate.setVisible(this.actionToolbarButtonsConfigurationProvider.showValidateButton());
        this.verify.setVisible(this.actionToolbarButtonsConfigurationProvider.showVerifyButton());
        this.viewSource.setVisible(this.actionToolbarButtonsConfigurationProvider.showViewSourceButton());
        this.copy.setVisible(this.actionToolbarButtonsConfigurationProvider.showCopyButton());
        this.rename.setVisible(this.actionToolbarButtonsConfigurationProvider.showRenameButton());
        this.promoteToGlobal.setVisible(this.actionToolbarButtonsConfigurationProvider.showPromoteToGlobalButton());
        this.archive.setVisible(this.actionToolbarButtonsConfigurationProvider.showArchiveButton());
        this.delete.setVisible(this.actionToolbarButtonsConfigurationProvider.showDeleteButton());
        this.changeStatus.setVisible(this.actionToolbarButtonsConfigurationProvider.showChangeStatusButton());
        this.selectWorkingSets.setVisible(this.actionToolbarButtonsConfigurationProvider.showSelectWorkingSetsButton());
        this.sourceMenu.setVisible(this.areSourceMenuChildrenVisible());
    }

    private boolean areSourceMenuChildrenVisible() {
        return this.validate.isVisible() || this.verify.isVisible() || this.viewSource.isVisible();
    }

    public void setSelectWorkingSetsCommand(Command command) {
        this.selectWorkingSets.setCommand(command);
    }

    public void setViewSourceCommand(Command command) {
        this.viewSource.setCommand(command);
    }

    public void setVerifyCommand(Command command) {
        this.verify.setCommand(command);
    }

    public void setValidateCommand(Command command) {
        this.validate.setCommand(command);
    }

    public void setSaveChangesCommand(Command command) {
        this.saveChanges.setCommand(command);
    }

    public void setSaveChangesAndCloseCommand(Command command) {
        this.saveChangesAndClose.setCommand(command);
    }

    public void setChangeStatusCommand(Command command) {
        this.changeStatus.setCommand(command);
    }

    public void setDeleteVisible(boolean b) {
        this.delete.setVisible(b);
    }

    public void setArchiveVisible(boolean b) {
        this.archive.setVisible(b);
    }

    public void setArchiveCommand(Command archiveCommand) {
        this.archive.setCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void setCopyCommand(Command command) {
        this.copy.setCommand(command);
    }

    public void setRenameCommand(Command command) {
        this.rename.setCommand(command);
    }

    public void setDeleteCommand(Command deleteCommand) {
        this.delete.setCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void setPromtToGlobalCommand(Command command) {
        this.promoteToGlobal.setCommand(command);
    }

    private void initActionToolBar() {
        if (this.readOnly) {
            this.setVisible(false);
        } else {
            this.setSaveChangesCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
            this.setArchiveCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
            this.setCopyCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
            this.setRenameCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
            this.setChangeStatusCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
            this.setViewSourceCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    protected void showStatusChanger() {
        StatusChangePopup pop = new StatusChangePopup(this.packageConfigData.getUuid(), true);
        pop.setChangeStatusEvent((Command)new /* Unavailable Anonymous Inner Class!! */);
        pop.show();
    }

    private void doRename() {
        FormStylePopup pop = new FormStylePopup(DroolsGuvnorImages.INSTANCE.newWiz(), Constants.INSTANCE.RenameThePackage());
        pop.addRow((Widget)new HTML(Constants.INSTANCE.RenamePackageTip()));
        TextBox name = new TextBox();
        pop.addAttribute(Constants.INSTANCE.NewPackageNameIs(), (IsWidget)name);
        Button ok = new Button(Constants.INSTANCE.OK());
        pop.addAttribute("", (IsWidget)ok);
        ok.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        pop.show();
    }

    private void completedRenaming(String newAssetUUID) {
        Window.alert((String)Constants.INSTANCE.PackageRenamedSuccessfully());
        this.refreshPackageList();
        this.eventBus.fireEvent((GwtEvent)new ClosePlaceEvent((Place)new ModuleEditorPlace(newAssetUUID)));
        this.openModule(newAssetUUID);
    }

    private void openModule(String newAssetUUID) {
        this.clientFactory.getPlaceController().goTo((Place)new ModuleEditorPlace(newAssetUUID));
    }

    private void doCopy() {
        FormStylePopup pop = new FormStylePopup(DroolsGuvnorImages.INSTANCE.newWiz(), Constants.INSTANCE.CopyThePackage());
        pop.addRow((Widget)new HTML(Constants.INSTANCE.CopyThePackageTip()));
        TextBox name = new TextBox();
        pop.addAttribute(Constants.INSTANCE.NewPackageNameIs(), (IsWidget)name);
        Button ok = new Button(Constants.INSTANCE.OK());
        pop.addAttribute("", (IsWidget)ok);
        ok.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        pop.show();
    }

    private void completedCopying(String newAssetUUID) {
        Window.alert((String)Constants.INSTANCE.PackageCopiedSuccessfully());
        this.refreshPackageList();
        this.openModule(newAssetUUID);
    }

    private void doSave(Command refresh) {
        LoadingPopup.showMessage((String)Constants.INSTANCE.SavingPackageConfigurationPleaseWait());
        RepositoryServiceFactory.getPackageService().saveModule(this.packageConfigData, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void doArchive() {
        this.packageConfigData.setArchived(true);
        13 ref = new /* Unavailable Anonymous Inner Class!! */;
        this.doSave((Command)ref);
    }

    private void refreshPackageList() {
        this.eventBus.fireEvent((GwtEvent)new RefreshModuleListEvent());
    }

    static /* synthetic */ void access$000(PackageEditorActionToolbar x0, Command x1) {
        x0.doSave(x1);
    }

    static /* synthetic */ void access$100(PackageEditorActionToolbar x0) {
        x0.doArchive();
    }

    static /* synthetic */ void access$200(PackageEditorActionToolbar x0) {
        x0.doCopy();
    }

    static /* synthetic */ void access$300(PackageEditorActionToolbar x0) {
        x0.doRename();
    }

    static /* synthetic */ Module access$400(PackageEditorActionToolbar x0) {
        return x0.packageConfigData;
    }

    static /* synthetic */ void access$500(PackageEditorActionToolbar x0, String x1) {
        x0.completedRenaming(x1);
    }

    static /* synthetic */ void access$600(PackageEditorActionToolbar x0, String x1) {
        x0.completedCopying(x1);
    }

    static /* synthetic */ Command access$700(PackageEditorActionToolbar x0) {
        return x0.refreshCommand;
    }

    static /* synthetic */ EventBus access$800(PackageEditorActionToolbar x0) {
        return x0.eventBus;
    }

    static /* synthetic */ void access$900(PackageEditorActionToolbar x0) {
        x0.refreshPackageList();
    }
}

