/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.converters.decisiontable;

import com.google.gwt.user.client.rpc.SerializationException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.drools.core.util.DateUtils;
import org.drools.decisiontable.parser.xls.ExcelParser;
import org.drools.guvnor.client.rpc.Asset;
import org.drools.guvnor.client.rpc.ConversionResult;
import org.drools.guvnor.client.rpc.Module;
import org.drools.guvnor.client.rpc.NewAssetConfiguration;
import org.drools.guvnor.client.rpc.RuleContentText;
import org.drools.guvnor.server.RepositoryAssetService;
import org.drools.guvnor.server.RepositoryModuleService;
import org.drools.guvnor.server.ServiceImplementation;
import org.drools.guvnor.server.converters.AbstractConverter;
import org.drools.guvnor.server.converters.decisiontable.GuidedDecisionTableGeneratorListener;
import org.drools.guvnor.shared.modules.ModuleHeader;
import org.drools.guvnor.shared.modules.ModuleHeaderHelper;
import org.drools.ide.common.client.modeldriven.brl.PortableObject;
import org.drools.ide.common.client.modeldriven.dt52.GuidedDecisionTable52;
import org.drools.repository.AssetItem;
import org.drools.template.model.Global;
import org.drools.template.model.Import;

@ApplicationScoped
public class DecisionTableXLSToDecisionTableGuidedConverter
extends AbstractConverter {
    private static final String FORMAT = "gdst";
    @Inject
    private ServiceImplementation serviceImplementation;
    @Inject
    private RepositoryAssetService repositoryAssetService;
    @Inject
    private RepositoryModuleService repositoryModuleService;

    public DecisionTableXLSToDecisionTableGuidedConverter() {
        super(FORMAT);
    }

    public ConversionResult convert(AssetItem item) {
        ConversionResult result = new ConversionResult();
        try {
            if (!item.getFormat().equals("xls")) {
                result.addMessage("Source Asset is not an XLS Decision Table.", ConversionResult.ConversionMessageType.ERROR);
                return result;
            }
            if (!item.isBinary()) {
                result.addMessage("Source Asset has no binary content.", ConversionResult.ConversionMessageType.ERROR);
                return result;
            }
            GuidedDecisionTableGeneratorListener listener = this.parseAssets(item, result);
            this.createNewFunctions(listener.getFunctions(), item, result);
            this.createNewGlobalsAndImports(listener.getGlobals(), listener.getImports(), item, result);
            this.createNewQueries(listener.getQueries(), item, result);
            this.createNewDeclarativeTypes(listener.getTypeDeclarations(), item, result);
            this.createNewDecisionTables(listener.getGuidedDecisionTables(), item, result);
        }
        catch (SerializationException se) {
            result.addMessage(se.getMessage(), ConversionResult.ConversionMessageType.ERROR);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GuidedDecisionTableGeneratorListener parseAssets(AssetItem item, ConversionResult result) {
        ArrayList<GuidedDecisionTableGeneratorListener> listeners = new ArrayList<GuidedDecisionTableGeneratorListener>();
        GuidedDecisionTableGeneratorListener listener = new GuidedDecisionTableGeneratorListener(result);
        listeners.add(listener);
        ExcelParser parser = new ExcelParser(listeners);
        InputStream stream = item.getBinaryContentAttachment();
        try {
            parser.parseFile(stream);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException ioe) {
                result.addMessage(ioe.getMessage(), ConversionResult.ConversionMessageType.ERROR);
            }
        }
        return listener;
    }

    private void createNewFunctions(List<String> functions, AssetItem item, ConversionResult result) throws SerializationException {
        if (functions == null) {
            return;
        }
        for (int iCounter = 0; iCounter < functions.size(); ++iCounter) {
            RuleContentText content = new RuleContentText();
            content.content = functions.get(iCounter);
            String assetName = this.makeNewAssetName("Function " + (iCounter + 1));
            String packageName = item.getModule().getName();
            String packageUUID = item.getModule().getUUID();
            String description = "Converted from XLS Decision Table '" + item.getName() + "'.";
            result.addMessage("Created Function '" + assetName + "'", ConversionResult.ConversionMessageType.INFO);
            NewAssetConfiguration config = new NewAssetConfiguration(assetName, packageName, packageUUID, description, null, "function");
            this.createNewAsset(item, config, (PortableObject)content, result);
        }
    }

    private void createNewGlobalsAndImports(List<Global> globals, List<Import> imports, AssetItem item, ConversionResult result) throws SerializationException {
        if (globals == null && imports == null) {
            return;
        }
        boolean isModified = false;
        String moduleUUID = item.getModule().getUUID();
        Module module = this.repositoryModuleService.loadModule(moduleUUID);
        ModuleHeader mh = ModuleHeaderHelper.parseHeader((String)module.header);
        HashMap<String, String> existingGlobals = new HashMap<String, String>();
        for (ModuleHeader.Global g : mh.getGlobals()) {
            existingGlobals.put(g.getName(), g.getType());
        }
        ArrayList<String> existingImports = new ArrayList<String>();
        for (ModuleHeader.Import import_ : mh.getImports()) {
            existingImports.add(import_.getType());
        }
        if (globals != null) {
            for (Global global : globals) {
                if (!existingGlobals.containsKey(global.getIdentifier())) {
                    isModified = true;
                    result.addMessage("Created Global '" + global.getIdentifier() + "' of type '" + global.getClassName() + "'.", ConversionResult.ConversionMessageType.INFO);
                    mh.getGlobals().add(new ModuleHeader.Global(global.getClassName(), global.getIdentifier()));
                    continue;
                }
                if (((String)existingGlobals.get(global.getIdentifier())).equals(global.getClassName())) continue;
                result.addMessage("Global '" + global.getIdentifier() + "' is already declared. Type '" + (String)existingGlobals.get(global.getIdentifier()) + "'. Cannot create from Worksheet.", ConversionResult.ConversionMessageType.WARNING);
            }
        }
        if (imports != null) {
            for (Import import_ : imports) {
                if (existingImports.contains(import_.getClassName())) continue;
                isModified = true;
                result.addMessage("Created Import for '" + import_.getClassName() + "'.", ConversionResult.ConversionMessageType.INFO);
                mh.getImports().add(new ModuleHeader.Import(import_.getClassName()));
            }
        }
        if (isModified) {
            module.setHeader(ModuleHeaderHelper.renderModuleHeader((ModuleHeader)mh));
            this.repositoryModuleService.saveModule(module);
        }
    }

    private void createNewQueries(List<String> queries, AssetItem item, ConversionResult result) {
        if (queries == null) {
            return;
        }
        for (String query : queries) {
            result.addMessage("Queries are not supported in Guvnor. Query '" + query + "' will not be added.", ConversionResult.ConversionMessageType.WARNING);
        }
    }

    private void createNewDeclarativeTypes(List<String> declaredTypes, AssetItem item, ConversionResult result) throws SerializationException {
        if (declaredTypes == null) {
            return;
        }
        for (int iCounter = 0; iCounter < declaredTypes.size(); ++iCounter) {
            RuleContentText content = new RuleContentText();
            content.content = declaredTypes.get(iCounter);
            String assetName = this.makeNewAssetName("Declarative Model " + (iCounter + 1));
            String packageName = item.getModule().getName();
            String packageUUID = item.getModule().getUUID();
            String description = "Converted from XLS Decision Table '" + item.getName() + "'.";
            result.addMessage("Created Declarative Model '" + assetName + "'.", ConversionResult.ConversionMessageType.INFO);
            NewAssetConfiguration config = new NewAssetConfiguration(assetName, packageName, packageUUID, description, null, "model.drl");
            this.createNewAsset(item, config, (PortableObject)content, result);
        }
    }

    private void createNewDecisionTables(List<GuidedDecisionTable52> dtables, AssetItem item, ConversionResult result) throws SerializationException {
        if (dtables == null) {
            return;
        }
        for (GuidedDecisionTable52 dtable : dtables) {
            String assetName = this.makeNewAssetName(dtable.getTableName());
            String packageName = item.getModule().getName();
            String packageUUID = item.getModule().getUUID();
            String description = "Converted from XLS Decision Table '" + item.getName() + "'.";
            result.addMessage("Created Guided Decision Table '" + assetName + "'.", ConversionResult.ConversionMessageType.INFO);
            NewAssetConfiguration config = new NewAssetConfiguration(assetName, packageName, packageUUID, description, null, FORMAT);
            this.createNewAsset(item, config, (PortableObject)dtable, result);
        }
    }

    private String makeNewAssetName(String baseName) {
        Calendar now = Calendar.getInstance();
        StringBuilder sb = new StringBuilder(baseName);
        sb.append(" (converted on ");
        sb.append(DateUtils.format((Date)now.getTime()));
        sb.append(" ");
        sb.append(now.get(11));
        sb.append(":");
        sb.append(now.get(12));
        sb.append(":");
        sb.append(now.get(13));
        sb.append(")");
        return sb.toString();
    }

    protected void createNewAsset(AssetItem item, NewAssetConfiguration config, PortableObject content, ConversionResult result) throws SerializationException {
        String uuid = this.serviceImplementation.createNewRule(config);
        if (uuid.startsWith("DUPLICATE")) {
            result.addMessage(uuid, ConversionResult.ConversionMessageType.ERROR);
            return;
        }
        Asset newAsset = this.repositoryAssetService.loadRuleAsset(uuid);
        newAsset.setContent(content);
        newAsset.setCheckinComment("Converted from '" + item.getName() + "'.");
        uuid = this.repositoryAssetService.checkinVersion(newAsset);
        if (uuid.startsWith("ERR")) {
            result.addMessage(uuid, ConversionResult.ConversionMessageType.ERROR);
            return;
        }
        result.addNewAsset(new ConversionResult.ConversionAsset(uuid, config.getFormat()));
    }
}

