/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.converters.decisiontable.builders;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ParameterUtilities {
    private static final Pattern patternSingleParameter = Pattern.compile("\\$param");
    private static final Pattern patternIndexedParameter = Pattern.compile("\\$\\d+");
    private static final Pattern patternTemplateKey = Pattern.compile("@\\{.+?\\}");
    private static final String PARAMETER_PREFIX = "param";
    private int parameterCounter = 1;

    public String convertIndexedParametersToTemplateKeys(String xlsTemplate) {
        StringBuffer result = new StringBuffer();
        Matcher matcherIndexedParameter = patternIndexedParameter.matcher(xlsTemplate);
        while (matcherIndexedParameter.find()) {
            matcherIndexedParameter.appendReplacement(result, "@{param" + this.parameterCounter++ + "}");
        }
        matcherIndexedParameter.appendTail(result);
        return result.toString();
    }

    public String convertSingleParameterToTemplateKey(String xlsTemplate) {
        StringBuffer result = new StringBuffer();
        Matcher matcherSingleParameter = patternSingleParameter.matcher(xlsTemplate);
        while (matcherSingleParameter.find()) {
            matcherSingleParameter.appendReplacement(result, "@{param" + this.parameterCounter + "}");
        }
        ++this.parameterCounter;
        matcherSingleParameter.appendTail(result);
        return result.toString();
    }

    public Set<String> extractTemplateKeys(String template) {
        HashSet<String> result = new HashSet<String>();
        Matcher matcherTemplateKey = patternTemplateKey.matcher(template);
        while (matcherTemplateKey.find()) {
            String fullKey = matcherTemplateKey.group();
            result.add(fullKey.substring(2, fullKey.length() - 1));
        }
        return result;
    }
}

