/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.generators;

import com.google.common.base.Preconditions;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.AssetReference;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.ServiceConfig;
import org.drools.guvnor.server.generators.ServiceWarGenerator;
import org.drools.guvnor.server.maven.cache.GuvnorArtifactCacheSupport;
import org.drools.repository.AssetItem;
import org.drools.repository.RulesRepository;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.mvel2.templates.CompiledTemplate;
import org.mvel2.templates.TemplateRegistry;
import org.mvel2.templates.TemplateRuntime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public final class ServiceWarGenerator {
    private static final Logger log = LoggerFactory.getLogger(ServiceWarGenerator.class);
    private static final Map<String, CompiledTemplate> templateMap = new /* Unavailable Anonymous Inner Class!! */;
    private static final TemplateRegistry templateRegistry = new /* Unavailable Anonymous Inner Class!! */;

    private ServiceWarGenerator() {
    }

    public static void buildWar(ServiceConfig config, RulesRepository repository, OutputStream out) {
        HashMap<String, File> models = new HashMap<String, File>();
        for (AssetReference model : config.getModels()) {
            try {
                AssetItem asset = repository.loadAssetByUUID(model.getUrl());
                File temp = File.createTempFile(asset.getBinaryContentAttachmentFileName(), ".jar");
                temp.deleteOnExit();
                FileOutputStream tempStream = new FileOutputStream(temp);
                IOUtils.copy((InputStream)asset.getBinaryContentAttachment(), (OutputStream)tempStream);
                tempStream.flush();
                tempStream.close();
                models.put(asset.getBinaryContentAttachmentFileName(), temp);
            }
            catch (IOException e) {
                log.error(e.getMessage());
            }
        }
        ServiceWarGenerator.buildWar((ServiceConfig)config, models, (OutputStream)out);
    }

    public static void buildWar(ServiceConfig config, Map<String, File> models, OutputStream out) {
        Preconditions.checkNotNull((Object)config);
        Preconditions.checkNotNull((Object)out);
        3 data = new /* Unavailable Anonymous Inner Class!! */;
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"drools-service.war");
        for (Map.Entry entry : templateMap.entrySet()) {
            String content = (String)TemplateRuntime.execute((CompiledTemplate)((CompiledTemplate)entry.getValue()), null, (Map)data, (TemplateRegistry)templateRegistry);
            archive.add((Asset)new StringAsset(content), (String)entry.getKey());
        }
        for (File file : GuvnorArtifactCacheSupport.resolveArtifacts((Collection)config.getExcludedArtifacts())) {
            archive.addAsLibraries(new File[]{file});
        }
        if (models != null && models.size() > 0) {
            for (Map.Entry<Object, Object> entry : models.entrySet()) {
                archive.addAsLibrary((File)entry.getValue(), (String)entry.getKey());
            }
        }
        try {
            ((ZipExporter)archive.as(ZipExporter.class)).exportTo(out);
            out.flush();
            out.close();
        }
        catch (Throwable e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private static String getResourceContent(String fileName) {
        try {
            ByteArrayOutputStream outContent = new ByteArrayOutputStream();
            BufferedInputStream inContent = new BufferedInputStream(ServiceWarGenerator.class.getClassLoader().getResourceAsStream(fileName));
            IOUtils.copy((InputStream)inContent, (OutputStream)outContent);
            return outContent.toString();
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Error " + fileName, ex);
        }
    }

    static /* synthetic */ String access$000(String x0) {
        return ServiceWarGenerator.getResourceContent((String)x0);
    }
}

