/*
 * Copyright 2012 JBoss Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.drools.guvnor.client.simulation;

import org.drools.guvnor.shared.simulation.SimulationPathModel;
import org.drools.guvnor.shared.simulation.SimulationStepModel;
import org.drools.guvnor.shared.simulation.command.AbstractCommandModel;

public interface SimulationTestEventHandler {

    void addPath();
    void removePath(SimulationPathModel path);

    void selectStep(SimulationStepModel step);
    void addStep(SimulationPathModel path);
    void removeStep(SimulationStepModel step);

    void addCommand(AbstractCommandModel command);
    void moveUpCommand(AbstractCommandModel command);
    void moveDownCommand(AbstractCommandModel command);
    void removeCommand(AbstractCommandModel command);

}
