/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.asseteditor.drools.serviceconfig;

import org.drools.guvnor.client.asseteditor.drools.serviceconfig.AssetReference;
import org.junit.Assert;
import org.junit.Test;

public class AssetReferenceTest {
    @Test
    public void testAssetReferenceExplicitConstructor() {
        AssetReference assetReference = new AssetReference("a", "b", "c", "d", "e");
        Assert.assertNotNull((Object)assetReference);
        Assert.assertEquals((Object)"a", (Object)assetReference.getPackageRef());
        Assert.assertEquals((Object)"b", (Object)assetReference.getName());
        Assert.assertEquals((Object)"c", (Object)assetReference.getFormat());
        Assert.assertEquals((Object)"d", (Object)assetReference.getUrl());
        Assert.assertEquals((Object)"e", (Object)assetReference.getUuid());
    }

    @Test
    public void testAssetReferenceToValueConsistency() {
        AssetReference assetReference = new AssetReference("a", "b", "c", "d", "e");
        Assert.assertEquals((Object)assetReference, (Object)new AssetReference(assetReference));
        Assert.assertEquals((long)assetReference.hashCode(), (long)new AssetReference(assetReference).hashCode());
        Assert.assertTrue((boolean)assetReference.equals((Object)assetReference));
        Assert.assertTrue((boolean)assetReference.equals((Object)new AssetReference("a", "b", "c", "d", "e")));
        Assert.assertFalse((boolean)assetReference.equals((Object)new AssetReference("a", "b", "c", "d", "x")));
        Assert.assertFalse((boolean)assetReference.equals((Object)new AssetReference("a", "b", "c", "x", "e")));
        Assert.assertFalse((boolean)assetReference.equals((Object)new AssetReference("a", "b", "x", "d", "e")));
        Assert.assertFalse((boolean)assetReference.equals((Object)new AssetReference("a", "x", "c", "d", "e")));
        Assert.assertFalse((boolean)assetReference.equals((Object)new AssetReference("x", "b", "c", "d", "e")));
        Assert.assertFalse((boolean)assetReference.equals(null));
        Assert.assertFalse((boolean)assetReference.equals((Object)"?!"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAssetReferenceNullConstructor() {
        new AssetReference(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAssetReferenceExplicitConstructorNull1() {
        new AssetReference(null, "b", "c", "d", "e");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAssetReferenceExplicitConstructorEmpty1() {
        new AssetReference("", "b", "c", "d", "e");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAssetReferenceExplicitConstructorNull2() {
        new AssetReference("a", null, "c", "d", "e");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAssetReferenceExplicitConstructorEmpty2() {
        new AssetReference("a", "", "c", "d", "e");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAssetReferenceExplicitConstructorNull3() {
        new AssetReference("a", "b", null, "d", "e");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAssetReferenceExplicitConstructorEmpty3() {
        new AssetReference("a", "b", "", "d", "e");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAssetReferenceExplicitConstructorNull4() {
        new AssetReference("a", "b", "c", null, "e");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAssetReferenceExplicitConstructorEmpty4() {
        new AssetReference("a", "b", "c", "", "e");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAssetReferenceExplicitConstructorNull5() {
        new AssetReference("a", "b", "c", "d", null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAssetReferenceExplicitConstructorEmpty5() {
        new AssetReference("a", "b", "c", "d", "");
    }
}

