/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.explorer.navigation.qa;

import org.drools.guvnor.client.explorer.navigation.qa.BulkRunResultPresenter;
import org.drools.guvnor.client.explorer.navigation.qa.BulkRunResultView;
import org.drools.guvnor.client.rpc.BulkTestRunResult;
import org.drools.guvnor.client.rpc.ScenarioResultSummary;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class BulkRunResultPresenterTest {
    private BulkRunResultPresenter bulkRunResultPresenter;
    private BulkRunResultView mockView;

    @Before
    public void setUp() {
        this.mockView = (BulkRunResultView)Mockito.mock(BulkRunResultView.class);
        this.bulkRunResultPresenter = new BulkRunResultPresenter(this.mockView);
    }

    @Test
    public void emptyScenarioTestSummary() throws Exception {
        BulkTestRunResult bulkTestRunResult = new BulkTestRunResult();
        this.bulkRunResultPresenter.setBulkTestRunResult(bulkTestRunResult);
        this.verifyBulkTestSucceeded();
        ((BulkRunResultView)Mockito.verify((Object)this.mockView)).setFailuresOutOfExpectation(0, 0);
        ((BulkRunResultView)Mockito.verify((Object)this.mockView)).setResultsPercent(0);
        ((BulkRunResultView)Mockito.verify((Object)this.mockView)).setRulesCoveredPercent(0);
        this.verifyNoUncoveredRules();
        ((BulkRunResultView)Mockito.verify((Object)this.mockView, (VerificationMode)Mockito.never())).addNormalSummaryTableRow(Mockito.anyInt(), Mockito.anyInt(), Matchers.anyString(), Mockito.anyInt(), Matchers.anyString());
        ((BulkRunResultView)Mockito.verify((Object)this.mockView, (VerificationMode)Mockito.never())).addMissingExpectationSummaryTableRow(Matchers.anyString(), Matchers.anyString());
    }

    @Test
    public void singleTestWithoutFailures() throws Exception {
        ScenarioResultSummary scenarioResultSummary = this.getScenarioResultSummary(0, 1);
        ScenarioResultSummary[] scenarioResultSummaries = new ScenarioResultSummary[]{scenarioResultSummary};
        BulkTestRunResult bulkTestRunResult = this.getBulkRunResult(100, scenarioResultSummaries);
        this.bulkRunResultPresenter.setBulkTestRunResult(bulkTestRunResult);
        this.verifyBulkTestSucceeded();
        ((BulkRunResultView)Mockito.verify((Object)this.mockView)).setFailuresOutOfExpectation(0, 1);
        ((BulkRunResultView)Mockito.verify((Object)this.mockView)).setResultsPercent(100);
        ((BulkRunResultView)Mockito.verify((Object)this.mockView)).setRulesCoveredPercent(100);
        this.verifyNoUncoveredRules();
        this.verifyThatResultSummaryWasAdded(scenarioResultSummary, 100);
    }

    @Test
    public void singleTestWithAFailure() throws Exception {
        ScenarioResultSummary scenarioResultSummary = this.getScenarioResultSummary(1, 1);
        ScenarioResultSummary[] scenarioResultSummaries = new ScenarioResultSummary[]{scenarioResultSummary};
        BulkTestRunResult bulkTestRunResult = this.getBulkRunResult(100, scenarioResultSummaries);
        this.bulkRunResultPresenter.setBulkTestRunResult(bulkTestRunResult);
        this.verifyBulkTestFailed();
        ((BulkRunResultView)Mockito.verify((Object)this.mockView)).setFailuresOutOfExpectation(1, 1);
        ((BulkRunResultView)Mockito.verify((Object)this.mockView)).setResultsPercent(0);
        ((BulkRunResultView)Mockito.verify((Object)this.mockView)).setRulesCoveredPercent(100);
        this.verifyNoUncoveredRules();
        this.verifyThatResultSummaryWasAdded(scenarioResultSummary, 0);
    }

    @Test
    public void testTestWithNoExpectations() throws Exception {
        ScenarioResultSummary scenarioResultSummary = new ScenarioResultSummary();
        scenarioResultSummary.setScenarioName("scenario");
        scenarioResultSummary.setUuid("uuid");
        scenarioResultSummary.setFailures(0);
        scenarioResultSummary.setTotal(0);
        ScenarioResultSummary[] scenarioResultSummaries = new ScenarioResultSummary[]{scenarioResultSummary};
        BulkTestRunResult bulkTestRunResult = this.getBulkRunResult(100, scenarioResultSummaries);
        this.bulkRunResultPresenter.setBulkTestRunResult(bulkTestRunResult);
        ((BulkRunResultView)Mockito.verify((Object)this.mockView)).addMissingExpectationSummaryTableRow("scenario", "uuid");
    }

    @Test
    public void threeTestsOneFailingTwoUncoveredRules() throws Exception {
        ScenarioResultSummary scenarioResultSummary1 = this.getScenarioResultSummary(1, 2);
        ScenarioResultSummary scenarioResultSummary2 = this.getScenarioResultSummary(0, 1);
        ScenarioResultSummary[] scenarioResultSummaries = new ScenarioResultSummary[]{scenarioResultSummary1, scenarioResultSummary2};
        BulkTestRunResult bulkTestRunResult = this.getBulkRunResult(100, scenarioResultSummaries);
        String[] uncoveredRules = new String[]{"I'm not covered 1", "I'm not covered 2"};
        bulkTestRunResult.setRulesNotCovered(uncoveredRules);
        this.bulkRunResultPresenter.setBulkTestRunResult(bulkTestRunResult);
        this.verifyBulkTestFailed();
        ((BulkRunResultView)Mockito.verify((Object)this.mockView)).setFailuresOutOfExpectation(1, 3);
        ((BulkRunResultView)Mockito.verify((Object)this.mockView)).setResultsPercent(66);
        ((BulkRunResultView)Mockito.verify((Object)this.mockView)).setRulesCoveredPercent(100);
        ((BulkRunResultView)Mockito.verify((Object)this.mockView)).addUncoveredRules("I'm not covered 1");
        ((BulkRunResultView)Mockito.verify((Object)this.mockView)).addUncoveredRules("I'm not covered 2");
        this.verifyThatResultSummaryWasAdded(scenarioResultSummary1, 50);
        this.verifyThatResultSummaryWasAdded(scenarioResultSummary2, 100);
    }

    private void verifyBulkTestSucceeded() {
        ((BulkRunResultView)Mockito.verify((Object)this.mockView, (VerificationMode)Mockito.never())).setFailed();
        ((BulkRunResultView)Mockito.verify((Object)this.mockView)).setSuccess();
    }

    private void verifyBulkTestFailed() {
        ((BulkRunResultView)Mockito.verify((Object)this.mockView)).setFailed();
        ((BulkRunResultView)Mockito.verify((Object)this.mockView, (VerificationMode)Mockito.never())).setSuccess();
    }

    private void verifyNoUncoveredRules() {
        ((BulkRunResultView)Mockito.verify((Object)this.mockView, (VerificationMode)Mockito.never())).addUncoveredRules(Matchers.anyString());
    }

    private void verifyThatResultSummaryWasAdded(ScenarioResultSummary scenarioResultSummary, int percentage) {
        ((BulkRunResultView)Mockito.verify((Object)this.mockView)).addNormalSummaryTableRow(scenarioResultSummary.getFailures(), scenarioResultSummary.getTotal(), scenarioResultSummary.getScenarioName(), percentage, scenarioResultSummary.getUuid());
    }

    private ScenarioResultSummary getScenarioResultSummary(int failures, int total) {
        ScenarioResultSummary scenarioResultSummary = new ScenarioResultSummary();
        scenarioResultSummary.setFailures(failures);
        scenarioResultSummary.setTotal(total);
        return scenarioResultSummary;
    }

    private BulkTestRunResult getBulkRunResult(int percentCovered, ScenarioResultSummary[] scenarioResultSummaries) {
        BulkTestRunResult bulkTestRunResult = new BulkTestRunResult();
        bulkTestRunResult.setPercentCovered(percentCovered);
        bulkTestRunResult.setResults(scenarioResultSummaries);
        return bulkTestRunResult;
    }
}

