/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.moduleeditor.drools;

import org.drools.guvnor.shared.modules.ModuleHeader;
import org.drools.guvnor.shared.modules.ModuleHeaderHelper;
import org.junit.Assert;
import org.junit.Test;

public class PackageHeaderWidgetTest {
    @Test
    public void testEmpty() {
        ModuleHeader mh = ModuleHeaderHelper.parseHeader(null);
        Assert.assertNotNull((Object)mh);
        Assert.assertNotNull((Object)mh.getGlobals());
        Assert.assertNotNull((Object)mh.getImports());
        mh = ModuleHeaderHelper.parseHeader((String)"");
        Assert.assertNotNull((Object)mh);
        Assert.assertNotNull((Object)mh.getGlobals());
        Assert.assertNotNull((Object)mh.getImports());
    }

    @Test
    public void testImports() {
        String s = "import goo.bar.Whee;\n\nimport wee.waah.Foo\nimport nee.Nah";
        ModuleHeader mh = ModuleHeaderHelper.parseHeader((String)s);
        Assert.assertNotNull((Object)mh);
        Assert.assertNotNull((Object)mh.getGlobals());
        Assert.assertNotNull((Object)mh.getImports());
        Assert.assertEquals((long)0L, (long)mh.getGlobals().size());
        Assert.assertEquals((long)3L, (long)mh.getImports().size());
        ModuleHeader.Import i = (ModuleHeader.Import)mh.getImports().get(0);
        Assert.assertEquals((Object)"goo.bar.Whee", (Object)i.getType());
        i = (ModuleHeader.Import)mh.getImports().get(1);
        Assert.assertEquals((Object)"wee.waah.Foo", (Object)i.getType());
        i = (ModuleHeader.Import)mh.getImports().get(2);
        Assert.assertEquals((Object)"nee.Nah", (Object)i.getType());
    }

    @Test
    public void testGlobals() {
        String s = "global goo.bar.Whee x;\n\nglobal wee.waah.Foo asd\nglobal nee.Nah d";
        ModuleHeader mh = ModuleHeaderHelper.parseHeader((String)s);
        Assert.assertNotNull((Object)mh);
        Assert.assertNotNull((Object)mh.getGlobals());
        Assert.assertNotNull((Object)mh.getImports());
        Assert.assertEquals((long)3L, (long)mh.getGlobals().size());
        Assert.assertEquals((long)0L, (long)mh.getImports().size());
        ModuleHeader.Global i = (ModuleHeader.Global)mh.getGlobals().get(0);
        Assert.assertEquals((Object)"goo.bar.Whee", (Object)i.getType());
        Assert.assertEquals((Object)"x", (Object)i.getName());
        i = (ModuleHeader.Global)mh.getGlobals().get(1);
        Assert.assertEquals((Object)"wee.waah.Foo", (Object)i.getType());
        Assert.assertEquals((Object)"asd", (Object)i.getName());
        i = (ModuleHeader.Global)mh.getGlobals().get(2);
        Assert.assertEquals((Object)"nee.Nah", (Object)i.getType());
        Assert.assertEquals((Object)"d", (Object)i.getName());
    }

    @Test
    public void testGlobalsImports() {
        String s = "import goo.bar.Whee;\n\nglobal wee.waah.Foo asd";
        ModuleHeader mh = ModuleHeaderHelper.parseHeader((String)s);
        Assert.assertNotNull((Object)mh);
        Assert.assertEquals((long)1L, (long)mh.getImports().size());
        Assert.assertEquals((long)1L, (long)mh.getGlobals().size());
        ModuleHeader.Import i = (ModuleHeader.Import)mh.getImports().get(0);
        Assert.assertEquals((Object)"goo.bar.Whee", (Object)i.getType());
        ModuleHeader.Global g = (ModuleHeader.Global)mh.getGlobals().get(0);
        Assert.assertEquals((Object)"wee.waah.Foo", (Object)g.getType());
        Assert.assertEquals((Object)"asd", (Object)g.getName());
    }

    @Test
    public void testAdvanced() {
        String s = "import goo.bar.Whee;\nglobal Wee waa;\n \nsomething else maybe dialect !";
        Assert.assertEquals(null, (Object)ModuleHeaderHelper.parseHeader((String)s));
    }

    @Test
    public void testRenderTypes() {
        ModuleHeader mh = new ModuleHeader();
        mh.getImports().add(new ModuleHeader.Import("foo.bar.Baz"));
        String h = ModuleHeaderHelper.renderModuleHeader((ModuleHeader)mh);
        Assert.assertNotNull((Object)h);
        Assert.assertEquals((Object)"import foo.bar.Baz", (Object)h.trim());
        mh = ModuleHeaderHelper.parseHeader((String)h);
        Assert.assertEquals((long)1L, (long)mh.getImports().size());
        ModuleHeader.Import i = (ModuleHeader.Import)mh.getImports().get(0);
        Assert.assertEquals((Object)"foo.bar.Baz", (Object)i.getType());
        mh.getGlobals().add(new ModuleHeader.Global("foo.Bar", "xs"));
        mh.getGlobals().add(new ModuleHeader.Global("whee.wah", "tt"));
        h = ModuleHeaderHelper.renderModuleHeader((ModuleHeader)mh);
        Assert.assertEquals((Object)"import foo.bar.Baz\nglobal foo.Bar xs\nglobal whee.wah tt", (Object)h.trim());
    }
}

