/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.widgets.drools.decoratedgrid;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.drools.guvnor.client.configurations.ApplicationPreferences;
import org.drools.guvnor.client.decisiontable.widget.DTCellValueUtilities;
import org.drools.guvnor.client.decisiontable.widget.DecisionTableCellValueFactory;
import org.drools.guvnor.client.util.DateConverter;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.CellValue;
import org.drools.guvnor.server.util.JVMDateConverter;
import org.drools.ide.common.client.modeldriven.ModelField;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.dt52.ActionInsertFactCol52;
import org.drools.ide.common.client.modeldriven.dt52.ActionSetFieldCol52;
import org.drools.ide.common.client.modeldriven.dt52.AttributeCol52;
import org.drools.ide.common.client.modeldriven.dt52.BaseColumn;
import org.drools.ide.common.client.modeldriven.dt52.ConditionCol52;
import org.drools.ide.common.client.modeldriven.dt52.DTCellValue52;
import org.drools.ide.common.client.modeldriven.dt52.DTDataTypes52;
import org.drools.ide.common.client.modeldriven.dt52.GuidedDecisionTable52;
import org.drools.ide.common.client.modeldriven.dt52.Pattern52;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CellValueFactoryTests {
    private SuggestionCompletionEngine sce = null;
    private GuidedDecisionTable52 dt = null;
    private DecisionTableCellValueFactory factory = null;
    private AttributeCol52 at1 = null;
    private AttributeCol52 at2 = null;
    private ConditionCol52 c1 = null;
    private ConditionCol52 c2 = null;
    private ConditionCol52 c3 = null;
    private ConditionCol52 c4 = null;
    private ConditionCol52 c5 = null;
    private ConditionCol52 c6 = null;
    private ConditionCol52 c7 = null;
    private ConditionCol52 c8 = null;
    private ConditionCol52 c9 = null;
    private ConditionCol52 c10 = null;
    private ConditionCol52 c11 = null;
    private ActionSetFieldCol52 a1 = null;
    private ActionInsertFactCol52 a2 = null;

    @Before
    public void setup() {
        this.sce = new SuggestionCompletionEngine();
        this.sce.setFieldsForTypes((Map)new HashMap<String, ModelField[]>(){
            {
                this.put("MyClass", new ModelField[]{new ModelField("bigDecimalField", Integer.class.getName(), ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, "BigDecimal"), new ModelField("bigIntegerField", Integer.class.getName(), ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, "BigInteger"), new ModelField("byteField", Integer.class.getName(), ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, "Byte"), new ModelField("doubleField", Integer.class.getName(), ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, "Double"), new ModelField("floatField", Integer.class.getName(), ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, "Float"), new ModelField("integerField", Integer.class.getName(), ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, "Integer"), new ModelField("longField", Integer.class.getName(), ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, "Long"), new ModelField("shortField", Integer.class.getName(), ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, "Short"), new ModelField("stringField", String.class.getName(), ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, "String"), new ModelField("dateField", Boolean.class.getName(), ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, "Date"), new ModelField("booleanField", Boolean.class.getName(), ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, "Boolean")});
            }
        });
        this.dt = new GuidedDecisionTable52();
        this.at1 = new AttributeCol52();
        this.at1.setAttribute("salience");
        this.at2 = new AttributeCol52();
        this.at2.setAttribute("enabled");
        this.dt.getAttributeCols().add(this.at1);
        this.dt.getAttributeCols().add(this.at2);
        Pattern52 p1 = new Pattern52();
        p1.setBoundName("c1");
        p1.setFactType("MyClass");
        this.c1 = new ConditionCol52();
        this.c1.setFactField("stringField");
        this.c1.setOperator("==");
        this.c1.setConstraintValueType(1);
        p1.getChildColumns().add(this.c1);
        this.dt.getConditions().add(p1);
        Pattern52 p2 = new Pattern52();
        p2.setBoundName("c2");
        p2.setFactType("MyClass");
        this.c2 = new ConditionCol52();
        this.c2.setFactField("bigDecimalField");
        this.c2.setOperator("==");
        this.c2.setConstraintValueType(1);
        p2.getChildColumns().add(this.c2);
        this.dt.getConditions().add(p2);
        this.c3 = new ConditionCol52();
        this.c3.setFactField("bigIntegerField");
        this.c3.setOperator("==");
        this.c3.setConstraintValueType(1);
        p2.getChildColumns().add(this.c3);
        this.c4 = new ConditionCol52();
        this.c4.setFactField("byteField");
        this.c4.setOperator("==");
        this.c4.setConstraintValueType(1);
        p2.getChildColumns().add(this.c4);
        this.c5 = new ConditionCol52();
        this.c5.setFactField("doubleField");
        this.c5.setOperator("==");
        this.c5.setConstraintValueType(1);
        p2.getChildColumns().add(this.c5);
        this.c6 = new ConditionCol52();
        this.c6.setFactField("floatField");
        this.c6.setOperator("==");
        this.c6.setConstraintValueType(1);
        p2.getChildColumns().add(this.c6);
        this.c7 = new ConditionCol52();
        this.c7.setFactField("integerField");
        this.c7.setOperator("==");
        this.c7.setConstraintValueType(1);
        p2.getChildColumns().add(this.c7);
        this.c8 = new ConditionCol52();
        this.c8.setFactField("longField");
        this.c8.setOperator("==");
        this.c8.setConstraintValueType(1);
        p2.getChildColumns().add(this.c8);
        this.c9 = new ConditionCol52();
        this.c9.setFactField("shortField");
        this.c9.setOperator("==");
        this.c9.setConstraintValueType(1);
        p2.getChildColumns().add(this.c9);
        Pattern52 p3 = new Pattern52();
        p3.setBoundName("c3");
        p3.setFactType("MyClass");
        this.c10 = new ConditionCol52();
        this.c10.setFactField("dateField");
        this.c10.setOperator("==");
        this.c10.setConstraintValueType(1);
        p3.getChildColumns().add(this.c10);
        this.dt.getConditions().add(p3);
        Pattern52 p4 = new Pattern52();
        p4.setBoundName("c4");
        p4.setFactType("MyClass");
        this.c11 = new ConditionCol52();
        this.c11.setFactField("booleanField");
        this.c11.setOperator("==");
        this.c11.setConstraintValueType(1);
        p4.getChildColumns().add(this.c11);
        this.dt.getConditions().add(p4);
        this.a1 = new ActionSetFieldCol52();
        this.a1.setBoundName("c1");
        this.a1.setFactField("stringField");
        this.dt.getActionCols().add(this.a1);
        this.a2 = new ActionInsertFactCol52();
        this.a2.setBoundName("a2");
        this.a2.setFactType("MyClass");
        this.a2.setFactField("stringField");
        this.dt.getActionCols().add(this.a2);
        this.factory = new DecisionTableCellValueFactory(this.dt, this.sce);
        HashMap<String, String> preferences = new HashMap<String, String>();
        preferences.put("drools.dateformat", "dd-MMM-yyyy");
        ApplicationPreferences.setUp(preferences);
        DTCellValueUtilities.injectDateConvertor((DateConverter)JVMDateConverter.getInstance());
    }

    @Test
    public void testDataTypes() {
        Calendar cdob = Calendar.getInstance();
        cdob.clear();
        cdob.set(2000, 0, 1);
        Date dob = cdob.getTime();
        DTCellValue52 dcv1 = new DTCellValue52(Boolean.TRUE);
        DTCellValue52 dcv2 = new DTCellValue52(dob);
        DTCellValue52 dcv3 = new DTCellValue52(new BigDecimal(1));
        DTCellValue52 dcv4 = new DTCellValue52(new BigInteger("1"));
        DTCellValue52 dcv5 = new DTCellValue52(new Byte("1"));
        DTCellValue52 dcv6 = new DTCellValue52(Double.valueOf(1.0));
        DTCellValue52 dcv7 = new DTCellValue52(Float.valueOf(1.0f));
        DTCellValue52 dcv8 = new DTCellValue52(new Integer(1));
        DTCellValue52 dcv9 = new DTCellValue52(Long.valueOf(1L));
        DTCellValue52 dcv10 = new DTCellValue52(new Short("1"));
        DTCellValue52 dcv11 = new DTCellValue52("Smurf");
        Assert.assertEquals((Object)dcv1.getDataType(), (Object)DTDataTypes52.BOOLEAN);
        Assert.assertEquals((Object)dcv2.getDataType(), (Object)DTDataTypes52.DATE);
        Assert.assertEquals((Object)dcv3.getDataType(), (Object)DTDataTypes52.NUMERIC_BIGDECIMAL);
        Assert.assertEquals((Object)dcv4.getDataType(), (Object)DTDataTypes52.NUMERIC_BIGINTEGER);
        Assert.assertEquals((Object)dcv5.getDataType(), (Object)DTDataTypes52.NUMERIC_BYTE);
        Assert.assertEquals((Object)dcv6.getDataType(), (Object)DTDataTypes52.NUMERIC_DOUBLE);
        Assert.assertEquals((Object)dcv7.getDataType(), (Object)DTDataTypes52.NUMERIC_FLOAT);
        Assert.assertEquals((Object)dcv8.getDataType(), (Object)DTDataTypes52.NUMERIC_INTEGER);
        Assert.assertEquals((Object)dcv9.getDataType(), (Object)DTDataTypes52.NUMERIC_LONG);
        Assert.assertEquals((Object)dcv10.getDataType(), (Object)DTDataTypes52.NUMERIC_SHORT);
        Assert.assertEquals((Object)dcv11.getDataType(), (Object)DTDataTypes52.STRING);
    }

    @Test
    public void testEmptyCells() {
        CellValue cell1 = this.factory.convertModelCellValue((BaseColumn)this.at1, new DTCellValue52());
        CellValue cell2 = this.factory.convertModelCellValue((BaseColumn)this.at2, new DTCellValue52());
        CellValue cell3 = this.factory.convertModelCellValue((BaseColumn)this.c1, new DTCellValue52());
        CellValue cell4 = this.factory.convertModelCellValue((BaseColumn)this.c2, new DTCellValue52());
        CellValue cell5 = this.factory.convertModelCellValue((BaseColumn)this.c3, new DTCellValue52());
        CellValue cell6 = this.factory.convertModelCellValue((BaseColumn)this.c4, new DTCellValue52());
        CellValue cell7 = this.factory.convertModelCellValue((BaseColumn)this.c5, new DTCellValue52());
        CellValue cell8 = this.factory.convertModelCellValue((BaseColumn)this.c6, new DTCellValue52());
        CellValue cell9 = this.factory.convertModelCellValue((BaseColumn)this.c7, new DTCellValue52());
        CellValue cell10 = this.factory.convertModelCellValue((BaseColumn)this.c8, new DTCellValue52());
        CellValue cell11 = this.factory.convertModelCellValue((BaseColumn)this.c9, new DTCellValue52());
        CellValue cell12 = this.factory.convertModelCellValue((BaseColumn)this.c10, new DTCellValue52());
        CellValue cell13 = this.factory.convertModelCellValue((BaseColumn)this.c11, new DTCellValue52());
        CellValue cell14 = this.factory.convertModelCellValue((BaseColumn)this.a1, new DTCellValue52());
        CellValue cell15 = this.factory.convertModelCellValue((BaseColumn)this.a2, new DTCellValue52());
        Assert.assertEquals((Object)cell1.getValue(), null);
        Assert.assertEquals((Object)cell2.getValue(), (Object)Boolean.FALSE);
        Assert.assertEquals((Object)cell3.getValue(), null);
        Assert.assertEquals((Object)cell4.getValue(), null);
        Assert.assertEquals((Object)cell5.getValue(), null);
        Assert.assertEquals((Object)cell6.getValue(), null);
        Assert.assertEquals((Object)cell7.getValue(), null);
        Assert.assertEquals((Object)cell8.getValue(), null);
        Assert.assertEquals((Object)cell9.getValue(), null);
        Assert.assertEquals((Object)cell10.getValue(), null);
        Assert.assertEquals((Object)cell11.getValue(), null);
        Assert.assertEquals((Object)cell12.getValue(), null);
        Assert.assertEquals((Object)cell13.getValue(), (Object)Boolean.FALSE);
        Assert.assertEquals((Object)cell14.getValue(), null);
        Assert.assertEquals((Object)cell15.getValue(), null);
    }

    @Test
    public void testTypedValues() {
        Calendar cdob = Calendar.getInstance();
        cdob.clear();
        cdob.set(2000, 0, 1);
        Date dob = cdob.getTime();
        DTCellValue52 dcv1 = new DTCellValue52(new Integer(1));
        DTCellValue52 dcv2 = new DTCellValue52(Boolean.TRUE);
        DTCellValue52 dcv3 = new DTCellValue52("Michael");
        DTCellValue52 dcv4 = new DTCellValue52(new BigDecimal(11));
        DTCellValue52 dcv5 = new DTCellValue52(new BigInteger("11"));
        DTCellValue52 dcv6 = new DTCellValue52(new Byte("11"));
        DTCellValue52 dcv7 = new DTCellValue52(Double.valueOf(11.0));
        DTCellValue52 dcv8 = new DTCellValue52(Float.valueOf(11.0f));
        DTCellValue52 dcv9 = new DTCellValue52(new Integer(11));
        DTCellValue52 dcv10 = new DTCellValue52(Long.valueOf(11L));
        DTCellValue52 dcv11 = new DTCellValue52(new Short("11"));
        DTCellValue52 dcv12 = new DTCellValue52(dob);
        DTCellValue52 dcv13 = new DTCellValue52(Boolean.TRUE);
        DTCellValue52 dcv14 = new DTCellValue52("Mike");
        DTCellValue52 dcv15 = new DTCellValue52("Mike");
        CellValue cell1 = this.factory.convertModelCellValue((BaseColumn)this.at1, dcv1);
        CellValue cell2 = this.factory.convertModelCellValue((BaseColumn)this.at2, dcv2);
        CellValue cell3 = this.factory.convertModelCellValue((BaseColumn)this.c1, dcv3);
        CellValue cell4 = this.factory.convertModelCellValue((BaseColumn)this.c2, dcv4);
        CellValue cell5 = this.factory.convertModelCellValue((BaseColumn)this.c3, dcv5);
        CellValue cell6 = this.factory.convertModelCellValue((BaseColumn)this.c4, dcv6);
        CellValue cell7 = this.factory.convertModelCellValue((BaseColumn)this.c5, dcv7);
        CellValue cell8 = this.factory.convertModelCellValue((BaseColumn)this.c6, dcv8);
        CellValue cell9 = this.factory.convertModelCellValue((BaseColumn)this.c7, dcv9);
        CellValue cell10 = this.factory.convertModelCellValue((BaseColumn)this.c8, dcv10);
        CellValue cell11 = this.factory.convertModelCellValue((BaseColumn)this.c9, dcv11);
        CellValue cell12 = this.factory.convertModelCellValue((BaseColumn)this.c10, dcv12);
        CellValue cell13 = this.factory.convertModelCellValue((BaseColumn)this.c11, dcv13);
        CellValue cell14 = this.factory.convertModelCellValue((BaseColumn)this.a1, dcv14);
        CellValue cell15 = this.factory.convertModelCellValue((BaseColumn)this.a2, dcv15);
        Assert.assertEquals((Object)cell1.getValue(), (Object)new Integer(1));
        Assert.assertEquals((Object)cell2.getValue(), (Object)Boolean.TRUE);
        Assert.assertEquals((Object)cell3.getValue(), (Object)"Michael");
        Assert.assertEquals((Object)cell4.getValue(), (Object)new BigDecimal(11));
        Assert.assertEquals((Object)cell5.getValue(), (Object)new BigInteger("11"));
        Assert.assertEquals((Object)cell6.getValue(), (Object)new Byte("11"));
        Assert.assertEquals((Object)cell7.getValue(), (Object)11.0);
        Assert.assertEquals((Object)cell8.getValue(), (Object)Float.valueOf(11.0f));
        Assert.assertEquals((Object)cell9.getValue(), (Object)new Integer(11));
        Assert.assertEquals((Object)cell10.getValue(), (Object)11L);
        Assert.assertEquals((Object)cell11.getValue(), (Object)new Short("11"));
        Assert.assertEquals((Object)cell12.getValue(), (Object)dob);
        Assert.assertEquals((Object)cell13.getValue(), (Object)Boolean.TRUE);
        Assert.assertEquals((Object)cell14.getValue(), (Object)"Mike");
        Assert.assertEquals((Object)cell15.getValue(), (Object)"Mike");
    }

    @Test
    public void testStringValues() {
        Calendar cdob = Calendar.getInstance();
        cdob.clear();
        cdob.set(2000, 0, 1);
        Date dob = cdob.getTime();
        DTCellValue52 dcv1 = new DTCellValue52("1");
        DTCellValue52 dcv2 = new DTCellValue52("true");
        DTCellValue52 dcv3 = new DTCellValue52("Michael");
        DTCellValue52 dcv4 = new DTCellValue52("11");
        DTCellValue52 dcv5 = new DTCellValue52("11");
        DTCellValue52 dcv6 = new DTCellValue52("11");
        DTCellValue52 dcv7 = new DTCellValue52("11");
        DTCellValue52 dcv8 = new DTCellValue52("11");
        DTCellValue52 dcv9 = new DTCellValue52("11");
        DTCellValue52 dcv10 = new DTCellValue52("11");
        DTCellValue52 dcv11 = new DTCellValue52("11");
        DTCellValue52 dcv12 = new DTCellValue52("01-JAN-2000");
        DTCellValue52 dcv13 = new DTCellValue52("true");
        DTCellValue52 dcv14 = new DTCellValue52("Mike");
        DTCellValue52 dcv15 = new DTCellValue52("Mike");
        CellValue cell1 = this.factory.convertModelCellValue((BaseColumn)this.at1, dcv1);
        CellValue cell2 = this.factory.convertModelCellValue((BaseColumn)this.at2, dcv2);
        CellValue cell3 = this.factory.convertModelCellValue((BaseColumn)this.c1, dcv3);
        CellValue cell4 = this.factory.convertModelCellValue((BaseColumn)this.c2, dcv4);
        CellValue cell5 = this.factory.convertModelCellValue((BaseColumn)this.c3, dcv5);
        CellValue cell6 = this.factory.convertModelCellValue((BaseColumn)this.c4, dcv6);
        CellValue cell7 = this.factory.convertModelCellValue((BaseColumn)this.c5, dcv7);
        CellValue cell8 = this.factory.convertModelCellValue((BaseColumn)this.c6, dcv8);
        CellValue cell9 = this.factory.convertModelCellValue((BaseColumn)this.c7, dcv9);
        CellValue cell10 = this.factory.convertModelCellValue((BaseColumn)this.c8, dcv10);
        CellValue cell11 = this.factory.convertModelCellValue((BaseColumn)this.c9, dcv11);
        CellValue cell12 = this.factory.convertModelCellValue((BaseColumn)this.c10, dcv12);
        CellValue cell13 = this.factory.convertModelCellValue((BaseColumn)this.c11, dcv13);
        CellValue cell14 = this.factory.convertModelCellValue((BaseColumn)this.a1, dcv14);
        CellValue cell15 = this.factory.convertModelCellValue((BaseColumn)this.a2, dcv15);
        Assert.assertEquals((Object)cell1.getValue(), (Object)new Integer(1));
        Assert.assertEquals((Object)cell2.getValue(), (Object)Boolean.TRUE);
        Assert.assertEquals((Object)cell3.getValue(), (Object)"Michael");
        Assert.assertEquals((Object)cell4.getValue(), (Object)new BigDecimal(11));
        Assert.assertEquals((Object)cell5.getValue(), (Object)new BigInteger("11"));
        Assert.assertEquals((Object)cell6.getValue(), (Object)new Byte("11"));
        Assert.assertEquals((Object)cell7.getValue(), (Object)11.0);
        Assert.assertEquals((Object)cell8.getValue(), (Object)Float.valueOf(11.0f));
        Assert.assertEquals((Object)cell9.getValue(), (Object)new Integer(11));
        Assert.assertEquals((Object)cell10.getValue(), (Object)11L);
        Assert.assertEquals((Object)cell11.getValue(), (Object)new Short("11"));
        Assert.assertEquals((Object)cell12.getValue(), (Object)dob);
        Assert.assertEquals((Object)cell13.getValue(), (Object)Boolean.TRUE);
        Assert.assertEquals((Object)cell14.getValue(), (Object)"Mike");
        Assert.assertEquals((Object)cell15.getValue(), (Object)"Mike");
    }

    @Test
    public void testConversionEmptyValues() {
        DTCellValue52 dcv1 = new DTCellValue52("");
        DTCellValue52 dcv2 = new DTCellValue52("");
        DTCellValue52 dcv3 = new DTCellValue52("");
        DTCellValue52 dcv4 = new DTCellValue52("");
        DTCellValue52 dcv5 = new DTCellValue52("");
        DTCellValue52 dcv6 = new DTCellValue52("");
        DTCellValue52 dcv7 = new DTCellValue52("");
        DTCellValue52 dcv8 = new DTCellValue52("");
        DTCellValue52 dcv9 = new DTCellValue52("");
        DTCellValue52 dcv10 = new DTCellValue52("");
        DTCellValue52 dcv11 = new DTCellValue52("");
        DTCellValue52 dcv12 = new DTCellValue52("");
        DTCellValue52 dcv13 = new DTCellValue52("");
        DTCellValue52 dcv14 = new DTCellValue52("");
        DTCellValue52 dcv15 = new DTCellValue52("");
        CellValue cell1 = this.factory.convertModelCellValue((BaseColumn)this.at1, dcv1);
        CellValue cell2 = this.factory.convertModelCellValue((BaseColumn)this.at2, dcv2);
        CellValue cell3 = this.factory.convertModelCellValue((BaseColumn)this.c1, dcv3);
        CellValue cell4 = this.factory.convertModelCellValue((BaseColumn)this.c2, dcv4);
        CellValue cell5 = this.factory.convertModelCellValue((BaseColumn)this.c3, dcv5);
        CellValue cell6 = this.factory.convertModelCellValue((BaseColumn)this.c4, dcv6);
        CellValue cell7 = this.factory.convertModelCellValue((BaseColumn)this.c5, dcv7);
        CellValue cell8 = this.factory.convertModelCellValue((BaseColumn)this.c6, dcv8);
        CellValue cell9 = this.factory.convertModelCellValue((BaseColumn)this.c7, dcv9);
        CellValue cell10 = this.factory.convertModelCellValue((BaseColumn)this.c8, dcv10);
        CellValue cell11 = this.factory.convertModelCellValue((BaseColumn)this.c9, dcv11);
        CellValue cell12 = this.factory.convertModelCellValue((BaseColumn)this.c10, dcv12);
        CellValue cell13 = this.factory.convertModelCellValue((BaseColumn)this.c11, dcv13);
        CellValue cell14 = this.factory.convertModelCellValue((BaseColumn)this.a1, dcv14);
        CellValue cell15 = this.factory.convertModelCellValue((BaseColumn)this.a2, dcv15);
        Assert.assertEquals((Object)cell1.getValue(), null);
        Assert.assertEquals((Object)cell2.getValue(), (Object)Boolean.FALSE);
        Assert.assertEquals((Object)cell3.getValue(), null);
        Assert.assertEquals((Object)cell4.getValue(), null);
        Assert.assertEquals((Object)cell5.getValue(), null);
        Assert.assertEquals((Object)cell6.getValue(), null);
        Assert.assertEquals((Object)cell7.getValue(), null);
        Assert.assertEquals((Object)cell8.getValue(), null);
        Assert.assertEquals((Object)cell9.getValue(), null);
        Assert.assertEquals((Object)cell10.getValue(), null);
        Assert.assertEquals((Object)cell11.getValue(), null);
        Assert.assertEquals((Object)cell12.getValue(), null);
        Assert.assertEquals((Object)cell13.getValue(), (Object)Boolean.FALSE);
        Assert.assertEquals((Object)cell14.getValue(), null);
        Assert.assertEquals((Object)cell15.getValue(), null);
        Assert.assertEquals((Object)dcv1.getDataType(), (Object)DTDataTypes52.NUMERIC_INTEGER);
        Assert.assertEquals((Object)dcv2.getDataType(), (Object)DTDataTypes52.BOOLEAN);
        Assert.assertEquals((Object)dcv3.getDataType(), (Object)DTDataTypes52.STRING);
        Assert.assertEquals((Object)dcv4.getDataType(), (Object)DTDataTypes52.NUMERIC_BIGDECIMAL);
        Assert.assertEquals((Object)dcv5.getDataType(), (Object)DTDataTypes52.NUMERIC_BIGINTEGER);
        Assert.assertEquals((Object)dcv6.getDataType(), (Object)DTDataTypes52.NUMERIC_BYTE);
        Assert.assertEquals((Object)dcv7.getDataType(), (Object)DTDataTypes52.NUMERIC_DOUBLE);
        Assert.assertEquals((Object)dcv8.getDataType(), (Object)DTDataTypes52.NUMERIC_FLOAT);
        Assert.assertEquals((Object)dcv9.getDataType(), (Object)DTDataTypes52.NUMERIC_INTEGER);
        Assert.assertEquals((Object)dcv10.getDataType(), (Object)DTDataTypes52.NUMERIC_LONG);
        Assert.assertEquals((Object)dcv11.getDataType(), (Object)DTDataTypes52.NUMERIC_SHORT);
        Assert.assertEquals((Object)dcv12.getDataType(), (Object)DTDataTypes52.DATE);
        Assert.assertEquals((Object)dcv13.getDataType(), (Object)DTDataTypes52.BOOLEAN);
        Assert.assertEquals((Object)dcv14.getDataType(), (Object)DTDataTypes52.STRING);
        Assert.assertEquals((Object)dcv15.getDataType(), (Object)DTDataTypes52.STRING);
    }
}

