/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.drools.guvnor.client.rpc.PushResponse;
import org.drools.guvnor.server.Backchannel;
import org.drools.guvnor.server.test.GuvnorIntegrationTest;
import org.junit.Assert;
import org.junit.Test;

public class BackchannelIntegrationTest
extends GuvnorIntegrationTest {
    @Inject
    private Backchannel backchannel;

    @Test
    public void testPushAll() throws Exception {
        final PushResponse[] resp = new PushResponse[2];
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    List r = BackchannelIntegrationTest.this.backchannel.await("mic");
                    Assert.assertEquals((long)1L, (long)r.size());
                    resp[0] = (PushResponse)r.get(0);
                }
                catch (InterruptedException e) {
                    Assert.fail((String)"should not interrupt");
                }
            }
        });
        Thread t2 = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    List r = BackchannelIntegrationTest.this.backchannel.await("jazz");
                    Assert.assertEquals((long)1L, (long)r.size());
                    resp[1] = (PushResponse)r.get(0);
                }
                catch (InterruptedException e) {
                    Assert.fail((String)"should not interrupt");
                }
            }
        });
        t.start();
        t2.start();
        Thread.sleep(200L);
        this.backchannel.publish(new PushResponse("hey", "ho"));
        Thread.sleep(500L);
        Assert.assertNotNull((Object)resp[0]);
        Assert.assertNotNull((Object)resp[1]);
        Assert.assertEquals((Object)"hey", (Object)resp[0].messageType);
        Assert.assertEquals((Object)"hey", (Object)resp[1].messageType);
    }

    @Test
    public void testSimple() throws Exception {
        this.backchannel.push("mici", new PushResponse("m", "b"));
        this.backchannel.push("davos", new PushResponse("d", "b"));
        List r = this.backchannel.await("mici");
        Assert.assertEquals((long)1L, (long)r.size());
        Assert.assertEquals((Object)"m", (Object)((PushResponse)r.get((int)0)).messageType);
        r = this.backchannel.await("davos");
        Assert.assertEquals((long)1L, (long)r.size());
        Assert.assertEquals((Object)"d", (Object)((PushResponse)r.get((int)0)).messageType);
        final boolean[] check = new boolean[1];
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    List list = BackchannelIntegrationTest.this.backchannel.await("mici");
                    check[0] = true;
                }
                catch (InterruptedException e) {
                    Assert.fail((String)"Should not interrupt");
                }
            }
        });
        t.setDaemon(true);
        t.start();
        Thread.sleep(400L);
        Assert.assertFalse((boolean)check[0]);
        this.backchannel.push("davos", new PushResponse("x", "y"));
        t.join();
        check[0] = false;
        this.backchannel.push("mici", new PushResponse("R", "T"));
        this.backchannel.push("mici", new PushResponse("Q", "A"));
        final ArrayList container = new ArrayList();
        t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    container.add(BackchannelIntegrationTest.this.backchannel.await("mici"));
                    check[0] = true;
                }
                catch (InterruptedException e) {
                    Assert.fail((String)"Should not interrupt");
                }
            }
        });
        t.setDaemon(true);
        t.start();
        t.join();
        Assert.assertTrue((boolean)check[0]);
        Assert.assertEquals((long)1L, (long)container.size());
        List list = (List)container.get(0);
        if (list.size() > 2) {
            for (PushResponse resp : list) {
                System.err.println(resp.messageType + "," + resp.message);
            }
        }
        Assert.assertEquals((long)2L, (long)list.size());
    }

    @Test
    public void testManyConcurrent() throws Exception {
        for (int i = 0; i < 1000; ++i) {
            this.spinup(this.backchannel, i);
        }
        this.backchannel.push("mc", new PushResponse("yo", "yo"));
        this.backchannel.push("mc", new PushResponse("yo", "yo"));
        List res = this.backchannel.await("mc");
        Assert.assertEquals((long)2L, (long)res.size());
        res = this.backchannel.await("mc");
        Assert.assertEquals((long)0L, (long)res.size());
        Thread.sleep(20L);
        for (int i = 0; i < 20000; ++i) {
            this.backchannel.push("mc", new PushResponse("yo", "yo"));
            this.backchannel.push("mc", new PushResponse("yo", "yo"));
            res = this.backchannel.await("mc");
            Assert.assertEquals((long)2L, (long)res.size());
        }
    }

    private void spinup(final Backchannel bc, final int i) {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(i / 2);
                }
                catch (InterruptedException e) {
                    Assert.fail((String)"should not interrupt");
                }
                bc.push(i + "user", new PushResponse(i + "type", "message"));
            }
        });
        t.setDaemon(true);
        t.start();
    }
}

