/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server;

import com.google.gwt.user.client.rpc.SerializationException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import org.drools.guvnor.client.rpc.AssetPageRequest;
import org.drools.guvnor.client.rpc.PageResponse;
import org.drools.guvnor.client.rpc.TableDataResult;
import org.drools.guvnor.client.rpc.TableDataRow;
import org.drools.guvnor.server.RepositoryAssetOperations;
import org.drools.guvnor.server.util.AssetEditorConfiguration;
import org.drools.guvnor.server.util.AssetEditorConfigurationParser;
import org.drools.repository.AssetHistoryIterator;
import org.drools.repository.AssetItem;
import org.drools.repository.AssetItemIterator;
import org.drools.repository.ModuleItem;
import org.drools.repository.RulesRepository;
import org.drools.repository.VersionableItem;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class RepositoryAssetOperationsTest {
    @Test
    public void testRenameAsset() {
        RulesRepository rulesRepository = (RulesRepository)Mockito.mock(RulesRepository.class);
        RepositoryAssetOperations repositoryAssetOperations = new RepositoryAssetOperations();
        repositoryAssetOperations.setRulesRepositoryForTest(rulesRepository);
        Mockito.when((Object)rulesRepository.renameAsset("uuid", "newname")).thenReturn((Object)"uuid");
        Assert.assertEquals((Object)repositoryAssetOperations.renameAsset("uuid", "newname"), (Object)"uuid");
    }

    @Test
    public void testLoadAssetHistoryIsNull() throws SerializationException {
        RulesRepository rulesRepository = (RulesRepository)Mockito.mock(RulesRepository.class);
        RepositoryAssetOperations repositoryAssetOperations = new RepositoryAssetOperations();
        repositoryAssetOperations.setRulesRepositoryForTest(rulesRepository);
        AssetItem assetItem = (AssetItem)Mockito.mock(AssetItem.class);
        AssetHistoryIterator assetHistoryIterator = (AssetHistoryIterator)Mockito.mock(AssetHistoryIterator.class);
        Mockito.when((Object)assetItem.getHistory()).thenReturn((Object)assetHistoryIterator);
        Calendar calendar = GregorianCalendar.getInstance();
        Mockito.when((Object)assetItem.getLastModified()).thenReturn((Object)calendar);
        TableDataResult result = repositoryAssetOperations.loadItemHistory((VersionableItem)assetItem);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)0L, (long)result.data.length);
    }

    @Test
    public void testLoadAssetHistoryAndHistoryDoesNotExistsAndNullIsReturned() throws SerializationException {
        RulesRepository rulesRepository = (RulesRepository)Mockito.mock(RulesRepository.class);
        RepositoryAssetOperations repositoryAssetOperations = new RepositoryAssetOperations();
        repositoryAssetOperations.setRulesRepositoryForTest(rulesRepository);
        AssetItem assetItem = this.initializeAssetItemMockForLoadAssetHistory();
        AssetHistoryIterator assetHistoryIterator = (AssetHistoryIterator)Mockito.mock(AssetHistoryIterator.class);
        Mockito.when((Object)assetItem.getHistory()).thenReturn((Object)assetHistoryIterator);
        Mockito.when((Object)assetHistoryIterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        AssetItem historicalAssetItem = this.initializeAssetItemHistoryMockForLoadAssetHistory(assetHistoryIterator);
        Mockito.when((Object)historicalAssetItem.getVersionNumber()).thenReturn((Object)1324567L);
        Calendar calendar = GregorianCalendar.getInstance();
        Mockito.when((Object)historicalAssetItem.getLastModified()).thenReturn((Object)calendar);
        Assert.assertNotNull((Object)repositoryAssetOperations.loadItemHistory((VersionableItem)assetItem));
    }

    @Test
    public void testLoadAssetHistoryAndHistoryExists() throws SerializationException {
        RulesRepository rulesRepository = (RulesRepository)Mockito.mock(RulesRepository.class);
        RepositoryAssetOperations repositoryAssetOperations = new RepositoryAssetOperations();
        repositoryAssetOperations.setRulesRepositoryForTest(rulesRepository);
        AssetItem assetItem = this.initializeAssetItemMockForLoadAssetHistory();
        AssetHistoryIterator assetHistoryIterator = (AssetHistoryIterator)Mockito.mock(AssetHistoryIterator.class);
        Mockito.when((Object)assetItem.getHistory()).thenReturn((Object)assetHistoryIterator);
        Mockito.when((Object)assetHistoryIterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        AssetItem historicalAssetItem = this.initializeAssetItemHistoryMockForLoadAssetHistory(assetHistoryIterator);
        Mockito.when((Object)historicalAssetItem.getVersionNumber()).thenReturn((Object)123456L);
        Calendar calendar = GregorianCalendar.getInstance();
        Mockito.when((Object)historicalAssetItem.getLastModified()).thenReturn((Object)calendar);
        TableDataResult tableDataResult = repositoryAssetOperations.loadItemHistory((VersionableItem)assetItem);
        Assert.assertNotNull((Object)tableDataResult);
        TableDataRow[] tableDataRow = tableDataResult.data;
        Assert.assertNotNull((Object)tableDataRow);
        Assert.assertEquals((long)tableDataRow.length, (long)1L);
    }

    private AssetItem initializeAssetItemMockForLoadAssetHistory() {
        AssetItem assetItem = (AssetItem)Mockito.mock(AssetItem.class);
        Mockito.when((Object)assetItem.getVersionNumber()).thenReturn((Object)1324567L);
        return assetItem;
    }

    private AssetItem initializeAssetItemHistoryMockForLoadAssetHistory(AssetHistoryIterator assetHistoryIterator) {
        AssetItem historicalAssetItem = (AssetItem)Mockito.mock(AssetItem.class);
        Mockito.when((Object)assetHistoryIterator.next()).thenReturn((Object)historicalAssetItem);
        return historicalAssetItem;
    }

    @Test
    public void testLoadArchivedAssetsReturnOne() throws SerializationException {
        RulesRepository rulesRepository = (RulesRepository)Mockito.mock(RulesRepository.class);
        AssetItemIterator assetItemIterator = (AssetItemIterator)Mockito.mock(AssetItemIterator.class);
        Mockito.when((Object)assetItemIterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        this.initializeAssetItemMockForLoadArchivedAssets(rulesRepository, assetItemIterator);
        RepositoryAssetOperations repositoryAssetOperations = new RepositoryAssetOperations();
        repositoryAssetOperations.setRulesRepositoryForTest(rulesRepository);
        TableDataResult loadArchivedAssets = repositoryAssetOperations.loadArchivedAssets(0, 1);
        Assert.assertEquals((long)loadArchivedAssets.data.length, (long)1L);
    }

    @Test
    public void testLoadArchivedAssetsReturnLessThanIsAvailable() throws SerializationException {
        RulesRepository rulesRepository = (RulesRepository)Mockito.mock(RulesRepository.class);
        AssetItemIterator assetItemIterator = (AssetItemIterator)Mockito.mock(AssetItemIterator.class);
        Mockito.when((Object)assetItemIterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{true, true, false});
        this.initializeAssetItemMockForLoadArchivedAssets(rulesRepository, assetItemIterator);
        RepositoryAssetOperations repositoryAssetOperations = new RepositoryAssetOperations();
        repositoryAssetOperations.setRulesRepositoryForTest(rulesRepository);
        TableDataResult loadArchivedAssets = repositoryAssetOperations.loadArchivedAssets(0, 2);
        Assert.assertEquals((long)loadArchivedAssets.data.length, (long)2L);
    }

    private void initializeAssetItemMockForLoadArchivedAssets(RulesRepository rulesRepository, AssetItemIterator assetItemIterator) {
        AssetItem assetItem = (AssetItem)Mockito.mock(AssetItem.class);
        Mockito.when((Object)assetItem.getLastModified()).thenReturn((Object)GregorianCalendar.getInstance());
        Mockito.when((Object)assetItemIterator.next()).thenReturn((Object)assetItem);
        Mockito.when((Object)rulesRepository.findArchivedAssets()).thenReturn((Object)assetItemIterator);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFindAssetPageFormatInListAndFormatIsRegisteredIsNotSupported() throws SerializationException {
        RulesRepository rulesRepository = (RulesRepository)Mockito.mock(RulesRepository.class);
        RepositoryAssetOperations repositoryAssetOperations = new RepositoryAssetOperations();
        repositoryAssetOperations.setRulesRepositoryForTest(rulesRepository);
        AssetPageRequest assetPageRequest = new AssetPageRequest("uuid", Arrays.asList("formatInList"), Boolean.valueOf(true), 0, Integer.valueOf(10));
        repositoryAssetOperations.findAssetPage(assetPageRequest);
    }

    @Test
    public void testFindAssetPageFormatInList() throws SerializationException {
        RulesRepository rulesRepository = (RulesRepository)Mockito.mock(RulesRepository.class);
        RepositoryAssetOperations repositoryAssetOperations = new RepositoryAssetOperations();
        repositoryAssetOperations.setRulesRepositoryForTest(rulesRepository);
        AssetPageRequest assetPageRequest = new AssetPageRequest("uuid", Arrays.asList("formatInList"), null, 1, Integer.valueOf(2));
        ModuleItem packageItem = (ModuleItem)Mockito.mock(ModuleItem.class);
        Mockito.when((Object)rulesRepository.loadModuleByUUID(Mockito.anyString())).thenReturn((Object)packageItem);
        AssetItemIterator assetItemIterator = (AssetItemIterator)Mockito.mock(AssetItemIterator.class);
        Mockito.when((Object)packageItem.listAssetsByFormat(assetPageRequest.getFormatInList())).thenReturn((Object)assetItemIterator);
        PageResponse pageResponse = repositoryAssetOperations.findAssetPage(assetPageRequest);
        Assert.assertNotNull((Object)pageResponse);
        Assert.assertEquals((long)pageResponse.getStartRowIndex(), (long)1L);
        ((ModuleItem)Mockito.verify((Object)packageItem)).listAssetsByFormat(assetPageRequest.getFormatInList());
    }

    @Test
    public void testFindAssetPageFormatInList2() throws SerializationException {
        RulesRepository rulesRepository = (RulesRepository)Mockito.mock(RulesRepository.class);
        RepositoryAssetOperations repositoryAssetOperations = new RepositoryAssetOperations();
        repositoryAssetOperations.setRulesRepositoryForTest(rulesRepository);
        AssetPageRequest assetPageRequest = new AssetPageRequest("uuid", Arrays.asList("formatInList"), null, 1, Integer.valueOf(10));
        ModuleItem packageItem = (ModuleItem)Mockito.mock(ModuleItem.class);
        Mockito.when((Object)rulesRepository.loadModuleByUUID(Mockito.anyString())).thenReturn((Object)packageItem);
        AssetItem a1 = (AssetItem)Mockito.mock(AssetItem.class);
        Mockito.when((Object)a1.getFormat()).thenReturn((Object)"formatInList");
        Mockito.when((Object)a1.getCreatedDate()).thenReturn((Object)Calendar.getInstance());
        Mockito.when((Object)a1.getLastModified()).thenReturn((Object)Calendar.getInstance());
        AssetItemIterator assetItemIterator = (AssetItemIterator)Mockito.mock(AssetItemIterator.class);
        Mockito.when((Object)assetItemIterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        Mockito.when((Object)assetItemIterator.next()).thenReturn((Object)a1);
        Mockito.when((Object)packageItem.listAssetsByFormat(assetPageRequest.getFormatInList())).thenReturn((Object)assetItemIterator);
        PageResponse pageResponse = repositoryAssetOperations.findAssetPage(assetPageRequest);
        Assert.assertNotNull((Object)pageResponse);
        Assert.assertEquals((long)pageResponse.getStartRowIndex(), (long)1L);
        Assert.assertEquals((long)1L, (long)pageResponse.getPageRowList().size());
        ((ModuleItem)Mockito.verify((Object)packageItem)).listAssetsByFormat(assetPageRequest.getFormatInList());
    }

    @Test
    public void testFindAssetPageFormatInList3() throws SerializationException {
        RulesRepository rulesRepository = (RulesRepository)Mockito.mock(RulesRepository.class);
        RepositoryAssetOperations repositoryAssetOperations = new RepositoryAssetOperations();
        repositoryAssetOperations.setRulesRepositoryForTest(rulesRepository);
        AssetPageRequest assetPageRequest = new AssetPageRequest("uuid", null, Boolean.valueOf(false), 1, Integer.valueOf(10));
        ModuleItem packageItem = (ModuleItem)Mockito.mock(ModuleItem.class);
        Mockito.when((Object)rulesRepository.loadModuleByUUID(Mockito.anyString())).thenReturn((Object)packageItem);
        AssetItem a1 = (AssetItem)Mockito.mock(AssetItem.class);
        Mockito.when((Object)a1.getFormat()).thenReturn((Object)"formatNotInList");
        Mockito.when((Object)a1.getCreatedDate()).thenReturn((Object)Calendar.getInstance());
        Mockito.when((Object)a1.getLastModified()).thenReturn((Object)Calendar.getInstance());
        AssetItemIterator assetItemIterator = (AssetItemIterator)Mockito.mock(AssetItemIterator.class);
        Mockito.when((Object)assetItemIterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        Mockito.when((Object)assetItemIterator.next()).thenReturn((Object)a1);
        String[] registeredFormats = this.registeredFormats();
        Mockito.when((Object)packageItem.listAssetsNotOfFormat(registeredFormats)).thenReturn((Object)assetItemIterator);
        PageResponse pageResponse = repositoryAssetOperations.findAssetPage(assetPageRequest);
        Assert.assertNotNull((Object)pageResponse);
        Assert.assertEquals((long)pageResponse.getStartRowIndex(), (long)1L);
        Assert.assertEquals((long)1L, (long)pageResponse.getPageRowList().size());
        ((ModuleItem)Mockito.verify((Object)packageItem)).listAssetsNotOfFormat(registeredFormats);
    }

    private String[] registeredFormats() {
        AssetEditorConfigurationParser parser = new AssetEditorConfigurationParser();
        List rfs = parser.getAssetEditors();
        String[] registeredFormats = new String[rfs.size()];
        for (int i = 0; i < rfs.size(); ++i) {
            registeredFormats[i] = ((AssetEditorConfiguration)rfs.get(i)).getFormat();
        }
        return registeredFormats;
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetAssetCountFormatInListAndFormatIsRegisteredIsNotSupported() throws SerializationException {
        RulesRepository rulesRepository = (RulesRepository)Mockito.mock(RulesRepository.class);
        RepositoryAssetOperations repositoryAssetOperations = new RepositoryAssetOperations();
        repositoryAssetOperations.setRulesRepositoryForTest(rulesRepository);
        AssetPageRequest assetPageRequest = new AssetPageRequest("uuid", Arrays.asList("formatInList"), Boolean.valueOf(true));
        repositoryAssetOperations.getAssetCount(assetPageRequest);
    }

    @Test
    public void testGetAssetCountFormatInList() throws SerializationException {
        RulesRepository rulesRepository = (RulesRepository)Mockito.mock(RulesRepository.class);
        RepositoryAssetOperations repositoryAssetOperations = new RepositoryAssetOperations();
        repositoryAssetOperations.setRulesRepositoryForTest(rulesRepository);
        AssetPageRequest assetPageRequest = new AssetPageRequest("uuid", Arrays.asList("formatInList"), null);
        ModuleItem packageItem = (ModuleItem)Mockito.mock(ModuleItem.class);
        Mockito.when((Object)rulesRepository.loadModuleByUUID(Mockito.anyString())).thenReturn((Object)packageItem);
        AssetItemIterator assetItemIterator = (AssetItemIterator)Mockito.mock(AssetItemIterator.class);
        Mockito.when((Object)packageItem.listAssetsByFormat(assetPageRequest.getFormatInList())).thenReturn((Object)assetItemIterator);
        Mockito.when((Object)assetItemIterator.getSize()).thenReturn((Object)0L);
        long count = repositoryAssetOperations.getAssetCount(assetPageRequest);
        Assert.assertEquals((long)0L, (long)count);
        ((ModuleItem)Mockito.verify((Object)packageItem)).listAssetsByFormat(assetPageRequest.getFormatInList());
    }

    @Test
    public void testGetAssetCountFormatInList2() throws SerializationException {
        RulesRepository rulesRepository = (RulesRepository)Mockito.mock(RulesRepository.class);
        RepositoryAssetOperations repositoryAssetOperations = new RepositoryAssetOperations();
        repositoryAssetOperations.setRulesRepositoryForTest(rulesRepository);
        AssetPageRequest assetPageRequest = new AssetPageRequest("uuid", Arrays.asList("formatInList"), null);
        ModuleItem packageItem = (ModuleItem)Mockito.mock(ModuleItem.class);
        Mockito.when((Object)rulesRepository.loadModuleByUUID(Mockito.anyString())).thenReturn((Object)packageItem);
        AssetItem a1 = (AssetItem)Mockito.mock(AssetItem.class);
        Mockito.when((Object)a1.getFormat()).thenReturn((Object)"formatInList");
        Mockito.when((Object)a1.getCreatedDate()).thenReturn((Object)Calendar.getInstance());
        Mockito.when((Object)a1.getLastModified()).thenReturn((Object)Calendar.getInstance());
        AssetItemIterator assetItemIterator = (AssetItemIterator)Mockito.mock(AssetItemIterator.class);
        Mockito.when((Object)packageItem.listAssetsByFormat(assetPageRequest.getFormatInList())).thenReturn((Object)assetItemIterator);
        Mockito.when((Object)assetItemIterator.getSize()).thenReturn((Object)1L);
        long count = repositoryAssetOperations.getAssetCount(assetPageRequest);
        Assert.assertEquals((long)1L, (long)count);
        ((ModuleItem)Mockito.verify((Object)packageItem)).listAssetsByFormat(assetPageRequest.getFormatInList());
    }

    @Test
    public void testGetAssetCountFormatInList3() throws SerializationException {
        RulesRepository rulesRepository = (RulesRepository)Mockito.mock(RulesRepository.class);
        RepositoryAssetOperations repositoryAssetOperations = new RepositoryAssetOperations();
        repositoryAssetOperations.setRulesRepositoryForTest(rulesRepository);
        AssetPageRequest assetPageRequest = new AssetPageRequest("uuid", null, Boolean.valueOf(false));
        ModuleItem packageItem = (ModuleItem)Mockito.mock(ModuleItem.class);
        Mockito.when((Object)rulesRepository.loadModuleByUUID(Mockito.anyString())).thenReturn((Object)packageItem);
        AssetItem a1 = (AssetItem)Mockito.mock(AssetItem.class);
        Mockito.when((Object)a1.getFormat()).thenReturn((Object)"formatNotInList");
        Mockito.when((Object)a1.getCreatedDate()).thenReturn((Object)Calendar.getInstance());
        Mockito.when((Object)a1.getLastModified()).thenReturn((Object)Calendar.getInstance());
        AssetItemIterator assetItemIterator = (AssetItemIterator)Mockito.mock(AssetItemIterator.class);
        Mockito.when((Object)assetItemIterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        Mockito.when((Object)assetItemIterator.next()).thenReturn((Object)a1);
        String[] registeredFormats = this.registeredFormats();
        Mockito.when((Object)packageItem.listAssetsNotOfFormat(registeredFormats)).thenReturn((Object)assetItemIterator);
        Mockito.when((Object)assetItemIterator.getSize()).thenReturn((Object)0L);
        long count = repositoryAssetOperations.getAssetCount(assetPageRequest);
        Assert.assertEquals((long)0L, (long)count);
        ((ModuleItem)Mockito.verify((Object)packageItem)).listAssetsNotOfFormat(registeredFormats);
    }
}

