/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server;

import com.google.gwt.user.client.rpc.SerializationException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.drools.KnowledgeBase;
import org.drools.Person;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.core.util.DroolsStreamUtils;
import org.drools.core.util.FileManager;
import org.drools.guvnor.client.rpc.Asset;
import org.drools.guvnor.client.rpc.BuilderResult;
import org.drools.guvnor.client.rpc.BuilderResultLine;
import org.drools.guvnor.client.rpc.DetailedSerializationException;
import org.drools.guvnor.client.rpc.Module;
import org.drools.guvnor.client.rpc.SnapshotComparisonPageRequest;
import org.drools.guvnor.client.rpc.SnapshotComparisonPageResponse;
import org.drools.guvnor.client.rpc.SnapshotComparisonPageRow;
import org.drools.guvnor.client.rpc.SnapshotDiff;
import org.drools.guvnor.client.rpc.SnapshotDiffs;
import org.drools.guvnor.client.rpc.SnapshotInfo;
import org.drools.guvnor.client.rpc.TableDataResult;
import org.drools.guvnor.client.rpc.ValidatedResponse;
import org.drools.guvnor.server.test.GuvnorIntegrationTest;
import org.drools.guvnor.server.util.DroolsHeader;
import org.drools.guvnor.shared.api.PortableObject;
import org.drools.ide.common.client.modeldriven.brl.ActionFieldValue;
import org.drools.ide.common.client.modeldriven.brl.ActionSetField;
import org.drools.ide.common.client.modeldriven.brl.FactPattern;
import org.drools.ide.common.client.modeldriven.brl.FieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.IAction;
import org.drools.ide.common.client.modeldriven.brl.IPattern;
import org.drools.ide.common.client.modeldriven.brl.RuleModel;
import org.drools.ide.common.client.modeldriven.brl.SingleFieldConstraint;
import org.drools.ide.common.server.util.BRXMLPersistence;
import org.drools.io.Resource;
import org.drools.io.impl.InputStreamResource;
import org.drools.repository.AssetItem;
import org.drools.repository.ModuleItem;
import org.drools.repository.ModuleIterator;
import org.drools.repository.RulesRepository;
import org.drools.repository.RulesRepositoryException;
import org.drools.rule.Package;
import org.drools.runtime.StatelessKnowledgeSession;
import org.junit.Assert;
import org.junit.Test;

public class RepositoryPackageServiceIntegrationTest
extends GuvnorIntegrationTest {
    @Test
    public void testSnapshotDiff() throws Exception {
        this.repositoryCategoryService.createCategory("/", "snapshotDiffTesting", "y");
        String packageUuid = this.repositoryPackageService.createModule("testSnapshotDiff", "d", "package");
        Assert.assertNotNull((Object)packageUuid);
        String archiveRuleUuid = this.serviceImplementation.createNewRule("testRuleArchived", "", "snapshotDiffTesting", "testSnapshotDiff", "drl");
        String modifiedRuleUuid = this.serviceImplementation.createNewRule("testRuleModified", "", "snapshotDiffTesting", "testSnapshotDiff", "drl");
        String deletedRuleUuid = this.serviceImplementation.createNewRule("testRuleDeleted", "", "snapshotDiffTesting", "testSnapshotDiff", "drl");
        String restoredRuleUuid = this.serviceImplementation.createNewRule("testRuleRestored", "", "snapshotDiffTesting", "testSnapshotDiff", "drl");
        String noChangesRuleUuid = this.serviceImplementation.createNewRule("testRuleNoChanges", "", "snapshotDiffTesting", "testSnapshotDiff", "drl");
        this.repositoryAssetService.archiveAsset(restoredRuleUuid);
        this.repositoryPackageService.createModuleSnapshot("testSnapshotDiff", "FIRST", false, "ya");
        Assert.assertEquals((long)1L, (long)this.repositoryPackageService.listSnapshots("testSnapshotDiff").length);
        Assert.assertEquals((long)4L, (long)this.repositoryPackageService.listRulesInPackage("testSnapshotDiff").length);
        Asset asset = this.repositoryAssetService.loadRuleAsset(modifiedRuleUuid);
        String uuid = this.repositoryAssetService.checkinVersion(asset);
        Assert.assertNotNull((Object)uuid);
        this.repositoryAssetService.removeAsset(deletedRuleUuid);
        this.repositoryAssetService.archiveAsset(archiveRuleUuid);
        String addedRuleUuid = this.serviceImplementation.createNewRule("testRuleAdded", "", "snapshotDiffTesting", "testSnapshotDiff", "drl");
        this.repositoryAssetService.unArchiveAsset(restoredRuleUuid);
        this.repositoryPackageService.createModuleSnapshot("testSnapshotDiff", "SECOND", false, "we");
        Assert.assertEquals((long)2L, (long)this.repositoryPackageService.listSnapshots("testSnapshotDiff").length);
        Assert.assertEquals((long)4L, (long)this.repositoryPackageService.listRulesInPackage("testSnapshotDiff").length);
        SnapshotDiffs diffs = this.repositoryPackageService.compareSnapshots("testSnapshotDiff", "FIRST", "SECOND");
        Assert.assertEquals((Object)"FIRST", (Object)diffs.leftName);
        Assert.assertEquals((Object)"SECOND", (Object)diffs.rightName);
        SnapshotDiff[] list = diffs.diffs;
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((long)5L, (long)list.length);
        for (int i = 0; i < list.length; ++i) {
            SnapshotDiff diff = list[i];
            if (diff.name.equals("testRuleArchived")) {
                Assert.assertEquals((Object)"TYPE_ARCHIVED", (Object)diff.diffType);
                Assert.assertNotNull((Object)diff.leftUuid);
                Assert.assertNotNull((Object)diff.rightUuid);
                continue;
            }
            if (diff.name.equals("testRuleModified")) {
                Assert.assertEquals((Object)"TYPE_UPDATED", (Object)diff.diffType);
                Assert.assertNotNull((Object)diff.leftUuid);
                Assert.assertNotNull((Object)diff.rightUuid);
                continue;
            }
            if (diff.name.equals("testRuleAdded")) {
                Assert.assertEquals((Object)"TYPE_ADDED", (Object)diff.diffType);
                Assert.assertNull((Object)diff.leftUuid);
                Assert.assertNotNull((Object)diff.rightUuid);
                continue;
            }
            if (diff.name.equals("testRuleDeleted")) {
                Assert.assertEquals((Object)"TYPE_DELETED", (Object)diff.diffType);
                Assert.assertNotNull((Object)diff.leftUuid);
                Assert.assertNull((Object)diff.rightUuid);
                continue;
            }
            if (diff.name.equals("testRuleRestored")) {
                Assert.assertEquals((Object)"TYPE_RESTORED", (Object)diff.diffType);
                Assert.assertNotNull((Object)diff.leftUuid);
                Assert.assertNotNull((Object)diff.rightUuid);
                continue;
            }
            Assert.fail((String)"Diff not expected.");
        }
    }

    @Test
    public void testPackageBinaryUpdatedResetWhenDeletingAnAsset() throws Exception {
        ModuleItem packageItem = this.rulesRepository.createModule("testPackageBinaryUpdatedResetWhenDeletingAnAsset", "");
        AssetItem assetItem = packageItem.addAsset("temp", "");
        Assert.assertNotNull((Object)packageItem.getName());
        packageItem.updateBinaryUpToDate(true);
        Assert.assertTrue((boolean)packageItem.isBinaryUpToDate());
        packageItem.checkin("");
        this.serviceImplementation.deleteUncheckedRule(assetItem.getUUID());
        ModuleItem reloadedPackage = this.rulesRepository.loadModule(packageItem.getName());
        Assert.assertEquals((Object)packageItem.getName(), (Object)reloadedPackage.getName());
        Assert.assertFalse((boolean)reloadedPackage.isBinaryUpToDate());
    }

    @Test
    public void testGetHistoryPackageBinary() throws Exception {
        RulesRepository repo = this.rulesRepository;
        ModuleItem pkg = repo.createModule("testGetHistoryPackageBinary", "");
        Assert.assertFalse((boolean)pkg.isBinaryUpToDate());
        DroolsHeader.updateDroolsHeader((String)"import org.drools.Person", (ModuleItem)pkg);
        AssetItem rule1 = pkg.addAsset("rule_1", "");
        rule1.updateFormat("drl");
        rule1.updateContent("rule 'rule1' \n when \np : Person() \n then \np.setAge(42); \n end");
        rule1.checkin("");
        repo.save();
        Assert.assertFalse((boolean)pkg.isBinaryUpToDate());
        pkg.checkout();
        pkg.checkin("version1");
        ModuleItem p = repo.loadModule("testGetHistoryPackageBinary", 2L);
        Assert.assertEquals((Object)"version1", (Object)p.getCheckinComment());
        Assert.assertFalse((boolean)p.isBinaryUpToDate());
        byte[] result = p.getCompiledBinaryBytes();
        Assert.assertNull((Object)result);
    }

    @Test
    public void testDependencyHistoryPackage() throws Exception {
        ModuleItem pkg = this.rulesRepository.createModule("testDependencyHistoryPackage", "");
        AssetItem func = pkg.addAsset("func", "");
        func.updateFormat("function");
        func.updateContent("function void foo() { System.out.println(version 1); }");
        func.checkin("func version 1");
        func.updateContent("function void foo() { System.out.println(version 2); }");
        func.checkin("func version 2");
        pkg.checkout();
        pkg.checkin("package version 2");
        pkg.updateDependency("func?version=1");
        pkg.checkin("package version 3");
        func.updateContent("function void foo() { System.out.println(version 2); }");
        func.checkin("func version 3");
        pkg.checkout();
        pkg.checkin("package version 4");
        ModuleItem item = this.rulesRepository.loadModule("testDependencyHistoryPackage");
        Assert.assertEquals((Object)"package version 4", (Object)item.getCheckinComment());
        Assert.assertEquals((Object)"func?version=1", (Object)item.getDependencies()[0]);
        item = this.rulesRepository.loadModule("testDependencyHistoryPackage", 2L);
        Assert.assertEquals((Object)"package version 2", (Object)item.getCheckinComment());
        Assert.assertEquals((Object)"func?version=2", (Object)item.getDependencies()[0]);
        item = this.rulesRepository.loadModule("testDependencyHistoryPackage", 3L);
        Assert.assertEquals((Object)"package version 3", (Object)item.getCheckinComment());
        Assert.assertEquals((Object)"func?version=1", (Object)item.getDependencies()[0]);
    }

    @Test
    public void testMovePackage() throws Exception {
        String[] cats = this.repositoryCategoryService.loadChildCategories("/");
        if (cats.length == 0) {
            this.repositoryCategoryService.createCategory("/", "la", "d");
        }
        String sourcePkgId = this.repositoryPackageService.createModule("sourcePackage", "description", "package");
        String destPkgId = this.repositoryPackageService.createModule("targetPackage", "description", "package");
        String cat = this.repositoryCategoryService.loadChildCategories("/")[0];
        String uuid = this.serviceImplementation.createNewRule("testMovePackage", "desc", cat, "sourcePackage", "drl");
        TableDataResult res = this.repositoryAssetService.listAssets(destPkgId, new String[]{"drl"}, 0, 2, "rulelist");
        Assert.assertEquals((long)0L, (long)res.data.length);
        this.repositoryAssetService.changeAssetPackage(uuid, "targetPackage", "yeah");
        res = this.repositoryAssetService.listAssets(destPkgId, new String[]{"drl"}, 0, 2, "rulelist");
        Assert.assertEquals((long)1L, (long)res.data.length);
        res = this.repositoryAssetService.listAssets(sourcePkgId, new String[]{"drl"}, 0, 2, "rulelist");
        Assert.assertEquals((long)0L, (long)res.data.length);
    }

    @Test
    public void testSnapshot() throws Exception {
        this.repositoryCategoryService.createCategory("/", "snapshotTesting", "y");
        this.repositoryPackageService.createModule("testSnapshot", "d", "package");
        String uuid = this.serviceImplementation.createNewRule("testSnapshotRule", "", "snapshotTesting", "testSnapshot", "drl");
        this.repositoryPackageService.createModuleSnapshot("testSnapshot", "X", false, "ya");
        SnapshotInfo[] snaps = this.repositoryPackageService.listSnapshots("testSnapshot");
        Assert.assertEquals((long)1L, (long)snaps.length);
        Assert.assertEquals((Object)"X", (Object)snaps[0].getName());
        Assert.assertEquals((Object)"ya", (Object)snaps[0].getComment());
        Assert.assertNotNull((Object)snaps[0].getUuid());
        Module confSnap = this.repositoryPackageService.loadModule(snaps[0].getUuid());
        Assert.assertEquals((Object)"testSnapshot", (Object)confSnap.getName());
        this.repositoryPackageService.createModuleSnapshot("testSnapshot", "Y", false, "we");
        Assert.assertEquals((long)2L, (long)this.repositoryPackageService.listSnapshots("testSnapshot").length);
        this.repositoryPackageService.createModuleSnapshot("testSnapshot", "X", true, "we");
        Assert.assertEquals((long)2L, (long)this.repositoryPackageService.listSnapshots("testSnapshot").length);
        this.repositoryPackageService.copyOrRemoveSnapshot("testSnapshot", "X", false, "Q");
        Assert.assertEquals((long)3L, (long)this.repositoryPackageService.listSnapshots("testSnapshot").length);
        try {
            this.repositoryPackageService.copyOrRemoveSnapshot("testSnapshot", "X", false, "");
            Assert.fail((String)"should not be able to copy snapshot to empty detination");
        }
        catch (SerializationException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
        this.repositoryPackageService.copyOrRemoveSnapshot("testSnapshot", "X", true, null);
        Assert.assertEquals((long)2L, (long)this.repositoryPackageService.listSnapshots("testSnapshot").length);
    }

    @Test
    public void testSnapshotRebuild() throws Exception {
        ModuleItem pkg;
        RulesRepository repo = this.rulesRepository;
        ModuleIterator pkit = repo.listModules();
        while (pkit.hasNext()) {
            String[] snaps;
            pkg = (ModuleItem)pkit.next();
            for (String snapName : snaps = repo.listModuleSnapshots(pkg.getName())) {
                repo.removeModuleSnapshot(pkg.getName(), snapName);
            }
        }
        pkg = repo.createModule("testSnapshotRebuild", "");
        DroolsHeader.updateDroolsHeader((String)"import java.util.List", (ModuleItem)pkg);
        repo.save();
        AssetItem item = pkg.addAsset("anAsset", "");
        item.updateFormat("drl");
        item.updateContent(" rule abc \n when \n then \n System.out.println(42); \n end");
        item.checkin("");
        BuilderResult builderResult = this.repositoryPackageService.buildPackage(pkg.getUUID(), true);
        Assert.assertFalse((boolean)builderResult.hasLines());
        this.repositoryPackageService.createModuleSnapshot("testSnapshotRebuild", "SNAP", false, "");
        ModuleItem snap = repo.loadModuleSnapshot("testSnapshotRebuild", "SNAP");
        long snapTime = snap.getLastModified().getTimeInMillis();
        Thread.sleep(100L);
        this.repositoryPackageService.rebuildSnapshots();
        ModuleItem snap_ = repo.loadModuleSnapshot("testSnapshotRebuild", "SNAP");
        long newTime = snap_.getLastModified().getTimeInMillis();
        Assert.assertTrue((newTime > snapTime ? 1 : 0) != 0);
        item.updateContent("garbage");
        item.checkin("");
        this.repositoryPackageService.createModuleSnapshot("testSnapshotRebuild", "SNAP2", false, "");
        try {
            this.repositoryPackageService.rebuildSnapshots();
        }
        catch (DetailedSerializationException e) {
            Assert.assertNotNull((Object)e.getMessage());
            Assert.assertNotNull((Object)e.getLongDescription());
        }
    }

    @Test
    public void testPackageRebuild() throws Exception {
        RulesRepository repo = this.rulesRepository;
        ModuleItem pkg = repo.createModule("testPackageRebuild", "");
        DroolsHeader.updateDroolsHeader((String)"import java.util.List", (ModuleItem)pkg);
        repo.save();
        AssetItem item = pkg.addAsset("anAsset", "");
        item.updateFormat("drl");
        item.updateContent(" rule abc \n when \n then \n System.out.println(42); \n end");
        item.checkin("");
        Assert.assertNull((Object)pkg.getCompiledBinaryBytes());
        long last = pkg.getLastModified().getTimeInMillis();
        Thread.sleep(100L);
        try {
            this.repositoryPackageService.rebuildPackages();
        }
        catch (DetailedSerializationException e) {
            Assert.assertNotNull((Object)e.getMessage());
            Assert.assertNotNull((Object)e.getLongDescription());
        }
        Assert.assertFalse((pkg.getLastModified().getTimeInMillis() == last ? 1 : 0) != 0);
        Assert.assertNotNull((Object)pkg.getCompiledBinaryBytes());
    }

    @Test
    public void testExportPackage() throws Exception {
        int n = this.repositoryPackageService.listModules().length;
        this.repositoryCategoryService.createCategory("/", "testExportPackageCat1", "desc");
        this.repositoryCategoryService.createCategory("/", "testExportPackageCat2", "desc");
        ModuleItem p = this.rulesRepository.createModule("testExportPackage", "");
        String uuid1 = this.serviceImplementation.createNewRule("testExportPackageAsset1", "desc", "testExportPackageCat1", "testExportPackage", "dsl");
        String uuid2 = this.serviceImplementation.createNewRule("testExportPackageAsset2", "desc", "testExportPackageCat2", "testExportPackage", "dsl");
        byte[] exportedPackage = this.repositoryPackageService.exportModules("testExportPackage");
        Assert.assertNotNull((Object)exportedPackage);
        File file = new File("testExportPackage.xml");
        FileOutputStream fos = new FileOutputStream(file);
        fos.write(exportedPackage);
        fos.close();
        file.delete();
    }

    @Test
    public void testArchivePackage() throws Exception {
        Module[] pkgs = this.repositoryPackageService.listModules();
        Module[] arch = this.repositoryPackageService.listArchivedModules();
        this.repositoryPackageService.createModule("testCreateArchivedPackage", "this is a new package", "package");
        ModuleItem item = this.rulesRepository.loadModule("testCreateArchivedPackage");
        TableDataResult td = this.repositoryAssetService.loadArchivedAssets(0, 1000);
        item.archiveItem(true);
        item.checkin("");
        TableDataResult td2 = this.repositoryAssetService.loadArchivedAssets(0, 1000);
        Assert.assertEquals((long)td2.data.length, (long)td.data.length);
        Module[] arch2 = this.repositoryPackageService.listArchivedModules();
        Assert.assertEquals((long)(arch.length + 1), (long)arch2.length);
        Assert.assertEquals((long)pkgs.length, (long)this.repositoryPackageService.listModules().length);
        item.archiveItem(false);
        item.checkin("");
        arch2 = this.repositoryPackageService.listArchivedModules();
        Assert.assertEquals((long)arch2.length, (long)arch.length);
    }

    @Test
    public void testCreatePackage() throws Exception {
        Module[] pkgs = this.repositoryPackageService.listModules();
        String uuid = this.repositoryPackageService.createModule("testCreatePackage", "this is a new package", "package");
        Assert.assertNotNull((Object)uuid);
        ModuleItem item = this.rulesRepository.loadModule("testCreatePackage");
        Assert.assertNotNull((Object)item);
        Assert.assertEquals((Object)"this is a new package", (Object)item.getDescription());
        Assert.assertEquals((long)(pkgs.length + 1), (long)this.repositoryPackageService.listModules().length);
        Module conf = this.repositoryPackageService.loadModule(uuid);
        Assert.assertEquals((Object)"this is a new package", (Object)conf.getDescription());
        Assert.assertNotNull((Object)conf.getLastModified());
        pkgs = this.repositoryPackageService.listModules();
        this.repositoryPackageService.copyModule("testCreatePackage", "testCreatePackage_COPY");
        Assert.assertEquals((long)(pkgs.length + 1), (long)this.repositoryPackageService.listModules().length);
        try {
            this.repositoryPackageService.copyModule("testCreatePackage", "testCreatePackage_COPY");
        }
        catch (RulesRepositoryException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
    }

    @Test
    public void testLoadPackageConfig() throws Exception {
        ModuleItem it = this.rulesRepository.loadDefaultModule();
        String uuid = it.getUUID();
        it.updateCoverage("xyz");
        it.updateExternalURI("ext");
        DroolsHeader.updateDroolsHeader((String)"header", (ModuleItem)it);
        this.rulesRepository.save();
        Module data = this.repositoryPackageService.loadModule(uuid);
        Assert.assertNotNull((Object)data);
        Assert.assertEquals((Object)"defaultPackage", (Object)data.getName());
        Assert.assertEquals((Object)"header", (Object)data.getHeader());
        Assert.assertEquals((Object)"ext", (Object)data.getExternalURI());
        Assert.assertNotNull((Object)data.getUuid());
        Assert.assertFalse((boolean)data.isSnapshot());
        Assert.assertNotNull((Object)data.getDateCreated());
        Date original = data.getLastModified();
        Thread.sleep(100L);
        this.repositoryPackageService.createModuleSnapshot("defaultPackage", "TEST SNAP 2.0", false, "ya");
        ModuleItem loaded = this.rulesRepository.loadModuleSnapshot("defaultPackage", "TEST SNAP 2.0");
        data = this.repositoryPackageService.loadModule(loaded.getUUID());
        Assert.assertTrue((boolean)data.isSnapshot());
        Assert.assertEquals((Object)"TEST SNAP 2.0", (Object)data.getSnapshotName());
        Assert.assertFalse((boolean)original.equals(data.getLastModified()));
        Assert.assertEquals((Object)"ya", (Object)data.getCheckinComment());
    }

    @Test
    public void testArchiveAndUnarchivePackageAndHeader() throws Exception {
        String uuid = this.repositoryPackageService.createModule("testArchiveAndUnarchivePackageAndHeader", "a desc", "package");
        Module data = this.repositoryPackageService.loadModule(uuid);
        ModuleItem it = this.rulesRepository.loadModuleByUUID(uuid);
        data.setArchived(true);
        AssetItem rule1 = it.addAsset("rule_1", "");
        rule1.updateFormat("drl");
        rule1.updateContent("rule 'rule1' \n when \np : Person() \n then \np.setAge(42); \n end");
        rule1.archiveItem(true);
        rule1.checkin("");
        this.rulesRepository.save();
        this.repositoryPackageService.saveModule(data);
        data = this.repositoryPackageService.loadModule(uuid);
        it = this.rulesRepository.loadModule(data.getName());
        Assert.assertTrue((boolean)data.isArchived());
        Assert.assertTrue((boolean)it.loadAsset("drools").isArchived());
        Assert.assertTrue((boolean)it.loadAsset("rule_1").isArchived());
        data.setArchived(false);
        this.repositoryPackageService.saveModule(data);
        data = this.repositoryPackageService.loadModule(uuid);
        it = this.rulesRepository.loadModule(data.getName());
        Assert.assertFalse((boolean)data.isArchived());
        Assert.assertFalse((boolean)it.loadAsset("drools").isArchived());
        Assert.assertTrue((boolean)it.loadAsset("rule_1").isArchived());
        data.setArchived(true);
        this.repositoryPackageService.saveModule(data);
        data = this.repositoryPackageService.loadModule(uuid);
        it = this.rulesRepository.loadModule(data.getName());
        Assert.assertTrue((boolean)data.isArchived());
        Assert.assertTrue((boolean)it.loadAsset("drools").isArchived());
        Assert.assertTrue((boolean)it.loadAsset("rule_1").isArchived());
    }

    @Test
    public void testPackageConfSave() throws Exception {
        String uuid = this.repositoryPackageService.createModule("testPackageConfSave", "a desc", "package");
        Module data = this.repositoryPackageService.loadModule(uuid);
        data.setDescription("new desc");
        data.setHeader("wa");
        data.setExternalURI("new URI");
        this.repositoryPackageService.saveModule(data);
        ValidatedResponse res = this.droolsServiceImplementation.validateModule(data);
        Assert.assertNotNull((Object)res);
        Assert.assertTrue((boolean)res.hasErrors);
        Assert.assertNotNull((Object)res.errorMessage);
        data = this.repositoryPackageService.loadModule(uuid);
        Assert.assertEquals((Object)"new desc", (Object)data.getDescription());
        Assert.assertEquals((Object)"wa", (Object)data.getHeader());
        Assert.assertEquals((Object)"new URI", (Object)data.getExternalURI());
        data.setHeader("");
        res = this.droolsServiceImplementation.validateModule(data);
        if (res.hasErrors) {
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            System.out.println(res.errorMessage);
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
        }
        Assert.assertFalse((boolean)res.hasErrors);
    }

    @Test
    public void testUpdateModuleFormat() throws Exception {
        String uuid = this.repositoryPackageService.createModule("testUpdateModuleFormat", "a desc", "package");
        Module data = this.repositoryPackageService.loadModule(uuid);
        Assert.assertEquals((Object)"a desc", (Object)data.getDescription());
        Assert.assertEquals((Object)"package", (Object)data.getFormat());
        data.setFormat("SOAService");
        this.repositoryPackageService.saveModule(data);
        data = this.repositoryPackageService.loadModule(uuid);
        Assert.assertEquals((Object)"SOAService", (Object)data.getFormat());
    }

    @Test
    public void testRemovePackage() throws Exception {
        int n = this.repositoryPackageService.listModules().length;
        ModuleItem p = this.rulesRepository.createModule("testRemovePackage", "");
        Assert.assertNotNull((Object)this.repositoryPackageService.loadModule(p.getUUID()));
        this.repositoryPackageService.removeModule(p.getUUID());
        Assert.assertEquals((long)n, (long)this.repositoryPackageService.listModules().length);
    }

    @Test
    public void testSnapshotDiffPagedResults() throws Exception {
        int PAGE_SIZE = 2;
        this.repositoryCategoryService.createCategory("/", "testSnapshotDiffPagedResultsCategory", "testSnapshotDiffPagedResultsCategoryDescription");
        String packageUuid = this.repositoryPackageService.createModule("testSnapshotDiffPagedResultsPackage", "testSnapshotDiffPagedResultsPackageDescription", "package");
        Assert.assertNotNull((Object)packageUuid);
        String archiveRuleUuid = this.serviceImplementation.createNewRule("testRuleArchived", "testRuleArchivedDescription", "testSnapshotDiffPagedResultsCategory", "testSnapshotDiffPagedResultsPackage", "drl");
        String modifiedRuleUuid = this.serviceImplementation.createNewRule("testRuleModified", "testRuleModifiedDescription", "testSnapshotDiffPagedResultsCategory", "testSnapshotDiffPagedResultsPackage", "drl");
        String deletedRuleUuid = this.serviceImplementation.createNewRule("testRuleDeleted", "testRuleDeletedDescription", "testSnapshotDiffPagedResultsCategory", "testSnapshotDiffPagedResultsPackage", "drl");
        String restoredRuleUuid = this.serviceImplementation.createNewRule("testRuleRestored", "testRuleRestoredDescription", "testSnapshotDiffPagedResultsCategory", "testSnapshotDiffPagedResultsPackage", "drl");
        this.repositoryAssetService.archiveAsset(restoredRuleUuid);
        String noChangesRuleUuid = this.serviceImplementation.createNewRule("testRuleNoChanges", "testRuleNoChangesDescription", "testSnapshotDiffPagedResultsCategory", "testSnapshotDiffPagedResultsPackage", "drl");
        this.repositoryPackageService.createModuleSnapshot("testSnapshotDiffPagedResultsPackage", "FIRST", false, "First snapshot");
        Assert.assertEquals((long)1L, (long)this.repositoryPackageService.listSnapshots("testSnapshotDiffPagedResultsPackage").length);
        Assert.assertEquals((long)4L, (long)this.repositoryPackageService.listRulesInPackage("testSnapshotDiffPagedResultsPackage").length);
        Asset asset = this.repositoryAssetService.loadRuleAsset(modifiedRuleUuid);
        String uuid = this.repositoryAssetService.checkinVersion(asset);
        Assert.assertNotNull((Object)uuid);
        this.repositoryAssetService.removeAsset(deletedRuleUuid);
        this.repositoryAssetService.archiveAsset(archiveRuleUuid);
        String addedRuleUuid = this.serviceImplementation.createNewRule("testRuleAdded", "testRuleAddedDescription", "testSnapshotDiffPagedResultsCategory", "testSnapshotDiffPagedResultsPackage", "drl");
        this.repositoryAssetService.unArchiveAsset(restoredRuleUuid);
        this.repositoryPackageService.createModuleSnapshot("testSnapshotDiffPagedResultsPackage", "SECOND", false, "Second snapshot");
        Assert.assertEquals((long)2L, (long)this.repositoryPackageService.listSnapshots("testSnapshotDiffPagedResultsPackage").length);
        Assert.assertEquals((long)4L, (long)this.repositoryPackageService.listRulesInPackage("testSnapshotDiffPagedResultsPackage").length);
        SnapshotComparisonPageRequest request = new SnapshotComparisonPageRequest("testSnapshotDiffPagedResultsPackage", "FIRST", "SECOND", 0, Integer.valueOf(2));
        SnapshotComparisonPageResponse response = this.repositoryPackageService.compareSnapshots(request);
        Assert.assertEquals((Object)"FIRST", (Object)response.getLeftSnapshotName());
        Assert.assertEquals((Object)"SECOND", (Object)response.getRightSnapshotName());
        Assert.assertNotNull((Object)response);
        Assert.assertNotNull((Object)response.getPageRowList());
        Assert.assertTrue((response.getStartRowIndex() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((response.getPageRowList().size() == 2 ? 1 : 0) != 0);
        Assert.assertFalse((boolean)response.isLastPage());
        request.setStartRowIndex(2);
        response = this.repositoryPackageService.compareSnapshots(request);
        Assert.assertNotNull((Object)response);
        Assert.assertNotNull((Object)response.getPageRowList());
        Assert.assertTrue((response.getStartRowIndex() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((response.getPageRowList().size() == 2 ? 1 : 0) != 0);
        Assert.assertFalse((boolean)response.isLastPage());
        request.setStartRowIndex(4);
        response = this.repositoryPackageService.compareSnapshots(request);
        Assert.assertNotNull((Object)response);
        Assert.assertNotNull((Object)response.getPageRowList());
        Assert.assertTrue((response.getStartRowIndex() == 4 ? 1 : 0) != 0);
        Assert.assertTrue((response.getPageRowList().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)response.isLastPage());
    }

    @Test
    public void testSnapshotDiffFullResults() throws Exception {
        this.repositoryCategoryService.createCategory("/", "testSnapshotDiffFullResultsCategory", "testSnapshotDiffFullResultsCategoryDescription");
        String packageUuid = this.repositoryPackageService.createModule("testSnapshotDiffFullResultsPackage", "testSnapshotDiffFullResultsPackageDescription", "package");
        Assert.assertNotNull((Object)packageUuid);
        String archiveRuleUuid = this.serviceImplementation.createNewRule("testRuleArchived", "testRuleArchivedDescription", "testSnapshotDiffFullResultsCategory", "testSnapshotDiffFullResultsPackage", "drl");
        String modifiedRuleUuid = this.serviceImplementation.createNewRule("testRuleModified", "testRuleModifiedDescription", "testSnapshotDiffFullResultsCategory", "testSnapshotDiffFullResultsPackage", "drl");
        String deletedRuleUuid = this.serviceImplementation.createNewRule("testRuleDeleted", "testRuleDeletedDescription", "testSnapshotDiffFullResultsCategory", "testSnapshotDiffFullResultsPackage", "drl");
        String restoredRuleUuid = this.serviceImplementation.createNewRule("testRuleRestored", "testRuleRestoredDescription", "testSnapshotDiffFullResultsCategory", "testSnapshotDiffFullResultsPackage", "drl");
        this.repositoryAssetService.archiveAsset(restoredRuleUuid);
        String noChangesRuleUuid = this.serviceImplementation.createNewRule("testRuleNoChanges", "testRuleNoChangesDescription", "testSnapshotDiffFullResultsCategory", "testSnapshotDiffFullResultsPackage", "drl");
        this.repositoryPackageService.createModuleSnapshot("testSnapshotDiffFullResultsPackage", "FIRST", false, "First snapshot");
        Assert.assertEquals((long)1L, (long)this.repositoryPackageService.listSnapshots("testSnapshotDiffFullResultsPackage").length);
        Assert.assertEquals((long)4L, (long)this.repositoryPackageService.listRulesInPackage("testSnapshotDiffFullResultsPackage").length);
        Asset asset = this.repositoryAssetService.loadRuleAsset(modifiedRuleUuid);
        String uuid = this.repositoryAssetService.checkinVersion(asset);
        Assert.assertNotNull((Object)uuid);
        this.repositoryAssetService.removeAsset(deletedRuleUuid);
        this.repositoryAssetService.archiveAsset(archiveRuleUuid);
        String addedRuleUuid = this.serviceImplementation.createNewRule("testRuleAdded", "testRuleAddedDescription", "testSnapshotDiffFullResultsCategory", "testSnapshotDiffFullResultsPackage", "drl");
        this.repositoryAssetService.unArchiveAsset(restoredRuleUuid);
        this.repositoryPackageService.createModuleSnapshot("testSnapshotDiffFullResultsPackage", "SECOND", false, "Second snapshot");
        Assert.assertEquals((long)2L, (long)this.repositoryPackageService.listSnapshots("testSnapshotDiffFullResultsPackage").length);
        Assert.assertEquals((long)4L, (long)this.repositoryPackageService.listRulesInPackage("testSnapshotDiffFullResultsPackage").length);
        SnapshotComparisonPageRequest request = new SnapshotComparisonPageRequest("testSnapshotDiffFullResultsPackage", "FIRST", "SECOND", 0, null);
        SnapshotComparisonPageResponse response = this.repositoryPackageService.compareSnapshots(request);
        Assert.assertEquals((Object)"FIRST", (Object)response.getLeftSnapshotName());
        Assert.assertEquals((Object)"SECOND", (Object)response.getRightSnapshotName());
        Assert.assertNotNull((Object)response);
        Assert.assertNotNull((Object)response.getPageRowList());
        Assert.assertTrue((response.getStartRowIndex() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((response.getPageRowList().size() == 5 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)response.isLastPage());
        for (SnapshotComparisonPageRow row : response.getPageRowList()) {
            SnapshotDiff diff = row.getDiff();
            if (diff.name.equals("testRuleArchived")) {
                Assert.assertEquals((Object)"TYPE_ARCHIVED", (Object)diff.diffType);
                Assert.assertNotNull((Object)diff.leftUuid);
                Assert.assertNotNull((Object)diff.rightUuid);
                continue;
            }
            if (diff.name.equals("testRuleModified")) {
                Assert.assertEquals((Object)"TYPE_UPDATED", (Object)diff.diffType);
                Assert.assertNotNull((Object)diff.leftUuid);
                Assert.assertNotNull((Object)diff.rightUuid);
                continue;
            }
            if (diff.name.equals("testRuleAdded")) {
                Assert.assertEquals((Object)"TYPE_ADDED", (Object)diff.diffType);
                Assert.assertNull((Object)diff.leftUuid);
                Assert.assertNotNull((Object)diff.rightUuid);
                continue;
            }
            if (diff.name.equals("testRuleDeleted")) {
                Assert.assertEquals((Object)"TYPE_DELETED", (Object)diff.diffType);
                Assert.assertNotNull((Object)diff.leftUuid);
                Assert.assertNull((Object)diff.rightUuid);
                continue;
            }
            if (diff.name.equals("testRuleRestored")) {
                Assert.assertEquals((Object)"TYPE_RESTORED", (Object)diff.diffType);
                Assert.assertNotNull((Object)diff.leftUuid);
                Assert.assertNotNull((Object)diff.rightUuid);
                continue;
            }
            Assert.fail((String)"Diff not expected.");
        }
    }

    @Test
    public void testBinaryPackageCompileAndExecute() throws Exception {
        RulesRepository repo = this.rulesRepository;
        ModuleItem pkg = repo.createModule("testBinaryPackageCompile", "");
        DroolsHeader.updateDroolsHeader((String)"global java.util.List ls \n import org.drools.Person", (ModuleItem)pkg);
        AssetItem rule1 = pkg.addAsset("rule_1", "");
        rule1.updateFormat("drl");
        rule1.updateContent("rule 'rule1' \n when \np : Person() \n then \np.setAge(42); \n end");
        rule1.checkin("");
        repo.save();
        BuilderResult result = this.repositoryPackageService.buildPackage(pkg.getUUID(), true);
        List lines = result.getLines();
        Assert.assertFalse((boolean)result.hasLines());
        pkg = repo.loadModule("testBinaryPackageCompile");
        byte[] binPackage = pkg.getCompiledBinaryBytes();
        Assert.assertNotNull((Object)binPackage);
        Package[] binPkgs = (Package[])DroolsStreamUtils.streamIn((byte[])binPackage);
        Assert.assertNotNull((Object)binPkgs);
        Assert.assertEquals((long)1L, (long)binPkgs.length);
        Package binPkg = binPkgs[0];
        Assert.assertNotNull((Object)binPkg);
        Assert.assertTrue((boolean)binPkg.isValid());
        Person p = new Person();
        KnowledgeBuilder kb = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kb.add((Resource)new InputStreamResource((InputStream)new ByteArrayInputStream(binPackage)), ResourceType.PKG);
        KnowledgeBase kbase = kb.newKnowledgeBase();
        StatelessKnowledgeSession sess = kbase.newStatelessKnowledgeSession();
        sess.setGlobal("ls", new ArrayList());
        sess.execute((Object)p);
        Assert.assertEquals((long)42L, (long)p.getAge());
        this.repositoryPackageService.createModuleSnapshot("testBinaryPackageCompile", "SNAP1", false, "");
        rule1.updateContent("rule 'rule1' \n when p:PersonX() \n then System.err.println(42); \n end");
        rule1.checkin("");
        result = this.repositoryPackageService.buildPackage(pkg.getUUID(), true);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)1L, (long)result.getLines().size());
        Assert.assertEquals((Object)rule1.getName(), (Object)((BuilderResultLine)result.getLines().get(0)).getAssetName());
        Assert.assertEquals((Object)"drl", (Object)((BuilderResultLine)result.getLines().get(0)).getAssetFormat());
        Assert.assertNotNull((Object)((BuilderResultLine)result.getLines().get(0)).getMessage());
        Assert.assertEquals((Object)rule1.getUUID(), (Object)((BuilderResultLine)result.getLines().get(0)).getUuid());
        pkg = repo.loadModuleSnapshot("testBinaryPackageCompile", "SNAP1");
        result = this.repositoryPackageService.buildPackage(pkg.getUUID(), true);
        Assert.assertFalse((boolean)result.hasLines());
    }

    @Test
    public void testBinaryPackageCompileAndExecuteWithBRXML() throws Exception {
        RulesRepository repo = this.rulesRepository;
        ModuleItem pkg = repo.createModule("testBinaryPackageCompileBRL", "");
        DroolsHeader.updateDroolsHeader((String)"import org.drools.Person", (ModuleItem)pkg);
        AssetItem rule2 = pkg.addAsset("rule2", "");
        rule2.updateFormat("brl");
        RuleModel model = new RuleModel();
        model.name = "rule2";
        FactPattern pattern = new FactPattern("Person");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setConstraintValueType(5);
        con.setValue("name soundslike 'foobar'");
        pattern.addConstraint((FieldConstraint)con);
        pattern.setBoundName("p");
        ActionSetField action = new ActionSetField("p");
        ActionFieldValue value = new ActionFieldValue("age", "42", "Integer");
        action.addFieldValue(value);
        model.addLhsItem((IPattern)pattern);
        model.addRhsItem((IAction)action);
        rule2.updateContent(BRXMLPersistence.getInstance().marshal(model));
        rule2.checkin("");
        repo.save();
        BuilderResult result = this.repositoryPackageService.buildPackage(pkg.getUUID(), true);
        if (result != null) {
            for (int i = 0; i < result.getLines().size(); ++i) {
                System.err.println(((BuilderResultLine)result.getLines().get(i)).getMessage());
            }
        }
        Assert.assertFalse((boolean)result.hasLines());
        pkg = repo.loadModule("testBinaryPackageCompileBRL");
        byte[] binPackage = pkg.getCompiledBinaryBytes();
        Assert.assertNotNull((Object)binPackage);
        Package[] binPkgs = (Package[])DroolsStreamUtils.streamIn((byte[])binPackage);
        Assert.assertNotNull((Object)binPkgs);
        Assert.assertEquals((long)1L, (long)binPkgs.length);
        Package binPkg = binPkgs[0];
        Assert.assertNotNull((Object)binPkg);
        Assert.assertTrue((boolean)binPkg.isValid());
        Person p = new Person("fubar");
        KnowledgeBuilder kb = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kb.add((Resource)new InputStreamResource((InputStream)new ByteArrayInputStream(binPackage)), ResourceType.PKG);
        KnowledgeBase kbase = kb.newKnowledgeBase();
        StatelessKnowledgeSession sess = kbase.newStatelessKnowledgeSession();
        sess.execute((Object)p);
        Assert.assertEquals((long)42L, (long)p.getAge());
        this.repositoryPackageService.createModuleSnapshot("testBinaryPackageCompileBRL", "SNAP1", false, "");
        pattern.setFactType("PersonX");
        rule2.updateContent(BRXMLPersistence.getInstance().marshal(model));
        rule2.checkin("");
        result = this.repositoryPackageService.buildPackage(pkg.getUUID(), true);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((result.getLines().size() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)rule2.getName(), (Object)((BuilderResultLine)result.getLines().get(0)).getAssetName());
        Assert.assertEquals((Object)"brl", (Object)((BuilderResultLine)result.getLines().get(0)).getAssetFormat());
        Assert.assertNotNull((Object)((BuilderResultLine)result.getLines().get(0)).getMessage());
        Assert.assertEquals((Object)rule2.getUUID(), (Object)((BuilderResultLine)result.getLines().get(0)).getUuid());
        pkg = repo.loadModuleSnapshot("testBinaryPackageCompileBRL", "SNAP1");
        result = this.repositoryPackageService.buildPackage(pkg.getUUID(), true);
        Assert.assertFalse((boolean)result.hasLines());
        AssetItem asset2 = pkg.addAsset("testSetRuleName", "");
        asset2.updateFormat("brl");
        asset2.checkin("");
        RuleModel model2 = new RuleModel();
        Assert.assertNull((Object)model2.name);
        Asset asset = this.repositoryAssetService.loadRuleAsset(asset2.getUUID());
        asset.setContent((PortableObject)model2);
        this.repositoryAssetService.checkinVersion(asset);
        asset = this.repositoryAssetService.loadRuleAsset(asset2.getUUID());
        model2 = (RuleModel)asset.getContent();
        Assert.assertNotNull((Object)model2);
        Assert.assertNotNull((Object)model2.name);
        Assert.assertEquals((Object)asset2.getName(), (Object)model2.name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLoadAndExecBinary() throws Exception {
        RulesRepository repo = this.rulesRepository;
        ModuleItem pkg = repo.createModule("testLoadAndExecBinary", "");
        DroolsHeader.updateDroolsHeader((String)"import org.drools.Person", (ModuleItem)pkg);
        AssetItem rule = pkg.addAsset("rule", "");
        rule.updateFormat("brl");
        RuleModel model = new RuleModel();
        model.name = "rule";
        FactPattern pattern = new FactPattern("Person");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setConstraintValueType(5);
        con.setValue("name soundslike 'foobar'");
        pattern.addConstraint((FieldConstraint)con);
        pattern.setBoundName("p");
        ActionSetField action = new ActionSetField("p");
        ActionFieldValue value = new ActionFieldValue("age", "42", "Integer");
        action.addFieldValue(value);
        model.addLhsItem((IPattern)pattern);
        model.addRhsItem((IAction)action);
        rule.updateContent(BRXMLPersistence.getInstance().marshal(model));
        rule.checkin("");
        repo.save();
        BuilderResult result = this.repositoryPackageService.buildPackage(pkg.getUUID(), true);
        if (result != null) {
            for (int i = 0; i < result.getLines().size(); ++i) {
                System.err.println(((BuilderResultLine)result.getLines().get(i)).getMessage());
            }
        }
        Assert.assertFalse((boolean)result.hasLines());
        pkg = repo.loadModule("testLoadAndExecBinary");
        byte[] binPackage = pkg.getCompiledBinaryBytes();
        File file = new File(System.getProperty("java.io.tmpdir") + File.separator + "RepoBinPackage.pkg");
        FileManager fm = new FileManager();
        try {
            fm.deleteFile(file);
            FileOutputStream out = new FileOutputStream(file);
            out.write(binPackage);
            out.flush();
            out.close();
            Person p = new Person("fubar");
            KnowledgeBuilder kb = KnowledgeBuilderFactory.newKnowledgeBuilder();
            kb.add((Resource)new InputStreamResource((InputStream)new ByteArrayInputStream(binPackage)), ResourceType.PKG);
            KnowledgeBase kbase = kb.newKnowledgeBase();
            StatelessKnowledgeSession sess = kbase.newStatelessKnowledgeSession();
            sess.execute((Object)p);
            Assert.assertEquals((long)42L, (long)p.getAge());
        }
        finally {
            fm.deleteFile(file);
        }
    }

    @Test
    public void testPackageSource() throws Exception {
        RulesRepository repo = this.rulesRepository;
        ModuleItem pkg = repo.createModule("testPackageSource", "");
        DroolsHeader.updateDroolsHeader((String)"import org.goo.Ber", (ModuleItem)pkg);
        AssetItem rule1 = pkg.addAsset("rule_1", "");
        rule1.updateFormat("drl");
        rule1.updateContent("rule 'rule1' \n when p:Person() \n then p.setAge(42); \n end");
        rule1.checkin("");
        repo.save();
        AssetItem func = pkg.addAsset("funky", "");
        func.updateFormat("function");
        func.updateContent("this is a func");
        func.checkin("");
        String drl = this.repositoryPackageService.buildModuleSource(pkg.getUUID());
        Assert.assertNotNull((Object)drl);
        Assert.assertTrue((drl.indexOf("import org.goo.Ber") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("package testPackageSource") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("rule 'rule1'") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("this is a func") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("this is a func") < drl.indexOf("rule 'rule1'") ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("package testPackageSource") < drl.indexOf("this is a func") ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("package testPackageSource") < drl.indexOf("import org.goo.Ber") ? 1 : 0) != 0);
        AssetItem dsl = pkg.addAsset("MyDSL", "");
        dsl.updateFormat("dsl");
        dsl.updateContent("[when]This is foo=bar()\n[then]do something=yeahMan();");
        dsl.checkin("");
        AssetItem asset = pkg.addAsset("MyDSLRule", "");
        asset.updateFormat("dslr");
        asset.updateContent("when \n This is foo \n then \n do something");
        asset.checkin("");
        drl = this.repositoryPackageService.buildModuleSource(pkg.getUUID());
        Assert.assertNotNull((Object)drl);
        Assert.assertTrue((drl.indexOf("import org.goo.Ber") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("This is foo") == -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("do something") == -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("bar()") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("yeahMan();") > 0 ? 1 : 0) != 0);
    }
}

