/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import org.drools.core.util.DateUtils;
import org.drools.guvnor.client.rpc.AssetPageRequest;
import org.drools.guvnor.client.rpc.MetaDataQuery;
import org.drools.guvnor.client.rpc.PageResponse;
import org.drools.guvnor.client.rpc.QueryMetadataPageRequest;
import org.drools.guvnor.client.rpc.QueryPageRequest;
import org.drools.guvnor.server.security.RoleBasedPermission;
import org.drools.guvnor.server.security.RoleBasedPermissionManager;
import org.drools.guvnor.server.security.RoleBasedPermissionResolver;
import org.drools.guvnor.server.security.RoleBasedPermissionStore;
import org.drools.guvnor.server.security.RoleType;
import org.drools.guvnor.server.test.GuvnorIntegrationTest;
import org.drools.repository.AssetItem;
import org.drools.repository.CategoryItem;
import org.drools.repository.ModuleItem;
import org.drools.type.DateFormats;
import org.drools.type.DateFormatsImpl;
import org.junit.Assert;
import org.junit.Test;

public class RepositoryQueryAndFindIntegrationTest
extends GuvnorIntegrationTest {
    @Inject
    private RoleBasedPermissionStore roleBasedPermissionStore;
    @Inject
    private RoleBasedPermissionManager roleBasedPermissionManager;
    @Inject
    private RoleBasedPermissionResolver roleBasedPermissionResolver;

    @Test
    public void testQueryFullTextPagedResults() throws Exception {
        int PAGE_SIZE = 2;
        String categoryName = "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryFullTextPagedResultsCategory";
        String categoryDescription = "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryFullTextPagedResultsCategoryDescription";
        this.repositoryCategoryService.createCategory("/", categoryName, categoryDescription);
        String packageName = "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryFullTextPagedResultsPackage";
        String packageDescription = "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryFullTextPagedResultsPackageDescription";
        this.repositoryPackageService.createModule(packageName, packageDescription, "package");
        this.serviceImplementation.createNewRule("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryFullTextPagedResults.testTextRule1", "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryFullTextPagedResults.testTextRule1Description", categoryName, packageName, "drl");
        this.serviceImplementation.createNewRule("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryFullTextPagedResults.testTextRule2", "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryFullTextPagedResults.testTextRule2Description", categoryName, packageName, "drl");
        this.serviceImplementation.createNewRule("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryFullTextPagedResults.testTextRule3", "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryFullTextPagedResults.testTextRule3Description", categoryName, packageName, "drl");
        QueryPageRequest request = new QueryPageRequest("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryFullTextPagedResults.testTextRule*", Boolean.valueOf(false), 0, Integer.valueOf(2));
        PageResponse response = this.serviceImplementation.queryFullText(request);
        Assert.assertNotNull((Object)response);
        Assert.assertNotNull((Object)response.getPageRowList());
        Assert.assertEquals((long)0L, (long)response.getStartRowIndex());
        Assert.assertEquals((long)2L, (long)response.getPageRowList().size());
        Assert.assertFalse((boolean)response.isLastPage());
        request.setStartRowIndex(2);
        response = this.serviceImplementation.queryFullText(request);
        Assert.assertNotNull((Object)response);
        Assert.assertNotNull((Object)response.getPageRowList());
        Assert.assertEquals((long)2L, (long)response.getStartRowIndex());
        Assert.assertEquals((long)1L, (long)response.getPageRowList().size());
        Assert.assertTrue((boolean)response.isLastPage());
    }

    @Test
    public void testQueryFullTextFullResults() throws Exception {
        String categoryName = "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryFullTextFullResultsCategory";
        String categoryDescription = "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryFullTextFullResultsCategoryDescription";
        this.repositoryCategoryService.createCategory("/", categoryName, categoryDescription);
        String packageName = "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryFullTextFullResultsPackage";
        String packageDescription = "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryFullTextFullResultsPackageDescription";
        this.repositoryPackageService.createModule(packageName, packageDescription, "package");
        this.serviceImplementation.createNewRule("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryFullTextFullResults.testTextRule1", "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryFullTextFullResults.testTextRule1Description", categoryName, packageName, "drl");
        this.serviceImplementation.createNewRule("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryFullTextFullResults.testTextRule2", "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryFullTextFullResults.testTextRule2Description", categoryName, packageName, "drl");
        this.serviceImplementation.createNewRule("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryFullTextFullResults.testTextRule3", "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryFullTextFullResults.testTextRule3Description", categoryName, packageName, "drl");
        QueryPageRequest request = new QueryPageRequest("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryFullTextFullResults.testTextRule*", Boolean.valueOf(false), 0, null);
        PageResponse response = this.serviceImplementation.queryFullText(request);
        Assert.assertNotNull((Object)response);
        Assert.assertNotNull((Object)response.getPageRowList());
        Assert.assertEquals((long)0L, (long)response.getStartRowIndex());
        Assert.assertEquals((long)3L, (long)response.getPageRowList().size());
        Assert.assertTrue((boolean)response.isLastPage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testQueryFullTextFullResultsWithAnalystPermission() throws Exception {
        CategoryItem rootCategory = this.rulesRepository.loadCategory("/");
        String categoryName = "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryFullTextFullResultsWithAnalystPermissionCategory";
        String categoryDescription = "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryFullTextFullResultsWithAnalystPermissionCategoryDescription";
        CategoryItem cat = rootCategory.addCategory(categoryName, categoryDescription);
        String subCategory1Name = "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryFullTextFullResultsWithAnalystPermissionCat1";
        cat.addCategory(subCategory1Name, "yeah");
        String subCategory2Name = "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryFullTextFullResultsWithAnalystPermissionCat2";
        cat.addCategory(subCategory2Name, "yeah");
        this.logoutAs("admin");
        String USERNAME = "queryAndFindUser";
        this.loginAs("queryAndFindUser");
        this.roleBasedPermissionResolver.setEnableRoleBasedAuthorization(true);
        this.roleBasedPermissionStore.addRoleBasedPermissionForTesting("queryAndFindUser", new RoleBasedPermission("queryAndFindUser", RoleType.ANALYST.getName(), null, categoryName + "/" + subCategory1Name));
        this.roleBasedPermissionManager.create();
        try {
            int PAGE_SIZE = 2;
            String packageName = "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryFullTextFullResultsWithAnalystPermissionPackage";
            String packageDescription = "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryFullTextFullResultsWithAnalystPermissionPackageDescription";
            ModuleItem pkg = this.rulesRepository.createModule(packageName, packageDescription);
            AssetItem asset = pkg.addAsset("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryFullTextFullResultsWithAnalystPermission.asset1", "", categoryName + "/" + subCategory1Name, null);
            asset.updateSubject("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryFullTextFullResultsWithAnalystPermission.testMetaDataSearch");
            asset.updateExternalSource("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryFullTextFullResultsWithAnalystPermission.numberwang");
            asset.checkin("");
            asset = pkg.addAsset("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryFullTextFullResultsWithAnalystPermission.asset2", "", categoryName + "/" + subCategory1Name, null);
            asset.updateSubject("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryFullTextFullResultsWithAnalystPermission.testMetaDataSearch");
            asset.updateExternalSource("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryFullTextFullResultsWithAnalystPermission.numberwang");
            asset.checkin("");
            asset = pkg.addAsset("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryFullTextFullResultsWithAnalystPermission.asset3", "", categoryName + "/" + subCategory2Name, null);
            asset.updateSubject("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryFullTextFullResultsWithAnalystPermission.testMetaDataSearch");
            asset.updateExternalSource("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryFullTextFullResultsWithAnalystPermission.numberwang");
            asset.checkin("");
            asset = pkg.addAsset("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryFullTextFullResultsWithAnalystPermission.asset4", "", categoryName + "/" + subCategory2Name, null);
            asset.updateSubject("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryFullTextFullResultsWithAnalystPermission.asset4");
            asset.updateExternalSource("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryFullTextFullResultsWithAnalystPermission.numberwang");
            asset.checkin("");
            asset.updateSubject("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryFullTextFullResultsWithAnalystPermission.testMetaDataSearch");
            asset.updateExternalSource("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryFullTextFullResultsWithAnalystPermission.numberwang");
            asset.checkin("");
            asset = pkg.addAsset("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryFullTextFullResultsWithAnalystPermission.asset5", "", categoryName + "/" + subCategory1Name, null);
            asset.updateSubject("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryFullTextFullResultsWithAnalystPermission.testMetaDataSearch");
            asset.updateExternalSource("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryFullTextFullResultsWithAnalystPermission.numberwang");
            asset.checkin("");
            QueryPageRequest request = new QueryPageRequest("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryFullTextFullResultsWithAnalystPermission.asset*", Boolean.valueOf(false), 0, Integer.valueOf(2));
            PageResponse response = this.serviceImplementation.queryFullText(request);
            Assert.assertNotNull((Object)response);
            Assert.assertNotNull((Object)response.getPageRowList());
            Assert.assertEquals((long)0L, (long)response.getStartRowIndex());
            Assert.assertEquals((long)2L, (long)response.getPageRowList().size());
            Assert.assertEquals((Object)false, (Object)response.isTotalRowSizeExact());
            Assert.assertFalse((boolean)response.isLastPage());
            request.setStartRowIndex(2);
            response = this.repositoryAssetService.quickFindAsset(request);
            Assert.assertNotNull((Object)response);
            Assert.assertNotNull((Object)response.getPageRowList());
            Assert.assertEquals((long)2L, (long)response.getStartRowIndex());
            Assert.assertEquals((long)1L, (long)response.getPageRowList().size());
            Assert.assertEquals((Object)true, (Object)response.isTotalRowSizeExact());
            Assert.assertEquals((long)3L, (long)response.getTotalRowSize());
            Assert.assertTrue((boolean)response.isLastPage());
        }
        finally {
            this.roleBasedPermissionResolver.setEnableRoleBasedAuthorization(false);
            this.roleBasedPermissionStore.clearAllRoleBasedPermissionsForTesting("queryAndFindUser");
            try {
                this.logoutAs("queryAndFindUser");
                this.loginAs("admin");
            }
            catch (IllegalStateException ise) {
                System.err.println(ise.getMessage());
            }
        }
    }

    @Test
    public void testQuickFindAssetPagedResults() throws Exception {
        int PAGE_SIZE = 2;
        String categoryName = "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQuickFindAssetPagedResultsCategory";
        String categoryDescription = "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQuickFindAssetPagedResultsCategoryDescription";
        this.repositoryCategoryService.createCategory("/", categoryName, categoryDescription);
        String packageName = "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQuickFindAssetPagedResultsPackage";
        String packageDescription = "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQuickFindAssetPagedResultsPackageDescription";
        this.repositoryPackageService.createModule(packageName, packageDescription, "package");
        this.serviceImplementation.createNewRule("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQuickFindAssetPagedResults.testTextRule1", "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQuickFindAssetPagedResults.testTextRule1Description", categoryName, packageName, "drl");
        this.serviceImplementation.createNewRule("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQuickFindAssetPagedResults.testTextRule2", "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQuickFindAssetPagedResults.testTextRule2Description", categoryName, packageName, "drl");
        this.serviceImplementation.createNewRule("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQuickFindAssetPagedResults.testTextRule3", "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQuickFindAssetPagedResults.testTextRule3Description", categoryName, packageName, "drl");
        QueryPageRequest request = new QueryPageRequest("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQuickFindAssetPagedResults.testTextRule*", Boolean.valueOf(false), 0, Integer.valueOf(2));
        PageResponse response = this.repositoryAssetService.quickFindAsset(request);
        Assert.assertNotNull((Object)response);
        Assert.assertNotNull((Object)response.getPageRowList());
        Assert.assertEquals((long)0L, (long)response.getStartRowIndex());
        Assert.assertEquals((long)2L, (long)response.getPageRowList().size());
        Assert.assertFalse((boolean)response.isLastPage());
        request.setStartRowIndex(2);
        response = this.serviceImplementation.queryFullText(request);
        Assert.assertNotNull((Object)response);
        Assert.assertNotNull((Object)response.getPageRowList());
        Assert.assertEquals((long)2L, (long)response.getStartRowIndex());
        Assert.assertEquals((long)1L, (long)response.getPageRowList().size());
        Assert.assertTrue((boolean)response.isLastPage());
    }

    @Test
    public void testQuickFindAssetFullResults() throws Exception {
        String categoryName = "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQuickFindAssetFullResultsCategory";
        String categoryDescription = "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQuickFindAssetFullResultsCategoryDescription";
        this.repositoryCategoryService.createCategory("/", categoryName, categoryDescription);
        String packageName = "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQuickFindAssetFullResultsPackage";
        String packageDescription = "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQuickFindAssetFullResultsPackageDescription";
        this.repositoryPackageService.createModule(packageName, packageDescription, "package");
        this.serviceImplementation.createNewRule("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQuickFindAssetFullResults.testTextRule1", "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQuickFindAssetFullResults.testTextRule1Description", categoryName, packageName, "drl");
        this.serviceImplementation.createNewRule("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQuickFindAssetFullResults.testTextRule2", "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQuickFindAssetFullResults.testTextRule2Description", categoryName, packageName, "drl");
        this.serviceImplementation.createNewRule("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQuickFindAssetFullResults.testTextRule3", "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQuickFindAssetFullResults.testTextRule3Description", categoryName, packageName, "drl");
        QueryPageRequest request = new QueryPageRequest("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQuickFindAssetFullResults.testTextRule*", Boolean.valueOf(false), 0, null);
        PageResponse response = this.repositoryAssetService.quickFindAsset(request);
        Assert.assertNotNull((Object)response);
        Assert.assertNotNull((Object)response.getPageRowList());
        Assert.assertEquals((long)0L, (long)response.getStartRowIndex());
        Assert.assertEquals((long)3L, (long)response.getPageRowList().size());
        Assert.assertTrue((boolean)response.isLastPage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testQuickFindAssetWithAnalystPermission() throws Exception {
        CategoryItem rootCategory = this.rulesRepository.loadCategory("/");
        String categoryName = "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQuickFindAssetWithAnalystPermissionCategory";
        String categoryDescription = "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQuickFindAssetWithAnalystPermissionCategoryDescription";
        CategoryItem cat = rootCategory.addCategory(categoryName, categoryDescription);
        String subCategory1Name = "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQuickFindAssetWithAnalystPermissionCat1";
        cat.addCategory(subCategory1Name, "yeah");
        String subCategory2Name = "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQuickFindAssetWithAnalystPermissionCat2";
        cat.addCategory(subCategory2Name, "yeah");
        this.logoutAs("admin");
        String USERNAME = "queryAndFindUser";
        this.loginAs("queryAndFindUser");
        this.roleBasedPermissionResolver.setEnableRoleBasedAuthorization(true);
        this.roleBasedPermissionStore.addRoleBasedPermissionForTesting("queryAndFindUser", new RoleBasedPermission("queryAndFindUser", RoleType.ANALYST.getName(), null, categoryName + "/" + subCategory1Name));
        this.roleBasedPermissionManager.create();
        try {
            int PAGE_SIZE = 2;
            String packageName = "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQuickFindAssetWithAnalystPermissionPackage";
            String packageDescription = "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQuickFindAssetWithAnalystPermissionPackageDescription";
            ModuleItem pkg = this.rulesRepository.createModule(packageName, packageDescription);
            AssetItem asset = pkg.addAsset("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQuickFindAssetWithAnalystPermission.asset1", "", categoryName + "/" + subCategory1Name, null);
            asset.updateSubject("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQuickFindAssetWithAnalystPermission.testMetaDataSearch");
            asset.updateExternalSource("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQuickFindAssetWithAnalystPermission.numberwang");
            asset.checkin("");
            asset = pkg.addAsset("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQuickFindAssetWithAnalystPermission.asset2", "", categoryName + "/" + subCategory2Name, null);
            asset.updateSubject("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQuickFindAssetWithAnalystPermission.testMetaDataSearch");
            asset.updateExternalSource("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQuickFindAssetWithAnalystPermission.numberwang");
            asset.checkin("");
            asset = pkg.addAsset("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQuickFindAssetWithAnalystPermission.asset3", "", categoryName + "/" + subCategory2Name, null);
            asset.updateSubject("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQuickFindAssetWithAnalystPermission.testMetaDataSearch");
            asset.updateExternalSource("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQuickFindAssetWithAnalystPermission.numberwang");
            asset.checkin("");
            asset = pkg.addAsset("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQuickFindAssetWithAnalystPermission.asset4", "", categoryName + "/" + subCategory1Name, null);
            asset.updateSubject("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQuickFindAssetWithAnalystPermission.asset4");
            asset.updateExternalSource("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQuickFindAssetWithAnalystPermission.numberwang");
            asset.checkin("");
            asset.updateSubject("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQuickFindAssetWithAnalystPermission.testMetaDataSearch");
            asset.updateExternalSource("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQuickFindAssetWithAnalystPermission.numberwang");
            asset.checkin("");
            asset = pkg.addAsset("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQuickFindAssetWithAnalystPermission.asset5", "", categoryName + "/" + subCategory1Name, null);
            asset.updateSubject("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQuickFindAssetWithAnalystPermission.testMetaDataSearch");
            asset.updateExternalSource("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQuickFindAssetWithAnalystPermission.numberwang");
            asset.checkin("");
            QueryPageRequest request = new QueryPageRequest("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQuickFindAssetWithAnalystPermission.asset*", Boolean.valueOf(false), 0, Integer.valueOf(2));
            PageResponse response = this.repositoryAssetService.quickFindAsset(request);
            Assert.assertNotNull((Object)response);
            Assert.assertNotNull((Object)response.getPageRowList());
            Assert.assertEquals((long)0L, (long)response.getStartRowIndex());
            Assert.assertEquals((long)2L, (long)response.getPageRowList().size());
            Assert.assertEquals((Object)false, (Object)response.isTotalRowSizeExact());
            Assert.assertFalse((boolean)response.isLastPage());
            request.setStartRowIndex(2);
            response = this.repositoryAssetService.quickFindAsset(request);
            Assert.assertNotNull((Object)response);
            Assert.assertNotNull((Object)response.getPageRowList());
            Assert.assertEquals((long)2L, (long)response.getStartRowIndex());
            Assert.assertEquals((long)1L, (long)response.getPageRowList().size());
            Assert.assertEquals((Object)true, (Object)response.isTotalRowSizeExact());
            Assert.assertEquals((long)3L, (long)response.getTotalRowSize());
            Assert.assertTrue((boolean)response.isLastPage());
        }
        finally {
            this.roleBasedPermissionResolver.setEnableRoleBasedAuthorization(false);
            this.roleBasedPermissionStore.clearAllRoleBasedPermissionsForTesting("queryAndFindUser");
            try {
                this.logoutAs("queryAndFindUser");
                this.loginAs("admin");
            }
            catch (IllegalStateException ise) {
                System.err.println(ise.getMessage());
            }
        }
    }

    @Test
    public void testQueryMetaDataPagedResults() throws Exception {
        int PAGE_SIZE = 2;
        String packageName = "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryMetaDataPagedResultsPackage";
        String packageDescription = "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryMetaDataPagedResultsPackageDescription";
        ModuleItem pkg = this.rulesRepository.createModule(packageName, packageDescription);
        AssetItem[] assets = new AssetItem[3];
        for (int i = 0; i < assets.length; ++i) {
            AssetItem asset = pkg.addAsset("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryMetaDataPagedResults.testMetaDataSearchAsset" + i, "");
            asset.updateSubject("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryMetaDataPagedResults.testMetaDataSearch");
            asset.updateExternalSource("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryMetaDataPagedResults.numberwang" + i);
            asset.checkin("");
        }
        MetaDataQuery[] qr = new MetaDataQuery[2];
        qr[0] = new MetaDataQuery();
        qr[0].attribute = "drools:subject";
        qr[0].valueList = "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryMetaDataPagedResults.wang, org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryMetaDataPagedResults.testMetaDataSearch";
        qr[1] = new MetaDataQuery();
        qr[1].attribute = "drools:source";
        qr[1].valueList = "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryMetaDataPagedResults.numberwan*";
        List<MetaDataQuery> metadata = Arrays.asList(qr);
        QueryMetadataPageRequest request = new QueryMetadataPageRequest(metadata, DateUtils.parseDate((String)"10-Jul-1974", (DateFormats)new DateFormatsImpl()), null, null, null, false, 0, Integer.valueOf(2));
        PageResponse response = this.serviceImplementation.queryMetaData(request);
        Assert.assertNotNull((Object)response);
        Assert.assertNotNull((Object)response.getPageRowList());
        Assert.assertEquals((long)0L, (long)response.getStartRowIndex());
        Assert.assertEquals((long)2L, (long)response.getPageRowList().size());
        Assert.assertFalse((boolean)response.isLastPage());
        request.setStartRowIndex(2);
        response = this.serviceImplementation.queryMetaData(request);
        Assert.assertNotNull((Object)response);
        Assert.assertNotNull((Object)response.getPageRowList());
        Assert.assertEquals((long)2L, (long)response.getStartRowIndex());
        Assert.assertEquals((long)1L, (long)response.getPageRowList().size());
        Assert.assertTrue((boolean)response.isLastPage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testQueryMetaDataPagedResultsWithAnalystPermission() throws Exception {
        CategoryItem rootCategory = this.rulesRepository.loadCategory("/");
        String categoryName = "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryMetaDataPagedResultsWithAnalystPermissionCategory";
        String categoryDescription = "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryMetaDataPagedResultsWithAnalystPermissionCategoryDescription";
        CategoryItem cat = rootCategory.addCategory(categoryName, categoryDescription);
        String subCategory1Name = "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryMetaDataPagedResultsWithAnalystPermissionCat1";
        cat.addCategory(subCategory1Name, "yeah");
        String subCategory2Name = "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryMetaDataPagedResultsWithAnalystPermissionCat2";
        cat.addCategory(subCategory2Name, "yeah");
        this.logoutAs("admin");
        String USERNAME = "queryAndFindUser";
        this.loginAs("queryAndFindUser");
        this.roleBasedPermissionResolver.setEnableRoleBasedAuthorization(true);
        this.roleBasedPermissionStore.addRoleBasedPermissionForTesting("queryAndFindUser", new RoleBasedPermission("queryAndFindUser", RoleType.ANALYST.getName(), null, categoryName + "/" + subCategory1Name));
        this.roleBasedPermissionManager.create();
        try {
            int PAGE_SIZE = 2;
            String packageName = "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryMetaDataPagedResultsWithAnalystPermissionPackage";
            String packageDescription = "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryMetaDataPagedResultsWithAnalystPermissionPackageDescription";
            ModuleItem pkg = this.rulesRepository.createModule(packageName, packageDescription);
            AssetItem asset = pkg.addAsset("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryMetaDataPagedResultsWithAnalystPermission.testMetaDataSearchAsset1", "", categoryName + "/" + subCategory1Name, null);
            asset.updateSubject("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryMetaDataPagedResultsWithAnalystPermission.testMetaDataSearch");
            asset.updateExternalSource("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryMetaDataPagedResultsWithAnalystPermission.numberwang");
            asset.checkin("");
            asset = pkg.addAsset("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryMetaDataPagedResultsWithAnalystPermission.testMetaDataSearchAsset2", "", categoryName + "/" + subCategory2Name, null);
            asset.updateSubject("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryMetaDataPagedResultsWithAnalystPermission.testMetaDataSearch");
            asset.updateExternalSource("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryMetaDataPagedResultsWithAnalystPermission.numberwang");
            asset.checkin("");
            asset = pkg.addAsset("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryMetaDataPagedResultsWithAnalystPermission.testMetaDataSearchAsset3", "", categoryName + "/" + subCategory1Name, null);
            asset.updateSubject("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryMetaDataPagedResultsWithAnalystPermission.testMetaDataSearch");
            asset.updateExternalSource("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryMetaDataPagedResultsWithAnalystPermission.numberwang");
            asset.checkin("");
            asset = pkg.addAsset("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryMetaDataPagedResultsWithAnalystPermission.testMetaDataSearchAsset4", "", categoryName + "/" + subCategory2Name, null);
            asset.updateSubject("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryMetaDataPagedResultsWithAnalystPermission.testMetaDataSearch");
            asset.updateExternalSource("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryMetaDataPagedResultsWithAnalystPermission.numberwang");
            asset.checkin("");
            asset.updateSubject("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryMetaDataPagedResultsWithAnalystPermission.testMetaDataSearch");
            asset.updateExternalSource("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryMetaDataPagedResultsWithAnalystPermission.numberwang");
            asset.checkin("");
            asset = pkg.addAsset("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryMetaDataPagedResultsWithAnalystPermission.testMetaDataSearchAsset5", "", categoryName + "/" + subCategory1Name, null);
            asset.updateSubject("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryMetaDataPagedResultsWithAnalystPermission.testMetaDataSearch");
            asset.updateExternalSource("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryMetaDataPagedResultsWithAnalystPermission.numberwang");
            asset.checkin("");
            MetaDataQuery[] qr = new MetaDataQuery[2];
            qr[0] = new MetaDataQuery();
            qr[0].attribute = "drools:subject";
            qr[0].valueList = "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryMetaDataPagedResultsWithAnalystPermission.wang, org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryMetaDataPagedResultsWithAnalystPermission.testMetaDataSearch";
            qr[1] = new MetaDataQuery();
            qr[1].attribute = "drools:source";
            qr[1].valueList = "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryMetaDataPagedResultsWithAnalystPermission.numberwan*";
            List<MetaDataQuery> metadata = Arrays.asList(qr);
            QueryMetadataPageRequest request = new QueryMetadataPageRequest(metadata, DateUtils.parseDate((String)"10-Jul-1974", (DateFormats)new DateFormatsImpl()), null, null, null, false, 0, Integer.valueOf(2));
            PageResponse response = this.serviceImplementation.queryMetaData(request);
            Assert.assertNotNull((Object)response);
            Assert.assertNotNull((Object)response.getPageRowList());
            Assert.assertEquals((long)0L, (long)response.getStartRowIndex());
            Assert.assertEquals((long)2L, (long)response.getPageRowList().size());
            Assert.assertEquals((Object)false, (Object)response.isTotalRowSizeExact());
            Assert.assertFalse((boolean)response.isLastPage());
            request.setStartRowIndex(2);
            response = this.serviceImplementation.queryMetaData(request);
            Assert.assertNotNull((Object)response);
            Assert.assertNotNull((Object)response.getPageRowList());
            Assert.assertEquals((long)2L, (long)response.getStartRowIndex());
            Assert.assertEquals((long)1L, (long)response.getPageRowList().size());
            Assert.assertEquals((Object)true, (Object)response.isTotalRowSizeExact());
            Assert.assertEquals((long)3L, (long)response.getTotalRowSize());
            Assert.assertTrue((boolean)response.isLastPage());
        }
        finally {
            this.roleBasedPermissionResolver.setEnableRoleBasedAuthorization(false);
            this.roleBasedPermissionStore.clearAllRoleBasedPermissionsForTesting("queryAndFindUser");
            try {
                this.logoutAs("queryAndFindUser");
                this.loginAs("admin");
            }
            catch (IllegalStateException ise) {
                System.err.println(ise.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testQueryMetaDataPagedResultsWithAnalystPermissionRootCategory() throws Exception {
        CategoryItem rootCategory = this.rulesRepository.loadCategory("/");
        String categoryName = "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryMetaDataPagedResultsWithAnalystPermissionRootCategoryCategory";
        String categoryDescription = "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryMetaDataPagedResultsWithAnalystPermissionRootCategoryCategoryDescription";
        CategoryItem cat = rootCategory.addCategory(categoryName, categoryDescription);
        String subCategory1Name = "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryMetaDataPagedResultsWithAnalystPermissionRootCategoryCat1";
        cat.addCategory(subCategory1Name, "yeah");
        String subCategory2Name = "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryMetaDataPagedResultsWithAnalystPermissionRootCategoryCat2";
        cat.addCategory(subCategory2Name, "yeah");
        this.logoutAs("admin");
        String USERNAME = "queryAndFindUser";
        this.loginAs("queryAndFindUser");
        this.roleBasedPermissionResolver.setEnableRoleBasedAuthorization(true);
        this.roleBasedPermissionStore.addRoleBasedPermissionForTesting("queryAndFindUser", new RoleBasedPermission("queryAndFindUser", RoleType.ANALYST.getName(), null, categoryName + "/" + subCategory1Name));
        this.roleBasedPermissionManager.create();
        try {
            int PAGE_SIZE = 2;
            String packageName = "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryMetaDataPagedResultsWithAnalystPermissionRootPackage";
            String packageDescription = "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryMetaDataPagedResultsWithAnalystPermissionRootPackageDescription";
            ModuleItem pkg = this.rulesRepository.createModule(packageName, packageDescription);
            AssetItem asset = pkg.addAsset("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryMetaDataPagedResultsWithAnalystPermissionRoot.testMetaDataSearchAsset1", "", categoryName + "/" + subCategory1Name, null);
            asset.updateSubject("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryMetaDataPagedResultsWithAnalystPermissionRoot.testMetaDataSearch");
            asset.updateExternalSource("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryMetaDataPagedResultsWithAnalystPermissionRoot.numberwang");
            asset.checkin("");
            asset = pkg.addAsset("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryMetaDataPagedResultsWithAnalystPermissionRoot.testMetaDataSearchAsset2", "", categoryName, null);
            asset.updateSubject("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryMetaDataPagedResultsWithAnalystPermissionRoot.testMetaDataSearch");
            asset.updateExternalSource("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryMetaDataPagedResultsWithAnalystPermissionRoot.numberwang");
            asset.checkin("");
            asset = pkg.addAsset("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryMetaDataPagedResultsWithAnalystPermissionRoot.testMetaDataSearchAsset3", "", categoryName + "/" + subCategory1Name, null);
            asset.updateSubject("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryMetaDataPagedResultsWithAnalystPermissionRoot.testMetaDataSearch");
            asset.updateExternalSource("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryMetaDataPagedResultsWithAnalystPermissionRoot.numberwang");
            asset.checkin("");
            asset = pkg.addAsset("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryMetaDataPagedResultsWithAnalystPermissionRoot.testMetaDataSearchAsset4", "", categoryName + "/" + subCategory2Name, null);
            asset.updateSubject("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryMetaDataPagedResultsWithAnalystPermissionRoot.testMetaDataSearch");
            asset.updateExternalSource("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryMetaDataPagedResultsWithAnalystPermissionRoot.numberwang");
            asset.checkin("");
            asset.updateSubject("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryMetaDataPagedResultsWithAnalystPermissionRoot.testMetaDataSearch");
            asset.updateExternalSource("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryMetaDataPagedResultsWithAnalystPermissionRoot.numberwang");
            asset.checkin("");
            asset = pkg.addAsset("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryMetaDataPagedResultsWithAnalystPermissionRoot.testMetaDataSearchAsset5", "", categoryName + "/" + subCategory1Name, null);
            asset.updateSubject("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryMetaDataPagedResultsWithAnalystPermissionRoot.testMetaDataSearch");
            asset.updateExternalSource("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryMetaDataPagedResultsWithAnalystPermissionRoot.numberwang");
            asset.checkin("");
            MetaDataQuery[] qr = new MetaDataQuery[2];
            qr[0] = new MetaDataQuery();
            qr[0].attribute = "drools:subject";
            qr[0].valueList = "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryMetaDataPagedResultsWithAnalystPermissionRoot.wang, org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryMetaDataPagedResultsWithAnalystPermissionRoot.testMetaDataSearch";
            qr[1] = new MetaDataQuery();
            qr[1].attribute = "drools:source";
            qr[1].valueList = "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryMetaDataPagedResultsWithAnalystPermissionRoot.numberwan*";
            List<MetaDataQuery> metadata = Arrays.asList(qr);
            QueryMetadataPageRequest request = new QueryMetadataPageRequest(metadata, DateUtils.parseDate((String)"10-Jul-1974", (DateFormats)new DateFormatsImpl()), null, null, null, false, 0, Integer.valueOf(2));
            PageResponse response = this.serviceImplementation.queryMetaData(request);
            Assert.assertNotNull((Object)response);
            Assert.assertNotNull((Object)response.getPageRowList());
            Assert.assertEquals((long)0L, (long)response.getStartRowIndex());
            Assert.assertEquals((long)2L, (long)response.getPageRowList().size());
            Assert.assertEquals((Object)false, (Object)response.isTotalRowSizeExact());
            Assert.assertFalse((boolean)response.isLastPage());
            request.setStartRowIndex(2);
            response = this.serviceImplementation.queryMetaData(request);
            Assert.assertNotNull((Object)response);
            Assert.assertNotNull((Object)response.getPageRowList());
            Assert.assertEquals((long)2L, (long)response.getStartRowIndex());
            Assert.assertEquals((long)1L, (long)response.getPageRowList().size());
            Assert.assertEquals((Object)true, (Object)response.isTotalRowSizeExact());
            Assert.assertEquals((long)3L, (long)response.getTotalRowSize());
            Assert.assertTrue((boolean)response.isLastPage());
        }
        finally {
            this.roleBasedPermissionResolver.setEnableRoleBasedAuthorization(false);
            this.roleBasedPermissionStore.clearAllRoleBasedPermissionsForTesting("queryAndFindUser");
            try {
                this.logoutAs("queryAndFindUser");
                this.loginAs("admin");
            }
            catch (IllegalStateException ise) {
                System.err.println(ise.getMessage());
            }
        }
    }

    @Test
    public void testQueryMetaDataFullResults() throws Exception {
        String packageName = "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryMetaDataFullResultsPackage";
        String packageDescription = "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryMetaDataFullResultsPackageDescription";
        ModuleItem pkg = this.rulesRepository.createModule(packageName, packageDescription);
        AssetItem[] assets = new AssetItem[3];
        for (int i = 0; i < assets.length; ++i) {
            AssetItem asset = pkg.addAsset("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryMetaDataFullResults.testMetaDataSearchAsset" + i, "");
            asset.updateSubject("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryMetaDataFullResults.testMetaDataSearch");
            asset.updateExternalSource("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryMetaDataFullResults.numberwang" + i);
            asset.checkin("");
        }
        MetaDataQuery[] qr = new MetaDataQuery[2];
        qr[0] = new MetaDataQuery();
        qr[0].attribute = "drools:subject";
        qr[0].valueList = "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryMetaDataFullResults.wang, org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryMetaDataFullResults.testMetaDataSearch";
        qr[1] = new MetaDataQuery();
        qr[1].attribute = "drools:source";
        qr[1].valueList = "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryMetaDataFullResults.numberwan*";
        List<MetaDataQuery> metadata = Arrays.asList(qr);
        QueryMetadataPageRequest request = new QueryMetadataPageRequest(metadata, DateUtils.parseDate((String)"10-Jul-1974", (DateFormats)new DateFormatsImpl()), null, null, null, false, 0, null);
        PageResponse response = this.serviceImplementation.queryMetaData(request);
        Assert.assertNotNull((Object)response);
        Assert.assertNotNull((Object)response.getPageRowList());
        Assert.assertEquals((long)0L, (long)response.getStartRowIndex());
        Assert.assertEquals((long)3L, (long)response.getPageRowList().size());
        Assert.assertTrue((boolean)response.isLastPage());
    }

    @Test
    public void testFindAssetPagePagedResults() throws Exception {
        int PAGE_SIZE = 2;
        String categoryName = "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testFindAssetPagePagedResultsCategory";
        String categoryDescription = "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testFindAssetPagePagedResultsCategoryDescription";
        this.repositoryCategoryService.createCategory("/", categoryName, categoryDescription);
        String packageName = "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testFindAssetPagePagedResultsPackage";
        String packageDescription = "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testFindAssetPagePagedResultsPackageDescription";
        ModuleItem packageItem = this.rulesRepository.createModule(packageName, packageDescription, "package");
        this.serviceImplementation.createNewRule("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testFindAssetPagePagedResults.testTextRule1", "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testFindAssetPagePagedResults.testTextRule1Description", categoryName, packageName, "brl");
        this.serviceImplementation.createNewRule("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testFindAssetPagePagedResults.testTextRule2", "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testFindAssetPagePagedResults.testTextRule2Description", categoryName, packageName, "brl");
        this.serviceImplementation.createNewRule("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testFindAssetPagePagedResults.testTextRule3", "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testFindAssetPagePagedResults.testTextRule3Description", categoryName, packageName, "brl");
        ArrayList<String> formats = new ArrayList<String>();
        formats.add("brl");
        AssetPageRequest request = new AssetPageRequest(packageItem.getUUID(), formats, null, 0, Integer.valueOf(2));
        PageResponse response = this.repositoryAssetService.findAssetPage(request);
        Assert.assertNotNull((Object)response);
        Assert.assertNotNull((Object)response.getPageRowList());
        Assert.assertEquals((long)0L, (long)response.getStartRowIndex());
        Assert.assertEquals((long)2L, (long)response.getPageRowList().size());
        Assert.assertFalse((boolean)response.isLastPage());
        request.setStartRowIndex(2);
        response = this.repositoryAssetService.findAssetPage(request);
        Assert.assertNotNull((Object)response);
        Assert.assertNotNull((Object)response.getPageRowList());
        Assert.assertEquals((long)2L, (long)response.getStartRowIndex());
        Assert.assertEquals((long)1L, (long)response.getPageRowList().size());
        Assert.assertTrue((boolean)response.isLastPage());
    }

    @Test
    public void testFindAssetPageFullResults() throws Exception {
        String categoryName = "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testFindAssetPageFullResultsCategory";
        String categoryDescription = "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testFindAssetPageFullResultsCategoryDescription";
        this.repositoryCategoryService.createCategory("/", categoryName, categoryDescription);
        String packageName = "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testFindAssetPageFullResultsPackage";
        String packageDescription = "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testFindAssetPageFullResultsPackageDescription";
        ModuleItem packageItem = this.rulesRepository.createModule(packageName, packageDescription, "package");
        this.serviceImplementation.createNewRule("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testFindAssetPageFullResults.testTextRule1", "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testFindAssetPageFullResults.testTextRule1Description", categoryName, packageName, "brl");
        this.serviceImplementation.createNewRule("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testFindAssetPageFullResults.testTextRule2", "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testFindAssetPageFullResults.testTextRule2Description", categoryName, packageName, "brl");
        this.serviceImplementation.createNewRule("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testFindAssetPageFullResults.testTextRule3", "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testFindAssetPageFullResults.testTextRule3Description", categoryName, packageName, "brl");
        ArrayList<String> formats = new ArrayList<String>();
        formats.add("brl");
        AssetPageRequest request = new AssetPageRequest(packageItem.getUUID(), formats, null, 0, null);
        PageResponse response = this.repositoryAssetService.findAssetPage(request);
        Assert.assertNotNull((Object)response);
        Assert.assertNotNull((Object)response.getPageRowList());
        Assert.assertEquals((long)0L, (long)response.getStartRowIndex());
        Assert.assertEquals((long)3L, (long)response.getPageRowList().size());
        Assert.assertTrue((boolean)response.isLastPage());
    }

    @Test
    public void testFindAssetPageUnregisteredAssetFormats() throws Exception {
        String packageName = "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testFindAssetPageUnregisteredAssetFormatsPackage";
        String packageDescription = "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testFindAssetPageUnregisteredAssetFormatsPackageDescription";
        ModuleItem packageItem = this.rulesRepository.createModule(packageName, packageDescription);
        AssetItem as = packageItem.addAsset("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testFindAssetPageUnregisteredAssetFormats.assetWithKnownFormat", "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testFindAssetPageUnregisteredAssetFormats.assetWithKnownFormatDescription");
        as.updateFormat("drl");
        as.checkin("");
        as = packageItem.addAsset("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testFindAssetPageUnregisteredAssetFormats.assetWithUnknownFormat", "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testFindAssetPageUnregisteredAssetFormats.assetWithUnknownFormatDescription");
        as.updateFormat("something_silly");
        as.checkin("");
        ArrayList<String> formats = new ArrayList<String>();
        formats.add("drl");
        AssetPageRequest request = new AssetPageRequest(packageItem.getUUID(), formats, null, 0, null);
        PageResponse response = this.repositoryAssetService.findAssetPage(request);
        Assert.assertEquals((long)1L, (long)response.getPageRowList().size());
    }

    @Test
    public void testQuickFindAssetCaseInsensitiveFullResults() throws Exception {
        String categoryName = "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQuickFindAssetCaseInsensitiveFullResultsCategory";
        String categoryDescription = "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQuickFindAssetCaseInsensitiveFullResultsCategoryDescription";
        this.repositoryCategoryService.createCategory("/", categoryName, categoryDescription);
        String packageName = "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQuickFindAssetCaseInsensitiveFullResultsPackage";
        String packageDescription = "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQuickFindAssetCaseInsensitiveFullResultsPackageDescription";
        this.repositoryPackageService.createModule(packageName, packageDescription, "package");
        this.serviceImplementation.createNewRule("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQuickFindAssetCaseInsensitiveFullResults.testTextRule", "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQuickFindAssetCaseInsensitiveFullResults.testTextRuleDescription", categoryName, packageName, "drl");
        this.serviceImplementation.createNewRule("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQuickFindAssetCaseInsensitiveFullResults.TESTTEXTRULE", "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQuickFindAssetCaseInsensitiveFullResults.TESTTEXTRULEDescription", categoryName, packageName, "drl");
        this.serviceImplementation.createNewRule("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQuickFindAssetCaseInsensitiveFullResults.tEsTtExTrUlE", "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQuickFindAssetCaseInsensitiveFullResults.tEsTtExTrUlEDescription", categoryName, packageName, "drl");
        QueryPageRequest request = new QueryPageRequest("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQuickFindAssetCaseInsensitiveFullResults.testTextRule", Boolean.valueOf(false), Boolean.valueOf(false), 0, null);
        PageResponse response = this.repositoryAssetService.quickFindAsset(request);
        Assert.assertNotNull((Object)response);
        Assert.assertNotNull((Object)response.getPageRowList());
        Assert.assertEquals((long)0L, (long)response.getStartRowIndex());
        Assert.assertEquals((long)3L, (long)response.getPageRowList().size());
        Assert.assertTrue((boolean)response.isLastPage());
    }

    @Test
    public void testQuickFindAssetCaseInsensitivePagedResults() throws Exception {
        int PAGE_SIZE = 2;
        String categoryName = "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQuickFindAssetCaseInsensitivePagedResultsCategory";
        String categoryDescription = "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQuickFindAssetCaseInsensitivePagedResultsCategoryDescription";
        this.repositoryCategoryService.createCategory("/", categoryName, categoryDescription);
        String packageName = "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQuickFindAssetCaseInsensitivePagedResultsPackage";
        String packageDescription = "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQuickFindAssetCaseInsensitivePagedResultsPackageDescription";
        this.repositoryPackageService.createModule(packageName, packageDescription, "package");
        this.serviceImplementation.createNewRule("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQuickFindAssetCaseInsensitivePagedResults.testTextRule", "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQuickFindAssetCaseInsensitivePagedResults.testTextRuleDescription", categoryName, packageName, "drl");
        this.serviceImplementation.createNewRule("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQuickFindAssetCaseInsensitivePagedResults.TESTTEXTRULE", "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQuickFindAssetCaseInsensitivePagedResults.TESTTEXTRULEDescription", categoryName, packageName, "drl");
        this.serviceImplementation.createNewRule("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQuickFindAssetCaseInsensitivePagedResults.tEsTtExTrUlE", "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQuickFindAssetCaseInsensitivePagedResults.tEsTtExTrUlEDescription", categoryName, packageName, "drl");
        QueryPageRequest request = new QueryPageRequest("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQuickFindAssetCaseInsensitivePagedResults.testTextRule", Boolean.valueOf(false), Boolean.valueOf(false), 0, Integer.valueOf(2));
        PageResponse response = this.repositoryAssetService.quickFindAsset(request);
        Assert.assertNotNull((Object)response);
        Assert.assertNotNull((Object)response.getPageRowList());
        Assert.assertEquals((long)0L, (long)response.getStartRowIndex());
        Assert.assertEquals((long)2L, (long)response.getPageRowList().size());
        Assert.assertFalse((boolean)response.isLastPage());
        request.setStartRowIndex(2);
        response = this.repositoryAssetService.quickFindAsset(request);
        Assert.assertNotNull((Object)response);
        Assert.assertNotNull((Object)response.getPageRowList());
        Assert.assertEquals((long)2L, (long)response.getStartRowIndex());
        Assert.assertEquals((long)1L, (long)response.getPageRowList().size());
        Assert.assertTrue((boolean)response.isLastPage());
    }

    @Test
    public void testQueryFullTextCaseInsensitiveFullResults() throws Exception {
        String categoryName = "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryFullTextCaseInsensitiveFullResultsCategory";
        String categoryDescription = "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryFullTextCaseInsensitiveFullResultsCategoryDescription";
        this.repositoryCategoryService.createCategory("/", categoryName, categoryDescription);
        String packageName = "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryFullTextCaseInsensitiveFullResultsPackage";
        String packageDescription = "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryFullTextCaseInsensitiveFullResultsPackageDescription";
        this.repositoryPackageService.createModule(packageName, packageDescription, "package");
        this.serviceImplementation.createNewRule("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryFullTextCaseInsensitiveFullResults.testTextRule", "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryFullTextCaseInsensitiveFullResults.testTextRuleDescription", categoryName, packageName, "drl");
        this.serviceImplementation.createNewRule("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryFullTextCaseInsensitiveFullResults.TESTTEXTRULE", "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryFullTextCaseInsensitiveFullResults.TESTTEXTRULEDescription", categoryName, packageName, "drl");
        this.serviceImplementation.createNewRule("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryFullTextCaseInsensitiveFullResults.tEsTtExTrUlE", "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryFullTextCaseInsensitiveFullResults.tEsTtExTrUlEDescription", categoryName, packageName, "drl");
        QueryPageRequest request = new QueryPageRequest("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryFullTextCaseInsensitiveFullResults.testTextRule", Boolean.valueOf(false), Boolean.valueOf(false), 0, null);
        PageResponse response = this.serviceImplementation.queryFullText(request);
        Assert.assertNotNull((Object)response);
        Assert.assertNotNull((Object)response.getPageRowList());
        Assert.assertTrue((response.getStartRowIndex() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((response.getPageRowList().size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)response.isLastPage());
    }

    @Test
    public void testQueryFullTextCaseInsensitivePagedResults() throws Exception {
        int PAGE_SIZE = 2;
        String categoryName = "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryFullTextCaseInsensitivePagedResultsCategory";
        String categoryDescription = "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryFullTextCaseInsensitivePagedResultsCategoryDescription";
        this.repositoryCategoryService.createCategory("/", categoryName, categoryDescription);
        String packageName = "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryFullTextCaseInsensitivePagedResultsPackage";
        String packageDescription = "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryFullTextCaseInsensitivePagedResultsPackageDescription";
        this.repositoryPackageService.createModule(packageName, packageDescription, "package");
        this.serviceImplementation.createNewRule("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryFullTextCaseInsensitivePagedResults.testTextRule", "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryFullTextCaseInsensitivePagedResults.testTextRuleDescription", categoryName, packageName, "drl");
        this.serviceImplementation.createNewRule("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryFullTextCaseInsensitivePagedResults.TESTTEXTRULE", "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryFullTextCaseInsensitivePagedResults.TESTTEXTRULEDescription", categoryName, packageName, "drl");
        this.serviceImplementation.createNewRule("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryFullTextCaseInsensitivePagedResults.tEsTtExTrUlE", "org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryFullTextCaseInsensitivePagedResults.tEsTtExTrUlEDescription", categoryName, packageName, "drl");
        QueryPageRequest request = new QueryPageRequest("org.drools.guvnor.server.RepositoryQueryAndFindIntegrationTest.testQueryFullTextCaseInsensitivePagedResults.testTextRule*", Boolean.valueOf(false), Boolean.valueOf(false), 0, Integer.valueOf(2));
        PageResponse response = this.serviceImplementation.queryFullText(request);
        Assert.assertNotNull((Object)response);
        Assert.assertNotNull((Object)response.getPageRowList());
        Assert.assertEquals((long)0L, (long)response.getStartRowIndex());
        Assert.assertEquals((long)2L, (long)response.getPageRowList().size());
        Assert.assertFalse((boolean)response.isLastPage());
        request.setStartRowIndex(2);
        response = this.serviceImplementation.queryFullText(request);
        Assert.assertNotNull((Object)response);
        Assert.assertNotNull((Object)response.getPageRowList());
        Assert.assertEquals((long)2L, (long)response.getStartRowIndex());
        Assert.assertEquals((long)1L, (long)response.getPageRowList().size());
        Assert.assertTrue((boolean)response.isLastPage());
    }
}

