/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server;

import javax.inject.Inject;
import org.drools.guvnor.client.rpc.Asset;
import org.drools.guvnor.client.rpc.BulkTestRunResult;
import org.drools.guvnor.client.rpc.ScenarioResultSummary;
import org.drools.guvnor.client.rpc.ScenarioRunResult;
import org.drools.guvnor.client.rpc.SingleScenarioResult;
import org.drools.guvnor.server.TestScenarioServiceImplementation;
import org.drools.guvnor.server.cache.RuleBaseCache;
import org.drools.guvnor.server.test.GuvnorIntegrationTest;
import org.drools.guvnor.server.util.DroolsHeader;
import org.drools.ide.common.client.modeldriven.testing.ExecutionTrace;
import org.drools.ide.common.client.modeldriven.testing.FactData;
import org.drools.ide.common.client.modeldriven.testing.FieldData;
import org.drools.ide.common.client.modeldriven.testing.Scenario;
import org.drools.ide.common.client.modeldriven.testing.VerifyFact;
import org.drools.ide.common.client.modeldriven.testing.VerifyField;
import org.drools.ide.common.client.modeldriven.testing.VerifyRuleFired;
import org.drools.ide.common.server.util.ScenarioXMLPersistence;
import org.drools.repository.AssetItem;
import org.drools.repository.ModuleItem;
import org.junit.Assert;
import org.junit.Test;

public class RepositoryScenarioIntegrationTest
extends GuvnorIntegrationTest {
    @Inject
    private TestScenarioServiceImplementation testScenarioServiceImplementation;

    @Test
    public void testRunScenario() throws Exception {
        ModuleItem pkg = this.rulesRepository.createModule("testScenarioRun", "");
        DroolsHeader.updateDroolsHeader((String)"import org.drools.Person\n global org.drools.Cheese cheese\n", (ModuleItem)pkg);
        AssetItem rule1 = pkg.addAsset("rule_1", "");
        rule1.updateFormat("drl");
        rule1.updateContent("rule 'rule1' \n when \np : Person() \n then \np.setAge(42); \n end");
        rule1.checkin("");
        this.rulesRepository.save();
        Scenario sc = new Scenario();
        FactData person = new FactData();
        person.setName("p");
        person.setType("Person");
        person.getFieldData().add(new FieldData("age", "40"));
        person.getFieldData().add(new FieldData("name", "michael"));
        sc.getFixtures().add(person);
        sc.getFixtures().add(new ExecutionTrace());
        VerifyRuleFired vr = new VerifyRuleFired("rule1", Integer.valueOf(1), null);
        sc.getFixtures().add(vr);
        VerifyFact vf = new VerifyFact();
        vf.setName("p");
        vf.getFieldValues().add(new VerifyField("name", "michael", "=="));
        vf.getFieldValues().add(new VerifyField("age", "42", "=="));
        sc.getFixtures().add(vf);
        FactData cheese = new FactData();
        cheese.setName("cheese");
        cheese.setType("Cheese");
        cheese.getFieldData().add(new FieldData("price", "42"));
        sc.getGlobals().add(cheese);
        ScenarioRunResult res = this.testScenarioServiceImplementation.runScenario(pkg.getName(), sc).getResult();
        Assert.assertNull((Object)res.getErrors());
        Assert.assertNotNull((Object)res.getScenario());
        Assert.assertTrue((boolean)vf.wasSuccessful());
        Assert.assertTrue((boolean)vr.wasSuccessful());
        res = this.testScenarioServiceImplementation.runScenario(pkg.getName(), sc).getResult();
        Assert.assertNull((Object)res.getErrors());
        Assert.assertNotNull((Object)res.getScenario());
        Assert.assertTrue((boolean)vf.wasSuccessful());
        Assert.assertTrue((boolean)vr.wasSuccessful());
        RuleBaseCache.getInstance().clearCache();
        res = this.testScenarioServiceImplementation.runScenario(pkg.getName(), sc).getResult();
        Assert.assertNull((Object)res.getErrors());
        Assert.assertNotNull((Object)res.getScenario());
        Assert.assertTrue((boolean)vf.wasSuccessful());
        Assert.assertTrue((boolean)vr.wasSuccessful());
        rule1.updateContent("Junk");
        rule1.checkin("");
        RuleBaseCache.getInstance().clearCache();
        pkg.updateBinaryUpToDate(false);
        this.rulesRepository.save();
        res = this.testScenarioServiceImplementation.runScenario(pkg.getName(), sc).getResult();
        Assert.assertNotNull((Object)res.getErrors());
        Assert.assertNull((Object)res.getScenario());
        Assert.assertTrue((res.getErrors().size() > 0 ? 1 : 0) != 0);
        this.repositoryCategoryService.createCategory("/", "sc", "");
        String scenarioId = this.serviceImplementation.createNewRule("sc1", "s", "sc", pkg.getName(), "scenario");
        Asset asset = this.repositoryAssetService.loadRuleAsset(scenarioId);
        Assert.assertNotNull((Object)asset.getContent());
        Assert.assertTrue((boolean)(asset.getContent() instanceof Scenario));
        Scenario sc_ = (Scenario)asset.getContent();
        sc_.getFixtures().add(new ExecutionTrace());
        this.repositoryAssetService.checkinVersion(asset);
        asset = this.repositoryAssetService.loadRuleAsset(scenarioId);
        Assert.assertNotNull((Object)asset.getContent());
        Assert.assertTrue((boolean)(asset.getContent() instanceof Scenario));
        sc_ = (Scenario)asset.getContent();
        Assert.assertEquals((long)1L, (long)sc_.getFixtures().size());
    }

    @Test
    public void testRunScenarioWithGeneratedBeans() throws Exception {
        ModuleItem pkg = this.rulesRepository.createModule("testScenarioRunWithGeneratedBeans", "");
        DroolsHeader.updateDroolsHeader((String)"declare GenBean\n name: String \n age: int \nend\n", (ModuleItem)pkg);
        AssetItem rule1 = pkg.addAsset("rule_1", "");
        rule1.updateFormat("drl");
        rule1.updateContent("rule 'rule1' \n when \n p : GenBean(name=='mic') \n then \n p.setAge(42); \n end");
        rule1.checkin("");
        this.rulesRepository.save();
        Scenario sc = new Scenario();
        FactData person = new FactData();
        person.setName("c");
        person.setType("GenBean");
        person.getFieldData().add(new FieldData("age", "40"));
        person.getFieldData().add(new FieldData("name", "mic"));
        sc.getFixtures().add(person);
        sc.getFixtures().add(new ExecutionTrace());
        VerifyRuleFired vr = new VerifyRuleFired("rule1", Integer.valueOf(1), null);
        sc.getFixtures().add(vr);
        VerifyFact vf = new VerifyFact();
        vf.setName("c");
        vf.getFieldValues().add(new VerifyField("name", "mic", "=="));
        vf.getFieldValues().add(new VerifyField("age", "42", "=="));
        sc.getFixtures().add(vf);
        SingleScenarioResult res_ = this.testScenarioServiceImplementation.runScenario(pkg.getName(), sc);
        Assert.assertTrue((res_.getAuditLog().size() > 0 ? 1 : 0) != 0);
        String[] logEntry = (String[])res_.getAuditLog().get(0);
        Assert.assertNotNull((String)logEntry[0], (Object)logEntry[1]);
        ScenarioRunResult res = res_.getResult();
        Assert.assertNull((Object)res.getErrors());
        Assert.assertNotNull((Object)res.getScenario());
        Assert.assertTrue((boolean)vf.wasSuccessful());
        Assert.assertTrue((boolean)vr.wasSuccessful());
    }

    @Test
    public void testRunPackageScenariosWithDeclaredFacts() throws Exception {
        ModuleItem pkg = this.rulesRepository.createModule("testScenarioRunBulkWithDeclaredFacts", "");
        DroolsHeader.updateDroolsHeader((String)"declare Wang \n age: Integer \n name: String \n end", (ModuleItem)pkg);
        AssetItem rule1 = pkg.addAsset("rule_1", "");
        rule1.updateFormat("drl");
        rule1.updateContent("rule 'rule1' \n when \np : Wang() \n then \np.setAge(42); \n end");
        rule1.checkin("");
        AssetItem rule2 = pkg.addAsset("rule_2", "");
        rule2.updateFormat("drl");
        rule2.updateContent("rule 'rule2' \n when \np : Wang(age == 1000) \n then \np.setAge(46); \n end");
        rule2.checkin("");
        this.rulesRepository.save();
        Scenario sc = new Scenario();
        FactData person = new FactData();
        person.setName("p");
        person.setType("Wang");
        person.getFieldData().add(new FieldData("age", "40"));
        person.getFieldData().add(new FieldData("name", "michael"));
        sc.getFixtures().add(person);
        sc.getFixtures().add(new ExecutionTrace());
        VerifyRuleFired vr = new VerifyRuleFired("rule1", Integer.valueOf(1), null);
        sc.getFixtures().add(vr);
        VerifyFact vf = new VerifyFact();
        vf.setName("p");
        vf.getFieldValues().add(new VerifyField("name", "michael", "=="));
        vf.getFieldValues().add(new VerifyField("age", "42", "=="));
        sc.getFixtures().add(vf);
        AssetItem scenario1 = pkg.addAsset("scen1", "");
        scenario1.updateFormat("scenario");
        scenario1.updateContent(ScenarioXMLPersistence.getInstance().marshal(sc));
        scenario1.checkin("");
        sc = new Scenario();
        person = new FactData();
        person.setName("p");
        person.setType("Wang");
        person.getFieldData().add(new FieldData("age", "40"));
        person.getFieldData().add(new FieldData("name", "michael"));
        sc.getFixtures().add(person);
        sc.getFixtures().add(new ExecutionTrace());
        vr = new VerifyRuleFired("rule2", Integer.valueOf(1), null);
        sc.getFixtures().add(vr);
        AssetItem scenario2 = pkg.addAsset("scen2", "");
        scenario2.updateFormat("scenario");
        scenario2.updateContent(ScenarioXMLPersistence.getInstance().marshal(sc));
        scenario2.checkin("");
        BulkTestRunResult result = this.testScenarioServiceImplementation.runScenariosInPackage(pkg.getUUID());
        Assert.assertNull((Object)result.getResult());
        Assert.assertEquals((long)50L, (long)result.getPercentCovered());
        Assert.assertEquals((long)1L, (long)result.getRulesNotCovered().length);
        Assert.assertEquals((Object)"rule2", (Object)result.getRulesNotCovered()[0]);
        Assert.assertEquals((long)2L, (long)result.getResults().length);
        ScenarioResultSummary s1 = result.getResults()[0];
        Assert.assertEquals((long)0L, (long)s1.getFailures());
        Assert.assertEquals((long)3L, (long)s1.getTotal());
        Assert.assertEquals((Object)scenario1.getUUID(), (Object)s1.getUuid());
        Assert.assertEquals((Object)scenario1.getName(), (Object)s1.getScenarioName());
        ScenarioResultSummary s2 = result.getResults()[1];
        Assert.assertEquals((long)1L, (long)s2.getFailures());
        Assert.assertEquals((long)1L, (long)s2.getTotal());
        Assert.assertEquals((Object)scenario2.getUUID(), (Object)s2.getUuid());
        Assert.assertEquals((Object)scenario2.getName(), (Object)s2.getScenarioName());
    }

    @Test
    public void testRunScenarioWithJar() throws Exception {
        ModuleItem pkg = this.rulesRepository.createModule("testRunScenarioWithJar", "");
        AssetItem model = pkg.addAsset("MyModel", "");
        model.updateFormat("jar");
        model.updateBinaryContentAttachment(this.getClass().getResourceAsStream("/billasurf.jar"));
        model.checkin("");
        DroolsHeader.updateDroolsHeader((String)"import com.billasurf.Board", (ModuleItem)pkg);
        AssetItem asset = pkg.addAsset("testRule", "");
        asset.updateFormat("drl");
        asset.updateContent("rule 'MyGoodRule' \n when Board() then System.err.println(42); \n end");
        asset.checkin("");
        this.rulesRepository.save();
        Scenario sc = new Scenario();
        FactData person = new FactData();
        person.setName("p");
        person.setType("Board");
        person.getFieldData().add(new FieldData("cost", "42"));
        sc.getFixtures().add(person);
        sc.getFixtures().add(new ExecutionTrace());
        VerifyRuleFired vr = new VerifyRuleFired("MyGoodRule", Integer.valueOf(1), null);
        sc.getFixtures().add(vr);
        VerifyFact vf = new VerifyFact();
        vf.setName("p");
        vf.getFieldValues().add(new VerifyField("cost", "42", "=="));
        sc.getFixtures().add(vf);
        ScenarioRunResult res = this.testScenarioServiceImplementation.runScenario(pkg.getName(), sc).getResult();
        Assert.assertNull((Object)res.getErrors());
        Assert.assertNotNull((Object)res.getScenario());
        Assert.assertTrue((boolean)vf.wasSuccessful());
        Assert.assertTrue((boolean)vr.wasSuccessful());
        res = this.testScenarioServiceImplementation.runScenario(pkg.getName(), sc).getResult();
        Assert.assertNull((Object)res.getErrors());
        Assert.assertNotNull((Object)res.getScenario());
        Assert.assertTrue((boolean)vf.wasSuccessful());
        Assert.assertTrue((boolean)vr.wasSuccessful());
        RuleBaseCache.getInstance().clearCache();
        res = this.testScenarioServiceImplementation.runScenario(pkg.getName(), sc).getResult();
        Assert.assertNull((Object)res.getErrors());
        Assert.assertNotNull((Object)res.getScenario());
        Assert.assertTrue((boolean)vf.wasSuccessful());
        Assert.assertTrue((boolean)vr.wasSuccessful());
    }

    @Test
    public void testRunScenarioWithJarThatHasSourceFiles() throws Exception {
        ModuleItem pkg = this.rulesRepository.createModule("testRunScenarioWithJarThatHasSourceFiles", "");
        AssetItem model = pkg.addAsset("MyModel", "");
        model.updateFormat("jar");
        model.updateBinaryContentAttachment(this.getClass().getResourceAsStream("jarWithSourceFiles.jar"));
        model.checkin("");
        DroolsHeader.updateDroolsHeader((String)"import org.test.Person; \n import org.test.Banana; \n ", (ModuleItem)pkg);
        AssetItem asset = pkg.addAsset("testRule", "");
        asset.updateFormat("drl");
        asset.updateContent("rule 'MyGoodRule' \n dialect 'mvel' \n when \n Person() \n then \n insert( new Banana() ); \n end");
        asset.checkin("");
        this.rulesRepository.save();
        Scenario sc = new Scenario();
        FactData person = new FactData();
        person.setName("p");
        person.setType("Person");
        sc.getFixtures().add(person);
        sc.getFixtures().add(new ExecutionTrace());
        VerifyRuleFired vr = new VerifyRuleFired("MyGoodRule", Integer.valueOf(1), null);
        sc.getFixtures().add(vr);
        ScenarioRunResult res = null;
        try {
            res = this.testScenarioServiceImplementation.runScenario(pkg.getName(), sc).getResult();
        }
        catch (ClassFormatError e) {
            Assert.fail((String)("Probably failed when loading a source file instead of class file. " + e));
        }
        Assert.assertNull((Object)res.getErrors());
        Assert.assertNotNull((Object)res.getScenario());
        Assert.assertTrue((boolean)vr.wasSuccessful());
        res = this.testScenarioServiceImplementation.runScenario(pkg.getName(), sc).getResult();
        Assert.assertNull((Object)res.getErrors());
        Assert.assertNotNull((Object)res.getScenario());
        Assert.assertTrue((boolean)vr.wasSuccessful());
        RuleBaseCache.getInstance().clearCache();
        res = this.testScenarioServiceImplementation.runScenario(pkg.getName(), sc).getResult();
        Assert.assertNull((Object)res.getErrors());
        Assert.assertNotNull((Object)res.getScenario());
        Assert.assertTrue((boolean)vr.wasSuccessful());
    }

    @Test
    public void testRunPackageScenarios() throws Exception {
        ModuleItem pkg = this.rulesRepository.createModule("testScenarioRunBulk", "");
        DroolsHeader.updateDroolsHeader((String)"import org.drools.Person", (ModuleItem)pkg);
        AssetItem rule1 = pkg.addAsset("rule_1", "");
        rule1.updateFormat("drl");
        rule1.updateContent("rule 'rule1' \n when \np : Person() \n then \np.setAge(42); \n end");
        rule1.checkin("");
        AssetItem rule2 = pkg.addAsset("rule_2", "");
        rule2.updateFormat("drl");
        rule2.updateContent("rule 'rule2' \n when \np : Person(age == 1000) \n then \np.setAge(46); \n end");
        rule2.checkin("");
        this.rulesRepository.save();
        Scenario sc = new Scenario();
        FactData person = new FactData();
        person.setName("p");
        person.setType("Person");
        person.getFieldData().add(new FieldData("age", "40"));
        person.getFieldData().add(new FieldData("name", "michael"));
        sc.getFixtures().add(person);
        sc.getFixtures().add(new ExecutionTrace());
        VerifyRuleFired vr = new VerifyRuleFired("rule1", Integer.valueOf(1), null);
        sc.getFixtures().add(vr);
        VerifyFact vf = new VerifyFact();
        vf.setName("p");
        vf.getFieldValues().add(new VerifyField("name", "michael", "=="));
        vf.getFieldValues().add(new VerifyField("age", "42", "=="));
        sc.getFixtures().add(vf);
        AssetItem scenario1 = pkg.addAsset("scen1", "");
        scenario1.updateFormat("scenario");
        scenario1.updateContent(ScenarioXMLPersistence.getInstance().marshal(sc));
        scenario1.checkin("");
        sc = new Scenario();
        person = new FactData();
        person.setName("p");
        person.setType("Person");
        person.getFieldData().add(new FieldData("age", "40"));
        person.getFieldData().add(new FieldData("name", "michael"));
        sc.getFixtures().add(person);
        sc.getFixtures().add(new ExecutionTrace());
        vr = new VerifyRuleFired("rule2", Integer.valueOf(1), null);
        sc.getFixtures().add(vr);
        AssetItem scenario2 = pkg.addAsset("scen2", "");
        scenario2.updateFormat("scenario");
        scenario2.updateContent(ScenarioXMLPersistence.getInstance().marshal(sc));
        scenario2.checkin("");
        AssetItem scenario3 = pkg.addAsset("scenBOGUS", "");
        scenario3.updateFormat("scenario");
        scenario3.updateContent("SOME RUBBISH");
        scenario3.updateDisabled(true);
        scenario3.checkin("");
        long time = System.currentTimeMillis();
        BulkTestRunResult result = this.testScenarioServiceImplementation.runScenariosInPackage(pkg.getUUID());
        System.err.println("Time taken for runScenariosInPackage " + (System.currentTimeMillis() - time));
        Assert.assertNull((Object)result.getResult());
        Assert.assertEquals((long)50L, (long)result.getPercentCovered());
        Assert.assertEquals((long)1L, (long)result.getRulesNotCovered().length);
        Assert.assertEquals((Object)"rule2", (Object)result.getRulesNotCovered()[0]);
        Assert.assertEquals((long)2L, (long)result.getResults().length);
        ScenarioResultSummary s1 = result.getResults()[0];
        Assert.assertEquals((long)0L, (long)s1.getFailures());
        Assert.assertEquals((long)3L, (long)s1.getTotal());
        Assert.assertEquals((Object)scenario1.getUUID(), (Object)s1.getUuid());
        Assert.assertEquals((Object)scenario1.getName(), (Object)s1.getScenarioName());
        ScenarioResultSummary s2 = result.getResults()[1];
        Assert.assertEquals((long)1L, (long)s2.getFailures());
        Assert.assertEquals((long)1L, (long)s2.getTotal());
        Assert.assertEquals((Object)scenario2.getUUID(), (Object)s2.getUuid());
        Assert.assertEquals((Object)scenario2.getName(), (Object)s2.getScenarioName());
    }
}

