/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server;

import javax.inject.Inject;
import org.drools.guvnor.client.rpc.Asset;
import org.drools.guvnor.client.rpc.MetaDataQuery;
import org.drools.guvnor.client.rpc.Module;
import org.drools.guvnor.client.rpc.RuleContentText;
import org.drools.guvnor.client.rpc.TableDataResult;
import org.drools.guvnor.server.security.RoleBasedPermission;
import org.drools.guvnor.server.security.RoleBasedPermissionManager;
import org.drools.guvnor.server.security.RoleBasedPermissionResolver;
import org.drools.guvnor.server.security.RoleBasedPermissionStore;
import org.drools.guvnor.server.security.RoleType;
import org.drools.guvnor.server.test.GuvnorIntegrationTest;
import org.drools.guvnor.shared.api.PortableObject;
import org.drools.repository.ModuleItem;
import org.jboss.seam.security.AuthorizationException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class ServiceImplSecurityIntegrationTest
extends GuvnorIntegrationTest {
    private static final String USER_NAME = "serviceImplSecurityUser";
    @Inject
    private RoleBasedPermissionStore roleBasedPermissionStore;
    @Inject
    private RoleBasedPermissionManager roleBasedPermissionManager;
    @Inject
    private RoleBasedPermissionResolver roleBasedPermissionResolver;

    public ServiceImplSecurityIntegrationTest() {
        this.autoLoginAsAdmin = false;
    }

    @Before
    public void loginAsSpecificUser() {
        this.loginAs(USER_NAME);
        this.roleBasedPermissionStore.addRoleBasedPermissionForTesting(USER_NAME, new RoleBasedPermission(USER_NAME, "UNDEFINED", null, null));
    }

    @After
    public void logoutAsSpecificUser() {
        this.logoutAs(USER_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLoadRuleAssetAnalyst() throws Exception {
        this.rulesRepository.createModule("testLoadRuleAssetAnalyst", "desc");
        this.repositoryCategoryService.createCategory("", "testLoadRuleAssetAnalystCat1", "this is a cat");
        this.repositoryCategoryService.createCategory("", "testLoadRuleAssetAnalystCat2", "this is a cat");
        String uuid1 = this.serviceImplementation.createNewRule("testLoadRuleAssetAnalystRule1", "description", "testLoadRuleAssetAnalystCat1", "testLoadRuleAssetAnalyst", "drl");
        String uuid2 = this.serviceImplementation.createNewRule("testLoadRuleAssetAnalystRule2", "description", "testLoadRuleAssetAnalystCat2", "testLoadRuleAssetAnalyst", "drl");
        this.roleBasedPermissionResolver.setEnableRoleBasedAuthorization(true);
        this.roleBasedPermissionStore.addRoleBasedPermissionForTesting(USER_NAME, new RoleBasedPermission(USER_NAME, RoleType.ANALYST.getName(), null, "testLoadRuleAssetAnalystCat1"));
        this.roleBasedPermissionManager.create();
        try {
            Asset asset = this.repositoryAssetService.loadRuleAsset(uuid1);
            try {
                asset = this.repositoryAssetService.loadRuleAsset(uuid2);
                Assert.fail((String)"Did not catch expected exception");
            }
            catch (AuthorizationException e) {
                // empty catch block
            }
        }
        finally {
            this.roleBasedPermissionStore.clearAllRoleBasedPermissionsForTesting(USER_NAME);
            this.roleBasedPermissionResolver.setEnableRoleBasedAuthorization(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLoadRuleAssetPackageReadonly() throws Exception {
        String package1Name = "testLoadRuleAssetPackageReadonlyPack1";
        String package1Uuid = this.repositoryPackageService.createModule(package1Name, "desc", "package");
        this.repositoryCategoryService.createCategory("", "testLoadRuleAssetPackageReadonlyCat1", "this is a cat");
        String uuid1 = this.serviceImplementation.createNewRule("testLoadRuleAssetPackageReadonlyRule1", "description", "testLoadRuleAssetPackageReadonlyCat1", "testLoadRuleAssetPackageReadonlyPack1", "drl");
        this.rulesRepository.createModule("testLoadRuleAssetPackageReadonlyPack2", "desc");
        String uuid2 = this.serviceImplementation.createNewRule("testLoadRuleAssetPackageReadonlyRule2", "description", "testLoadRuleAssetPackageReadonlyCat1", "testLoadRuleAssetPackageReadonlyPack2", "drl");
        this.roleBasedPermissionResolver.setEnableRoleBasedAuthorization(true);
        this.roleBasedPermissionStore.addRoleBasedPermissionForTesting(USER_NAME, new RoleBasedPermission(USER_NAME, RoleType.PACKAGE_READONLY.getName(), package1Name, null));
        this.roleBasedPermissionManager.create();
        try {
            Asset asset = this.repositoryAssetService.loadRuleAsset(uuid1);
            try {
                asset = this.repositoryAssetService.loadRuleAsset(uuid2);
                Assert.fail((String)"Did not catch expected exception");
            }
            catch (AuthorizationException e) {
                // empty catch block
            }
        }
        finally {
            this.roleBasedPermissionStore.clearAllRoleBasedPermissionsForTesting(USER_NAME);
            this.roleBasedPermissionResolver.setEnableRoleBasedAuthorization(false);
        }
    }

    @Test
    public void testLoadRuleAssetNoCategory() throws Exception {
        this.rulesRepository.createModule("testLoadRuleAssetNoCategoryPack1", "desc");
        this.repositoryCategoryService.createCategory("", "testLoadRuleAssetNoCategoryCat1", "this is a cat");
        String uuid = this.serviceImplementation.createNewRule("testLoadRuleAssetNoCategoryRule1", "description", null, "testLoadRuleAssetNoCategoryPack1", "drl");
        Asset asset = this.repositoryAssetService.loadRuleAsset(uuid);
        Assert.assertNotNull((Object)asset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLoadRuleAssetNoCategoryPackageAdmin() throws Exception {
        ModuleItem packageItem = this.rulesRepository.createModule("testLoadRuleAssetNoCategoryPackageAdminPack1", "desc");
        String packageName = packageItem.getName();
        String packageUuid = packageItem.getUUID();
        this.repositoryCategoryService.createCategory("", "testLoadRuleAssetNoCategoryPackageAdminCat1", "this is a cat");
        String uuid = this.serviceImplementation.createNewRule("testLoadRuleAssetNoCategoryPackageAdminRule1", "description", null, "testLoadRuleAssetNoCategoryPackageAdminPack1", "drl");
        this.roleBasedPermissionResolver.setEnableRoleBasedAuthorization(true);
        this.roleBasedPermissionStore.addRoleBasedPermissionForTesting(USER_NAME, new RoleBasedPermission(USER_NAME, RoleType.PACKAGE_ADMIN.getName(), packageName, null));
        this.roleBasedPermissionManager.create();
        try {
            Asset asset = this.repositoryAssetService.loadRuleAsset(uuid);
            Assert.assertNotNull((Object)asset);
        }
        finally {
            this.roleBasedPermissionStore.clearAllRoleBasedPermissionsForTesting(USER_NAME);
            this.roleBasedPermissionResolver.setEnableRoleBasedAuthorization(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLoadRuleAssetNoCategoryAnalystNegative() throws Exception {
        ModuleItem packageItem = this.rulesRepository.createModule("testLoadRuleAssetNoCategoryAnalystPack1", "desc");
        String packageUuid = packageItem.getUUID();
        this.repositoryCategoryService.createCategory("", "testLoadRuleAssetNoCategoryAnalystCat1", "this is a cat");
        this.repositoryCategoryService.createCategory("", "testLoadRuleAssetNoCategoryAnalystCat2", "this is a cat");
        String uuid1 = this.serviceImplementation.createNewRule("testLoadRuleAssetNoCategoryAnalystRule1", "description", null, "testLoadRuleAssetNoCategoryAnalystPack1", "drl");
        String uuid2 = this.serviceImplementation.createNewRule("testLoadRuleAssetNoCategoryAnalystRule2", "description", "testLoadRuleAssetNoCategoryAnalystCat2", "testLoadRuleAssetNoCategoryAnalystPack1", "drl");
        this.roleBasedPermissionResolver.setEnableRoleBasedAuthorization(true);
        this.roleBasedPermissionStore.addRoleBasedPermissionForTesting(USER_NAME, new RoleBasedPermission(USER_NAME, RoleType.ANALYST.getName(), null, "testLoadRuleAssetNoCategoryAnalystCat2"));
        this.roleBasedPermissionManager.create();
        try {
            Asset asset2 = this.repositoryAssetService.loadRuleAsset(uuid2);
            try {
                Asset asset1 = this.repositoryAssetService.loadRuleAsset(uuid1);
                Assert.fail((String)"Did not catch expected exception");
            }
            catch (AuthorizationException e) {
                // empty catch block
            }
        }
        finally {
            this.roleBasedPermissionStore.clearAllRoleBasedPermissionsForTesting(USER_NAME);
            this.roleBasedPermissionResolver.setEnableRoleBasedAuthorization(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Ignore(value="See JIRA https://issues.jboss.org/browse/GUVNOR-1813")
    public void testLoadRuleAssetNoCategoryAnalystPositive() throws Exception {
        ModuleItem packageItem = this.rulesRepository.createModule("testLoadRuleAssetNoCategoryAnalystPositivePack1", "desc");
        String packageUuid = packageItem.getUUID();
        this.repositoryCategoryService.createCategory("", "testLoadRuleAssetNoCategoryAnalystPositiveCat1", "this is a cat");
        this.repositoryCategoryService.createCategory("", "testLoadRuleAssetNoCategoryAnalystPositiveCat2", "this is a cat");
        String uuid1 = this.serviceImplementation.createNewRule("testLoadRuleAssetNoCategoryAnalystPositiveRule1", "description", null, "testLoadRuleAssetNoCategoryAnalystPositivePack1", "drl");
        String uuid2 = this.serviceImplementation.createNewRule("testLoadRuleAssetNoCategoryAnalystPositiveRule2", "description", "testLoadRuleAssetNoCategoryAnalystPositiveCat2", "testLoadRuleAssetNoCategoryAnalystPositivePack1", "drl");
        this.roleBasedPermissionResolver.setEnableRoleBasedAuthorization(true);
        this.roleBasedPermissionStore.addRoleBasedPermissionForTesting(USER_NAME, new RoleBasedPermission(USER_NAME, RoleType.ANALYST.getName(), null, null));
        this.roleBasedPermissionManager.create();
        try {
            Asset asset1 = this.repositoryAssetService.loadRuleAsset(uuid1);
        }
        finally {
            this.roleBasedPermissionStore.clearAllRoleBasedPermissionsForTesting(USER_NAME);
            this.roleBasedPermissionResolver.setEnableRoleBasedAuthorization(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLoadRuleAssetWithRoleBasedAuthrozationAssetHasCategory() throws Exception {
        String category1 = "testLoadRuleAssetWithRoleBasedAuthrozationAssetHasCategoryCat";
        ModuleItem packageItem = this.rulesRepository.createModule("testLoadRuleAssetWithRoleBasedAuthrozationAssetHasCategoryPack", "desc");
        String packageUuid = packageItem.getUUID();
        this.repositoryCategoryService.createCategory("", category1, "this is a cat");
        String uuid = this.serviceImplementation.createNewRule("testLoadRuleAssetWithRoleBasedAuthrozationAssetHasCategory", "description", category1, "testLoadRuleAssetWithRoleBasedAuthrozationAssetHasCategoryPack", "drl");
        this.roleBasedPermissionResolver.setEnableRoleBasedAuthorization(true);
        this.roleBasedPermissionStore.addRoleBasedPermissionForTesting(USER_NAME, new RoleBasedPermission(USER_NAME, RoleType.ANALYST.getName(), null, category1));
        this.roleBasedPermissionManager.create();
        try {
            Asset asset = null;
            try {
                asset = this.repositoryAssetService.loadRuleAsset(uuid);
            }
            catch (AuthorizationException e) {
                Assert.fail((String)"User has permissions for the category");
            }
        }
        finally {
            this.roleBasedPermissionStore.clearAllRoleBasedPermissionsForTesting(USER_NAME);
            this.roleBasedPermissionResolver.setEnableRoleBasedAuthorization(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLoadRuleAssetWithRoleBasedAuthrozationAssetNoCategoryMixed() throws Exception {
        ModuleItem packageItem = this.rulesRepository.createModule("testLoadRuleAssetWithRoleBasedAuthrozationAssetNoCategoryMixedPack", "desc");
        String packageUuid = packageItem.getUUID();
        this.repositoryCategoryService.createCategory("", "testLoadRuleAssetWithRoleBasedAuthrozationAssetNoCategoryMixedCat", "this is a cat");
        String uuid = this.serviceImplementation.createNewRule("testLoadRuleAssetWithRoleBasedAuthrozation", "description", null, "testLoadRuleAssetWithRoleBasedAuthrozationAssetNoCategoryMixedPack", "drl");
        this.roleBasedPermissionResolver.setEnableRoleBasedAuthorization(true);
        this.roleBasedPermissionStore.addRoleBasedPermissionForTesting(USER_NAME, new RoleBasedPermission(USER_NAME, RoleType.ANALYST.getName(), null, "category1"));
        this.roleBasedPermissionStore.addRoleBasedPermissionForTesting(USER_NAME, new RoleBasedPermission(USER_NAME, RoleType.PACKAGE_ADMIN.getName(), packageUuid, null));
        this.roleBasedPermissionManager.create();
        try {
            try {
                Asset asset = this.repositoryAssetService.loadRuleAsset(uuid);
                Assert.fail((String)"Did not catch expected exception");
            }
            catch (AuthorizationException e) {
                // empty catch block
            }
        }
        finally {
            this.roleBasedPermissionStore.clearAllRoleBasedPermissionsForTesting(USER_NAME);
            this.roleBasedPermissionResolver.setEnableRoleBasedAuthorization(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateNewRule() throws Exception {
        this.rulesRepository.createModule("testSecurityCreateNewRule", "desc");
        this.repositoryCategoryService.createCategory("", "testSecurityCreateNewRule", "this is a cat");
        this.roleBasedPermissionResolver.setEnableRoleBasedAuthorization(true);
        try {
            this.serviceImplementation.createNewRule("testCreateNewRuleName22", "an initial desc", "testSecurityCreateNewRule", "testSecurityCreateNewRule", "dslr");
            Assert.fail((String)"not allowed");
        }
        catch (AuthorizationException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
        finally {
            this.roleBasedPermissionResolver.setEnableRoleBasedAuthorization(false);
        }
        this.serviceImplementation.createNewRule("testCreateNewRuleName22", "an initial desc", "testSecurityCreateNewRule", "testSecurityCreateNewRule", "dslr");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCheckinWithPackageReadonly() throws Exception {
        String packageUuid = this.repositoryPackageService.createModule("testCheckinWithPackageReadonlyPack", "desc", "package");
        this.repositoryCategoryService.createCategory("/", "testCheckinWithPackageReadonlyCat", "this is a description");
        this.repositoryCategoryService.createCategory("testCheckinWithPackageReadonlyCat", "deeper", "description");
        String uuid = this.serviceImplementation.createNewRule("testChecking", "this is a description", "testCheckinWithPackageReadonlyCat", "testCheckinWithPackageReadonlyPack", "drl");
        Asset asset = this.repositoryAssetService.loadRuleAsset(uuid);
        Assert.assertNotNull((Object)asset.getLastModified());
        asset.getMetaData().setCoverage("boo");
        asset.setContent((PortableObject)new RuleContentText());
        ((RuleContentText)asset.getContent()).content = "yeah !";
        Thread.sleep(100L);
        this.roleBasedPermissionResolver.setEnableRoleBasedAuthorization(true);
        this.roleBasedPermissionStore.addRoleBasedPermissionForTesting(USER_NAME, new RoleBasedPermission(USER_NAME, RoleType.PACKAGE_READONLY.getName(), packageUuid, null));
        this.roleBasedPermissionManager.create();
        try {
            try {
                this.repositoryAssetService.checkinVersion(asset);
                Assert.fail((String)"Did not catch expected exception");
            }
            catch (AuthorizationException e) {
                // empty catch block
            }
        }
        finally {
            this.roleBasedPermissionStore.clearAllRoleBasedPermissionsForTesting(USER_NAME);
            this.roleBasedPermissionResolver.setEnableRoleBasedAuthorization(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCheckinPackageDeveloper() throws Exception {
        String packageName = "testCheckinPackageDeveloperPack1";
        String packageUuid = this.repositoryPackageService.createModule(packageName, "desc", "package");
        this.repositoryCategoryService.createCategory("/", "testCheckinPackageDeveloperCat1", "this is a description");
        this.repositoryCategoryService.createCategory("testCheckinPackageDeveloperCat1", "deeper", "description");
        String uuid = this.serviceImplementation.createNewRule("testCheckinPackageDeveloperRule1", "this is a description", "testCheckinPackageDeveloperCat1", "testCheckinPackageDeveloperPack1", "drl");
        Asset asset = this.repositoryAssetService.loadRuleAsset(uuid);
        Assert.assertNotNull((Object)asset.getLastModified());
        asset.getMetaData().setCoverage("boo");
        asset.setContent((PortableObject)new RuleContentText());
        ((RuleContentText)asset.getContent()).content = "yeah !";
        Thread.sleep(100L);
        this.roleBasedPermissionResolver.setEnableRoleBasedAuthorization(true);
        this.roleBasedPermissionStore.addRoleBasedPermissionForTesting(USER_NAME, new RoleBasedPermission(USER_NAME, RoleType.PACKAGE_DEVELOPER.getName(), packageName, null));
        this.roleBasedPermissionManager.create();
        try {
            String uuid2 = this.repositoryAssetService.checkinVersion(asset);
            Assert.assertEquals((Object)uuid, (Object)uuid2);
        }
        finally {
            this.roleBasedPermissionStore.clearAllRoleBasedPermissionsForTesting(USER_NAME);
            this.roleBasedPermissionResolver.setEnableRoleBasedAuthorization(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLoadRuleAssetWithRoleBasedAuthrozationPackageReadonlyFilter() throws Exception {
        String package3Name = "testLoadRuleAssetWithRoleBasedAuthrozationPackageReadonlyPack3";
        String package3Uuid = this.repositoryPackageService.createModule(package3Name, "desc", "package");
        this.repositoryCategoryService.createCategory("", "testLoadRuleAssetWithRoleBasedAuthrozationPackageReadonlyCat3", "this is a cat");
        String uuid3 = this.serviceImplementation.createNewRule("testLoadRuleAssetWithRoleBasedAuthrozation", "ReadonlyFilterDescription", "testLoadRuleAssetWithRoleBasedAuthrozationPackageReadonlyCat3", package3Name, "drl");
        String package4Name = "testLoadRuleAssetWithRoleBasedAuthrozationPackageReadonlyPack4";
        this.rulesRepository.createModule(package4Name, "desc");
        String uuid2 = this.serviceImplementation.createNewRule("testLoadRuleAssetWithRoleBasedAuthrozation", "ReadonlyFilterDescription", "testLoadRuleAssetWithRoleBasedAuthrozationPackageReadonlyCat3", package4Name, "drl");
        this.roleBasedPermissionResolver.setEnableRoleBasedAuthorization(true);
        this.roleBasedPermissionStore.addRoleBasedPermissionForTesting(USER_NAME, new RoleBasedPermission(USER_NAME, RoleType.PACKAGE_READONLY.getName(), package3Name, null));
        this.roleBasedPermissionManager.create();
        try {
            TableDataResult result = this.repositoryAssetService.queryFullText("testLoadRuleAssetWithRoleBasedAuthrozation", true, 0, -1);
            Assert.assertEquals((long)1L, (long)result.data.length);
        }
        finally {
            this.roleBasedPermissionStore.clearAllRoleBasedPermissionsForTesting(USER_NAME);
            this.roleBasedPermissionResolver.setEnableRoleBasedAuthorization(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLoadRuleAssetWithRoleBasedAuthrozationPackageReadonlyMetaDataFilter() throws Exception {
        String rule7Name = "testLoadRuleAssetWithRoleBasedAuthrozationForMetaData7";
        String rule8Name = "testLoadRuleAssetWithRoleBasedAuthrozationForMetaData8";
        String package7Name = "testLoadRuleAssetWithRoleBasedAuthrozationPackageReadonlyPack7";
        String category7Name = "testLoadRuleAssetWithRoleBasedAuthrozationPackageReadonlyCat7";
        ModuleItem packageItem7 = this.rulesRepository.createModule(package7Name, "desc");
        String packageItem7UUID = packageItem7.getUUID();
        this.repositoryCategoryService.createCategory("", category7Name, "this is a rabbit");
        String uuid7 = this.serviceImplementation.createNewRule(rule7Name, "MetaDataFilterDescription7", category7Name, package7Name, "drl");
        String package8Name = "testLoadRuleAssetWithRoleBasedAuthrozationPackageReadonlyPack8";
        String category8Name = "testLoadRuleAssetWithRoleBasedAuthrozationPackageReadonlyCat8";
        ModuleItem packageItem8 = this.rulesRepository.createModule(package8Name, "desc");
        String packageItem8UUID = packageItem8.getUUID();
        this.repositoryCategoryService.createCategory("", category8Name, "this is a mouse");
        String uuid8 = this.serviceImplementation.createNewRule(rule8Name, "MetaDataFilterDescription8", category8Name, package8Name, "drl");
        this.roleBasedPermissionResolver.setEnableRoleBasedAuthorization(true);
        this.roleBasedPermissionStore.addRoleBasedPermissionForTesting(USER_NAME, new RoleBasedPermission(USER_NAME, RoleType.PACKAGE_READONLY.getName(), package7Name, null));
        this.roleBasedPermissionStore.addRoleBasedPermissionForTesting(USER_NAME, new RoleBasedPermission(USER_NAME, RoleType.ANALYST.getName(), null, category7Name));
        this.roleBasedPermissionStore.addRoleBasedPermissionForTesting(USER_NAME, new RoleBasedPermission(USER_NAME, RoleType.ANALYST.getName(), null, category8Name));
        this.roleBasedPermissionManager.create();
        try {
            MetaDataQuery[] qr = new MetaDataQuery[]{new MetaDataQuery()};
            qr[0].attribute = "drools:description";
            qr[0].valueList = "MetaDataFilterDescription%";
            TableDataResult result = this.serviceImplementation.queryMetaData(qr, null, null, null, null, false, 0, -1);
            Assert.assertEquals((long)2L, (long)result.data.length);
        }
        finally {
            this.roleBasedPermissionStore.clearAllRoleBasedPermissionsForTesting(USER_NAME);
            this.roleBasedPermissionResolver.setEnableRoleBasedAuthorization(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLoadRuleAssetWithRoleBasedAuthrozationPackageReadonlyMetaDataFilter2() throws Exception {
        String rule5Name = "testLoadRuleAssetWithRoleBasedAuthrozationForMetaData5";
        String rule6Name = "testLoadRuleAssetWithRoleBasedAuthrozationForMetaData6";
        String package5Name = "testLoadRuleAssetWithRoleBasedAuthrozationPackageReadonlyPack5";
        String category5Name = "testLoadRuleAssetWithRoleBasedAuthrozationPackageReadonlyCat5";
        ModuleItem packageItem5 = this.rulesRepository.createModule(package5Name, "desc");
        String packageItem5UUID = packageItem5.getUUID();
        this.repositoryCategoryService.createCategory("", category5Name, "this is a cat");
        String uuid7 = this.serviceImplementation.createNewRule(rule5Name, "MetaDataFilter2Description5", category5Name, package5Name, "drl");
        String package6Name = "testLoadRuleAssetWithRoleBasedAuthrozationPackageReadonlyPack6";
        String category6Name = "testLoadRuleAssetWithRoleBasedAuthrozationPackageReadonlyCat6";
        ModuleItem packageItem6 = this.rulesRepository.createModule(package6Name, "desc");
        String packageItem6UUID = packageItem6.getUUID();
        this.repositoryCategoryService.createCategory("", category6Name, "this is a dog");
        String uuid6 = this.serviceImplementation.createNewRule(rule6Name, "MetaDataFilter2Description6", category6Name, package6Name, "drl");
        this.roleBasedPermissionResolver.setEnableRoleBasedAuthorization(true);
        this.roleBasedPermissionStore.addRoleBasedPermissionForTesting(USER_NAME, new RoleBasedPermission(USER_NAME, RoleType.PACKAGE_READONLY.getName(), package5Name, null));
        this.roleBasedPermissionStore.addRoleBasedPermissionForTesting(USER_NAME, new RoleBasedPermission(USER_NAME, RoleType.PACKAGE_READONLY.getName(), package6Name, null));
        this.roleBasedPermissionManager.create();
        try {
            MetaDataQuery[] qr = new MetaDataQuery[]{new MetaDataQuery()};
            qr[0].attribute = "drools:description";
            qr[0].valueList = "MetaDataFilter2Description%";
            TableDataResult result = this.serviceImplementation.queryMetaData(qr, null, null, null, null, false, 0, -1);
            Assert.assertEquals((long)2L, (long)result.data.length);
        }
        finally {
            this.roleBasedPermissionStore.clearAllRoleBasedPermissionsForTesting(USER_NAME);
            this.roleBasedPermissionResolver.setEnableRoleBasedAuthorization(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLoadRuleAssetWithRoleBasedAuthrozationPackageReadonlyMetaDataFilter3() throws Exception {
        String rule9Name = "testLoadRuleAssetWithRoleBasedAuthrozationForMetaData9";
        String rule10Name = "testLoadRuleAssetWithRoleBasedAuthrozationForMetaData10";
        String package9Name = "testLoadRuleAssetWithRoleBasedAuthrozationPackageReadonlyPack9";
        String category9Name = "testLoadRuleAssetWithRoleBasedAuthrozationPackageReadonlyCat9";
        ModuleItem packageItem9 = this.rulesRepository.createModule(package9Name, "desc");
        String packageItem9UUID = packageItem9.getUUID();
        this.repositoryCategoryService.createCategory("", category9Name, "this is a pigeon");
        String uuid9 = this.serviceImplementation.createNewRule(rule9Name, "MetaDataFilter3Description9", category9Name, package9Name, "drl");
        String package10Name = "testLoadRuleAssetWithRoleBasedAuthrozationPackageReadonlyPack10";
        String category10Name = "testLoadRuleAssetWithRoleBasedAuthrozationPackageReadonlyCat10";
        ModuleItem packageItem10 = this.rulesRepository.createModule(package10Name, "desc");
        String packageItem10UUID = packageItem10.getUUID();
        this.repositoryCategoryService.createCategory("", category10Name, "this is a sparrow");
        String uuid10 = this.serviceImplementation.createNewRule(rule10Name, "MetaDataFilter3Description10", category10Name, package10Name, "drl");
        this.roleBasedPermissionResolver.setEnableRoleBasedAuthorization(true);
        this.roleBasedPermissionStore.addRoleBasedPermissionForTesting(USER_NAME, new RoleBasedPermission(USER_NAME, RoleType.ANALYST.getName(), null, category9Name));
        this.roleBasedPermissionStore.addRoleBasedPermissionForTesting(USER_NAME, new RoleBasedPermission(USER_NAME, RoleType.ANALYST.getName(), null, category10Name));
        this.roleBasedPermissionManager.create();
        try {
            MetaDataQuery[] qr = new MetaDataQuery[]{new MetaDataQuery()};
            qr[0].attribute = "drools:description";
            qr[0].valueList = "MetaDataFilter3Description%";
            TableDataResult result = this.serviceImplementation.queryMetaData(qr, null, null, null, null, false, 0, -1);
            Assert.assertEquals((long)2L, (long)result.data.length);
        }
        finally {
            this.roleBasedPermissionStore.clearAllRoleBasedPermissionsForTesting(USER_NAME);
            this.roleBasedPermissionResolver.setEnableRoleBasedAuthorization(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTableDisplayHandler() throws Exception {
        String rule11Name = "testLoadRuleAssetWithRoleBasedAuthrozationForMetaData11";
        String rule12Name = "testLoadRuleAssetWithRoleBasedAuthrozationForMetaData12";
        String package11Name = "testLoadRuleAssetWithRoleBasedAuthrozationPackageReadonlyPack11";
        String category11Name = "testLoadRuleAssetWithRoleBasedAuthrozationPackageReadonlyCat11";
        ModuleItem packageItem11 = this.rulesRepository.createModule(package11Name, "desc");
        String packageItem11UUID = packageItem11.getUUID();
        this.repositoryCategoryService.createCategory("", category11Name, "this is a dock");
        String uuid11 = this.serviceImplementation.createNewRule(rule11Name, "DisplayHandlerDescription11", category11Name, package11Name, "drl");
        String package12Name = "testLoadRuleAssetWithRoleBasedAuthrozationPackageReadonlyPack12";
        String category12Name = "testLoadRuleAssetWithRoleBasedAuthrozationPackageReadonlyCat12";
        ModuleItem packageItem12 = this.rulesRepository.createModule(package12Name, "desc");
        String packageItem12UUID = packageItem12.getUUID();
        this.repositoryCategoryService.createCategory("", category12Name, "this is a sparrow");
        String uuid12 = this.serviceImplementation.createNewRule(rule12Name, "DisplayHandlerDescription12", category12Name, package12Name, "drl");
        this.roleBasedPermissionResolver.setEnableRoleBasedAuthorization(true);
        this.roleBasedPermissionStore.addRoleBasedPermissionForTesting(USER_NAME, new RoleBasedPermission(USER_NAME, RoleType.ANALYST.getName(), null, category11Name));
        this.roleBasedPermissionStore.addRoleBasedPermissionForTesting(USER_NAME, new RoleBasedPermission(USER_NAME, RoleType.ANALYST.getName(), null, category12Name));
        this.roleBasedPermissionManager.create();
        try {
            MetaDataQuery[] qr = new MetaDataQuery[]{new MetaDataQuery()};
            qr[0].attribute = "drools:description";
            qr[0].valueList = "DisplayHandlerDescription%";
            TableDataResult result = this.serviceImplementation.queryMetaData(qr, null, null, null, null, false, 1, 1);
            Assert.assertEquals((long)1L, (long)result.data.length);
            result = this.serviceImplementation.queryMetaData(qr, null, null, null, null, false, 0, 1);
            Assert.assertEquals((long)1L, (long)result.data.length);
            result = this.serviceImplementation.queryMetaData(qr, null, null, null, null, false, 0, 4);
            Assert.assertEquals((long)2L, (long)result.data.length);
            result = this.serviceImplementation.queryMetaData(qr, null, null, null, null, false, -1, 4);
            Assert.assertEquals((long)2L, (long)result.data.length);
            result = this.serviceImplementation.queryMetaData(qr, null, null, null, null, false, 6, 4);
            Assert.assertEquals((long)0L, (long)result.data.length);
        }
        finally {
            this.roleBasedPermissionStore.clearAllRoleBasedPermissionsForTesting(USER_NAME);
            this.roleBasedPermissionResolver.setEnableRoleBasedAuthorization(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testListPackagesPackageAdminAndAnalyst() throws Exception {
        String package1Name = "testListPackagesPackageAdminAndAnalystPack1";
        String package2Name = "testListPackagesPackageAdminAndAnalystPack2";
        String category1Name = "testListPackagesPackageAdminAndAnalystCat1";
        String package1UUID = this.rulesRepository.createModule(package1Name, "desc").getUUID();
        this.rulesRepository.createModule(package2Name, "desc");
        this.repositoryCategoryService.createCategory("", category1Name, "this is a cat");
        this.serviceImplementation.createNewRule("testListPackagesPackageAdminAndAnalystRule1", "description", null, package1Name, "drl");
        this.serviceImplementation.createNewRule("testListPackagesPackageAdminAndAnalystRule2", "description", category1Name, package2Name, "drl");
        this.serviceImplementation.createNewRule("testListPackagesPackageAdminAndAnalystRule3", "description", null, package2Name, "drl");
        this.roleBasedPermissionResolver.setEnableRoleBasedAuthorization(true);
        this.roleBasedPermissionStore.addRoleBasedPermissionForTesting(USER_NAME, new RoleBasedPermission(USER_NAME, RoleType.PACKAGE_ADMIN.getName(), package1Name, null));
        this.roleBasedPermissionStore.addRoleBasedPermissionForTesting(USER_NAME, new RoleBasedPermission(USER_NAME, RoleType.ANALYST.getName(), null, category1Name));
        this.roleBasedPermissionManager.create();
        try {
            Module[] res = this.repositoryPackageService.listModules();
            Assert.assertEquals((long)1L, (long)res.length);
        }
        finally {
            this.roleBasedPermissionStore.clearAllRoleBasedPermissionsForTesting(USER_NAME);
            this.roleBasedPermissionResolver.setEnableRoleBasedAuthorization(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLoadChildCategories() throws Exception {
        String package1Name = "testLoadChildCategoriesPack1";
        String category1Name = "testLoadChildCategoriesCat1";
        String category2Name = "testLoadChildCategoriesCat2";
        this.rulesRepository.createModule(package1Name, "desc");
        this.repositoryCategoryService.createCategory("", category1Name, "this is a cat");
        this.repositoryCategoryService.createCategory("", category2Name, "this is a cat");
        this.serviceImplementation.createNewRule("testLoadChildCategoriesRule1", "description", category1Name, package1Name, "drl");
        this.serviceImplementation.createNewRule("testLoadChildCategoriesRule2", "description", category2Name, package1Name, "drl");
        this.roleBasedPermissionResolver.setEnableRoleBasedAuthorization(true);
        this.roleBasedPermissionStore.addRoleBasedPermissionForTesting(USER_NAME, new RoleBasedPermission(USER_NAME, RoleType.ANALYST.getName(), null, category1Name));
        this.roleBasedPermissionManager.create();
        try {
            String[] res = this.repositoryCategoryService.loadChildCategories("/");
            Assert.assertEquals((long)1L, (long)res.length);
        }
        finally {
            this.roleBasedPermissionStore.clearAllRoleBasedPermissionsForTesting(USER_NAME);
            this.roleBasedPermissionResolver.setEnableRoleBasedAuthorization(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testloadRuleListForCategoriesPackageReadonly() throws Exception {
        String package1Name = "testloadRuleListForCategoriesPackageReadonlyPack1";
        String category1Name = "testloadRuleListForCategoriesPackageReadonlyCat1";
        this.rulesRepository.createModule(package1Name, "desc");
        this.repositoryCategoryService.createCategory("", category1Name, "this is a cat");
        this.serviceImplementation.createNewRule("testloadRuleListForCategoriesPackageReadonlyRule1", "description", category1Name, package1Name, "drl");
        String package2Name = "testloadRuleListForCategoriesPackageReadonlyPack2";
        this.rulesRepository.createModule(package2Name, "desc");
        this.serviceImplementation.createNewRule("testloadRuleListForCategoriesPackageReadonlyRule2", "description", category1Name, package2Name, "drl");
        String package3Name = "testloadRuleListForCategoriesPackageReadonlyPack3";
        this.rulesRepository.createModule(package3Name, "desc");
        this.serviceImplementation.createNewRule("testloadRuleListForCategoriesPackageReadonlyRule3", "description", category1Name, package3Name, "drl");
        this.roleBasedPermissionResolver.setEnableRoleBasedAuthorization(true);
        this.roleBasedPermissionStore.addRoleBasedPermissionForTesting(USER_NAME, new RoleBasedPermission(USER_NAME, RoleType.PACKAGE_READONLY.getName(), package1Name, null));
        this.roleBasedPermissionStore.addRoleBasedPermissionForTesting(USER_NAME, new RoleBasedPermission(USER_NAME, RoleType.PACKAGE_DEVELOPER.getName(), package2Name, null));
        this.roleBasedPermissionManager.create();
        try {
            TableDataResult res = this.repositoryCategoryService.loadRuleListForCategories("testloadRuleListForCategoriesPackageReadonlyCat1", 0, -1, "rulelist");
            Assert.assertEquals((long)0L, (long)res.data.length);
        }
        finally {
            this.roleBasedPermissionStore.clearAllRoleBasedPermissionsForTesting(USER_NAME);
            this.roleBasedPermissionResolver.setEnableRoleBasedAuthorization(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testloadRuleListForCategoriesPackageReadonlyPositive() throws Exception {
        String package1Name = "testloadRuleListForCategoriesPackageReadonlyPositivePack1";
        String category1Name = "testloadRuleListForCategoriesPackageReadonlyPositiveCat1";
        this.rulesRepository.createModule(package1Name, "desc");
        this.repositoryCategoryService.createCategory("", category1Name, "this is a cat");
        this.serviceImplementation.createNewRule("testloadRuleListForCategoriesPackageReadonlyPositiveRule1", "description", category1Name, package1Name, "drl");
        String package2Name = "testloadRuleListForCategoriesPackageReadonlyPositivePack2";
        this.rulesRepository.createModule(package2Name, "desc");
        this.serviceImplementation.createNewRule("testloadRuleListForCategoriesPackageReadonlyPositiveRule2", "description", category1Name, package2Name, "drl");
        String package3Name = "testloadRuleListForCategoriesPackageReadonlyPositivePack3";
        this.rulesRepository.createModule(package3Name, "desc");
        this.serviceImplementation.createNewRule("testloadRuleListForCategoriesPackageReadonlyPositiveRule3", "description", category1Name, package3Name, "drl");
        this.roleBasedPermissionResolver.setEnableRoleBasedAuthorization(true);
        this.roleBasedPermissionStore.addRoleBasedPermissionForTesting(USER_NAME, new RoleBasedPermission(USER_NAME, RoleType.PACKAGE_READONLY.getName(), package1Name, null));
        this.roleBasedPermissionStore.addRoleBasedPermissionForTesting(USER_NAME, new RoleBasedPermission(USER_NAME, RoleType.PACKAGE_DEVELOPER.getName(), package2Name, null));
        this.roleBasedPermissionStore.addRoleBasedPermissionForTesting(USER_NAME, new RoleBasedPermission(USER_NAME, RoleType.ANALYST_READ.getName(), null, category1Name));
        this.roleBasedPermissionManager.create();
        try {
            TableDataResult res = this.repositoryCategoryService.loadRuleListForCategories("testloadRuleListForCategoriesPackageReadonlyPositiveCat1", 0, -1, "rulelist");
            Assert.assertEquals((long)3L, (long)res.data.length);
        }
        finally {
            this.roleBasedPermissionStore.clearAllRoleBasedPermissionsForTesting(USER_NAME);
            this.roleBasedPermissionResolver.setEnableRoleBasedAuthorization(false);
        }
    }
}

