/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server;

import com.google.gwt.user.client.rpc.SerializationException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.KnowledgeBase;
import org.drools.Person;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.core.util.DateUtils;
import org.drools.core.util.DroolsStreamUtils;
import org.drools.guvnor.client.rpc.Asset;
import org.drools.guvnor.client.rpc.BuilderResult;
import org.drools.guvnor.client.rpc.BuilderResultLine;
import org.drools.guvnor.client.rpc.DiscussionRecord;
import org.drools.guvnor.client.rpc.InboxPageRequest;
import org.drools.guvnor.client.rpc.MetaDataQuery;
import org.drools.guvnor.client.rpc.Module;
import org.drools.guvnor.client.rpc.NewAssetConfiguration;
import org.drools.guvnor.client.rpc.NewAssetWithContentConfiguration;
import org.drools.guvnor.client.rpc.NewGuidedDecisionTableAssetConfiguration;
import org.drools.guvnor.client.rpc.PageRequest;
import org.drools.guvnor.client.rpc.PageResponse;
import org.drools.guvnor.client.rpc.PermissionsPageRow;
import org.drools.guvnor.client.rpc.QueryPageRequest;
import org.drools.guvnor.client.rpc.QueryPageRow;
import org.drools.guvnor.client.rpc.RuleContentText;
import org.drools.guvnor.client.rpc.StatePageRequest;
import org.drools.guvnor.client.rpc.TableConfig;
import org.drools.guvnor.client.rpc.TableDataResult;
import org.drools.guvnor.client.rpc.TableDataRow;
import org.drools.guvnor.server.cache.RuleBaseCache;
import org.drools.guvnor.server.repository.UserInbox;
import org.drools.guvnor.server.ruleeditor.workitem.AssetWorkDefinitionsLoader;
import org.drools.guvnor.server.ruleeditor.workitem.ConfigFileWorkDefinitionsLoader;
import org.drools.guvnor.server.test.GuvnorIntegrationTest;
import org.drools.guvnor.server.util.DroolsHeader;
import org.drools.guvnor.server.util.TableDisplayHandler;
import org.drools.guvnor.shared.api.PortableObject;
import org.drools.ide.common.client.modeldriven.dt52.ActionSetFieldCol52;
import org.drools.ide.common.client.modeldriven.dt52.ConditionCol52;
import org.drools.ide.common.client.modeldriven.dt52.GuidedDecisionTable52;
import org.drools.ide.common.client.modeldriven.dt52.Pattern52;
import org.drools.ide.common.server.util.upgrade.GuidedDecisionTableUpgradeHelper1;
import org.drools.io.Resource;
import org.drools.io.impl.InputStreamResource;
import org.drools.process.core.datatype.impl.type.BooleanDataType;
import org.drools.process.core.datatype.impl.type.EnumDataType;
import org.drools.process.core.datatype.impl.type.FloatDataType;
import org.drools.process.core.datatype.impl.type.IntegerDataType;
import org.drools.process.core.datatype.impl.type.ListDataType;
import org.drools.process.core.datatype.impl.type.ObjectDataType;
import org.drools.process.core.datatype.impl.type.StringDataType;
import org.drools.repository.AssetItem;
import org.drools.repository.CategoryItem;
import org.drools.repository.ModuleItem;
import org.drools.rule.Package;
import org.drools.runtime.StatelessKnowledgeSession;
import org.drools.type.DateFormats;
import org.drools.type.DateFormatsImpl;
import org.jbpm.process.workitem.WorkDefinitionImpl;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class ServiceImplementationIntegrationTest
extends GuvnorIntegrationTest {
    private GuidedDecisionTableUpgradeHelper1 upgrader = new GuidedDecisionTableUpgradeHelper1();

    @Test
    public void testDeleteUnversionedRule() throws Exception {
        this.rulesRepository.loadDefaultModule();
        this.rulesRepository.createModule("anotherPackage", "woot");
        CategoryItem cat = this.rulesRepository.loadCategory("/");
        cat.addCategory("testDeleteUnversioned", "yeah");
        String uuid = this.serviceImplementation.createNewRule("test Delete Unversioned", "a description", "testDeleteUnversioned", "anotherPackage", "txt");
        Assert.assertNotNull((Object)uuid);
        Assert.assertFalse((boolean)"".equals(uuid));
        AssetItem localItem = this.rulesRepository.loadAssetByUUID(uuid);
        Assert.assertEquals((Object)"test Delete Unversioned", (Object)localItem.getName());
        localItem.remove();
        this.rulesRepository.save();
        try {
            localItem = this.rulesRepository.loadAssetByUUID(uuid);
            Assert.fail();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testAddRuleAndListPackages() throws Exception {
        this.rulesRepository.loadDefaultModule();
        this.rulesRepository.createModule("another", "woot");
        CategoryItem cat = this.rulesRepository.loadCategory("/");
        cat.addCategory("testAddRule", "yeah");
        String result = this.serviceImplementation.createNewRule("test AddRule", "a description", "testAddRule", "another", "txt");
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)"".equals(result));
        Module[] packages = this.repositoryPackageService.listModules();
        Assert.assertTrue((packages.length > 0 ? 1 : 0) != 0);
        boolean found = false;
        for (int i = 0; i < packages.length; ++i) {
            if (!packages[i].getName().equals("another")) continue;
            found = true;
        }
        Assert.assertTrue((boolean)found);
        Assert.assertFalse((packages[0].getUuid() == null ? 1 : 0) != 0);
        Assert.assertFalse((boolean)packages[0].getUuid().equals(""));
        result = this.serviceImplementation.createNewRule("testDTSample", "a description", "testAddRule", "another", "xls");
        AssetItem dtItem = this.rulesRepository.loadAssetByUUID(result);
        Assert.assertNull((Object)dtItem.getBinaryContentAttachment());
        Assert.assertEquals((long)0L, (long)dtItem.getBinaryContentAsBytes().length);
    }

    @Test
    public void testAttemptDupeRule() throws Exception {
        CategoryItem cat = this.rulesRepository.loadCategory("/");
        cat.addCategory("testAttemptDupeRule", "yeah");
        this.rulesRepository.createModule("dupes", "yeah");
        this.serviceImplementation.createNewRule("testAttemptDupeRule", "ya", "testAttemptDupeRule", "dupes", "rule");
        String uuid = this.serviceImplementation.createNewRule("testAttemptDupeRule", "ya", "testAttemptDupeRule", "dupes", "rule");
        Assert.assertEquals((Object)"DUPLICATE", (Object)uuid);
    }

    @Test
    public void testCreateNewRule() throws Exception {
        this.rulesRepository.createModule("testCreateNewRule", "desc");
        this.repositoryCategoryService.createCategory("", "testCreateNewRule", "this is a cat");
        String uuid = this.serviceImplementation.createNewRule("testCreateNewRuleName", "an initial desc", "testCreateNewRule", "testCreateNewRule", "dslr");
        Assert.assertNotNull((Object)uuid);
        Assert.assertFalse((boolean)"".equals(uuid));
        AssetItem dtItem = this.rulesRepository.loadAssetByUUID(uuid);
        Assert.assertEquals((Object)dtItem.getDescription(), (Object)"an initial desc");
    }

    @Test
    public void testCreateNewRuleUsingConfiguration() throws Exception {
        this.rulesRepository.createModule("testCreateNewRuleUsingConfiguration", "desc");
        this.repositoryCategoryService.createCategory("", "testCreateNewRuleUsingConfiguration", "this is a cat");
        NewAssetConfiguration config = new NewAssetConfiguration("testCreateNewRuleUsingConfigurationName", "testCreateNewRuleUsingConfiguration", null, "an initial desc", "testCreateNewRuleUsingConfiguration", "dslr");
        String uuid = this.serviceImplementation.createNewRule(config);
        Assert.assertNotNull((Object)uuid);
        Assert.assertFalse((boolean)"".equals(uuid));
        AssetItem dtItem = this.rulesRepository.loadAssetByUUID(uuid);
        Assert.assertEquals((Object)dtItem.getDescription(), (Object)"an initial desc");
    }

    @Test
    public void testCreateNewGuidedDecisionTableUsingConfiguration() throws Exception {
        this.rulesRepository.createModule("testCreateNewGuidedDecisionTableUsingConfiguration", "desc");
        this.repositoryCategoryService.createCategory("", "testCreateNewGuidedDecisionTableUsingConfiguration", "this is a cat");
        GuidedDecisionTable52 content = new GuidedDecisionTable52();
        content.setTableFormat(GuidedDecisionTable52.TableFormat.LIMITED_ENTRY);
        NewGuidedDecisionTableAssetConfiguration config = new NewGuidedDecisionTableAssetConfiguration("testCreateNewGuidedDecisionTableUsingConfigurationName", "testCreateNewGuidedDecisionTableUsingConfiguration", null, "an initial desc", "testCreateNewGuidedDecisionTableUsingConfiguration", "gdst", content);
        String uuid = this.serviceImplementation.createNewRule((NewAssetWithContentConfiguration)config);
        Assert.assertNotNull((Object)uuid);
        Assert.assertFalse((boolean)"".equals(uuid));
        AssetItem dtItem = this.rulesRepository.loadAssetByUUID(uuid);
        Assert.assertEquals((Object)dtItem.getDescription(), (Object)"an initial desc");
        Asset asset = this.repositoryAssetService.loadRuleAsset(uuid);
        GuidedDecisionTable52 retrievedContent = (GuidedDecisionTable52)asset.getContent();
        Assert.assertNotNull((Object)retrievedContent);
        Assert.assertEquals((Object)GuidedDecisionTable52.TableFormat.LIMITED_ENTRY, (Object)retrievedContent.getTableFormat());
    }

    @Test
    public void testCreateNewRuleContainsApostrophe() throws Exception {
        this.rulesRepository.createModule("testCreateNewRuleContainsApostropheContainsApostrophe", "desc");
        this.repositoryCategoryService.createCategory("", "testCreateNewRuleContainsApostropheContainsApostrophe", "this is a cat");
        String uuid = null;
        try {
            uuid = this.serviceImplementation.createNewRule("testCreateNewRuleContainsApostropheContains' character", "an initial desc", "testCreateNewRuleContainsApostropheContainsApostrophe", "testCreateNewRuleContainsApostropheContainsApostrophe", "dslr");
        }
        catch (SerializationException e) {
            // empty catch block
        }
        Asset assetWrapper = this.repositoryAssetService.loadRuleAsset(uuid);
        Assert.assertEquals((Object)assetWrapper.getDescription(), (Object)"an initial desc");
        Assert.assertEquals((Object)assetWrapper.getName(), (Object)"testCreateNewRuleContainsApostropheContains' character");
    }

    @Test
    @Deprecated
    public void testRuleTableLoad() throws Exception {
        TableConfig conf = this.serviceImplementation.loadTableConfig("rulelist");
        Assert.assertNotNull((Object)conf.headers);
        Assert.assertNotNull((Object)conf.headerTypes);
        CategoryItem cat = this.rulesRepository.loadCategory("/");
        cat.addCategory("testRuleTableLoad", "yeah");
        this.rulesRepository.createModule("testRuleTableLoad", "yeah");
        this.serviceImplementation.createNewRule("testRuleTableLoad", "ya", "testRuleTableLoad", "testRuleTableLoad", "rule");
        this.serviceImplementation.createNewRule("testRuleTableLoad2", "ya", "testRuleTableLoad", "testRuleTableLoad", "rule");
        TableDataResult result = this.repositoryCategoryService.loadRuleListForCategories("testRuleTableLoad", 0, -1, "rulelist");
        Assert.assertEquals((long)2L, (long)result.data.length);
        String key = result.data[0].id;
        Assert.assertFalse((boolean)key.startsWith("testRule"));
        Assert.assertEquals((Object)result.data[0].format, (Object)"rule");
        Assert.assertTrue((boolean)result.data[0].values[0].startsWith("testRuleTableLoad"));
    }

    @Test
    @Deprecated
    public void testDateFormatting() throws Exception {
        Calendar cal = Calendar.getInstance();
        TableDisplayHandler handler = new TableDisplayHandler("rulelist");
        String fmt = handler.formatDate(cal);
        Assert.assertNotNull((Object)fmt);
        Assert.assertTrue((fmt.length() > 8 ? 1 : 0) != 0);
    }

    @Test
    @Deprecated
    public void testListByFormat() throws Exception {
        String cat = "testListByFormat";
        this.repositoryCategoryService.createCategory("/", cat, "ya");
        String pkgUUID = this.repositoryPackageService.createModule("testListByFormat", "used for listing by format.", "package");
        String uuid = this.serviceImplementation.createNewRule("testListByFormat", "x", cat, "testListByFormat", "testListByFormat");
        String uuid2 = this.serviceImplementation.createNewRule("testListByFormat2", "x", cat, "testListByFormat", "testListByFormat");
        String uuid3 = this.serviceImplementation.createNewRule("testListByFormat3", "x", cat, "testListByFormat", "testListByFormat");
        String uuid4 = this.serviceImplementation.createNewRule("testListByFormat4", "x", cat, "testListByFormat", "testListByFormat");
        TableDataResult res = this.repositoryAssetService.listAssets(pkgUUID, this.arr("testListByFormat"), 0, -1, "rulelist");
        Assert.assertEquals((long)4L, (long)res.data.length);
        Assert.assertEquals((Object)uuid, (Object)res.data[0].id);
        Assert.assertEquals((Object)"testListByFormat", (Object)res.data[0].values[0]);
        res = this.repositoryAssetService.listAssets(pkgUUID, this.arr("testListByFormat"), 0, 4, "rulelist");
        Assert.assertEquals((long)4L, (long)res.data.length);
        res = this.repositoryAssetService.listAssets(pkgUUID, this.arr("testListByFormat"), 0, 2, "rulelist");
        Assert.assertEquals((long)2L, (long)res.data.length);
        Assert.assertEquals((Object)uuid, (Object)res.data[0].id);
        Assert.assertEquals((long)4L, (long)res.total);
        Assert.assertTrue((boolean)res.hasNext);
        res = this.repositoryAssetService.listAssets(pkgUUID, this.arr("testListByFormat"), 2, 2, "rulelist");
        Assert.assertEquals((long)2L, (long)res.data.length);
        Assert.assertEquals((Object)uuid3, (Object)res.data[0].id);
        Assert.assertEquals((long)4L, (long)res.total);
        Assert.assertFalse((boolean)res.hasNext);
        uuid = this.serviceImplementation.createNewRule("testListByFormat5", "x", cat, "testListByFormat", "otherFormat");
        res = this.repositoryAssetService.listAssets(pkgUUID, this.arr("otherFormat"), 0, 40, "rulelist");
        Assert.assertEquals((long)1L, (long)res.data.length);
        Assert.assertEquals((Object)uuid, (Object)res.data[0].id);
        res = this.repositoryAssetService.listAssets(pkgUUID, new String[]{"otherFormat", "testListByFormat"}, 0, 40, "rulelist");
        Assert.assertEquals((long)5L, (long)res.data.length);
        TableDataResult result = this.repositoryAssetService.quickFindAsset("testListByForma", false, 0, 5);
        Assert.assertEquals((long)5L, (long)result.data.length);
        Assert.assertNotNull((Object)result.data[0].id);
        Assert.assertTrue((boolean)result.data[0].values[0].startsWith("testListByFormat"));
        result = this.repositoryAssetService.quickFindAsset("testListByForma", false, 0, 4);
        Assert.assertEquals((long)4L, (long)result.data.length);
    }

    @Test
    @Deprecated
    public void testQuickFind() throws Exception {
        String cat = "testQuickFind";
        this.repositoryCategoryService.createCategory("/", cat, "qkfnd");
        this.repositoryPackageService.createModule("testQuickFind", "for testing quick find.", "package");
        String uuid = this.serviceImplementation.createNewRule("testQuickFindmyRule1", "desc", cat, "testQuickFind", "drl");
        TableDataResult res = this.repositoryAssetService.quickFindAsset("testQuickFindmyRule", false, 0, 20);
        Assert.assertEquals((long)1L, (long)res.data.length);
        this.serviceImplementation.createNewRule("testQuickFindmyRule2", "desc", cat, "testQuickFind", "drl");
        res = this.repositoryAssetService.quickFindAsset("testQuickFindmyRule", false, 0, 20);
        Assert.assertEquals((long)2L, (long)res.data.length);
        this.repositoryAssetService.copyAsset(uuid, "testQuickFind", "testQuickFindmyRule3");
        res = this.repositoryAssetService.quickFindAsset("testQuickFindmyRule", false, 0, 20);
        Assert.assertEquals((long)3L, (long)res.data.length);
        res = this.repositoryAssetService.quickFindAsset("testQuickFindm*Rule", false, 0, 20);
        Assert.assertEquals((long)3L, (long)res.data.length);
    }

    @Test
    @Deprecated
    public void testSearchText() throws Exception {
        String cat = "testTextSearch";
        this.repositoryCategoryService.createCategory("/", cat, "qkfnd");
        this.repositoryPackageService.createModule("testTextSearch", "for testing search.", "package");
        String uuid = this.serviceImplementation.createNewRule("testTextRule1", "desc", cat, "testTextSearch", "drl");
        TableDataResult res = this.repositoryAssetService.queryFullText("testTextRule1", false, 0, -1);
        Assert.assertEquals((long)1L, (long)res.data.length);
    }

    @Test
    @Deprecated
    public void testSearchMetaData() throws Exception {
        ModuleItem pkg = this.rulesRepository.createModule("testMetaDataSearch", "");
        AssetItem asset = pkg.addAsset("testMetaDataSearchAsset", "");
        asset.updateSubject("testMetaDataSearch");
        asset.updateExternalSource("numberwang");
        asset.checkin("");
        MetaDataQuery[] qr = new MetaDataQuery[2];
        qr[0] = new MetaDataQuery();
        qr[0].attribute = "drools:subject";
        qr[0].valueList = "wang, testMetaDataSearch";
        qr[1] = new MetaDataQuery();
        qr[1].attribute = "drools:source";
        qr[1].valueList = "numberwan*";
        TableDataResult res = this.serviceImplementation.queryMetaData(qr, DateUtils.parseDate((String)"10-Jul-1974", (DateFormats)new DateFormatsImpl()), null, null, null, false, 0, -1);
        Assert.assertEquals((long)1L, (long)res.data.length);
    }

    public String[] arr(String s) {
        return new String[]{s};
    }

    @Test
    public void testStatus() throws Exception {
        String uuid = this.serviceImplementation.createState("testStatus1");
        Assert.assertNotNull((Object)uuid);
        String[] states = this.serviceImplementation.listStates();
        Assert.assertTrue((states.length > 0 ? 1 : 0) != 0);
        this.serviceImplementation.createState("testStatus2");
        String[] states2 = this.serviceImplementation.listStates();
        Assert.assertEquals((long)(states.length + 1), (long)states2.length);
        int match = 0;
        for (int i = 0; i < states2.length; ++i) {
            if (states2[i].equals("testStatus2")) {
                ++match;
                continue;
            }
            if (!states2[i].equals("testStatus1")) continue;
            ++match;
        }
        Assert.assertEquals((long)2L, (long)match);
        String packagUUID = this.repositoryPackageService.createModule("testStatus", "description", "package");
        String ruleUUID = this.serviceImplementation.createNewRule("testStatus", "desc", null, "testStatus", "drl");
        String ruleUUID2 = this.serviceImplementation.createNewRule("testStatus2", "desc", null, "testStatus", "drl");
        this.serviceImplementation.createState("testState");
        Asset asset = this.repositoryAssetService.loadRuleAsset(ruleUUID);
        Assert.assertEquals((Object)"Draft", (Object)asset.getState());
        this.repositoryAssetService.changeState(ruleUUID, "testState");
        asset = this.repositoryAssetService.loadRuleAsset(ruleUUID);
        Assert.assertEquals((Object)"testState", (Object)asset.getState());
        asset = this.repositoryAssetService.loadRuleAsset(ruleUUID2);
        Assert.assertEquals((Object)"Draft", (Object)asset.getState());
        this.serviceImplementation.createState("testState2");
        this.repositoryAssetService.changePackageState(packagUUID, "testState2");
        Module pkg = this.repositoryPackageService.loadModule(packagUUID);
        Assert.assertEquals((Object)"testState2", (Object)pkg.getState());
        asset = this.repositoryAssetService.loadRuleAsset(ruleUUID2);
        Assert.assertEquals((Object)"testState2", (Object)asset.getState());
        this.repositoryAssetService.checkinVersion(asset);
        asset = this.repositoryAssetService.loadRuleAsset(asset.getUuid());
        Assert.assertEquals((Object)"testState2", (Object)asset.getState());
    }

    @Test
    public void testDiscussion() throws Exception {
        ModuleItem pkg = this.rulesRepository.createModule("testDiscussionFeature", "");
        AssetItem rule1 = pkg.addAsset("rule_1", "");
        rule1.updateFormat("drl");
        rule1.updateContent("rule 'rule1' \n when \np : Person() \n then \np.setAge(42); \n end");
        rule1.checkin("");
        this.rulesRepository.save();
        List dr = this.repositoryAssetService.loadDiscussionForAsset(rule1.getUUID());
        Assert.assertEquals((long)0L, (long)dr.size());
        List dr_ = this.repositoryAssetService.addToDiscussionForAsset(rule1.getUUID(), "This is a note");
        Assert.assertEquals((long)1L, (long)dr_.size());
        Assert.assertNotNull((Object)((DiscussionRecord)dr_.get((int)0)).author);
        Assert.assertEquals((Object)"This is a note", (Object)((DiscussionRecord)dr_.get((int)0)).note);
        Thread.sleep(100L);
        this.repositoryAssetService.addToDiscussionForAsset(rule1.getUUID(), "This is a note2");
        List d_ = this.repositoryAssetService.loadDiscussionForAsset(rule1.getUUID());
        Assert.assertEquals((long)2L, (long)d_.size());
        Assert.assertEquals((Object)"This is a note", (Object)((DiscussionRecord)d_.get((int)0)).note);
        Assert.assertEquals((Object)"This is a note2", (Object)((DiscussionRecord)d_.get((int)1)).note);
        Assert.assertTrue((((DiscussionRecord)d_.get((int)1)).timestamp > ((DiscussionRecord)d_.get((int)0)).timestamp ? 1 : 0) != 0);
        rule1.updateContent("some more content");
        rule1.checkin("");
        this.repositoryAssetService.addToDiscussionForAsset(rule1.getUUID(), "This is a note2");
        d_ = this.repositoryAssetService.loadDiscussionForAsset(rule1.getUUID());
        Assert.assertEquals((long)3L, (long)d_.size());
        Assert.assertEquals((Object)"This is a note", (Object)((DiscussionRecord)d_.get((int)0)).note);
        Assert.assertEquals((Object)"This is a note2", (Object)((DiscussionRecord)d_.get((int)1)).note);
        this.repositoryAssetService.clearAllDiscussionsForAsset(rule1.getUUID());
        d_ = this.repositoryAssetService.loadDiscussionForAsset(rule1.getUUID());
        Assert.assertEquals((long)0L, (long)d_.size());
        this.repositoryAssetService.addToDiscussionForAsset(rule1.getUUID(), "This is a note2");
        d_ = this.repositoryAssetService.loadDiscussionForAsset(rule1.getUUID());
        Assert.assertEquals((long)1L, (long)d_.size());
    }

    @Test
    public void testSuggestionCompletionLoading() throws Exception {
        ModuleItem pkg = this.rulesRepository.createModule("testSISuggestionCompletionLoading", "");
        DroolsHeader.updateDroolsHeader((String)"import org.drools.Person", (ModuleItem)pkg);
        AssetItem rule1 = pkg.addAsset("model_1", "");
        rule1.updateFormat("model.drl");
        rule1.updateContent("declare Whee\n name: String \nend");
        rule1.checkin("");
        this.rulesRepository.save();
    }

    @Test
    public void testRuleNameList() throws Exception {
        ModuleItem pkg = this.rulesRepository.createModule("testRuleNameList", "");
        DroolsHeader.updateDroolsHeader((String)"import org.goo.Ber", (ModuleItem)pkg);
        AssetItem rule1 = pkg.addAsset("rule_1", "");
        rule1.updateFormat("drl");
        rule1.updateContent("package wee.wee \nrule 'rule1' \n  when p:Person() \n then p.setAge(42); \n end");
        rule1.checkin("");
        this.rulesRepository.save();
        AssetItem rule2 = pkg.addAsset("rule_2", "");
        rule2.updateFormat("drl");
        rule2.updateContent("rule 'rule2' \n ruleflow-group 'whee' \nwhen p:Person() \n then p.setAge(42); \n end");
        rule2.checkin("");
        this.rulesRepository.save();
        String[] list = this.repositoryPackageService.listRulesInPackage(pkg.getName());
        Assert.assertEquals((long)2L, (long)list.length);
        Assert.assertEquals((Object)"rule1", (Object)list[0]);
        Assert.assertEquals((Object)"rule2", (Object)list[1]);
        rule2.updateContent("wang");
        rule2.checkin("");
        list = this.repositoryPackageService.listRulesInPackage(pkg.getName());
        Assert.assertEquals((long)2L, (long)list.length);
    }

    @Test
    public void testBinaryUpToDate() throws Exception {
        ModuleItem pkg = this.rulesRepository.createModule("testBinaryPackageUpToDate", "");
        Assert.assertFalse((boolean)pkg.isBinaryUpToDate());
        DroolsHeader.updateDroolsHeader((String)"import org.drools.Person", (ModuleItem)pkg);
        AssetItem rule1 = pkg.addAsset("rule_1", "");
        rule1.updateFormat("drl");
        rule1.updateContent("rule 'rule1' \n when \np : Person() \n then \np.setAge(42); \n end");
        rule1.checkin("");
        this.rulesRepository.save();
        Assert.assertFalse((boolean)pkg.isBinaryUpToDate());
        Assert.assertFalse((boolean)RuleBaseCache.getInstance().contains(pkg.getUUID()));
        RuleBaseCache.getInstance().remove("XXX");
        BuilderResult results = this.repositoryPackageService.buildPackage(pkg.getUUID(), true);
        Assert.assertFalse((boolean)results.hasLines());
        pkg = this.rulesRepository.loadModule("testBinaryPackageUpToDate");
        byte[] binPackage = pkg.getCompiledBinaryBytes();
        Assert.assertNotNull((Object)binPackage);
        Assert.assertTrue((boolean)pkg.getNode().getProperty("drools:binaryUpToDate").getBoolean());
        Assert.assertTrue((boolean)pkg.isBinaryUpToDate());
        Assert.assertFalse((boolean)RuleBaseCache.getInstance().contains(pkg.getUUID()));
        Asset asset = this.repositoryAssetService.loadRuleAsset(rule1.getUUID());
        this.repositoryAssetService.checkinVersion(asset);
        Assert.assertFalse((boolean)pkg.getNode().getProperty("drools:binaryUpToDate").getBoolean());
        Assert.assertFalse((boolean)RuleBaseCache.getInstance().contains(pkg.getUUID()));
        this.repositoryPackageService.buildPackage(pkg.getUUID(), false);
        Assert.assertTrue((boolean)pkg.getNode().getProperty("drools:binaryUpToDate").getBoolean());
        Assert.assertFalse((boolean)RuleBaseCache.getInstance().contains(pkg.getUUID()));
        Module config = this.repositoryPackageService.loadModule(pkg.getUUID());
        this.repositoryPackageService.saveModule(config);
        Assert.assertFalse((boolean)pkg.getNode().getProperty("drools:binaryUpToDate").getBoolean());
        Assert.assertFalse((boolean)pkg.isBinaryUpToDate());
        this.repositoryPackageService.buildPackage(pkg.getUUID(), false);
        Assert.assertTrue((boolean)pkg.getNode().getProperty("drools:binaryUpToDate").getBoolean());
        Assert.assertTrue((boolean)pkg.isBinaryUpToDate());
    }

    @Test
    public void testListFactTypesAvailableInPackage() throws Exception {
        ModuleItem pkg = this.rulesRepository.createModule("testAvailableTypes", "");
        AssetItem model = pkg.addAsset("MyModel", "");
        model.updateFormat("jar");
        model.updateBinaryContentAttachment(this.getClass().getResourceAsStream("/billasurf.jar"));
        model.checkin("");
        this.rulesRepository.save();
        String[] s = this.repositoryPackageService.listTypesInPackage(pkg.getUUID());
        Assert.assertNotNull((Object)s);
        Assert.assertEquals((long)2L, (long)s.length);
        Assert.assertEquals((Object)"com.billasurf.Person", (Object)s[0]);
        Assert.assertEquals((Object)"com.billasurf.Board", (Object)s[1]);
        AssetItem asset = pkg.addAsset("declaretTypes", "");
        asset.updateFormat("model.drl");
        asset.updateContent("declare Whee\n name: String \n end");
        asset.checkin("");
        s = this.repositoryPackageService.listTypesInPackage(pkg.getUUID());
        Assert.assertEquals((long)3L, (long)s.length);
        Assert.assertEquals((Object)"Whee", (Object)s[2]);
    }

    @Test
    public void testGuidedDTExecute() throws Exception {
        this.repositoryCategoryService.createCategory("/", "testGuidedDTExecuteCategory", "");
        ModuleItem pkg = this.rulesRepository.createModule("testGuidedDTExecutePackage", "");
        DroolsHeader.updateDroolsHeader((String)"import org.drools.Person", (ModuleItem)pkg);
        AssetItem rule1 = pkg.addAsset("rule_1", "");
        rule1.updateFormat("drl");
        rule1.updateContent("rule 'rule1' \n when \np : Person() \n then \np.setAge(42); \n end");
        rule1.checkin("");
        this.rulesRepository.save();
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        Pattern52 p1 = new Pattern52();
        p1.setBoundName("p");
        p1.setFactType("Person");
        ConditionCol52 col = new ConditionCol52();
        col.setConstraintValueType(1);
        col.setFieldType("String");
        col.setFactField("hair");
        col.setOperator("==");
        p1.getChildColumns().add(col);
        dt.getConditions().add(p1);
        ActionSetFieldCol52 ac = new ActionSetFieldCol52();
        ac.setBoundName("p");
        ac.setFactField("likes");
        ac.setType("String");
        dt.getActionCols().add(ac);
        dt.setData(this.upgrader.makeDataLists((Object[][])new String[][]{{"1", "descrip", "pink", "cheese"}}));
        String uid = this.serviceImplementation.createNewRule("decTable", "", "testGuidedDTExecuteCategory", pkg.getName(), "gdst");
        Asset ass = this.repositoryAssetService.loadRuleAsset(uid);
        ass.setContent((PortableObject)dt);
        this.repositoryAssetService.checkinVersion(ass);
        BuilderResult results = this.repositoryPackageService.buildPackage(pkg.getUUID(), true);
        for (BuilderResultLine line : results.getLines()) {
            System.out.println(line.getMessage());
        }
        Assert.assertFalse((boolean)results.hasLines());
        pkg = this.rulesRepository.loadModule("testGuidedDTExecutePackage");
        byte[] binPackage = pkg.getCompiledBinaryBytes();
        Assert.assertNotNull((Object)binPackage);
        Package[] binPkgs = (Package[])DroolsStreamUtils.streamIn((byte[])binPackage);
        Assert.assertNotNull((Object)binPkgs);
        Assert.assertEquals((long)1L, (long)binPkgs.length);
        Package binPkg = binPkgs[0];
        Assert.assertNotNull((Object)binPkg);
        Assert.assertEquals((long)2L, (long)binPkg.getRules().length);
        Assert.assertNotNull((Object)binPkg);
        Assert.assertTrue((boolean)binPkg.isValid());
        Person p = new Person();
        p.setHair("pink");
        KnowledgeBuilder kb = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kb.add((Resource)new InputStreamResource((InputStream)new ByteArrayInputStream(binPackage)), ResourceType.PKG);
        KnowledgeBase kbase = kb.newKnowledgeBase();
        StatelessKnowledgeSession sess = kbase.newStatelessKnowledgeSession();
        sess.execute((Object)p);
        Assert.assertEquals((long)42L, (long)p.getAge());
        Assert.assertEquals((Object)"cheese", (Object)p.getLikes());
    }

    @Test
    public void testLoadDropDown() throws Exception {
        String[] pairs = new String[]{"f1=x", "f2=2"};
        String expression = "['@{f1}', '@{f2}']";
        String[] r = this.serviceImplementation.loadDropDownExpression(pairs, expression);
        Assert.assertEquals((long)2L, (long)r.length);
        Assert.assertEquals((Object)"x", (Object)r[0]);
        Assert.assertEquals((Object)"2", (Object)r[1]);
    }

    @Test
    public void testLoadDropDownNoValuePairs() throws Exception {
        String[] pairs = new String[]{null};
        String expression = "['@{f1}', '@{f2}']";
        String[] r = this.serviceImplementation.loadDropDownExpression(pairs, expression);
        Assert.assertEquals((long)0L, (long)r.length);
    }

    @Test
    @Deprecated
    public void testListUserPermisisons() throws Exception {
        Map r = this.serviceImplementation.listUserPermissions();
        Assert.assertNotNull((Object)r);
    }

    @Test
    public void testListUserPermissionsPagedResults() throws Exception {
        PageRequest request = new PageRequest(0, null);
        PageResponse response = this.serviceImplementation.listUserPermissions(request);
        int preExistingNumberOfUsers = response.getTotalRowSize();
        this.serviceImplementation.createUser("testListUserPermissionsPagedResultsUser1");
        this.serviceImplementation.createUser("testListUserPermissionsPagedResultsUser2");
        this.serviceImplementation.createUser("testListUserPermissionsPagedResultsUser3");
        PageRequest requestPage1 = new PageRequest(0, Integer.valueOf(preExistingNumberOfUsers));
        PageResponse responsePage1 = this.serviceImplementation.listUserPermissions(requestPage1);
        Assert.assertNotNull((Object)responsePage1);
        Assert.assertNotNull((Object)responsePage1.getPageRowList());
        System.out.println("ListUserPermissionsFullResults-page1");
        for (PermissionsPageRow row : responsePage1.getPageRowList()) {
            System.out.println("--> Username = " + row.getUserName());
        }
        Assert.assertEquals((long)0L, (long)responsePage1.getStartRowIndex());
        Assert.assertEquals((long)preExistingNumberOfUsers, (long)responsePage1.getPageRowList().size());
        Assert.assertFalse((boolean)responsePage1.isLastPage());
        PageRequest requestPage2 = new PageRequest(preExistingNumberOfUsers, Integer.valueOf(preExistingNumberOfUsers));
        PageResponse responsePage2 = this.serviceImplementation.listUserPermissions(requestPage2);
        Assert.assertNotNull((Object)responsePage2);
        Assert.assertNotNull((Object)responsePage2.getPageRowList());
        System.out.println("ListUserPermissionsFullResults-page2");
        for (PermissionsPageRow row : responsePage2.getPageRowList()) {
            System.out.println("--> Username = " + row.getUserName());
        }
        Assert.assertEquals((long)preExistingNumberOfUsers, (long)responsePage2.getStartRowIndex());
        Assert.assertEquals((long)3L, (long)responsePage2.getPageRowList().size());
        Assert.assertTrue((boolean)responsePage2.isLastPage());
    }

    @Test
    public void testListUserPermissionsFullResults() throws Exception {
        PageRequest request = new PageRequest(0, null);
        PageResponse response = this.serviceImplementation.listUserPermissions(request);
        int preExistingNumberOfUsers = response.getTotalRowSize();
        this.serviceImplementation.createUser("testListUserPermissionsFullResultsUser1");
        this.serviceImplementation.createUser("testListUserPermissionsFullResultsUser2");
        this.serviceImplementation.createUser("testListUserPermissionsFullResultsUser3");
        request = new PageRequest(0, null);
        response = this.serviceImplementation.listUserPermissions(request);
        Assert.assertNotNull((Object)response);
        Assert.assertNotNull((Object)response.getPageRowList());
        System.out.println("ListUserPermissionsFullResults");
        for (PermissionsPageRow row : response.getPageRowList()) {
            System.out.println("--> Username = " + row.getUserName());
        }
        Assert.assertEquals((long)0L, (long)response.getStartRowIndex());
        Assert.assertEquals((long)(3 + preExistingNumberOfUsers), (long)response.getPageRowList().size());
        Assert.assertTrue((boolean)response.isLastPage());
    }

    @Test
    public void testShowLogPagedResults() throws Exception {
        int PAGE_SIZE = 2;
        this.serviceImplementation.cleanLog();
        this.serviceImplementation.createUser("testShowLogPagedResultsUser1");
        this.serviceImplementation.createUser("testShowLogPagedResultsUser2");
        this.serviceImplementation.createUser("testShowLogPagedResultsUser3");
        PageRequest request = new PageRequest(0, Integer.valueOf(2));
        PageResponse response = this.serviceImplementation.showLog(request);
        Assert.assertNotNull((Object)response);
        Assert.assertNotNull((Object)response.getPageRowList());
        Assert.assertTrue((response.getStartRowIndex() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((response.getPageRowList().size() == 2 ? 1 : 0) != 0);
        Assert.assertFalse((boolean)response.isLastPage());
        request.setStartRowIndex(2);
        response = this.serviceImplementation.showLog(request);
        Assert.assertNotNull((Object)response);
        Assert.assertNotNull((Object)response.getPageRowList());
        Assert.assertTrue((response.getStartRowIndex() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((response.getPageRowList().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)response.isLastPage());
    }

    @Test
    public void testShowLogFullResults() throws Exception {
        this.serviceImplementation.cleanLog();
        this.serviceImplementation.createUser("testShowLogFullResultsUser1");
        this.serviceImplementation.createUser("testShowLogFullResultsUser2");
        this.serviceImplementation.createUser("testShowLogFullResultsUser3");
        PageRequest request = new PageRequest(0, null);
        PageResponse response = this.serviceImplementation.showLog(request);
        Assert.assertNotNull((Object)response);
        Assert.assertNotNull((Object)response.getPageRowList());
        Assert.assertTrue((response.getStartRowIndex() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((response.getPageRowList().size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)response.isLastPage());
    }

    @Test
    public void testLoadRuleListForStatePagedResults() throws Exception {
        int PAGE_SIZE = 2;
        String cat = "testLoadRuleListForStatePagedResultsCategory";
        String status = "testStatus";
        this.repositoryCategoryService.createCategory("/", cat, "testLoadRuleListForStatePagedResultsCategoryDescription");
        this.repositoryPackageService.createModule("testLoadRuleListForStatePagedResultsCategoryPackage", "testLoadRuleListForStatePagedResultsCategoryPackageDescription", "package");
        this.serviceImplementation.createState(status);
        String uuid = this.serviceImplementation.createNewRule("testTextRule1", "testLoadRuleListForStatePagedResultsCategoryRule1", cat, "testLoadRuleListForStatePagedResultsCategoryPackage", "drl");
        this.repositoryAssetService.changeState(uuid, status);
        uuid = this.serviceImplementation.createNewRule("testTextRule2", "testLoadRuleListForStatePagedResultsCategoryRule2", cat, "testLoadRuleListForStatePagedResultsCategoryPackage", "drl");
        this.repositoryAssetService.changeState(uuid, status);
        uuid = this.serviceImplementation.createNewRule("testTextRule3", "testLoadRuleListForStatePagedResultsCategoryRule3", cat, "testLoadRuleListForStatePagedResultsCategoryPackage", "drl");
        this.repositoryAssetService.changeState(uuid, status);
        StatePageRequest request = new StatePageRequest(status, 0, Integer.valueOf(2));
        PageResponse response = this.serviceImplementation.loadRuleListForState(request);
        Assert.assertNotNull((Object)response);
        Assert.assertNotNull((Object)response.getPageRowList());
        Assert.assertTrue((response.getStartRowIndex() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((response.getPageRowList().size() == 2 ? 1 : 0) != 0);
        Assert.assertFalse((boolean)response.isLastPage());
        request.setStartRowIndex(2);
        response = this.serviceImplementation.loadRuleListForState(request);
        Assert.assertNotNull((Object)response);
        Assert.assertNotNull((Object)response.getPageRowList());
        Assert.assertTrue((response.getStartRowIndex() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((response.getPageRowList().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)response.isLastPage());
    }

    @Test
    public void testLoadRuleListForStateFullResults() throws Exception {
        String cat = "testLoadRuleListForStateFullResultsCategory";
        String status = "testLoadRuleListForStateFullResultsTestStatus";
        this.repositoryCategoryService.createCategory("/", cat, "testLoadRuleListForStateFullResultsCategoryDescription");
        this.repositoryPackageService.createModule("testLoadRuleListForStateFullResultsCategoryPackage", "testLoadRuleListForStateFullResultsCategoryPackageDescription", "package");
        this.serviceImplementation.createState(status);
        String uuid = this.serviceImplementation.createNewRule("testTextRule1", "testLoadRuleListForStateFullResultsCategoryRule1", cat, "testLoadRuleListForStateFullResultsCategoryPackage", "drl");
        this.repositoryAssetService.changeState(uuid, status);
        uuid = this.serviceImplementation.createNewRule("testTextRule2", "testLoadRuleListForStateFullResultsCategoryRule2", cat, "testLoadRuleListForStateFullResultsCategoryPackage", "drl");
        this.repositoryAssetService.changeState(uuid, status);
        uuid = this.serviceImplementation.createNewRule("testTextRule3", "testLoadRuleListForStateFullResultsCategoryRule3", cat, "testLoadRuleListForStateFullResultsCategoryPackage", "drl");
        this.repositoryAssetService.changeState(uuid, status);
        StatePageRequest request = new StatePageRequest(status, 0, null);
        PageResponse response = this.serviceImplementation.loadRuleListForState(request);
        Assert.assertNotNull((Object)response);
        Assert.assertNotNull((Object)response.getPageRowList());
        Assert.assertTrue((response.getStartRowIndex() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((response.getPageRowList().size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)response.isLastPage());
    }

    @Test
    public void testLoadInboxPagedResults() throws Exception {
        int PAGE_SIZE = 2;
        UserInbox ib = new UserInbox(this.rulesRepository);
        ib.clearAll();
        this.rulesRepository.createModule("testLoadInboxPackage", "testLoadInboxDescription");
        this.repositoryCategoryService.createCategory("", "testLoadInboxPagedResultsCategory", "testLoadInboxPagedResultsCategoryDescription");
        String uuid = this.serviceImplementation.createNewRule("rule1", "desc", "testLoadInboxPagedResultsCategory", "testLoadInboxPackage", "drl");
        Asset asset = this.repositoryAssetService.loadRuleAsset(uuid);
        uuid = this.serviceImplementation.createNewRule("rule2", "desc", "testLoadInboxPagedResultsCategory", "testLoadInboxPackage", "drl");
        asset = this.repositoryAssetService.loadRuleAsset(uuid);
        uuid = this.serviceImplementation.createNewRule("rule3", "desc", "testLoadInboxPagedResultsCategory", "testLoadInboxPackage", "drl");
        asset = this.repositoryAssetService.loadRuleAsset(uuid);
        InboxPageRequest request = new InboxPageRequest("recentViewed", 0, Integer.valueOf(2));
        PageResponse response = this.serviceImplementation.loadInbox(request);
        Assert.assertNotNull((Object)response);
        Assert.assertNotNull((Object)response.getPageRowList());
        Assert.assertTrue((response.getStartRowIndex() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((response.getPageRowList().size() == 2 ? 1 : 0) != 0);
        Assert.assertFalse((boolean)response.isLastPage());
        request.setStartRowIndex(2);
        response = this.serviceImplementation.loadInbox(request);
        Assert.assertNotNull((Object)response);
        Assert.assertNotNull((Object)response.getPageRowList());
        Assert.assertTrue((response.getStartRowIndex() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((response.getPageRowList().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)response.isLastPage());
    }

    @Test
    public void testLoadInboxFullResults() throws Exception {
        UserInbox ib = new UserInbox(this.rulesRepository);
        ib.clearAll();
        this.rulesRepository.createModule("testLoadInboxFullResults", "testLoadInboxDescription");
        this.repositoryCategoryService.createCategory("", "testLoadInboxFullResultsCategory", "testLoadInboxFullResultsCategoryDescription");
        String uuid = this.serviceImplementation.createNewRule("rule1", "desc", "testLoadInboxFullResultsCategory", "testLoadInboxFullResults", "drl");
        Asset asset = this.repositoryAssetService.loadRuleAsset(uuid);
        uuid = this.serviceImplementation.createNewRule("rule2", "desc", "testLoadInboxFullResultsCategory", "testLoadInboxFullResults", "drl");
        asset = this.repositoryAssetService.loadRuleAsset(uuid);
        uuid = this.serviceImplementation.createNewRule("rule3", "desc", "testLoadInboxFullResultsCategory", "testLoadInboxFullResults", "drl");
        asset = this.repositoryAssetService.loadRuleAsset(uuid);
        InboxPageRequest request = new InboxPageRequest("recentViewed", 0, null);
        PageResponse response = this.serviceImplementation.loadInbox(request);
        Assert.assertNotNull((Object)response);
        Assert.assertNotNull((Object)response.getPageRowList());
        Assert.assertTrue((response.getStartRowIndex() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((response.getPageRowList().size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)response.isLastPage());
    }

    @Test
    public void testManageUserPermissions() throws Exception {
        HashMap perms = new HashMap();
        this.serviceImplementation.updateUserPermissions("googoo", perms);
        Map perms_ = this.serviceImplementation.retrieveUserPermissions("googoo");
        Assert.assertEquals((long)0L, (long)perms_.size());
    }

    @Test
    @Ignore(value="To be fixed: GUVNOR-296")
    public void testHistoryAfterReImportSampleRepository() throws Exception {
        this.repositoryPackageService.installSampleRepository();
        Module[] cfgs = this.repositoryPackageService.listModules();
        Assert.assertEquals((long)2L, (long)cfgs.length);
        Assert.assertTrue((cfgs[0].getName().equals("mortgages") || cfgs[1].getName().equals("mortgages") ? 1 : 0) != 0);
        QueryPageRequest request = new QueryPageRequest("Bankruptcy history", Boolean.valueOf(false), 0, Integer.valueOf(20));
        PageResponse response = this.repositoryAssetService.quickFindAsset(request);
        Assert.assertEquals((long)1L, (long)response.getPageRowList().size());
        String uuid = ((QueryPageRow)response.getPageRowList().get(0)).getUuid();
        Asset ai = this.repositoryAssetService.loadRuleAsset(uuid);
        ai.setCheckinComment("version 4");
        this.repositoryAssetService.checkinVersion(ai);
        ai = this.repositoryAssetService.loadRuleAsset(uuid);
        ai.setCheckinComment("version 5");
        this.repositoryAssetService.checkinVersion(ai);
        System.out.println("old uuid: " + uuid);
        this.rulesRepository.createModule("testHistoryAfterReImportSampleRepository", "desc");
        TableDataResult result = this.repositoryAssetService.loadItemHistory(uuid);
        Assert.assertNotNull((Object)result);
        TableDataRow[] rows = result.data;
        Assert.assertEquals((long)2L, (long)rows.length);
        this.repositoryPackageService.installSampleRepository();
        request = new QueryPageRequest("Bankruptcy history", Boolean.valueOf(false), 0, Integer.valueOf(20));
        response = this.repositoryAssetService.quickFindAsset(request);
        Assert.assertEquals((long)1L, (long)response.getPageRowList().size());
        String newUuid = ((QueryPageRow)response.getPageRowList().get(0)).getUuid();
        result = this.repositoryAssetService.loadItemHistory(newUuid);
        System.out.println("new uuid: " + newUuid);
        Assert.assertNotNull((Object)result);
        rows = result.data;
        Assert.assertEquals((long)0L, (long)rows.length);
    }

    @Test
    public void testWorkspaces() throws Exception {
        this.serviceImplementation.createWorkspace("testWorkspaces1");
        this.serviceImplementation.createWorkspace("testWorkspaces2");
        String[] result = this.serviceImplementation.listWorkspaces();
        Assert.assertEquals((long)2L, (long)result.length);
    }

    @Test
    public void testLoadingWorkDefinitionsFromConfigurationFile() {
        try {
            Map wids = ConfigFileWorkDefinitionsLoader.getInstance().getWorkDefinitions();
            Assert.assertNotNull((Object)wids);
            Assert.assertEquals((long)1L, (long)wids.size());
            WorkDefinitionImpl wid = (WorkDefinitionImpl)wids.get("MyTask");
            Assert.assertEquals((Object)"MyTask", (Object)wid.getName());
            Assert.assertEquals((Object)"My Task", (Object)wid.getDisplayName());
            Assert.assertNotNull((Object)wid.getParameters());
            Assert.assertEquals((long)7L, (long)wid.getParameters().size());
            Assert.assertNotNull((Object)wid.getParameter("StringParam"));
            Assert.assertNotNull((Object)wid.getParameter("IntegerParam"));
            Assert.assertNotNull((Object)wid.getParameter("FloatParam"));
            Assert.assertNotNull((Object)wid.getParameter("BooleanParam"));
            Assert.assertNotNull((Object)wid.getParameter("EnumParam"));
            Assert.assertNotNull((Object)wid.getParameter("ListParam"));
            Assert.assertNotNull((Object)wid.getParameter("ObjectParam"));
            Assert.assertTrue((boolean)(wid.getParameter("StringParam").getType() instanceof StringDataType));
            Assert.assertTrue((boolean)(wid.getParameter("IntegerParam").getType() instanceof IntegerDataType));
            Assert.assertTrue((boolean)(wid.getParameter("FloatParam").getType() instanceof FloatDataType));
            Assert.assertTrue((boolean)(wid.getParameter("BooleanParam").getType() instanceof BooleanDataType));
            Assert.assertTrue((boolean)(wid.getParameter("EnumParam").getType() instanceof EnumDataType));
            Assert.assertTrue((boolean)(wid.getParameter("ListParam").getType() instanceof ListDataType));
            Assert.assertTrue((boolean)(wid.getParameter("ObjectParam").getType() instanceof ObjectDataType));
            Assert.assertNotNull((Object)wid.getResults());
            Assert.assertEquals((long)7L, (long)wid.getResults().size());
            Assert.assertNotNull((Object)wid.getResult("StringResult"));
            Assert.assertNotNull((Object)wid.getResult("IntegerResult"));
            Assert.assertNotNull((Object)wid.getResult("FloatResult"));
            Assert.assertNotNull((Object)wid.getResult("BooleanResult"));
            Assert.assertNotNull((Object)wid.getResult("EnumResult"));
            Assert.assertNotNull((Object)wid.getResult("ListResult"));
            Assert.assertNotNull((Object)wid.getResult("ObjectResult"));
            Assert.assertTrue((boolean)(wid.getResult("StringResult").getType() instanceof StringDataType));
            Assert.assertTrue((boolean)(wid.getResult("IntegerResult").getType() instanceof IntegerDataType));
            Assert.assertTrue((boolean)(wid.getResult("FloatResult").getType() instanceof FloatDataType));
            Assert.assertTrue((boolean)(wid.getResult("BooleanResult").getType() instanceof BooleanDataType));
            Assert.assertTrue((boolean)(wid.getResult("EnumResult").getType() instanceof EnumDataType));
            Assert.assertTrue((boolean)(wid.getResult("ListResult").getType() instanceof ListDataType));
            Assert.assertTrue((boolean)(wid.getResult("ObjectResult").getType() instanceof ObjectDataType));
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testLoadingWorkDefinitionsFromPackageAssets() throws SerializationException {
        this.repositoryCategoryService.createCategory("", "testLoadingWorkDefinitionsFromPackageAssetsCategory", "testLoadingWorkDefinitionsFromPackageAssetsCategory");
        String packageUUID = this.repositoryPackageService.createModule("testLoadingWorkDefinitionsFromPackageAssets", "testLoadingWorkDefinitionsFromPackageAssets", "package");
        String uuid1 = this.serviceImplementation.createNewRule("workItem1", "workItem1description", "testLoadingWorkDefinitionsFromPackageAssetsCategory", "testLoadingWorkDefinitionsFromPackageAssets", "wid");
        Asset asset1 = this.repositoryAssetService.loadRuleAsset(uuid1);
        RuleContentText content1 = new RuleContentText();
        content1.content = "import org.drools.process.core.datatype.impl.type.StringDataType;\n[\n[\n\"name\" : \"MyTask1\",\n\"parameters\" : [\n\"StringParam\" : new StringDataType()\n],\n\"results\" : [\n\"StringResult\" : new StringDataType()\n],\n\"displayName\" : \"My Task1\",\"icon\" : \"\",\n]\n]";
        asset1.setContent((PortableObject)content1);
        this.repositoryAssetService.checkinVersion(asset1);
        String uuid2 = this.serviceImplementation.createNewRule("workItem2", "workItem2description", "testLoadingWorkDefinitionsFromPackageAssetsCategory", "testLoadingWorkDefinitionsFromPackageAssets", "wid");
        Asset asset2 = this.repositoryAssetService.loadRuleAsset(uuid2);
        RuleContentText content2 = new RuleContentText();
        content2.content = "import org.drools.process.core.datatype.impl.type.IntegerDataType;\n[\n[\n\"name\" : \"MyTask2\",\n\"parameters\" : [\n\"IntegerParam\" : new IntegerDataType()\n],\n\"results\" : [\n\"IntegerResult\" : new IntegerDataType()\n],\n\"displayName\" : \"My Task2\",\"icon\" : \"\",\n]\n]";
        asset2.setContent((PortableObject)content2);
        this.repositoryAssetService.checkinVersion(asset2);
        String uuid3 = this.serviceImplementation.createNewRule("workItem3", "workItem3description", "testLoadingWorkDefinitionsFromPackageAssetsCategory", "testLoadingWorkDefinitionsFromPackageAssets", "wid");
        Asset asset3 = this.repositoryAssetService.loadRuleAsset(uuid3);
        RuleContentText content3 = new RuleContentText();
        content3.content = "import org.drools.process.core.datatype.impl.type.ObjectDataType;\n[\n[\n\"name\" : \"MyTask3\",\n\"parameters\" : [\n\"ObjectParam\" : new ObjectDataType()\n],\n\"results\" : [\n\"ObjectResult\" : new ObjectDataType()\n],\n\"displayName\" : \"My Task3\",\"icon\" : \"\",\n]\n]";
        asset3.setContent((PortableObject)content3);
        this.repositoryAssetService.checkinVersion(asset3);
        try {
            AssetWorkDefinitionsLoader loader = new AssetWorkDefinitionsLoader(this.repositoryAssetService, packageUUID);
            Map wids = loader.getWorkDefinitions();
            Assert.assertNotNull((Object)wids);
            Assert.assertEquals((long)3L, (long)wids.size());
            WorkDefinitionImpl wid1 = (WorkDefinitionImpl)wids.get("MyTask1");
            Assert.assertEquals((Object)"MyTask1", (Object)wid1.getName());
            Assert.assertEquals((Object)"My Task1", (Object)wid1.getDisplayName());
            Assert.assertNotNull((Object)wid1.getParameters());
            Assert.assertEquals((long)1L, (long)wid1.getParameters().size());
            Assert.assertNotNull((Object)wid1.getParameter("StringParam"));
            Assert.assertTrue((boolean)(wid1.getParameter("StringParam").getType() instanceof StringDataType));
            Assert.assertNotNull((Object)wid1.getResults());
            Assert.assertEquals((long)1L, (long)wid1.getResults().size());
            Assert.assertNotNull((Object)wid1.getResult("StringResult"));
            Assert.assertTrue((boolean)(wid1.getResult("StringResult").getType() instanceof StringDataType));
            WorkDefinitionImpl wid2 = (WorkDefinitionImpl)wids.get("MyTask2");
            Assert.assertEquals((Object)"MyTask2", (Object)wid2.getName());
            Assert.assertEquals((Object)"My Task2", (Object)wid2.getDisplayName());
            Assert.assertNotNull((Object)wid2.getParameters());
            Assert.assertEquals((long)1L, (long)wid2.getParameters().size());
            Assert.assertNotNull((Object)wid2.getParameter("IntegerParam"));
            Assert.assertTrue((boolean)(wid2.getParameter("IntegerParam").getType() instanceof IntegerDataType));
            Assert.assertNotNull((Object)wid2.getResults());
            Assert.assertEquals((long)1L, (long)wid2.getResults().size());
            Assert.assertNotNull((Object)wid2.getResult("IntegerResult"));
            Assert.assertTrue((boolean)(wid2.getResult("IntegerResult").getType() instanceof IntegerDataType));
            WorkDefinitionImpl wid3 = (WorkDefinitionImpl)wids.get("MyTask3");
            Assert.assertEquals((Object)"MyTask3", (Object)wid3.getName());
            Assert.assertEquals((Object)"My Task3", (Object)wid3.getDisplayName());
            Assert.assertNotNull((Object)wid3.getParameters());
            Assert.assertEquals((long)1L, (long)wid3.getParameters().size());
            Assert.assertNotNull((Object)wid3.getParameter("ObjectParam"));
            Assert.assertTrue((boolean)(wid3.getParameter("ObjectParam").getType() instanceof ObjectDataType));
            Assert.assertNotNull((Object)wid3.getResults());
            Assert.assertEquals((long)1L, (long)wid3.getResults().size());
            Assert.assertNotNull((Object)wid3.getResult("ObjectResult"));
            Assert.assertTrue((boolean)(wid3.getResult("ObjectResult").getType() instanceof ObjectDataType));
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

