/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server;

import javax.inject.Inject;
import org.drools.guvnor.client.rpc.Asset;
import org.drools.guvnor.client.rpc.TableDataResult;
import org.drools.guvnor.client.rpc.TableDataRow;
import org.drools.guvnor.server.repository.MailboxService;
import org.drools.guvnor.server.repository.RepositoryStartupService;
import org.drools.guvnor.server.repository.UserInbox;
import org.drools.guvnor.server.test.GuvnorIntegrationTest;
import org.drools.repository.AssetItem;
import org.drools.repository.RulesRepository;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class ServiceImplementationMailboxService2IntegrationTest
extends GuvnorIntegrationTest {
    @Inject
    private RepositoryStartupService repositoryStartupService;
    @Inject
    private MailboxService mailboxService;

    public void startMailboxService() {
        this.mailboxService.wakeUp();
    }

    public void stopMailboxService() {
        this.mailboxService.destroy();
    }

    @Test
    @Ignore(value="Is this the cause of our pain?")
    public void testInboxEvents() throws Exception {
        Assert.assertNotNull((Object)this.serviceImplementation.loadInbox("recentEdited"));
        AssetItem as = this.rulesRepository.loadDefaultModule().addAsset("testLoadInbox", "");
        as.checkin("");
        Asset ras = this.repositoryAssetService.loadRuleAsset(as.getUUID());
        TableDataResult res = this.serviceImplementation.loadInbox("recentEdited");
        boolean found = false;
        for (TableDataRow row : res.data) {
            if (!row.id.equals(ras.getUuid())) continue;
            found = true;
        }
        Assert.assertTrue((boolean)found);
        found = false;
        res = this.serviceImplementation.loadInbox("incoming");
        for (TableDataRow row : res.data) {
            if (!row.id.equals(as.getUUID())) continue;
            found = true;
        }
        Assert.assertFalse((boolean)found);
        RulesRepository repo2 = new RulesRepository(this.repositoryStartupService.newSession("seconduser"));
        AssetItem as2 = repo2.loadDefaultModule().loadAsset("testLoadInbox");
        as2.updateContent("hey");
        as2.checkin("here we go again !");
        Thread.sleep(250L);
        TableDataRow rowMatch = null;
        res = this.serviceImplementation.loadInbox("incoming");
        for (TableDataRow row : res.data) {
            if (!row.id.equals(as.getUUID())) continue;
            rowMatch = row;
            break;
        }
        Assert.assertNotNull(rowMatch);
        Assert.assertEquals((Object)as.getName(), (Object)rowMatch.values[0]);
        Assert.assertEquals((Object)"seconduser", (Object)rowMatch.values[2]);
        UserInbox secondUsersInbox = new UserInbox(repo2);
        secondUsersInbox.loadIncoming();
        Assert.assertEquals((long)0L, (long)secondUsersInbox.loadIncoming().size());
        Assert.assertEquals((long)1L, (long)secondUsersInbox.loadRecentEdited().size());
        RulesRepository repo3 = new RulesRepository(this.repositoryStartupService.newSession("thirduser"));
        AssetItem as3 = repo3.loadDefaultModule().loadAsset("testLoadInbox");
        as3.updateContent("hey22");
        as3.checkin("here we go again 22!");
        Thread.sleep(250L);
        Assert.assertEquals((long)1L, (long)secondUsersInbox.loadIncoming().size());
        found = false;
        res = this.serviceImplementation.loadInbox("incoming");
        for (TableDataRow row : res.data) {
            if (!row.id.equals(as.getUUID())) continue;
            found = true;
        }
        Assert.assertTrue((boolean)found);
        this.repositoryAssetService.loadRuleAsset(as.getUUID());
        found = false;
        res = this.serviceImplementation.loadInbox("incoming");
        for (TableDataRow row : res.data) {
            if (!row.id.equals(as.getUUID())) continue;
            found = true;
        }
        Assert.assertFalse((boolean)found);
    }
}

