/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server;

import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import org.drools.guvnor.server.SuggestionCompletionEngineServiceImplementation;
import org.drools.guvnor.server.test.GuvnorIntegrationTest;
import org.drools.guvnor.server.util.DroolsHeader;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.repository.AssetItem;
import org.drools.repository.ModuleItem;
import org.junit.Assert;
import org.junit.Test;

public class SuggestionCompletionEngineServiceImplementationIntegrationTest
extends GuvnorIntegrationTest {
    @Inject
    protected SuggestionCompletionEngineServiceImplementation suggestionCompletionEngineServiceImplementation;

    @Test
    public void testLoadSuggestionCompletionEngine() throws Exception {
        ModuleItem pkg = this.rulesRepository.createModule("testSILoadSCE", "");
        AssetItem model = pkg.addAsset("MyModel", "");
        model.updateFormat("jar");
        model.updateBinaryContentAttachment(this.getClass().getResourceAsStream("/billasurf.jar"));
        model.checkin("");
        DroolsHeader.updateDroolsHeader((String)"import com.billasurf.Board", (ModuleItem)pkg);
        AssetItem m2 = pkg.addAsset("MyModel2", "");
        m2.updateFormat("model.drl");
        m2.updateContent("declare Whee\n name: String\nend");
        m2.checkin("");
        AssetItem r1 = pkg.addAsset("garbage", "");
        r1.updateFormat("drl");
        r1.updateContent("this will not compile");
        r1.checkin("");
        SuggestionCompletionEngine eng = this.suggestionCompletionEngineServiceImplementation.loadSuggestionCompletionEngine(pkg.getName());
        Assert.assertNotNull((Object)eng);
        Assert.assertTrue((eng.getFactTypes().length >= 2 ? 1 : 0) != 0);
        List<String> factTypes = Arrays.asList(eng.getFactTypes());
        Assert.assertTrue((boolean)factTypes.contains("Board"));
        Assert.assertTrue((boolean)factTypes.contains("Whee"));
    }
}

